// Code generated by tutone: DO NOT EDIT
package keytransaction

import "context"

// Creates a key transaction.
func (a *Keytransaction) KeyTransactionCreate(
	apdexTarget float64,
	applicationGUID EntityGUID,
	browserApdexTarget float64,
	metricName string,
	name string,
) (*KeyTransactionCreateResult, error) {
	return a.KeyTransactionCreateWithContext(context.Background(),
		apdexTarget,
		applicationGUID,
		browserApdexTarget,
		metricName,
		name,
	)
}

// Creates a key transaction.
func (a *Keytransaction) KeyTransactionCreateWithContext(
	ctx context.Context,
	apdexTarget float64,
	applicationGUID EntityGUID,
	browserApdexTarget float64,
	metricName string,
	name string,
) (*KeyTransactionCreateResult, error) {

	resp := KeyTransactionCreateQueryResponse{}
	vars := map[string]interface{}{
		"apdexTarget":        apdexTarget,
		"applicationGuid":    applicationGUID,
		"browserApdexTarget": browserApdexTarget,
		"metricName":         metricName,
		"name":               name,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, KeyTransactionCreateMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.KeyTransactionCreateResult, nil
}

type KeyTransactionCreateQueryResponse struct {
	KeyTransactionCreateResult KeyTransactionCreateResult `json:"KeyTransactionCreate"`
}

const KeyTransactionCreateMutation = `mutation(
	$apdexTarget: Float!,
	$applicationGuid: EntityGuid!,
	$browserApdexTarget: Float!,
	$metricName: String!,
	$name: String!,
) { keyTransactionCreate(
	apdexTarget: $apdexTarget,
	applicationGuid: $applicationGuid,
	browserApdexTarget: $browserApdexTarget,
	metricName: $metricName,
	name: $name,
) {
	apdexTarget
	application {
		entity {
			__typename
			account {
				id
				name
				reportingEventTypes
			}
			accountId
			alertSeverity
			domain
			entityType
			firstIndexedAt
			goldenMetrics {
				context {
					account
					guid
				}
				metrics {
					metricName
					name
					query
					title
					unit
				}
			}
			goldenTags {
				context {
					account
					guid
				}
				tags {
					key
				}
			}
			guid
			indexedAt
			lastReportingChangeAt
			name
			permalink
			reporting
			serviceLevel {
				indicators {
					createdAt
					description
					entityGuid
					guid
					id
					name
					slug
					updatedAt
				}
			}
			tags {
				key
				values
			}
			type
			... on ApmApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				apmBrowserSummary {
					ajaxRequestThroughput
					ajaxResponseTimeAverage
					jsErrorRate
					pageLoadThroughput
					pageLoadTimeAverage
				}
				apmSummary {
					apdexScore
					errorRate
					hostCount
					instanceCount
					nonWebResponseTimeAverage
					nonWebThroughput
					responseTimeAverage
					throughput
					webResponseTimeAverage
					webThroughput
				}
				applicationId
				language
				runningAgentVersions {
					maxVersion
					minVersion
				}
				settings {
					apdexTarget
					serverSideConfig
				}
				tags {
					key
					values
				}
			}
			... on ApmDatabaseInstanceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				host
				portOrPath
				tags {
					key
					values
				}
				vendor
			}
			... on ApmExternalServiceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				externalSummary {
					responseTimeAverage
					throughput
				}
				host
				tags {
					key
					values
				}
			}
			... on BrowserApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				agentInstallType
				applicationId
				browserSummary {
					ajaxRequestThroughput
					ajaxResponseTimeAverage
					jsErrorRate
					pageLoadThroughput
					pageLoadTimeAverage
					pageLoadTimeMedian
					spaResponseTimeAverage
					spaResponseTimeMedian
				}
				runningAgentVersions {
					maxSemanticVersion
					maxVersion
					minSemanticVersion
					minVersion
				}
				servingApmApplicationId
				settings {
					apdexTarget
				}
				tags {
					key
					values
				}
			}
			... on DashboardEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				createdAt
				dashboardParentGuid
				owner {
					email
					userId
				}
				permissions
				tags {
					key
					values
				}
				updatedAt
			}
			... on ExternalEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on GenericEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on GenericInfrastructureEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				integrationTypeCode
				tags {
					key
					values
				}
			}
			... on InfrastructureAwsLambdaFunctionEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				integrationTypeCode
				runtime
				tags {
					key
					values
				}
			}
			... on InfrastructureHostEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				hostSummary {
					cpuUtilizationPercent
					diskUsedPercent
					memoryUsedPercent
					networkReceiveRate
					networkTransmitRate
					servicesCount
				}
				tags {
					key
					values
				}
			}
			... on KeyTransactionEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on MobileApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				applicationId
				mobileSummary {
					appLaunchCount
					crashCount
					crashRate
					httpErrorRate
					httpRequestCount
					httpRequestRate
					httpResponseTimeAverage
					mobileSessionCount
					networkFailureRate
					usersAffectedCount
				}
				tags {
					key
					values
				}
			}
			... on SecureCredentialEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				description
				secureCredentialId
				secureCredentialSummary {
					failingMonitorCount
					monitorCount
				}
				tags {
					key
					values
				}
				updatedAt
			}
			... on SyntheticMonitorEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				monitorId
				monitorSummary {
					locationsFailing
					locationsRunning
					status
					successRate
				}
				monitorType
				monitoredUrl
				period
				tags {
					key
					values
				}
			}
			... on TeamEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on ThirdPartyServiceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on UnavailableEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on WorkloadEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				createdAt
				createdByUser {
					email
					gravatar
					id
					name
				}
				tags {
					key
					values
				}
				updatedAt
				workloadStatus {
					description
					statusSource
					statusValue
					summary
				}
			}
		}
		guid
	}
	browserApdexTarget
	guid
	metricName
	name
} }`

// Deletes a key transaction (historical data is not removed).
func (a *Keytransaction) KeyTransactionDelete(
	gUID EntityGUID,
) (*KeyTransactionDeleteResult, error) {
	return a.KeyTransactionDeleteWithContext(context.Background(),
		gUID,
	)
}

// Deletes a key transaction (historical data is not removed).
func (a *Keytransaction) KeyTransactionDeleteWithContext(
	ctx context.Context,
	gUID EntityGUID,
) (*KeyTransactionDeleteResult, error) {

	resp := KeyTransactionDeleteQueryResponse{}
	vars := map[string]interface{}{
		"guid": gUID,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, KeyTransactionDeleteMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.KeyTransactionDeleteResult, nil
}

type KeyTransactionDeleteQueryResponse struct {
	KeyTransactionDeleteResult KeyTransactionDeleteResult `json:"KeyTransactionDelete"`
}

const KeyTransactionDeleteMutation = `mutation(
	$guid: EntityGuid!,
) { keyTransactionDelete(
	guid: $guid,
) {
	success
} }`

// Update a key transaction.
func (a *Keytransaction) KeyTransactionUpdate(
	apdexTarget float64,
	browserApdexTarget float64,
	gUID EntityGUID,
	name string,
) (*KeyTransactionUpdateResult, error) {
	return a.KeyTransactionUpdateWithContext(context.Background(),
		apdexTarget,
		browserApdexTarget,
		gUID,
		name,
	)
}

// Update a key transaction.
func (a *Keytransaction) KeyTransactionUpdateWithContext(
	ctx context.Context,
	apdexTarget float64,
	browserApdexTarget float64,
	gUID EntityGUID,
	name string,
) (*KeyTransactionUpdateResult, error) {

	resp := KeyTransactionUpdateQueryResponse{}
	vars := map[string]interface{}{
		"apdexTarget":        apdexTarget,
		"browserApdexTarget": browserApdexTarget,
		"guid":               gUID,
		"name":               name,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, KeyTransactionUpdateMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.KeyTransactionUpdateResult, nil
}

type KeyTransactionUpdateQueryResponse struct {
	KeyTransactionUpdateResult KeyTransactionUpdateResult `json:"KeyTransactionUpdate"`
}

const KeyTransactionUpdateMutation = `mutation(
	$apdexTarget: Float,
	$browserApdexTarget: Float,
	$guid: EntityGuid!,
	$name: String,
) { keyTransactionUpdate(
	apdexTarget: $apdexTarget,
	browserApdexTarget: $browserApdexTarget,
	guid: $guid,
	name: $name,
) {
	apdexTarget
	application {
		entity {
			__typename
			account {
				id
				name
				reportingEventTypes
			}
			accountId
			alertSeverity
			domain
			entityType
			firstIndexedAt
			goldenMetrics {
				context {
					account
					guid
				}
				metrics {
					metricName
					name
					query
					title
					unit
				}
			}
			goldenTags {
				context {
					account
					guid
				}
				tags {
					key
				}
			}
			guid
			indexedAt
			lastReportingChangeAt
			name
			permalink
			reporting
			serviceLevel {
				indicators {
					createdAt
					description
					entityGuid
					guid
					id
					name
					slug
					updatedAt
				}
			}
			tags {
				key
				values
			}
			type
			... on ApmApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				apmBrowserSummary {
					ajaxRequestThroughput
					ajaxResponseTimeAverage
					jsErrorRate
					pageLoadThroughput
					pageLoadTimeAverage
				}
				apmSummary {
					apdexScore
					errorRate
					hostCount
					instanceCount
					nonWebResponseTimeAverage
					nonWebThroughput
					responseTimeAverage
					throughput
					webResponseTimeAverage
					webThroughput
				}
				applicationId
				language
				runningAgentVersions {
					maxVersion
					minVersion
				}
				settings {
					apdexTarget
					serverSideConfig
				}
				tags {
					key
					values
				}
			}
			... on ApmDatabaseInstanceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				host
				portOrPath
				tags {
					key
					values
				}
				vendor
			}
			... on ApmExternalServiceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				externalSummary {
					responseTimeAverage
					throughput
				}
				host
				tags {
					key
					values
				}
			}
			... on BrowserApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				agentInstallType
				applicationId
				browserSummary {
					ajaxRequestThroughput
					ajaxResponseTimeAverage
					jsErrorRate
					pageLoadThroughput
					pageLoadTimeAverage
					pageLoadTimeMedian
					spaResponseTimeAverage
					spaResponseTimeMedian
				}
				runningAgentVersions {
					maxSemanticVersion
					maxVersion
					minSemanticVersion
					minVersion
				}
				servingApmApplicationId
				settings {
					apdexTarget
				}
				tags {
					key
					values
				}
			}
			... on DashboardEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				createdAt
				dashboardParentGuid
				owner {
					email
					userId
				}
				permissions
				tags {
					key
					values
				}
				updatedAt
			}
			... on ExternalEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on GenericEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on GenericInfrastructureEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				integrationTypeCode
				tags {
					key
					values
				}
			}
			... on InfrastructureAwsLambdaFunctionEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				integrationTypeCode
				runtime
				tags {
					key
					values
				}
			}
			... on InfrastructureHostEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				hostSummary {
					cpuUtilizationPercent
					diskUsedPercent
					memoryUsedPercent
					networkReceiveRate
					networkTransmitRate
					servicesCount
				}
				tags {
					key
					values
				}
			}
			... on KeyTransactionEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on MobileApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				applicationId
				mobileSummary {
					appLaunchCount
					crashCount
					crashRate
					httpErrorRate
					httpRequestCount
					httpRequestRate
					httpResponseTimeAverage
					mobileSessionCount
					networkFailureRate
					usersAffectedCount
				}
				tags {
					key
					values
				}
			}
			... on SecureCredentialEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				description
				secureCredentialId
				secureCredentialSummary {
					failingMonitorCount
					monitorCount
				}
				tags {
					key
					values
				}
				updatedAt
			}
			... on SyntheticMonitorEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				monitorId
				monitorSummary {
					locationsFailing
					locationsRunning
					status
					successRate
				}
				monitorType
				monitoredUrl
				period
				tags {
					key
					values
				}
			}
			... on TeamEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on ThirdPartyServiceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on UnavailableEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on WorkloadEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				createdAt
				createdByUser {
					email
					gravatar
					id
					name
				}
				tags {
					key
					values
				}
				updatedAt
				workloadStatus {
					description
					statusSource
					statusValue
					summary
				}
			}
		}
		guid
	}
	browserApdexTarget
	name
} }`
