// Code generated by tutone: DO NOT EDIT
package installevents

import "context"

// Creates a new install status.
// An install status is created on behalf of the newrelic-cli whenever the CLI has started an installation and completed an installation.
//
// Guided install: https://docs.newrelic.com/docs/full-stack-observability/observe-everything/get-started/new-relic-guided-install-overview/
// newrelic-cli: https://github.com/newrelic/newrelic-cli
func (a *Installevents) InstallationCreateInstallStatus(
	accountID int,
	installStatus InstallationInstallStatusInput,
) (*InstallationInstallStatus, error) {
	return a.InstallationCreateInstallStatusWithContext(context.Background(),
		accountID,
		installStatus,
	)
}

// Creates a new install status.
// An install status is created on behalf of the newrelic-cli whenever the CLI has started an installation and completed an installation.
//
// Guided install: https://docs.newrelic.com/docs/full-stack-observability/observe-everything/get-started/new-relic-guided-install-overview/
// newrelic-cli: https://github.com/newrelic/newrelic-cli
func (a *Installevents) InstallationCreateInstallStatusWithContext(
	ctx context.Context,
	accountID int,
	installStatus InstallationInstallStatusInput,
) (*InstallationInstallStatus, error) {

	resp := InstallationCreateInstallStatusQueryResponse{}
	vars := map[string]interface{}{
		"accountId":     accountID,
		"installStatus": installStatus,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, InstallationCreateInstallStatusMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.InstallationInstallStatus, nil
}

type InstallationCreateInstallStatusQueryResponse struct {
	InstallationInstallStatus InstallationInstallStatus `json:"InstallationCreateInstallStatus"`
}

const InstallationCreateInstallStatusMutation = `mutation(
	$accountId: Int!,
	$installStatus: InstallationInstallStatusInput!,
) { installationCreateInstallStatus(
	accountId: $accountId,
	installStatus: $installStatus,
) {
	cliVersion
	deployedBy
	enabledProxy
	error {
		details
		message
	}
	hostName
	installId
	installLibraryVersion
	isUnsupported
	kernelArch
	kernelVersion
	logFilePath
	os
	platform
	platformFamily
	platformVersion
	redirectUrl
	state
	targetedInstall
	timestamp
} }`

// Creates a new recipe event.
// - A recipe event is created on behalf of the newrelic-cli whenever the CLI attempts to install the infrastructure-agent, for example.
// - A recipe event is appended to any existing recipe events, if there are any present in the cache.
//
// Guided install: https://docs.newrelic.com/docs/full-stack-observability/observe-everything/get-started/new-relic-guided-install-overview/
// newrelic-cli: https://github.com/newrelic/newrelic-cli
func (a *Installevents) InstallationCreateRecipeEvent(
	accountID int,
	status InstallationRecipeStatus,
) (*InstallationRecipeEvent, error) {
	return a.InstallationCreateRecipeEventWithContext(context.Background(),
		accountID,
		status,
	)
}

// Creates a new recipe event.
// - A recipe event is created on behalf of the newrelic-cli whenever the CLI attempts to install the infrastructure-agent, for example.
// - A recipe event is appended to any existing recipe events, if there are any present in the cache.
//
// Guided install: https://docs.newrelic.com/docs/full-stack-observability/observe-everything/get-started/new-relic-guided-install-overview/
// newrelic-cli: https://github.com/newrelic/newrelic-cli
func (a *Installevents) InstallationCreateRecipeEventWithContext(
	ctx context.Context,
	accountID int,
	status InstallationRecipeStatus,
) (*InstallationRecipeEvent, error) {

	resp := InstallationCreateRecipeEventQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"status":    status,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, InstallationCreateRecipeEventMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.InstallationRecipeEvent, nil
}

type InstallationCreateRecipeEventQueryResponse struct {
	InstallationRecipeEvent InstallationRecipeEvent `json:"InstallationCreateRecipeEvent"`
}

const InstallationCreateRecipeEventMutation = `mutation(
	$accountId: Int!,
	$status: InstallationRecipeStatus!,
) { installationCreateRecipeEvent(
	accountId: $accountId,
	status: $status,
) {
	cliVersion
	complete
	displayName
	entityGuid
	error {
		details
		message
	}
	hostName
	installId
	installLibraryVersion
	kernelArch
	kernelVersion
	logFilePath
	metadata
	name
	os
	platform
	platformFamily
	platformVersion
	redirectUrl
	status
	targetedInstall
	taskPath
	timestamp
	validationDurationMilliseconds
} }`
