// Code generated by tutone: DO NOT EDIT
package entities

import (
	"encoding/json"
	"fmt"

	"github.com/newrelic/newrelic-client-go/v2/pkg/accounts"
	"github.com/newrelic/newrelic-client-go/v2/pkg/common"
	"github.com/newrelic/newrelic-client-go/v2/pkg/nrdb"
	"github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"
	"github.com/newrelic/newrelic-client-go/v2/pkg/servicelevel"
	"github.com/newrelic/newrelic-client-go/v2/pkg/users"
)

// AgentApplicationSegmentsListType - Allow lists have two different types. They are either internal lists or user lists.
type AgentApplicationSegmentsListType string

var AgentApplicationSegmentsListTypeTypes = struct {
	// INTERNAL refers to a list that has been generated by New Relic.
	INTERNAL AgentApplicationSegmentsListType
	// USER refers to a list that has been generated by the customer.
	USER AgentApplicationSegmentsListType
}{
	// INTERNAL refers to a list that has been generated by New Relic.
	INTERNAL: "INTERNAL",
	// USER refers to a list that has been generated by the customer.
	USER: "USER",
}

// AgentApplicationSettingsBrowserLoader - Determines which browser loader will be configured. Some allowed return values are specified for backwards-compatability and do not represent currently allowed values for new applications.
// See [documentation](https://docs.newrelic.com/docs/browser/browser-monitoring/installation/install-browser-monitoring-agent/#agent-types) for further information.
type AgentApplicationSettingsBrowserLoader string

var AgentApplicationSettingsBrowserLoaderTypes = struct {
	// Use PRO instead
	FULL AgentApplicationSettingsBrowserLoader
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE AgentApplicationSettingsBrowserLoader
	// Don't use an agent.
	NONE AgentApplicationSettingsBrowserLoader
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO AgentApplicationSettingsBrowserLoader
	// This value is no longer in use.
	RUM AgentApplicationSettingsBrowserLoader
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA AgentApplicationSettingsBrowserLoader
	// This value is specified for backwards-compatability.
	XHR AgentApplicationSettingsBrowserLoader
}{
	// Use PRO instead
	FULL: "FULL",
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE: "LITE",
	// Don't use an agent.
	NONE: "NONE",
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO: "PRO",
	// This value is no longer in use.
	RUM: "RUM",
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA: "SPA",
	// This value is specified for backwards-compatability.
	XHR: "XHR",
}

// AgentApplicationSettingsNetworkFilterMode - Configuration setting to apply either the show or hide strategy for network filtering.
type AgentApplicationSettingsNetworkFilterMode string

var AgentApplicationSettingsNetworkFilterModeTypes = struct {
	// Disables both show and hide confurations.
	DISABLED AgentApplicationSettingsNetworkFilterMode
	// Use the hide list configuration.
	HIDE AgentApplicationSettingsNetworkFilterMode
	// Use the show list configuration.
	SHOW AgentApplicationSettingsNetworkFilterMode
}{
	// Disables both show and hide confurations.
	DISABLED: "DISABLED",
	// Use the hide list configuration.
	HIDE: "HIDE",
	// Use the show list configuration.
	SHOW: "SHOW",
}

// AgentApplicationSettingsRecordSqlEnum - Obfuscation level for SQL queries reported in transaction trace nodes.
//
// When turned on, the New Relic agent will attempt to remove values from SQL qeries.
//
// For example:
//
// ```
// SELECT * FROM Table WHERE ssn='123-45-6789'
// ```
//
// might become:
//
// ```
// SELECT * FROM Table WHERE ssn=?
// ```
//
// This can behave differently for differnet applications and frameworks. Please test for your specific case.
// Note: RAW collection is not campatible with High Security mode and cannot be set if your agent is running in that mode.
type AgentApplicationSettingsRecordSqlEnum string

var AgentApplicationSettingsRecordSqlEnumTypes = struct {
	// This is the default value. This setting strips string literals and numeric sequences from your queries and replaces them with the ? character. For example: the query select * from table where ssn='123-45-6789' would become select * from table where ssn=?.
	OBFUSCATED AgentApplicationSettingsRecordSqlEnum
	// Query collection is turned off entirely.
	OFF AgentApplicationSettingsRecordSqlEnum
	// If you are confident that full query data collection will not impact your data security or your users' privacy, you can change the setting to RAW, which will record all query values. NOTE: 'RAW' is not permitted when 'High security mode' is enabled.
	RAW AgentApplicationSettingsRecordSqlEnum
}{
	// This is the default value. This setting strips string literals and numeric sequences from your queries and replaces them with the ? character. For example: the query select * from table where ssn='123-45-6789' would become select * from table where ssn=?.
	OBFUSCATED: "OBFUSCATED",
	// Query collection is turned off entirely.
	OFF: "OFF",
	// If you are confident that full query data collection will not impact your data security or your users' privacy, you can change the setting to RAW, which will record all query values. NOTE: 'RAW' is not permitted when 'High security mode' is enabled.
	RAW: "RAW",
}

// AgentApplicationSettingsSessionTraceMode - Default (fixed_rate) or custom (probabilistic) option used to collect session traces.
type AgentApplicationSettingsSessionTraceMode string

var AgentApplicationSettingsSessionTraceModeTypes = struct {
	// Fixed Rate mode for Session Trace
	// (Default) Session traces are randomly sampled and stored at a rate of 90/hour.
	FIXED_RATE AgentApplicationSettingsSessionTraceMode
	// Probabilistic mode for Session Trace
	// (Custom) Opt to collect more session traces using percentage from 0-100.
	PROBABILISTIC AgentApplicationSettingsSessionTraceMode
}{
	// Fixed Rate mode for Session Trace
	// (Default) Session traces are randomly sampled and stored at a rate of 90/hour.
	FIXED_RATE: "FIXED_RATE",
	// Probabilistic mode for Session Trace
	// (Custom) Opt to collect more session traces using percentage from 0-100.
	PROBABILISTIC: "PROBABILISTIC",
}

// AgentApplicationSettingsThresholdTypeEnum - Determines whether a threshold is statically configured or dynamically configured.
type AgentApplicationSettingsThresholdTypeEnum string

var AgentApplicationSettingsThresholdTypeEnumTypes = struct {
	// Configures the threshold to be 4 times the value of APDEX_T.
	APDEX_F AgentApplicationSettingsThresholdTypeEnum
	// Threshold will be statically configured via the corresponding "value" field.
	VALUE AgentApplicationSettingsThresholdTypeEnum
}{
	// Configures the threshold to be 4 times the value of APDEX_T.
	APDEX_F: "APDEX_F",
	// Threshold will be statically configured via the corresponding "value" field.
	VALUE: "VALUE",
}

// AgentApplicationSettingsTracer - The type of tracing being done.
type AgentApplicationSettingsTracer string

var AgentApplicationSettingsTracerTypes = struct {
	// Cross-application tracing feature enabled.
	CROSS_APPLICATION_TRACER AgentApplicationSettingsTracer
	// Distributed tracing feature enabled.
	DISTRIBUTED_TRACING AgentApplicationSettingsTracer
	// Both cross-application and distributed tracing disabled.
	NONE AgentApplicationSettingsTracer
}{
	// Cross-application tracing feature enabled.
	CROSS_APPLICATION_TRACER: "CROSS_APPLICATION_TRACER",
	// Distributed tracing feature enabled.
	DISTRIBUTED_TRACING: "DISTRIBUTED_TRACING",
	// Both cross-application and distributed tracing disabled.
	NONE: "NONE",
}

// AiNotificationsChannelStatus - Channel statuses
type AiNotificationsChannelStatus string

var AiNotificationsChannelStatusTypes = struct {
	// Configuration Error channel status
	CONFIGURATION_ERROR AiNotificationsChannelStatus
	// Configuration Warning channel status
	CONFIGURATION_WARNING AiNotificationsChannelStatus
	// Default channel status
	DEFAULT AiNotificationsChannelStatus
	// Draft channel status
	DRAFT AiNotificationsChannelStatus
	// Error channel status
	ERROR AiNotificationsChannelStatus
	// Tested channel status
	TESTED AiNotificationsChannelStatus
	// Throttled channel status
	THROTTLED AiNotificationsChannelStatus
	// Unknown Error channel status
	UNKNOWN_ERROR AiNotificationsChannelStatus
}{
	// Configuration Error channel status
	CONFIGURATION_ERROR: "CONFIGURATION_ERROR",
	// Configuration Warning channel status
	CONFIGURATION_WARNING: "CONFIGURATION_WARNING",
	// Default channel status
	DEFAULT: "DEFAULT",
	// Draft channel status
	DRAFT: "DRAFT",
	// Error channel status
	ERROR: "ERROR",
	// Tested channel status
	TESTED: "TESTED",
	// Throttled channel status
	THROTTLED: "THROTTLED",
	// Unknown Error channel status
	UNKNOWN_ERROR: "UNKNOWN_ERROR",
}

// AiNotificationsChannelType - Channel type
type AiNotificationsChannelType string

var AiNotificationsChannelTypeTypes = struct {
	// Email channel type
	EMAIL AiNotificationsChannelType
	// Event Bridge channel type
	EVENT_BRIDGE AiNotificationsChannelType
	// Jira Classic channel type
	JIRA_CLASSIC AiNotificationsChannelType
	// Jira Nextgen channel type
	JIRA_NEXTGEN AiNotificationsChannelType
	// Mobile push channel type
	MOBILE_PUSH AiNotificationsChannelType
	// PagerDuty channel type
	PAGERDUTY_ACCOUNT_INTEGRATION AiNotificationsChannelType
	// Pager Duty channel type
	PAGERDUTY_SERVICE_INTEGRATION AiNotificationsChannelType
	// Servicenow events channel type
	SERVICENOW_EVENTS AiNotificationsChannelType
	// Servicenow incidents channel type
	SERVICENOW_INCIDENTS AiNotificationsChannelType
	// ServiceNow app channel type
	SERVICE_NOW_APP AiNotificationsChannelType
	// Slack channel type
	SLACK AiNotificationsChannelType
	// Slack Collaboration channel type
	SLACK_COLLABORATION AiNotificationsChannelType
	// Legacy Slack channel type based on Incoming Webhooks
	SLACK_LEGACY AiNotificationsChannelType
	// Webhook channel type
	WEBHOOK AiNotificationsChannelType
}{
	// Email channel type
	EMAIL: "EMAIL",
	// Event Bridge channel type
	EVENT_BRIDGE: "EVENT_BRIDGE",
	// Jira Classic channel type
	JIRA_CLASSIC: "JIRA_CLASSIC",
	// Jira Nextgen channel type
	JIRA_NEXTGEN: "JIRA_NEXTGEN",
	// Mobile push channel type
	MOBILE_PUSH: "MOBILE_PUSH",
	// PagerDuty channel type
	PAGERDUTY_ACCOUNT_INTEGRATION: "PAGERDUTY_ACCOUNT_INTEGRATION",
	// Pager Duty channel type
	PAGERDUTY_SERVICE_INTEGRATION: "PAGERDUTY_SERVICE_INTEGRATION",
	// Servicenow events channel type
	SERVICENOW_EVENTS: "SERVICENOW_EVENTS",
	// Servicenow incidents channel type
	SERVICENOW_INCIDENTS: "SERVICENOW_INCIDENTS",
	// ServiceNow app channel type
	SERVICE_NOW_APP: "SERVICE_NOW_APP",
	// Slack channel type
	SLACK: "SLACK",
	// Slack Collaboration channel type
	SLACK_COLLABORATION: "SLACK_COLLABORATION",
	// Legacy Slack channel type based on Incoming Webhooks
	SLACK_LEGACY: "SLACK_LEGACY",
	// Webhook channel type
	WEBHOOK: "WEBHOOK",
}

// AiNotificationsDestinationStatus - Destination statuses
type AiNotificationsDestinationStatus string

var AiNotificationsDestinationStatusTypes = struct {
	// Authentication Error destination status
	AUTHENTICATION_ERROR AiNotificationsDestinationStatus
	// Authorization Error destination status
	AUTHORIZATION_ERROR AiNotificationsDestinationStatus
	// Authorization Warning destination status
	AUTHORIZATION_WARNING AiNotificationsDestinationStatus
	// Auth Error destination status
	AUTH_ERROR AiNotificationsDestinationStatus
	// Configuration Error destination status
	CONFIGURATION_ERROR AiNotificationsDestinationStatus
	// Default destination status
	DEFAULT AiNotificationsDestinationStatus
	// Draft channel status
	DRAFT AiNotificationsDestinationStatus
	// Error channel status
	ERROR AiNotificationsDestinationStatus
	// External Server Error destination status
	EXTERNAL_SERVER_ERROR AiNotificationsDestinationStatus
	// Temporary Warning destination status
	TEMPORARY_WARNING AiNotificationsDestinationStatus
	// Tested channel status
	TESTED AiNotificationsDestinationStatus
	// Throttled channel status
	THROTTLED AiNotificationsDestinationStatus
	// Throttling Warning destination status
	THROTTLING_WARNING AiNotificationsDestinationStatus
	// Timeout Error destination status
	TIMEOUT_ERROR AiNotificationsDestinationStatus
	// Uninstalled destination status
	UNINSTALLED AiNotificationsDestinationStatus
	// Unknown Error destination status
	UNKNOWN_ERROR AiNotificationsDestinationStatus
}{
	// Authentication Error destination status
	AUTHENTICATION_ERROR: "AUTHENTICATION_ERROR",
	// Authorization Error destination status
	AUTHORIZATION_ERROR: "AUTHORIZATION_ERROR",
	// Authorization Warning destination status
	AUTHORIZATION_WARNING: "AUTHORIZATION_WARNING",
	// Auth Error destination status
	AUTH_ERROR: "AUTH_ERROR",
	// Configuration Error destination status
	CONFIGURATION_ERROR: "CONFIGURATION_ERROR",
	// Default destination status
	DEFAULT: "DEFAULT",
	// Draft channel status
	DRAFT: "DRAFT",
	// Error channel status
	ERROR: "ERROR",
	// External Server Error destination status
	EXTERNAL_SERVER_ERROR: "EXTERNAL_SERVER_ERROR",
	// Temporary Warning destination status
	TEMPORARY_WARNING: "TEMPORARY_WARNING",
	// Tested channel status
	TESTED: "TESTED",
	// Throttled channel status
	THROTTLED: "THROTTLED",
	// Throttling Warning destination status
	THROTTLING_WARNING: "THROTTLING_WARNING",
	// Timeout Error destination status
	TIMEOUT_ERROR: "TIMEOUT_ERROR",
	// Uninstalled destination status
	UNINSTALLED: "UNINSTALLED",
	// Unknown Error destination status
	UNKNOWN_ERROR: "UNKNOWN_ERROR",
}

// AiNotificationsDestinationType - Destination types
type AiNotificationsDestinationType string

var AiNotificationsDestinationTypeTypes = struct {
	// Email destination type
	EMAIL AiNotificationsDestinationType
	// EventBridge destination type
	EVENT_BRIDGE AiNotificationsDestinationType
	// Jira destination type
	JIRA AiNotificationsDestinationType
	// Mobile push destination type
	MOBILE_PUSH AiNotificationsDestinationType
	// PagerDuty destination type
	PAGERDUTY_ACCOUNT_INTEGRATION AiNotificationsDestinationType
	// PagerDuty destination type}
	PAGERDUTY_SERVICE_INTEGRATION AiNotificationsDestinationType
	// ServiceNow destination type
	SERVICE_NOW AiNotificationsDestinationType
	// ServiceNow app destination type
	SERVICE_NOW_APP AiNotificationsDestinationType
	// Slack destination type
	SLACK AiNotificationsDestinationType
	// Slack Collaboration destination type
	SLACK_COLLABORATION AiNotificationsDestinationType
	// Legacy Slack destination type based on Incoming Webhooks
	SLACK_LEGACY AiNotificationsDestinationType
	// WebHook destination type
	WEBHOOK AiNotificationsDestinationType
}{
	// Email destination type
	EMAIL: "EMAIL",
	// EventBridge destination type
	EVENT_BRIDGE: "EVENT_BRIDGE",
	// Jira destination type
	JIRA: "JIRA",
	// Mobile push destination type
	MOBILE_PUSH: "MOBILE_PUSH",
	// PagerDuty destination type
	PAGERDUTY_ACCOUNT_INTEGRATION: "PAGERDUTY_ACCOUNT_INTEGRATION",
	// PagerDuty destination type}
	PAGERDUTY_SERVICE_INTEGRATION: "PAGERDUTY_SERVICE_INTEGRATION",
	// ServiceNow destination type
	SERVICE_NOW: "SERVICE_NOW",
	// ServiceNow app destination type
	SERVICE_NOW_APP: "SERVICE_NOW_APP",
	// Slack destination type
	SLACK: "SLACK",
	// Slack Collaboration destination type
	SLACK_COLLABORATION: "SLACK_COLLABORATION",
	// Legacy Slack destination type based on Incoming Webhooks
	SLACK_LEGACY: "SLACK_LEGACY",
	// WebHook destination type
	WEBHOOK: "WEBHOOK",
}

// AiNotificationsProduct - Product types
type AiNotificationsProduct string

var AiNotificationsProductTypes = struct {
	// Alerts product type
	ALERTS AiNotificationsProduct
	// APM product type
	APM AiNotificationsProduct
	// Change tracking product type
	CHANGE_TRACKING AiNotificationsProduct
	// CSSP (EOPs) product type
	CSSP AiNotificationsProduct
	// Discussions and comments product type
	DISCUSSIONS AiNotificationsProduct
	// Error Tracking product type
	ERROR_TRACKING AiNotificationsProduct
	// Incident Intelligence product type
	IINT AiNotificationsProduct
	// Notifications internal product type
	NTFC AiNotificationsProduct
	// Proactive Detection product type
	PD AiNotificationsProduct
	// Security product type
	SECURITY AiNotificationsProduct
	// Sharing product type
	SHARING AiNotificationsProduct
}{
	// Alerts product type
	ALERTS: "ALERTS",
	// APM product type
	APM: "APM",
	// Change tracking product type
	CHANGE_TRACKING: "CHANGE_TRACKING",
	// CSSP (EOPs) product type
	CSSP: "CSSP",
	// Discussions and comments product type
	DISCUSSIONS: "DISCUSSIONS",
	// Error Tracking product type
	ERROR_TRACKING: "ERROR_TRACKING",
	// Incident Intelligence product type
	IINT: "IINT",
	// Notifications internal product type
	NTFC: "NTFC",
	// Proactive Detection product type
	PD: "PD",
	// Security product type
	SECURITY: "SECURITY",
	// Sharing product type
	SHARING: "SHARING",
}

// AiNotificationsVariableCategory - Category fields to group by
type AiNotificationsVariableCategory string

var AiNotificationsVariableCategoryTypes = struct {
	// Condition category
	CONDITION AiNotificationsVariableCategory
	// Entities category
	ENTITIES AiNotificationsVariableCategory
	// Incident category
	INCIDENT AiNotificationsVariableCategory
	// Issue category
	ISSUE AiNotificationsVariableCategory
	// Default category
	OTHER AiNotificationsVariableCategory
	// Policy category
	POLICY AiNotificationsVariableCategory
	// Tags category
	TAGS AiNotificationsVariableCategory
	// Workflow category
	WORKFLOW AiNotificationsVariableCategory
}{
	// Condition category
	CONDITION: "CONDITION",
	// Entities category
	ENTITIES: "ENTITIES",
	// Incident category
	INCIDENT: "INCIDENT",
	// Issue category
	ISSUE: "ISSUE",
	// Default category
	OTHER: "OTHER",
	// Policy category
	POLICY: "POLICY",
	// Tags category
	TAGS: "TAGS",
	// Workflow category
	WORKFLOW: "WORKFLOW",
}

// AiNotificationsVariableType - Variable types
type AiNotificationsVariableType string

var AiNotificationsVariableTypeTypes = struct {
	// Boolean variable type
	BOOLEAN AiNotificationsVariableType
	// List variable type
	LIST AiNotificationsVariableType
	// number variable type
	NUMBER AiNotificationsVariableType
	// Object variable type
	OBJECT AiNotificationsVariableType
	// String variable type
	STRING AiNotificationsVariableType
}{
	// Boolean variable type
	BOOLEAN: "BOOLEAN",
	// List variable type
	LIST: "LIST",
	// number variable type
	NUMBER: "NUMBER",
	// Object variable type
	OBJECT: "OBJECT",
	// String variable type
	STRING: "STRING",
}

// AiWorkflowsDestinationType - Type of Destination Configuration
type AiWorkflowsDestinationType string

var AiWorkflowsDestinationTypeTypes = struct {
	// Email Destination Configuration type
	EMAIL AiWorkflowsDestinationType
	// Event Bridge Destination Configuration type
	EVENT_BRIDGE AiWorkflowsDestinationType
	// Jira Destination Configuration type
	JIRA AiWorkflowsDestinationType
	// New Relic Mobile Push Destination Configuration type
	MOBILE_PUSH AiWorkflowsDestinationType
	// Pager Duty Destination Configuration type
	PAGERDUTY AiWorkflowsDestinationType
	// Pager Duty with account integration Destination Configuration type
	PAGERDUTY_ACCOUNT_INTEGRATION AiWorkflowsDestinationType
	// Pager Duty with service integration Destination Configuration type
	PAGERDUTY_SERVICE_INTEGRATION AiWorkflowsDestinationType
	// Service Now Destination Configuration type
	SERVICE_NOW AiWorkflowsDestinationType
	// ServiceNow official NewRelic app Configuration type
	SERVICE_NOW_APP AiWorkflowsDestinationType
	// Slack Destination Configuration type
	SLACK AiWorkflowsDestinationType
	// Slack legacy Destination Configuration type
	SLACK_LEGACY AiWorkflowsDestinationType
	// Webhook Destination Configuration type
	WEBHOOK AiWorkflowsDestinationType
}{
	// Email Destination Configuration type
	EMAIL: "EMAIL",
	// Event Bridge Destination Configuration type
	EVENT_BRIDGE: "EVENT_BRIDGE",
	// Jira Destination Configuration type
	JIRA: "JIRA",
	// New Relic Mobile Push Destination Configuration type
	MOBILE_PUSH: "MOBILE_PUSH",
	// Pager Duty Destination Configuration type
	PAGERDUTY: "PAGERDUTY",
	// Pager Duty with account integration Destination Configuration type
	PAGERDUTY_ACCOUNT_INTEGRATION: "PAGERDUTY_ACCOUNT_INTEGRATION",
	// Pager Duty with service integration Destination Configuration type
	PAGERDUTY_SERVICE_INTEGRATION: "PAGERDUTY_SERVICE_INTEGRATION",
	// Service Now Destination Configuration type
	SERVICE_NOW: "SERVICE_NOW",
	// ServiceNow official NewRelic app Configuration type
	SERVICE_NOW_APP: "SERVICE_NOW_APP",
	// Slack Destination Configuration type
	SLACK: "SLACK",
	// Slack legacy Destination Configuration type
	SLACK_LEGACY: "SLACK_LEGACY",
	// Webhook Destination Configuration type
	WEBHOOK: "WEBHOOK",
}

// AiWorkflowsEnrichmentType - Type of Enrichment
type AiWorkflowsEnrichmentType string

var AiWorkflowsEnrichmentTypeTypes = struct {
	// NRQL Enrichment type
	NRQL AiWorkflowsEnrichmentType
}{
	// NRQL Enrichment type
	NRQL: "NRQL",
}

// AiWorkflowsFilterType - Type of Filter
type AiWorkflowsFilterType string

var AiWorkflowsFilterTypeTypes = struct {
	// Standard Filter type
	FILTER AiWorkflowsFilterType
	// View Filter type
	VIEW AiWorkflowsFilterType
}{
	// Standard Filter type
	FILTER: "FILTER",
	// View Filter type
	VIEW: "VIEW",
}

// AiWorkflowsMutingRulesHandling - The wanted behavior for muted issues in the workflow
type AiWorkflowsMutingRulesHandling string

var AiWorkflowsMutingRulesHandlingTypes = struct {
	// Notify only about partially muted and unmuted issues
	DONT_NOTIFY_FULLY_MUTED_ISSUES AiWorkflowsMutingRulesHandling
	// Notify only about unmuted issues
	DONT_NOTIFY_FULLY_OR_PARTIALLY_MUTED_ISSUES AiWorkflowsMutingRulesHandling
	// Notify about all issues
	NOTIFY_ALL_ISSUES AiWorkflowsMutingRulesHandling
}{
	// Notify only about partially muted and unmuted issues
	DONT_NOTIFY_FULLY_MUTED_ISSUES: "DONT_NOTIFY_FULLY_MUTED_ISSUES",
	// Notify only about unmuted issues
	DONT_NOTIFY_FULLY_OR_PARTIALLY_MUTED_ISSUES: "DONT_NOTIFY_FULLY_OR_PARTIALLY_MUTED_ISSUES",
	// Notify about all issues
	NOTIFY_ALL_ISSUES: "NOTIFY_ALL_ISSUES",
}

// AiWorkflowsNotificationTrigger - Notification Triggers for the Destination Configuration
type AiWorkflowsNotificationTrigger string

var AiWorkflowsNotificationTriggerTypes = struct {
	// Send a notification when the issue is acknowledged
	ACKNOWLEDGED AiWorkflowsNotificationTrigger
	// Send a notification when the issue is activated
	ACTIVATED AiWorkflowsNotificationTrigger
	// Send a notification when the issue is closed
	CLOSED AiWorkflowsNotificationTrigger
	// Sends notification when the issue has other updates
	OTHER_UPDATES AiWorkflowsNotificationTrigger
	// Send a notification when the issue's priority has changed
	PRIORITY_CHANGED AiWorkflowsNotificationTrigger
}{
	// Send a notification when the issue is acknowledged
	ACKNOWLEDGED: "ACKNOWLEDGED",
	// Send a notification when the issue is activated
	ACTIVATED: "ACTIVATED",
	// Send a notification when the issue is closed
	CLOSED: "CLOSED",
	// Sends notification when the issue has other updates
	OTHER_UPDATES: "OTHER_UPDATES",
	// Send a notification when the issue's priority has changed
	PRIORITY_CHANGED: "PRIORITY_CHANGED",
}

// AiWorkflowsOperator - Type of Filter
type AiWorkflowsOperator string

var AiWorkflowsOperatorTypes = struct {
	// String or list attribute contains this value
	CONTAINS AiWorkflowsOperator
	// String or list attribute does not contain this value
	DOES_NOT_CONTAIN AiWorkflowsOperator
	// String or Numeric attribute does not equal this value
	DOES_NOT_EQUAL AiWorkflowsOperator
	// Element in list attribute does not exactly match this value
	DOES_NOT_EXACTLY_MATCH AiWorkflowsOperator
	// String attribute ends with this value
	ENDS_WITH AiWorkflowsOperator
	// String or Numeric attribute equals this value
	EQUAL AiWorkflowsOperator
	// Element in list attribute exactly matches this value
	EXACTLY_MATCHES AiWorkflowsOperator
	// Numeric attribute is greater or equal to this value
	GREATER_OR_EQUAL AiWorkflowsOperator
	// Numeric attribute is greater than this value
	GREATER_THAN AiWorkflowsOperator
	// Boolean attribute equals value
	IS AiWorkflowsOperator
	// Boolean attribute does not equal value
	IS_NOT AiWorkflowsOperator
	// Numeric attribute is less or equal to this value
	LESS_OR_EQUAL AiWorkflowsOperator
	// Numeric attribute is less than this value
	LESS_THAN AiWorkflowsOperator
	// String attribute starts with this value
	STARTS_WITH AiWorkflowsOperator
}{
	// String or list attribute contains this value
	CONTAINS: "CONTAINS",
	// String or list attribute does not contain this value
	DOES_NOT_CONTAIN: "DOES_NOT_CONTAIN",
	// String or Numeric attribute does not equal this value
	DOES_NOT_EQUAL: "DOES_NOT_EQUAL",
	// Element in list attribute does not exactly match this value
	DOES_NOT_EXACTLY_MATCH: "DOES_NOT_EXACTLY_MATCH",
	// String attribute ends with this value
	ENDS_WITH: "ENDS_WITH",
	// String or Numeric attribute equals this value
	EQUAL: "EQUAL",
	// Element in list attribute exactly matches this value
	EXACTLY_MATCHES: "EXACTLY_MATCHES",
	// Numeric attribute is greater or equal to this value
	GREATER_OR_EQUAL: "GREATER_OR_EQUAL",
	// Numeric attribute is greater than this value
	GREATER_THAN: "GREATER_THAN",
	// Boolean attribute equals value
	IS: "IS",
	// Boolean attribute does not equal value
	IS_NOT: "IS_NOT",
	// Numeric attribute is less or equal to this value
	LESS_OR_EQUAL: "LESS_OR_EQUAL",
	// Numeric attribute is less than this value
	LESS_THAN: "LESS_THAN",
	// String attribute starts with this value
	STARTS_WITH: "STARTS_WITH",
}

// BrowserAgentInstallType - Browser agent install types.
type BrowserAgentInstallType string

var BrowserAgentInstallTypeTypes = struct {
	// Lite agent install type.
	LITE BrowserAgentInstallType
	// Pro agent install type.
	PRO BrowserAgentInstallType
	// Pro + SPA agent install type.
	PRO_SPA BrowserAgentInstallType
}{
	// Lite agent install type.
	LITE: "LITE",
	// Pro agent install type.
	PRO: "PRO",
	// Pro + SPA agent install type.
	PRO_SPA: "PRO_SPA",
}

// ChangeTrackingDeploymentType - Type of deployment.
type ChangeTrackingDeploymentType string

var ChangeTrackingDeploymentTypeTypes = struct {
	// A vanilla deployment
	BASIC ChangeTrackingDeploymentType
	// Blue-green deployment
	BLUE_GREEN ChangeTrackingDeploymentType
	// Canary deployment
	CANARY ChangeTrackingDeploymentType
	// Other types of deployment.
	OTHER ChangeTrackingDeploymentType
	// Rolling deployment.
	ROLLING ChangeTrackingDeploymentType
	// Shadow deployment
	SHADOW ChangeTrackingDeploymentType
}{
	// A vanilla deployment
	BASIC: "BASIC",
	// Blue-green deployment
	BLUE_GREEN: "BLUE_GREEN",
	// Canary deployment
	CANARY: "CANARY",
	// Other types of deployment.
	OTHER: "OTHER",
	// Rolling deployment.
	ROLLING: "ROLLING",
	// Shadow deployment
	SHADOW: "SHADOW",
}

// DashboardAlertSeverity - Alert severity.
type DashboardAlertSeverity string

var DashboardAlertSeverityTypes = struct {
	// CRITICAL.
	CRITICAL DashboardAlertSeverity
	// NOT_ALERTING.
	NOT_ALERTING DashboardAlertSeverity
	// WARNING.
	WARNING DashboardAlertSeverity
}{
	// CRITICAL.
	CRITICAL: "CRITICAL",
	// NOT_ALERTING.
	NOT_ALERTING: "NOT_ALERTING",
	// WARNING.
	WARNING: "WARNING",
}

// DashboardEntityPermissions - Permisions that represent visibility & editability
type DashboardEntityPermissions string

var DashboardEntityPermissionsTypes = struct {
	// Private
	PRIVATE DashboardEntityPermissions
	// Public read only
	PUBLIC_READ_ONLY DashboardEntityPermissions
	// Public read & write
	PUBLIC_READ_WRITE DashboardEntityPermissions
}{
	// Private
	PRIVATE: "PRIVATE",
	// Public read only
	PUBLIC_READ_ONLY: "PUBLIC_READ_ONLY",
	// Public read & write
	PUBLIC_READ_WRITE: "PUBLIC_READ_WRITE",
}

// DashboardVariableReplacementStrategy - Possible strategies when replacing variables in a NRQL query.
type DashboardVariableReplacementStrategy string

var DashboardVariableReplacementStrategyTypes = struct {
	// Replace the variable based on its automatically-inferred type.
	DEFAULT DashboardVariableReplacementStrategy
	// Replace the variable value as an identifier.
	IDENTIFIER DashboardVariableReplacementStrategy
	// Replace the variable value as a number.
	NUMBER DashboardVariableReplacementStrategy
	// Replace the variable value as a string.
	STRING DashboardVariableReplacementStrategy
}{
	// Replace the variable based on its automatically-inferred type.
	DEFAULT: "DEFAULT",
	// Replace the variable value as an identifier.
	IDENTIFIER: "IDENTIFIER",
	// Replace the variable value as a number.
	NUMBER: "NUMBER",
	// Replace the variable value as a string.
	STRING: "STRING",
}

// DashboardVariableType - Indicates where a variable's possible values may come from.
type DashboardVariableType string

var DashboardVariableTypeTypes = struct {
	// Value comes from an enumerated list of possible values.
	ENUM DashboardVariableType
	// Value comes from the results of a NRQL query.
	NRQL DashboardVariableType
	// Dashboard user can supply an arbitrary string value to variable.
	STRING DashboardVariableType
}{
	// Value comes from an enumerated list of possible values.
	ENUM: "ENUM",
	// Value comes from the results of a NRQL query.
	NRQL: "NRQL",
	// Dashboard user can supply an arbitrary string value to variable.
	STRING: "STRING",
}

// EntityAlertSeverity - The alert severity of the entity.
type EntityAlertSeverity string

var EntityAlertSeverityTypes = struct {
	// Indicates an entity has a critical violation in progress.
	CRITICAL EntityAlertSeverity
	// Indicates an entity has no violations and therefore is not alerting.
	NOT_ALERTING EntityAlertSeverity
	// Indicates an entity is not configured for alerting.
	NOT_CONFIGURED EntityAlertSeverity
	// Indicates an entity  has a warning violation in progress.
	WARNING EntityAlertSeverity
}{
	// Indicates an entity has a critical violation in progress.
	CRITICAL: "CRITICAL",
	// Indicates an entity has no violations and therefore is not alerting.
	NOT_ALERTING: "NOT_ALERTING",
	// Indicates an entity is not configured for alerting.
	NOT_CONFIGURED: "NOT_CONFIGURED",
	// Indicates an entity  has a warning violation in progress.
	WARNING: "WARNING",
}

// EntityCollectionType - Indicates where this collection is used
type EntityCollectionType string

var EntityCollectionTypeTypes = struct {
	// Collections that define the entities that belong to a team
	TEAM EntityCollectionType
	// Collections that define the entities that belong to a workload
	WORKLOAD EntityCollectionType
	// Collections that define the entity groups that are used to calculate the status of a workload
	WORKLOAD_STATUS_RULE_GROUP EntityCollectionType
}{
	// Collections that define the entities that belong to a team
	TEAM: "TEAM",
	// Collections that define the entities that belong to a workload
	WORKLOAD: "WORKLOAD",
	// Collections that define the entity groups that are used to calculate the status of a workload
	WORKLOAD_STATUS_RULE_GROUP: "WORKLOAD_STATUS_RULE_GROUP",
}

// EntityGoldenEventObjectId - Types of references for the default WHERE clause.
type EntityGoldenEventObjectId string

var EntityGoldenEventObjectIdTypes = struct {
	// The WHERE clause will be done against a domainId.
	DOMAIN_IDS EntityGoldenEventObjectId
	// The WHERE clause will be done against a GUID.
	ENTITY_GUIDS EntityGoldenEventObjectId
	// The WHERE clause will be done against the name of the entity.
	ENTITY_NAMES EntityGoldenEventObjectId
}{
	// The WHERE clause will be done against a domainId.
	DOMAIN_IDS: "DOMAIN_IDS",
	// The WHERE clause will be done against a GUID.
	ENTITY_GUIDS: "ENTITY_GUIDS",
	// The WHERE clause will be done against the name of the entity.
	ENTITY_NAMES: "ENTITY_NAMES",
}

// EntityGoldenMetricUnit - The different units that can be used to express golden metrics.
type EntityGoldenMetricUnit string

var EntityGoldenMetricUnitTypes = struct {
	// Apdex (Application Performance Index).
	APDEX EntityGoldenMetricUnit
	// Bits.
	BITS EntityGoldenMetricUnit
	// Bits per second.
	BITS_PER_SECOND EntityGoldenMetricUnit
	// Bytes.
	BYTES EntityGoldenMetricUnit
	// Bytes per second.
	BYTES_PER_SECOND EntityGoldenMetricUnit
	// Degrees celsius.
	CELSIUS EntityGoldenMetricUnit
	// Count.
	COUNT EntityGoldenMetricUnit
	// Hertz.
	HERTZ EntityGoldenMetricUnit
	// Messages per second.
	MESSAGES_PER_SECOND EntityGoldenMetricUnit
	// Milliseconds.
	MS EntityGoldenMetricUnit
	// Operations per second.
	OPERATIONS_PER_SECOND EntityGoldenMetricUnit
	// Pages loaded per second.
	PAGES_PER_SECOND EntityGoldenMetricUnit
	// Percentage.
	PERCENTAGE EntityGoldenMetricUnit
	// Requests received per minute.
	REQUESTS_PER_MINUTE EntityGoldenMetricUnit
	// Requests received per second.
	REQUESTS_PER_SECOND EntityGoldenMetricUnit
	// Seconds.
	SECONDS EntityGoldenMetricUnit
	// Timestamp.
	TIMESTAMP EntityGoldenMetricUnit
}{
	// Apdex (Application Performance Index).
	APDEX: "APDEX",
	// Bits.
	BITS: "BITS",
	// Bits per second.
	BITS_PER_SECOND: "BITS_PER_SECOND",
	// Bytes.
	BYTES: "BYTES",
	// Bytes per second.
	BYTES_PER_SECOND: "BYTES_PER_SECOND",
	// Degrees celsius.
	CELSIUS: "CELSIUS",
	// Count.
	COUNT: "COUNT",
	// Hertz.
	HERTZ: "HERTZ",
	// Messages per second.
	MESSAGES_PER_SECOND: "MESSAGES_PER_SECOND",
	// Milliseconds.
	MS: "MS",
	// Operations per second.
	OPERATIONS_PER_SECOND: "OPERATIONS_PER_SECOND",
	// Pages loaded per second.
	PAGES_PER_SECOND: "PAGES_PER_SECOND",
	// Percentage.
	PERCENTAGE: "PERCENTAGE",
	// Requests received per minute.
	REQUESTS_PER_MINUTE: "REQUESTS_PER_MINUTE",
	// Requests received per second.
	REQUESTS_PER_SECOND: "REQUESTS_PER_SECOND",
	// Seconds.
	SECONDS: "SECONDS",
	// Timestamp.
	TIMESTAMP: "TIMESTAMP",
}

// EntityInfrastructureIntegrationType - The type of Infrastructure Integration
type EntityInfrastructureIntegrationType string

var EntityInfrastructureIntegrationTypeTypes = struct {
	// APACHE_SERVER integration
	APACHE_SERVER EntityInfrastructureIntegrationType
	// AWSELASTICSEARCHNODE integration
	AWSELASTICSEARCHNODE EntityInfrastructureIntegrationType
	// AWS_ALB integration
	AWS_ALB EntityInfrastructureIntegrationType
	// AWS_ALB_LISTENER integration
	AWS_ALB_LISTENER EntityInfrastructureIntegrationType
	// AWS_ALB_LISTENER_RULE integration
	AWS_ALB_LISTENER_RULE EntityInfrastructureIntegrationType
	// AWS_ALB_TARGET_GROUP integration
	AWS_ALB_TARGET_GROUP EntityInfrastructureIntegrationType
	// AWS_API_GATEWAY_API integration
	AWS_API_GATEWAY_API EntityInfrastructureIntegrationType
	// AWS_API_GATEWAY_RESOURCE integration
	AWS_API_GATEWAY_RESOURCE EntityInfrastructureIntegrationType
	// AWS_API_GATEWAY_RESOURCE_WITH_METRICS integration
	AWS_API_GATEWAY_RESOURCE_WITH_METRICS EntityInfrastructureIntegrationType
	// AWS_API_GATEWAY_STAGE integration
	AWS_API_GATEWAY_STAGE EntityInfrastructureIntegrationType
	// AWS_AUTO_SCALING_GROUP integration
	AWS_AUTO_SCALING_GROUP EntityInfrastructureIntegrationType
	// AWS_AUTO_SCALING_INSTANCE integration
	AWS_AUTO_SCALING_INSTANCE EntityInfrastructureIntegrationType
	// AWS_AUTO_SCALING_LAUNCH_CONFIGURATION integration
	AWS_AUTO_SCALING_LAUNCH_CONFIGURATION EntityInfrastructureIntegrationType
	// AWS_AUTO_SCALING_POLICY integration
	AWS_AUTO_SCALING_POLICY EntityInfrastructureIntegrationType
	// AWS_AUTO_SCALING_REGION_LIMIT integration
	AWS_AUTO_SCALING_REGION_LIMIT EntityInfrastructureIntegrationType
	// AWS_BILLING_ACCOUNT_COST integration
	AWS_BILLING_ACCOUNT_COST EntityInfrastructureIntegrationType
	// AWS_BILLING_ACCOUNT_SERVICE_COST integration
	AWS_BILLING_ACCOUNT_SERVICE_COST EntityInfrastructureIntegrationType
	// AWS_BILLING_BUDGET integration
	AWS_BILLING_BUDGET EntityInfrastructureIntegrationType
	// AWS_BILLING_SERVICE_COST integration
	AWS_BILLING_SERVICE_COST EntityInfrastructureIntegrationType
	// AWS_CLOUD_FRONT_DISTRIBUTION integration
	AWS_CLOUD_FRONT_DISTRIBUTION EntityInfrastructureIntegrationType
	// AWS_CLOUD_TRAIL integration
	AWS_CLOUD_TRAIL EntityInfrastructureIntegrationType
	// AWS_DYNAMO_DB_GLOBAL_SECONDARY_INDEX integration
	AWS_DYNAMO_DB_GLOBAL_SECONDARY_INDEX EntityInfrastructureIntegrationType
	// AWS_DYNAMO_DB_REGION integration
	AWS_DYNAMO_DB_REGION EntityInfrastructureIntegrationType
	// AWS_DYNAMO_DB_TABLE integration
	AWS_DYNAMO_DB_TABLE EntityInfrastructureIntegrationType
	// AWS_EBS_VOLUME integration
	AWS_EBS_VOLUME EntityInfrastructureIntegrationType
	// AWS_ECS_CLUSTER integration
	AWS_ECS_CLUSTER EntityInfrastructureIntegrationType
	// AWS_ECS_SERVICE integration
	AWS_ECS_SERVICE EntityInfrastructureIntegrationType
	// AWS_EFS_FILE_SYSTEM integration
	AWS_EFS_FILE_SYSTEM EntityInfrastructureIntegrationType
	// AWS_ELASTICSEARCH_CLUSTER integration
	AWS_ELASTICSEARCH_CLUSTER EntityInfrastructureIntegrationType
	// AWS_ELASTICSEARCH_INSTANCE integration
	AWS_ELASTICSEARCH_INSTANCE EntityInfrastructureIntegrationType
	// AWS_ELASTIC_BEANSTALK_ENVIRONMENT integration
	AWS_ELASTIC_BEANSTALK_ENVIRONMENT EntityInfrastructureIntegrationType
	// AWS_ELASTIC_BEANSTALK_INSTANCE integration
	AWS_ELASTIC_BEANSTALK_INSTANCE EntityInfrastructureIntegrationType
	// AWS_ELASTIC_MAP_REDUCE_CLUSTER integration
	AWS_ELASTIC_MAP_REDUCE_CLUSTER EntityInfrastructureIntegrationType
	// AWS_ELASTIC_MAP_REDUCE_INSTANCE integration
	AWS_ELASTIC_MAP_REDUCE_INSTANCE EntityInfrastructureIntegrationType
	// AWS_ELASTIC_MAP_REDUCE_INSTANCE_FLEET integration
	AWS_ELASTIC_MAP_REDUCE_INSTANCE_FLEET EntityInfrastructureIntegrationType
	// AWS_ELASTIC_MAP_REDUCE_INSTANCE_GROUP integration
	AWS_ELASTIC_MAP_REDUCE_INSTANCE_GROUP EntityInfrastructureIntegrationType
	// AWS_ELASTI_CACHE_MEMCACHED_CLUSTER integration
	AWS_ELASTI_CACHE_MEMCACHED_CLUSTER EntityInfrastructureIntegrationType
	// AWS_ELASTI_CACHE_MEMCACHED_NODE integration
	AWS_ELASTI_CACHE_MEMCACHED_NODE EntityInfrastructureIntegrationType
	// AWS_ELASTI_CACHE_REDIS_CLUSTER integration
	AWS_ELASTI_CACHE_REDIS_CLUSTER EntityInfrastructureIntegrationType
	// AWS_ELASTI_CACHE_REDIS_NODE integration
	AWS_ELASTI_CACHE_REDIS_NODE EntityInfrastructureIntegrationType
	// AWS_ELB integration
	AWS_ELB EntityInfrastructureIntegrationType
	// AWS_HEALTH_ISSUE integration
	AWS_HEALTH_ISSUE EntityInfrastructureIntegrationType
	// AWS_HEALTH_NOTIFICATION integration
	AWS_HEALTH_NOTIFICATION EntityInfrastructureIntegrationType
	// AWS_HEALTH_SCHEDULED_CHANGE integration
	AWS_HEALTH_SCHEDULED_CHANGE EntityInfrastructureIntegrationType
	// AWS_HEALTH_UNKNOWN integration
	AWS_HEALTH_UNKNOWN EntityInfrastructureIntegrationType
	// AWS_IAM integration
	AWS_IAM EntityInfrastructureIntegrationType
	// AWS_IAM_GROUP integration
	AWS_IAM_GROUP EntityInfrastructureIntegrationType
	// AWS_IAM_OPEN_ID_PROVIDER integration
	AWS_IAM_OPEN_ID_PROVIDER EntityInfrastructureIntegrationType
	// AWS_IAM_POLICY integration
	AWS_IAM_POLICY EntityInfrastructureIntegrationType
	// AWS_IAM_ROLE integration
	AWS_IAM_ROLE EntityInfrastructureIntegrationType
	// AWS_IAM_SAML_PROVIDER integration
	AWS_IAM_SAML_PROVIDER EntityInfrastructureIntegrationType
	// AWS_IAM_SERVER_CERTIFICATE integration
	AWS_IAM_SERVER_CERTIFICATE EntityInfrastructureIntegrationType
	// AWS_IAM_USER integration
	AWS_IAM_USER EntityInfrastructureIntegrationType
	// AWS_IAM_VIRTUAL_MFA_DEVICE integration
	AWS_IAM_VIRTUAL_MFA_DEVICE EntityInfrastructureIntegrationType
	// AWS_IOT_BROKER integration
	AWS_IOT_BROKER EntityInfrastructureIntegrationType
	// AWS_IOT_RULE integration
	AWS_IOT_RULE EntityInfrastructureIntegrationType
	// AWS_IOT_RULE_ACTION integration
	AWS_IOT_RULE_ACTION EntityInfrastructureIntegrationType
	// AWS_KINESIS_DELIVERY_STREAM integration
	AWS_KINESIS_DELIVERY_STREAM EntityInfrastructureIntegrationType
	// AWS_KINESIS_STREAM integration
	AWS_KINESIS_STREAM EntityInfrastructureIntegrationType
	// AWS_KINESIS_STREAM_SHARD integration
	AWS_KINESIS_STREAM_SHARD EntityInfrastructureIntegrationType
	// AWS_LAMBDA_AGENT_TRANSACTION integration
	AWS_LAMBDA_AGENT_TRANSACTION EntityInfrastructureIntegrationType
	// AWS_LAMBDA_AGENT_TRANSACTION_ERROR integration
	AWS_LAMBDA_AGENT_TRANSACTION_ERROR EntityInfrastructureIntegrationType
	// AWS_LAMBDA_EDGE_FUNCTION integration
	AWS_LAMBDA_EDGE_FUNCTION EntityInfrastructureIntegrationType
	// AWS_LAMBDA_EVENT_SOURCE_MAPPING integration
	AWS_LAMBDA_EVENT_SOURCE_MAPPING EntityInfrastructureIntegrationType
	// AWS_LAMBDA_FUNCTION integration
	AWS_LAMBDA_FUNCTION EntityInfrastructureIntegrationType
	// AWS_LAMBDA_FUNCTION_ALIAS integration
	AWS_LAMBDA_FUNCTION_ALIAS EntityInfrastructureIntegrationType
	// AWS_LAMBDA_OPERATION integration
	AWS_LAMBDA_OPERATION EntityInfrastructureIntegrationType
	// AWS_LAMBDA_REGION integration
	AWS_LAMBDA_REGION EntityInfrastructureIntegrationType
	// AWS_LAMBDA_SPAN integration
	AWS_LAMBDA_SPAN EntityInfrastructureIntegrationType
	// AWS_LAMBDA_TRACE integration
	AWS_LAMBDA_TRACE EntityInfrastructureIntegrationType
	// AWS_RDS_DB_CLUSTER integration
	AWS_RDS_DB_CLUSTER EntityInfrastructureIntegrationType
	// AWS_RDS_DB_INSTANCE integration
	AWS_RDS_DB_INSTANCE EntityInfrastructureIntegrationType
	// AWS_REDSHIFT_CLUSTER integration
	AWS_REDSHIFT_CLUSTER EntityInfrastructureIntegrationType
	// AWS_REDSHIFT_NODE integration
	AWS_REDSHIFT_NODE EntityInfrastructureIntegrationType
	// AWS_ROUTE53_HEALTH_CHECK integration
	AWS_ROUTE53_HEALTH_CHECK EntityInfrastructureIntegrationType
	// AWS_ROUTE53_ZONE integration
	AWS_ROUTE53_ZONE EntityInfrastructureIntegrationType
	// AWS_ROUTE53_ZONE_RECORD_SET integration
	AWS_ROUTE53_ZONE_RECORD_SET EntityInfrastructureIntegrationType
	// AWS_S3_BUCKET integration
	AWS_S3_BUCKET EntityInfrastructureIntegrationType
	// AWS_S3_BUCKET_REQUESTS integration
	AWS_S3_BUCKET_REQUESTS EntityInfrastructureIntegrationType
	// AWS_SES_CONFIGURATION_SET integration
	AWS_SES_CONFIGURATION_SET EntityInfrastructureIntegrationType
	// AWS_SES_EVENT_DESTINATION integration
	AWS_SES_EVENT_DESTINATION EntityInfrastructureIntegrationType
	// AWS_SES_RECEIPT_FILTER integration
	AWS_SES_RECEIPT_FILTER EntityInfrastructureIntegrationType
	// AWS_SES_RECEIPT_RULE integration
	AWS_SES_RECEIPT_RULE EntityInfrastructureIntegrationType
	// AWS_SES_RECEIPT_RULE_SET integration
	AWS_SES_RECEIPT_RULE_SET EntityInfrastructureIntegrationType
	// AWS_SES_REGION integration
	AWS_SES_REGION EntityInfrastructureIntegrationType
	// AWS_SNS_SUBSCRIPTION integration
	AWS_SNS_SUBSCRIPTION EntityInfrastructureIntegrationType
	// AWS_SNS_TOPIC integration
	AWS_SNS_TOPIC EntityInfrastructureIntegrationType
	// AWS_SQS_QUEUE integration
	AWS_SQS_QUEUE EntityInfrastructureIntegrationType
	// AWS_VPC integration
	AWS_VPC EntityInfrastructureIntegrationType
	// AWS_VPC_ENDPOINT integration
	AWS_VPC_ENDPOINT EntityInfrastructureIntegrationType
	// AWS_VPC_INTERNET_GATEWAY integration
	AWS_VPC_INTERNET_GATEWAY EntityInfrastructureIntegrationType
	// AWS_VPC_NAT_GATEWAY integration
	AWS_VPC_NAT_GATEWAY EntityInfrastructureIntegrationType
	// AWS_VPC_NETWORK_ACL integration
	AWS_VPC_NETWORK_ACL EntityInfrastructureIntegrationType
	// AWS_VPC_NETWORK_INTERFACE integration
	AWS_VPC_NETWORK_INTERFACE EntityInfrastructureIntegrationType
	// AWS_VPC_PEERING_CONNECTION integration
	AWS_VPC_PEERING_CONNECTION EntityInfrastructureIntegrationType
	// AWS_VPC_ROUTE_TABLE integration
	AWS_VPC_ROUTE_TABLE EntityInfrastructureIntegrationType
	// AWS_VPC_SECURITY_GROUP integration
	AWS_VPC_SECURITY_GROUP EntityInfrastructureIntegrationType
	// AWS_VPC_SUBNET integration
	AWS_VPC_SUBNET EntityInfrastructureIntegrationType
	// AWS_VPC_VPN_CONNECTION integration
	AWS_VPC_VPN_CONNECTION EntityInfrastructureIntegrationType
	// AWS_VPC_VPN_TUNNEL integration
	AWS_VPC_VPN_TUNNEL EntityInfrastructureIntegrationType
	// AZURE_APP_SERVICE_HOST_NAME integration
	AZURE_APP_SERVICE_HOST_NAME EntityInfrastructureIntegrationType
	// AZURE_APP_SERVICE_WEB_APP integration
	AZURE_APP_SERVICE_WEB_APP EntityInfrastructureIntegrationType
	// AZURE_COSMOS_DB_ACCOUNT integration
	AZURE_COSMOS_DB_ACCOUNT EntityInfrastructureIntegrationType
	// AZURE_FUNCTIONS_APP integration
	AZURE_FUNCTIONS_APP EntityInfrastructureIntegrationType
	// AZURE_LOAD_BALANCER integration
	AZURE_LOAD_BALANCER EntityInfrastructureIntegrationType
	// AZURE_LOAD_BALANCER_BACKEND integration
	AZURE_LOAD_BALANCER_BACKEND EntityInfrastructureIntegrationType
	// AZURE_LOAD_BALANCER_FRONTEND_IP integration
	AZURE_LOAD_BALANCER_FRONTEND_IP EntityInfrastructureIntegrationType
	// AZURE_LOAD_BALANCER_INBOUND_NAT_POOL integration
	AZURE_LOAD_BALANCER_INBOUND_NAT_POOL EntityInfrastructureIntegrationType
	// AZURE_LOAD_BALANCER_INBOUND_NAT_RULE integration
	AZURE_LOAD_BALANCER_INBOUND_NAT_RULE EntityInfrastructureIntegrationType
	// AZURE_LOAD_BALANCER_PROBE integration
	AZURE_LOAD_BALANCER_PROBE EntityInfrastructureIntegrationType
	// AZURE_LOAD_BALANCER_RULE integration
	AZURE_LOAD_BALANCER_RULE EntityInfrastructureIntegrationType
	// AZURE_MARIADB_SERVER integration
	AZURE_MARIADB_SERVER EntityInfrastructureIntegrationType
	// AZURE_MYSQL_SERVER integration
	AZURE_MYSQL_SERVER EntityInfrastructureIntegrationType
	// AZURE_POSTGRESQL_SERVER integration
	AZURE_POSTGRESQL_SERVER EntityInfrastructureIntegrationType
	// AZURE_REDIS_CACHE integration
	AZURE_REDIS_CACHE EntityInfrastructureIntegrationType
	// AZURE_REDIS_CACHE_SHARD integration
	AZURE_REDIS_CACHE_SHARD EntityInfrastructureIntegrationType
	// AZURE_SERVICE_BUS_NAMESPACE integration
	AZURE_SERVICE_BUS_NAMESPACE EntityInfrastructureIntegrationType
	// AZURE_SERVICE_BUS_QUEUE integration
	AZURE_SERVICE_BUS_QUEUE EntityInfrastructureIntegrationType
	// AZURE_SERVICE_BUS_SUBSCRIPTION integration
	AZURE_SERVICE_BUS_SUBSCRIPTION EntityInfrastructureIntegrationType
	// AZURE_SERVICE_BUS_TOPIC integration
	AZURE_SERVICE_BUS_TOPIC EntityInfrastructureIntegrationType
	// AZURE_SQL_DATABASE integration
	AZURE_SQL_DATABASE EntityInfrastructureIntegrationType
	// AZURE_SQL_ELASTIC_POOL integration
	AZURE_SQL_ELASTIC_POOL EntityInfrastructureIntegrationType
	// AZURE_SQL_FIREWALL integration
	AZURE_SQL_FIREWALL EntityInfrastructureIntegrationType
	// AZURE_SQL_REPLICATION_LINK integration
	AZURE_SQL_REPLICATION_LINK EntityInfrastructureIntegrationType
	// AZURE_SQL_RESTORE_POINT integration
	AZURE_SQL_RESTORE_POINT EntityInfrastructureIntegrationType
	// AZURE_SQL_SERVER integration
	AZURE_SQL_SERVER EntityInfrastructureIntegrationType
	// AZURE_STORAGE_ACCOUNT integration
	AZURE_STORAGE_ACCOUNT EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS integration
	AZURE_VIRTUAL_NETWORKS EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_IP_CONFIGURATION integration
	AZURE_VIRTUAL_NETWORKS_IP_CONFIGURATION EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_NETWORK_INTERFACE integration
	AZURE_VIRTUAL_NETWORKS_NETWORK_INTERFACE EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_PEERING integration
	AZURE_VIRTUAL_NETWORKS_PEERING EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_PUBLIC_IP_ADDRESS integration
	AZURE_VIRTUAL_NETWORKS_PUBLIC_IP_ADDRESS EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_ROUTE integration
	AZURE_VIRTUAL_NETWORKS_ROUTE EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_ROUTE_TABLE integration
	AZURE_VIRTUAL_NETWORKS_ROUTE_TABLE EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_SECURITY_GROUP integration
	AZURE_VIRTUAL_NETWORKS_SECURITY_GROUP EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_SECURITY_RULE integration
	AZURE_VIRTUAL_NETWORKS_SECURITY_RULE EntityInfrastructureIntegrationType
	// AZURE_VIRTUAL_NETWORKS_SUBNET integration
	AZURE_VIRTUAL_NETWORKS_SUBNET EntityInfrastructureIntegrationType
	// CASSANDRA_NODE integration
	CASSANDRA_NODE EntityInfrastructureIntegrationType
	// CONSUL_AGENT integration
	CONSUL_AGENT EntityInfrastructureIntegrationType
	// COUCHBASE_BUCKET integration
	COUCHBASE_BUCKET EntityInfrastructureIntegrationType
	// COUCHBASE_CLUSTER integration
	COUCHBASE_CLUSTER EntityInfrastructureIntegrationType
	// COUCHBASE_NODE integration
	COUCHBASE_NODE EntityInfrastructureIntegrationType
	// COUCHBASE_QUERY_ENGINE integration
	COUCHBASE_QUERY_ENGINE EntityInfrastructureIntegrationType
	// ELASTICSEARCH_NODE integration
	ELASTICSEARCH_NODE EntityInfrastructureIntegrationType
	// F5_NODE integration
	F5_NODE EntityInfrastructureIntegrationType
	// F5_POOL integration
	F5_POOL EntityInfrastructureIntegrationType
	// F5_POOL_MEMBER integration
	F5_POOL_MEMBER EntityInfrastructureIntegrationType
	// F5_SYSTEM integration
	F5_SYSTEM EntityInfrastructureIntegrationType
	// F5_VIRTUAL_SERVER integration
	F5_VIRTUAL_SERVER EntityInfrastructureIntegrationType
	// GCP_APP_ENGINE_SERVICE integration
	GCP_APP_ENGINE_SERVICE EntityInfrastructureIntegrationType
	// GCP_BIG_QUERY_DATA_SET integration
	GCP_BIG_QUERY_DATA_SET EntityInfrastructureIntegrationType
	// GCP_BIG_QUERY_PROJECT integration
	GCP_BIG_QUERY_PROJECT EntityInfrastructureIntegrationType
	// GCP_BIG_QUERY_TABLE integration
	GCP_BIG_QUERY_TABLE EntityInfrastructureIntegrationType
	// GCP_CLOUD_FUNCTION integration
	GCP_CLOUD_FUNCTION EntityInfrastructureIntegrationType
	// GCP_CLOUD_SQL integration
	GCP_CLOUD_SQL EntityInfrastructureIntegrationType
	// GCP_CLOUD_TASKS_QUEUE integration
	GCP_CLOUD_TASKS_QUEUE EntityInfrastructureIntegrationType
	// GCP_HTTP_LOAD_BALANCER integration
	GCP_HTTP_LOAD_BALANCER EntityInfrastructureIntegrationType
	// GCP_INTERNAL_LOAD_BALANCER integration
	GCP_INTERNAL_LOAD_BALANCER EntityInfrastructureIntegrationType
	// GCP_KUBERNETES_CONTAINER integration
	GCP_KUBERNETES_CONTAINER EntityInfrastructureIntegrationType
	// GCP_KUBERNETES_NODE integration
	GCP_KUBERNETES_NODE EntityInfrastructureIntegrationType
	// GCP_KUBERNETES_POD integration
	GCP_KUBERNETES_POD EntityInfrastructureIntegrationType
	// GCP_PUB_SUB_SUBSCRIPTION integration
	GCP_PUB_SUB_SUBSCRIPTION EntityInfrastructureIntegrationType
	// GCP_PUB_SUB_TOPIC integration
	GCP_PUB_SUB_TOPIC EntityInfrastructureIntegrationType
	// GCP_SPANNER_DATABASE integration
	GCP_SPANNER_DATABASE EntityInfrastructureIntegrationType
	// GCP_SPANNER_INSTANCE integration
	GCP_SPANNER_INSTANCE EntityInfrastructureIntegrationType
	// GCP_STORAGE_BUCKET integration
	GCP_STORAGE_BUCKET EntityInfrastructureIntegrationType
	// GCP_TCP_SSL_PROXY_LOAD_BALANCER integration
	GCP_TCP_SSL_PROXY_LOAD_BALANCER EntityInfrastructureIntegrationType
	// GCP_VIRTUAL_MACHINE_DISK integration
	GCP_VIRTUAL_MACHINE_DISK EntityInfrastructureIntegrationType
	// KAFKA_BROKER integration
	KAFKA_BROKER EntityInfrastructureIntegrationType
	// KAFKA_TOPIC integration
	KAFKA_TOPIC EntityInfrastructureIntegrationType
	// KUBERNETES_CLUSTER integration
	KUBERNETES_CLUSTER EntityInfrastructureIntegrationType
	// MEMCACHED_INSTANCE integration
	MEMCACHED_INSTANCE EntityInfrastructureIntegrationType
	// MSSQL_INSTANCE integration
	MSSQL_INSTANCE EntityInfrastructureIntegrationType
	// MYSQL_NODE integration
	MYSQL_NODE EntityInfrastructureIntegrationType
	// NA integration
	NA EntityInfrastructureIntegrationType
	// NGINX_SERVER integration
	NGINX_SERVER EntityInfrastructureIntegrationType
	// ORACLE_DB_INSTANCE integration
	ORACLE_DB_INSTANCE EntityInfrastructureIntegrationType
	// POSTGRE_SQL_INSTANCE integration
	POSTGRE_SQL_INSTANCE EntityInfrastructureIntegrationType
	// RABBIT_MQ_CLUSTER integration
	RABBIT_MQ_CLUSTER EntityInfrastructureIntegrationType
	// RABBIT_MQ_EXCHANGE integration
	RABBIT_MQ_EXCHANGE EntityInfrastructureIntegrationType
	// RABBIT_MQ_NODE integration
	RABBIT_MQ_NODE EntityInfrastructureIntegrationType
	// RABBIT_MQ_QUEUE integration
	RABBIT_MQ_QUEUE EntityInfrastructureIntegrationType
	// REDIS_INSTANCE integration
	REDIS_INSTANCE EntityInfrastructureIntegrationType
	// VARNISH_INSTANCE integration
	VARNISH_INSTANCE EntityInfrastructureIntegrationType
}{
	// APACHE_SERVER integration
	APACHE_SERVER: "APACHE_SERVER",
	// AWSELASTICSEARCHNODE integration
	AWSELASTICSEARCHNODE: "AWSELASTICSEARCHNODE",
	// AWS_ALB integration
	AWS_ALB: "AWS_ALB",
	// AWS_ALB_LISTENER integration
	AWS_ALB_LISTENER: "AWS_ALB_LISTENER",
	// AWS_ALB_LISTENER_RULE integration
	AWS_ALB_LISTENER_RULE: "AWS_ALB_LISTENER_RULE",
	// AWS_ALB_TARGET_GROUP integration
	AWS_ALB_TARGET_GROUP: "AWS_ALB_TARGET_GROUP",
	// AWS_API_GATEWAY_API integration
	AWS_API_GATEWAY_API: "AWS_API_GATEWAY_API",
	// AWS_API_GATEWAY_RESOURCE integration
	AWS_API_GATEWAY_RESOURCE: "AWS_API_GATEWAY_RESOURCE",
	// AWS_API_GATEWAY_RESOURCE_WITH_METRICS integration
	AWS_API_GATEWAY_RESOURCE_WITH_METRICS: "AWS_API_GATEWAY_RESOURCE_WITH_METRICS",
	// AWS_API_GATEWAY_STAGE integration
	AWS_API_GATEWAY_STAGE: "AWS_API_GATEWAY_STAGE",
	// AWS_AUTO_SCALING_GROUP integration
	AWS_AUTO_SCALING_GROUP: "AWS_AUTO_SCALING_GROUP",
	// AWS_AUTO_SCALING_INSTANCE integration
	AWS_AUTO_SCALING_INSTANCE: "AWS_AUTO_SCALING_INSTANCE",
	// AWS_AUTO_SCALING_LAUNCH_CONFIGURATION integration
	AWS_AUTO_SCALING_LAUNCH_CONFIGURATION: "AWS_AUTO_SCALING_LAUNCH_CONFIGURATION",
	// AWS_AUTO_SCALING_POLICY integration
	AWS_AUTO_SCALING_POLICY: "AWS_AUTO_SCALING_POLICY",
	// AWS_AUTO_SCALING_REGION_LIMIT integration
	AWS_AUTO_SCALING_REGION_LIMIT: "AWS_AUTO_SCALING_REGION_LIMIT",
	// AWS_BILLING_ACCOUNT_COST integration
	AWS_BILLING_ACCOUNT_COST: "AWS_BILLING_ACCOUNT_COST",
	// AWS_BILLING_ACCOUNT_SERVICE_COST integration
	AWS_BILLING_ACCOUNT_SERVICE_COST: "AWS_BILLING_ACCOUNT_SERVICE_COST",
	// AWS_BILLING_BUDGET integration
	AWS_BILLING_BUDGET: "AWS_BILLING_BUDGET",
	// AWS_BILLING_SERVICE_COST integration
	AWS_BILLING_SERVICE_COST: "AWS_BILLING_SERVICE_COST",
	// AWS_CLOUD_FRONT_DISTRIBUTION integration
	AWS_CLOUD_FRONT_DISTRIBUTION: "AWS_CLOUD_FRONT_DISTRIBUTION",
	// AWS_CLOUD_TRAIL integration
	AWS_CLOUD_TRAIL: "AWS_CLOUD_TRAIL",
	// AWS_DYNAMO_DB_GLOBAL_SECONDARY_INDEX integration
	AWS_DYNAMO_DB_GLOBAL_SECONDARY_INDEX: "AWS_DYNAMO_DB_GLOBAL_SECONDARY_INDEX",
	// AWS_DYNAMO_DB_REGION integration
	AWS_DYNAMO_DB_REGION: "AWS_DYNAMO_DB_REGION",
	// AWS_DYNAMO_DB_TABLE integration
	AWS_DYNAMO_DB_TABLE: "AWS_DYNAMO_DB_TABLE",
	// AWS_EBS_VOLUME integration
	AWS_EBS_VOLUME: "AWS_EBS_VOLUME",
	// AWS_ECS_CLUSTER integration
	AWS_ECS_CLUSTER: "AWS_ECS_CLUSTER",
	// AWS_ECS_SERVICE integration
	AWS_ECS_SERVICE: "AWS_ECS_SERVICE",
	// AWS_EFS_FILE_SYSTEM integration
	AWS_EFS_FILE_SYSTEM: "AWS_EFS_FILE_SYSTEM",
	// AWS_ELASTICSEARCH_CLUSTER integration
	AWS_ELASTICSEARCH_CLUSTER: "AWS_ELASTICSEARCH_CLUSTER",
	// AWS_ELASTICSEARCH_INSTANCE integration
	AWS_ELASTICSEARCH_INSTANCE: "AWS_ELASTICSEARCH_INSTANCE",
	// AWS_ELASTIC_BEANSTALK_ENVIRONMENT integration
	AWS_ELASTIC_BEANSTALK_ENVIRONMENT: "AWS_ELASTIC_BEANSTALK_ENVIRONMENT",
	// AWS_ELASTIC_BEANSTALK_INSTANCE integration
	AWS_ELASTIC_BEANSTALK_INSTANCE: "AWS_ELASTIC_BEANSTALK_INSTANCE",
	// AWS_ELASTIC_MAP_REDUCE_CLUSTER integration
	AWS_ELASTIC_MAP_REDUCE_CLUSTER: "AWS_ELASTIC_MAP_REDUCE_CLUSTER",
	// AWS_ELASTIC_MAP_REDUCE_INSTANCE integration
	AWS_ELASTIC_MAP_REDUCE_INSTANCE: "AWS_ELASTIC_MAP_REDUCE_INSTANCE",
	// AWS_ELASTIC_MAP_REDUCE_INSTANCE_FLEET integration
	AWS_ELASTIC_MAP_REDUCE_INSTANCE_FLEET: "AWS_ELASTIC_MAP_REDUCE_INSTANCE_FLEET",
	// AWS_ELASTIC_MAP_REDUCE_INSTANCE_GROUP integration
	AWS_ELASTIC_MAP_REDUCE_INSTANCE_GROUP: "AWS_ELASTIC_MAP_REDUCE_INSTANCE_GROUP",
	// AWS_ELASTI_CACHE_MEMCACHED_CLUSTER integration
	AWS_ELASTI_CACHE_MEMCACHED_CLUSTER: "AWS_ELASTI_CACHE_MEMCACHED_CLUSTER",
	// AWS_ELASTI_CACHE_MEMCACHED_NODE integration
	AWS_ELASTI_CACHE_MEMCACHED_NODE: "AWS_ELASTI_CACHE_MEMCACHED_NODE",
	// AWS_ELASTI_CACHE_REDIS_CLUSTER integration
	AWS_ELASTI_CACHE_REDIS_CLUSTER: "AWS_ELASTI_CACHE_REDIS_CLUSTER",
	// AWS_ELASTI_CACHE_REDIS_NODE integration
	AWS_ELASTI_CACHE_REDIS_NODE: "AWS_ELASTI_CACHE_REDIS_NODE",
	// AWS_ELB integration
	AWS_ELB: "AWS_ELB",
	// AWS_HEALTH_ISSUE integration
	AWS_HEALTH_ISSUE: "AWS_HEALTH_ISSUE",
	// AWS_HEALTH_NOTIFICATION integration
	AWS_HEALTH_NOTIFICATION: "AWS_HEALTH_NOTIFICATION",
	// AWS_HEALTH_SCHEDULED_CHANGE integration
	AWS_HEALTH_SCHEDULED_CHANGE: "AWS_HEALTH_SCHEDULED_CHANGE",
	// AWS_HEALTH_UNKNOWN integration
	AWS_HEALTH_UNKNOWN: "AWS_HEALTH_UNKNOWN",
	// AWS_IAM integration
	AWS_IAM: "AWS_IAM",
	// AWS_IAM_GROUP integration
	AWS_IAM_GROUP: "AWS_IAM_GROUP",
	// AWS_IAM_OPEN_ID_PROVIDER integration
	AWS_IAM_OPEN_ID_PROVIDER: "AWS_IAM_OPEN_ID_PROVIDER",
	// AWS_IAM_POLICY integration
	AWS_IAM_POLICY: "AWS_IAM_POLICY",
	// AWS_IAM_ROLE integration
	AWS_IAM_ROLE: "AWS_IAM_ROLE",
	// AWS_IAM_SAML_PROVIDER integration
	AWS_IAM_SAML_PROVIDER: "AWS_IAM_SAML_PROVIDER",
	// AWS_IAM_SERVER_CERTIFICATE integration
	AWS_IAM_SERVER_CERTIFICATE: "AWS_IAM_SERVER_CERTIFICATE",
	// AWS_IAM_USER integration
	AWS_IAM_USER: "AWS_IAM_USER",
	// AWS_IAM_VIRTUAL_MFA_DEVICE integration
	AWS_IAM_VIRTUAL_MFA_DEVICE: "AWS_IAM_VIRTUAL_MFA_DEVICE",
	// AWS_IOT_BROKER integration
	AWS_IOT_BROKER: "AWS_IOT_BROKER",
	// AWS_IOT_RULE integration
	AWS_IOT_RULE: "AWS_IOT_RULE",
	// AWS_IOT_RULE_ACTION integration
	AWS_IOT_RULE_ACTION: "AWS_IOT_RULE_ACTION",
	// AWS_KINESIS_DELIVERY_STREAM integration
	AWS_KINESIS_DELIVERY_STREAM: "AWS_KINESIS_DELIVERY_STREAM",
	// AWS_KINESIS_STREAM integration
	AWS_KINESIS_STREAM: "AWS_KINESIS_STREAM",
	// AWS_KINESIS_STREAM_SHARD integration
	AWS_KINESIS_STREAM_SHARD: "AWS_KINESIS_STREAM_SHARD",
	// AWS_LAMBDA_AGENT_TRANSACTION integration
	AWS_LAMBDA_AGENT_TRANSACTION: "AWS_LAMBDA_AGENT_TRANSACTION",
	// AWS_LAMBDA_AGENT_TRANSACTION_ERROR integration
	AWS_LAMBDA_AGENT_TRANSACTION_ERROR: "AWS_LAMBDA_AGENT_TRANSACTION_ERROR",
	// AWS_LAMBDA_EDGE_FUNCTION integration
	AWS_LAMBDA_EDGE_FUNCTION: "AWS_LAMBDA_EDGE_FUNCTION",
	// AWS_LAMBDA_EVENT_SOURCE_MAPPING integration
	AWS_LAMBDA_EVENT_SOURCE_MAPPING: "AWS_LAMBDA_EVENT_SOURCE_MAPPING",
	// AWS_LAMBDA_FUNCTION integration
	AWS_LAMBDA_FUNCTION: "AWS_LAMBDA_FUNCTION",
	// AWS_LAMBDA_FUNCTION_ALIAS integration
	AWS_LAMBDA_FUNCTION_ALIAS: "AWS_LAMBDA_FUNCTION_ALIAS",
	// AWS_LAMBDA_OPERATION integration
	AWS_LAMBDA_OPERATION: "AWS_LAMBDA_OPERATION",
	// AWS_LAMBDA_REGION integration
	AWS_LAMBDA_REGION: "AWS_LAMBDA_REGION",
	// AWS_LAMBDA_SPAN integration
	AWS_LAMBDA_SPAN: "AWS_LAMBDA_SPAN",
	// AWS_LAMBDA_TRACE integration
	AWS_LAMBDA_TRACE: "AWS_LAMBDA_TRACE",
	// AWS_RDS_DB_CLUSTER integration
	AWS_RDS_DB_CLUSTER: "AWS_RDS_DB_CLUSTER",
	// AWS_RDS_DB_INSTANCE integration
	AWS_RDS_DB_INSTANCE: "AWS_RDS_DB_INSTANCE",
	// AWS_REDSHIFT_CLUSTER integration
	AWS_REDSHIFT_CLUSTER: "AWS_REDSHIFT_CLUSTER",
	// AWS_REDSHIFT_NODE integration
	AWS_REDSHIFT_NODE: "AWS_REDSHIFT_NODE",
	// AWS_ROUTE53_HEALTH_CHECK integration
	AWS_ROUTE53_HEALTH_CHECK: "AWS_ROUTE53_HEALTH_CHECK",
	// AWS_ROUTE53_ZONE integration
	AWS_ROUTE53_ZONE: "AWS_ROUTE53_ZONE",
	// AWS_ROUTE53_ZONE_RECORD_SET integration
	AWS_ROUTE53_ZONE_RECORD_SET: "AWS_ROUTE53_ZONE_RECORD_SET",
	// AWS_S3_BUCKET integration
	AWS_S3_BUCKET: "AWS_S3_BUCKET",
	// AWS_S3_BUCKET_REQUESTS integration
	AWS_S3_BUCKET_REQUESTS: "AWS_S3_BUCKET_REQUESTS",
	// AWS_SES_CONFIGURATION_SET integration
	AWS_SES_CONFIGURATION_SET: "AWS_SES_CONFIGURATION_SET",
	// AWS_SES_EVENT_DESTINATION integration
	AWS_SES_EVENT_DESTINATION: "AWS_SES_EVENT_DESTINATION",
	// AWS_SES_RECEIPT_FILTER integration
	AWS_SES_RECEIPT_FILTER: "AWS_SES_RECEIPT_FILTER",
	// AWS_SES_RECEIPT_RULE integration
	AWS_SES_RECEIPT_RULE: "AWS_SES_RECEIPT_RULE",
	// AWS_SES_RECEIPT_RULE_SET integration
	AWS_SES_RECEIPT_RULE_SET: "AWS_SES_RECEIPT_RULE_SET",
	// AWS_SES_REGION integration
	AWS_SES_REGION: "AWS_SES_REGION",
	// AWS_SNS_SUBSCRIPTION integration
	AWS_SNS_SUBSCRIPTION: "AWS_SNS_SUBSCRIPTION",
	// AWS_SNS_TOPIC integration
	AWS_SNS_TOPIC: "AWS_SNS_TOPIC",
	// AWS_SQS_QUEUE integration
	AWS_SQS_QUEUE: "AWS_SQS_QUEUE",
	// AWS_VPC integration
	AWS_VPC: "AWS_VPC",
	// AWS_VPC_ENDPOINT integration
	AWS_VPC_ENDPOINT: "AWS_VPC_ENDPOINT",
	// AWS_VPC_INTERNET_GATEWAY integration
	AWS_VPC_INTERNET_GATEWAY: "AWS_VPC_INTERNET_GATEWAY",
	// AWS_VPC_NAT_GATEWAY integration
	AWS_VPC_NAT_GATEWAY: "AWS_VPC_NAT_GATEWAY",
	// AWS_VPC_NETWORK_ACL integration
	AWS_VPC_NETWORK_ACL: "AWS_VPC_NETWORK_ACL",
	// AWS_VPC_NETWORK_INTERFACE integration
	AWS_VPC_NETWORK_INTERFACE: "AWS_VPC_NETWORK_INTERFACE",
	// AWS_VPC_PEERING_CONNECTION integration
	AWS_VPC_PEERING_CONNECTION: "AWS_VPC_PEERING_CONNECTION",
	// AWS_VPC_ROUTE_TABLE integration
	AWS_VPC_ROUTE_TABLE: "AWS_VPC_ROUTE_TABLE",
	// AWS_VPC_SECURITY_GROUP integration
	AWS_VPC_SECURITY_GROUP: "AWS_VPC_SECURITY_GROUP",
	// AWS_VPC_SUBNET integration
	AWS_VPC_SUBNET: "AWS_VPC_SUBNET",
	// AWS_VPC_VPN_CONNECTION integration
	AWS_VPC_VPN_CONNECTION: "AWS_VPC_VPN_CONNECTION",
	// AWS_VPC_VPN_TUNNEL integration
	AWS_VPC_VPN_TUNNEL: "AWS_VPC_VPN_TUNNEL",
	// AZURE_APP_SERVICE_HOST_NAME integration
	AZURE_APP_SERVICE_HOST_NAME: "AZURE_APP_SERVICE_HOST_NAME",
	// AZURE_APP_SERVICE_WEB_APP integration
	AZURE_APP_SERVICE_WEB_APP: "AZURE_APP_SERVICE_WEB_APP",
	// AZURE_COSMOS_DB_ACCOUNT integration
	AZURE_COSMOS_DB_ACCOUNT: "AZURE_COSMOS_DB_ACCOUNT",
	// AZURE_FUNCTIONS_APP integration
	AZURE_FUNCTIONS_APP: "AZURE_FUNCTIONS_APP",
	// AZURE_LOAD_BALANCER integration
	AZURE_LOAD_BALANCER: "AZURE_LOAD_BALANCER",
	// AZURE_LOAD_BALANCER_BACKEND integration
	AZURE_LOAD_BALANCER_BACKEND: "AZURE_LOAD_BALANCER_BACKEND",
	// AZURE_LOAD_BALANCER_FRONTEND_IP integration
	AZURE_LOAD_BALANCER_FRONTEND_IP: "AZURE_LOAD_BALANCER_FRONTEND_IP",
	// AZURE_LOAD_BALANCER_INBOUND_NAT_POOL integration
	AZURE_LOAD_BALANCER_INBOUND_NAT_POOL: "AZURE_LOAD_BALANCER_INBOUND_NAT_POOL",
	// AZURE_LOAD_BALANCER_INBOUND_NAT_RULE integration
	AZURE_LOAD_BALANCER_INBOUND_NAT_RULE: "AZURE_LOAD_BALANCER_INBOUND_NAT_RULE",
	// AZURE_LOAD_BALANCER_PROBE integration
	AZURE_LOAD_BALANCER_PROBE: "AZURE_LOAD_BALANCER_PROBE",
	// AZURE_LOAD_BALANCER_RULE integration
	AZURE_LOAD_BALANCER_RULE: "AZURE_LOAD_BALANCER_RULE",
	// AZURE_MARIADB_SERVER integration
	AZURE_MARIADB_SERVER: "AZURE_MARIADB_SERVER",
	// AZURE_MYSQL_SERVER integration
	AZURE_MYSQL_SERVER: "AZURE_MYSQL_SERVER",
	// AZURE_POSTGRESQL_SERVER integration
	AZURE_POSTGRESQL_SERVER: "AZURE_POSTGRESQL_SERVER",
	// AZURE_REDIS_CACHE integration
	AZURE_REDIS_CACHE: "AZURE_REDIS_CACHE",
	// AZURE_REDIS_CACHE_SHARD integration
	AZURE_REDIS_CACHE_SHARD: "AZURE_REDIS_CACHE_SHARD",
	// AZURE_SERVICE_BUS_NAMESPACE integration
	AZURE_SERVICE_BUS_NAMESPACE: "AZURE_SERVICE_BUS_NAMESPACE",
	// AZURE_SERVICE_BUS_QUEUE integration
	AZURE_SERVICE_BUS_QUEUE: "AZURE_SERVICE_BUS_QUEUE",
	// AZURE_SERVICE_BUS_SUBSCRIPTION integration
	AZURE_SERVICE_BUS_SUBSCRIPTION: "AZURE_SERVICE_BUS_SUBSCRIPTION",
	// AZURE_SERVICE_BUS_TOPIC integration
	AZURE_SERVICE_BUS_TOPIC: "AZURE_SERVICE_BUS_TOPIC",
	// AZURE_SQL_DATABASE integration
	AZURE_SQL_DATABASE: "AZURE_SQL_DATABASE",
	// AZURE_SQL_ELASTIC_POOL integration
	AZURE_SQL_ELASTIC_POOL: "AZURE_SQL_ELASTIC_POOL",
	// AZURE_SQL_FIREWALL integration
	AZURE_SQL_FIREWALL: "AZURE_SQL_FIREWALL",
	// AZURE_SQL_REPLICATION_LINK integration
	AZURE_SQL_REPLICATION_LINK: "AZURE_SQL_REPLICATION_LINK",
	// AZURE_SQL_RESTORE_POINT integration
	AZURE_SQL_RESTORE_POINT: "AZURE_SQL_RESTORE_POINT",
	// AZURE_SQL_SERVER integration
	AZURE_SQL_SERVER: "AZURE_SQL_SERVER",
	// AZURE_STORAGE_ACCOUNT integration
	AZURE_STORAGE_ACCOUNT: "AZURE_STORAGE_ACCOUNT",
	// AZURE_VIRTUAL_NETWORKS integration
	AZURE_VIRTUAL_NETWORKS: "AZURE_VIRTUAL_NETWORKS",
	// AZURE_VIRTUAL_NETWORKS_IP_CONFIGURATION integration
	AZURE_VIRTUAL_NETWORKS_IP_CONFIGURATION: "AZURE_VIRTUAL_NETWORKS_IP_CONFIGURATION",
	// AZURE_VIRTUAL_NETWORKS_NETWORK_INTERFACE integration
	AZURE_VIRTUAL_NETWORKS_NETWORK_INTERFACE: "AZURE_VIRTUAL_NETWORKS_NETWORK_INTERFACE",
	// AZURE_VIRTUAL_NETWORKS_PEERING integration
	AZURE_VIRTUAL_NETWORKS_PEERING: "AZURE_VIRTUAL_NETWORKS_PEERING",
	// AZURE_VIRTUAL_NETWORKS_PUBLIC_IP_ADDRESS integration
	AZURE_VIRTUAL_NETWORKS_PUBLIC_IP_ADDRESS: "AZURE_VIRTUAL_NETWORKS_PUBLIC_IP_ADDRESS",
	// AZURE_VIRTUAL_NETWORKS_ROUTE integration
	AZURE_VIRTUAL_NETWORKS_ROUTE: "AZURE_VIRTUAL_NETWORKS_ROUTE",
	// AZURE_VIRTUAL_NETWORKS_ROUTE_TABLE integration
	AZURE_VIRTUAL_NETWORKS_ROUTE_TABLE: "AZURE_VIRTUAL_NETWORKS_ROUTE_TABLE",
	// AZURE_VIRTUAL_NETWORKS_SECURITY_GROUP integration
	AZURE_VIRTUAL_NETWORKS_SECURITY_GROUP: "AZURE_VIRTUAL_NETWORKS_SECURITY_GROUP",
	// AZURE_VIRTUAL_NETWORKS_SECURITY_RULE integration
	AZURE_VIRTUAL_NETWORKS_SECURITY_RULE: "AZURE_VIRTUAL_NETWORKS_SECURITY_RULE",
	// AZURE_VIRTUAL_NETWORKS_SUBNET integration
	AZURE_VIRTUAL_NETWORKS_SUBNET: "AZURE_VIRTUAL_NETWORKS_SUBNET",
	// CASSANDRA_NODE integration
	CASSANDRA_NODE: "CASSANDRA_NODE",
	// CONSUL_AGENT integration
	CONSUL_AGENT: "CONSUL_AGENT",
	// COUCHBASE_BUCKET integration
	COUCHBASE_BUCKET: "COUCHBASE_BUCKET",
	// COUCHBASE_CLUSTER integration
	COUCHBASE_CLUSTER: "COUCHBASE_CLUSTER",
	// COUCHBASE_NODE integration
	COUCHBASE_NODE: "COUCHBASE_NODE",
	// COUCHBASE_QUERY_ENGINE integration
	COUCHBASE_QUERY_ENGINE: "COUCHBASE_QUERY_ENGINE",
	// ELASTICSEARCH_NODE integration
	ELASTICSEARCH_NODE: "ELASTICSEARCH_NODE",
	// F5_NODE integration
	F5_NODE: "F5_NODE",
	// F5_POOL integration
	F5_POOL: "F5_POOL",
	// F5_POOL_MEMBER integration
	F5_POOL_MEMBER: "F5_POOL_MEMBER",
	// F5_SYSTEM integration
	F5_SYSTEM: "F5_SYSTEM",
	// F5_VIRTUAL_SERVER integration
	F5_VIRTUAL_SERVER: "F5_VIRTUAL_SERVER",
	// GCP_APP_ENGINE_SERVICE integration
	GCP_APP_ENGINE_SERVICE: "GCP_APP_ENGINE_SERVICE",
	// GCP_BIG_QUERY_DATA_SET integration
	GCP_BIG_QUERY_DATA_SET: "GCP_BIG_QUERY_DATA_SET",
	// GCP_BIG_QUERY_PROJECT integration
	GCP_BIG_QUERY_PROJECT: "GCP_BIG_QUERY_PROJECT",
	// GCP_BIG_QUERY_TABLE integration
	GCP_BIG_QUERY_TABLE: "GCP_BIG_QUERY_TABLE",
	// GCP_CLOUD_FUNCTION integration
	GCP_CLOUD_FUNCTION: "GCP_CLOUD_FUNCTION",
	// GCP_CLOUD_SQL integration
	GCP_CLOUD_SQL: "GCP_CLOUD_SQL",
	// GCP_CLOUD_TASKS_QUEUE integration
	GCP_CLOUD_TASKS_QUEUE: "GCP_CLOUD_TASKS_QUEUE",
	// GCP_HTTP_LOAD_BALANCER integration
	GCP_HTTP_LOAD_BALANCER: "GCP_HTTP_LOAD_BALANCER",
	// GCP_INTERNAL_LOAD_BALANCER integration
	GCP_INTERNAL_LOAD_BALANCER: "GCP_INTERNAL_LOAD_BALANCER",
	// GCP_KUBERNETES_CONTAINER integration
	GCP_KUBERNETES_CONTAINER: "GCP_KUBERNETES_CONTAINER",
	// GCP_KUBERNETES_NODE integration
	GCP_KUBERNETES_NODE: "GCP_KUBERNETES_NODE",
	// GCP_KUBERNETES_POD integration
	GCP_KUBERNETES_POD: "GCP_KUBERNETES_POD",
	// GCP_PUB_SUB_SUBSCRIPTION integration
	GCP_PUB_SUB_SUBSCRIPTION: "GCP_PUB_SUB_SUBSCRIPTION",
	// GCP_PUB_SUB_TOPIC integration
	GCP_PUB_SUB_TOPIC: "GCP_PUB_SUB_TOPIC",
	// GCP_SPANNER_DATABASE integration
	GCP_SPANNER_DATABASE: "GCP_SPANNER_DATABASE",
	// GCP_SPANNER_INSTANCE integration
	GCP_SPANNER_INSTANCE: "GCP_SPANNER_INSTANCE",
	// GCP_STORAGE_BUCKET integration
	GCP_STORAGE_BUCKET: "GCP_STORAGE_BUCKET",
	// GCP_TCP_SSL_PROXY_LOAD_BALANCER integration
	GCP_TCP_SSL_PROXY_LOAD_BALANCER: "GCP_TCP_SSL_PROXY_LOAD_BALANCER",
	// GCP_VIRTUAL_MACHINE_DISK integration
	GCP_VIRTUAL_MACHINE_DISK: "GCP_VIRTUAL_MACHINE_DISK",
	// KAFKA_BROKER integration
	KAFKA_BROKER: "KAFKA_BROKER",
	// KAFKA_TOPIC integration
	KAFKA_TOPIC: "KAFKA_TOPIC",
	// KUBERNETES_CLUSTER integration
	KUBERNETES_CLUSTER: "KUBERNETES_CLUSTER",
	// MEMCACHED_INSTANCE integration
	MEMCACHED_INSTANCE: "MEMCACHED_INSTANCE",
	// MSSQL_INSTANCE integration
	MSSQL_INSTANCE: "MSSQL_INSTANCE",
	// MYSQL_NODE integration
	MYSQL_NODE: "MYSQL_NODE",
	// NA integration
	NA: "NA",
	// NGINX_SERVER integration
	NGINX_SERVER: "NGINX_SERVER",
	// ORACLE_DB_INSTANCE integration
	ORACLE_DB_INSTANCE: "ORACLE_DB_INSTANCE",
	// POSTGRE_SQL_INSTANCE integration
	POSTGRE_SQL_INSTANCE: "POSTGRE_SQL_INSTANCE",
	// RABBIT_MQ_CLUSTER integration
	RABBIT_MQ_CLUSTER: "RABBIT_MQ_CLUSTER",
	// RABBIT_MQ_EXCHANGE integration
	RABBIT_MQ_EXCHANGE: "RABBIT_MQ_EXCHANGE",
	// RABBIT_MQ_NODE integration
	RABBIT_MQ_NODE: "RABBIT_MQ_NODE",
	// RABBIT_MQ_QUEUE integration
	RABBIT_MQ_QUEUE: "RABBIT_MQ_QUEUE",
	// REDIS_INSTANCE integration
	REDIS_INSTANCE: "REDIS_INSTANCE",
	// VARNISH_INSTANCE integration
	VARNISH_INSTANCE: "VARNISH_INSTANCE",
}

// EntityManagementEntityScope - The list of possible scopes of an entity.
type EntityManagementEntityScope string

var EntityManagementEntityScopeTypes = struct {
	// Account scope.
	ACCOUNT EntityManagementEntityScope
	// Organization scope.
	ORGANIZATION EntityManagementEntityScope
}{
	// Account scope.
	ACCOUNT: "ACCOUNT",
	// Organization scope.
	ORGANIZATION: "ORGANIZATION",
}

// EntityManagementManagedEntityType - Entity types that a Fleet can manage
type EntityManagementManagedEntityType string

var EntityManagementManagedEntityTypeTypes = struct {
	// Infra Host
	HOST EntityManagementManagedEntityType
	// Kubernetes Cluster
	KUBERNETESCLUSTER EntityManagementManagedEntityType
}{
	// Infra Host
	HOST: "HOST",
	// Kubernetes Cluster
	KUBERNETESCLUSTER: "KUBERNETESCLUSTER",
}

// EntityManagementTeamExternalIntegrationType - Possible types for the External Integration.
type EntityManagementTeamExternalIntegrationType string

var EntityManagementTeamExternalIntegrationTypeTypes = struct {
	// IAM Group Integration.
	IAM_GROUP EntityManagementTeamExternalIntegrationType
}{
	// IAM Group Integration.
	IAM_GROUP: "IAM_GROUP",
}

// EntityRelationshipEdgeDirection - Values for relationship direction filter.
type EntityRelationshipEdgeDirection string

var EntityRelationshipEdgeDirectionTypes = struct {
	// Traverse both inbound and outbound connections.
	BOTH EntityRelationshipEdgeDirection
	// Traverse inbound connections to the source of the relationship.
	INBOUND EntityRelationshipEdgeDirection
	// Traverse outbound connections to the target of the relationship.
	OUTBOUND EntityRelationshipEdgeDirection
}{
	// Traverse both inbound and outbound connections.
	BOTH: "BOTH",
	// Traverse inbound connections to the source of the relationship.
	INBOUND: "INBOUND",
	// Traverse outbound connections to the target of the relationship.
	OUTBOUND: "OUTBOUND",
}

// EntityRelationshipEdgeType - The type of the relationship.
type EntityRelationshipEdgeType string

var EntityRelationshipEdgeTypeTypes = struct {
	// The target entity contains the code for the source entity.
	BUILT_FROM EntityRelationshipEdgeType
	// The source entity calls the target entity.
	CALLS EntityRelationshipEdgeType
	// The source entity has a connection to the target entity.
	CONNECTS_TO EntityRelationshipEdgeType
	// The source entity consumes messages from a target kafka topic or other queue systems.
	CONSUMES EntityRelationshipEdgeType
	// The source entity contains the target entity.
	CONTAINS EntityRelationshipEdgeType
	// The source entity hosts the target.
	HOSTS EntityRelationshipEdgeType
	// The source and target entities are perspectives on the same thing.
	IS EntityRelationshipEdgeType
	// The source entity manages the target, that represents a subsystem of the source.
	MANAGES EntityRelationshipEdgeType
	// The source entity is used to measure the target entity.
	MEASURES EntityRelationshipEdgeType
	// The source entity monitors the target entity.
	MONITORS EntityRelationshipEdgeType
	// The source operates in the target entity, e.g. a region or a data center.
	OPERATES_IN EntityRelationshipEdgeType
	// The source entity owns the target entity.
	OWNS EntityRelationshipEdgeType
	// The source entity produces messages to a target kafka topic or other queue systems.
	PRODUCES EntityRelationshipEdgeType
	// The source is an Application that serves the target Browser application.
	SERVES EntityRelationshipEdgeType
	// The source entity initiates an action in the target entity.
	TRIGGERS EntityRelationshipEdgeType
}{
	// The target entity contains the code for the source entity.
	BUILT_FROM: "BUILT_FROM",
	// The source entity calls the target entity.
	CALLS: "CALLS",
	// The source entity has a connection to the target entity.
	CONNECTS_TO: "CONNECTS_TO",
	// The source entity consumes messages from a target kafka topic or other queue systems.
	CONSUMES: "CONSUMES",
	// The source entity contains the target entity.
	CONTAINS: "CONTAINS",
	// The source entity hosts the target.
	HOSTS: "HOSTS",
	// The source and target entities are perspectives on the same thing.
	IS: "IS",
	// The source entity manages the target, that represents a subsystem of the source.
	MANAGES: "MANAGES",
	// The source entity is used to measure the target entity.
	MEASURES: "MEASURES",
	// The source entity monitors the target entity.
	MONITORS: "MONITORS",
	// The source operates in the target entity, e.g. a region or a data center.
	OPERATES_IN: "OPERATES_IN",
	// The source entity owns the target entity.
	OWNS: "OWNS",
	// The source entity produces messages to a target kafka topic or other queue systems.
	PRODUCES: "PRODUCES",
	// The source is an Application that serves the target Browser application.
	SERVES: "SERVES",
	// The source entity initiates an action in the target entity.
	TRIGGERS: "TRIGGERS",
}

// EntityRelationshipType - The type of the relationship.
//
// For details, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
type EntityRelationshipType string

var EntityRelationshipTypeTypes = struct {
	// The source repository containing the code for the target
	BUILT_FROM EntityRelationshipType
	// The source entity calls the target entity.
	CALLS EntityRelationshipType
	// The source establishes TCP connections to the target
	CONNECTS_TO EntityRelationshipType
	// The source entity contains the target entity
	CONTAINS EntityRelationshipType
	// The source entity hosts the target
	HOSTS EntityRelationshipType
	// The source and target entities are perspectives on the same thing
	IS EntityRelationshipType
	// The source is an Application that serves the target Browser application
	SERVES EntityRelationshipType
	// Type not known
	UNKNOWN EntityRelationshipType
}{
	// The source repository containing the code for the target
	BUILT_FROM: "BUILT_FROM",
	// The source entity calls the target entity.
	CALLS: "CALLS",
	// The source establishes TCP connections to the target
	CONNECTS_TO: "CONNECTS_TO",
	// The source entity contains the target entity
	CONTAINS: "CONTAINS",
	// The source entity hosts the target
	HOSTS: "HOSTS",
	// The source and target entities are perspectives on the same thing
	IS: "IS",
	// The source is an Application that serves the target Browser application
	SERVES: "SERVES",
	// Type not known
	UNKNOWN: "UNKNOWN",
}

// EntitySearchCountsFacet - Possible entity search count facets.
type EntitySearchCountsFacet string

var EntitySearchCountsFacetTypes = struct {
	// Facet by account id.
	ACCOUNT_ID EntitySearchCountsFacet
	// Facet by alert severity.
	ALERT_SEVERITY EntitySearchCountsFacet
	// Facet by entity domain.
	DOMAIN EntitySearchCountsFacet
	// Facet by entity domain and entity type.
	DOMAIN_TYPE EntitySearchCountsFacet
	// Facet by entity name
	NAME EntitySearchCountsFacet
	// Facet by reporting state.
	REPORTING EntitySearchCountsFacet
	// Facet by entity type.
	TYPE EntitySearchCountsFacet
}{
	// Facet by account id.
	ACCOUNT_ID: "ACCOUNT_ID",
	// Facet by alert severity.
	ALERT_SEVERITY: "ALERT_SEVERITY",
	// Facet by entity domain.
	DOMAIN: "DOMAIN",
	// Facet by entity domain and entity type.
	DOMAIN_TYPE: "DOMAIN_TYPE",
	// Facet by entity name
	NAME: "NAME",
	// Facet by reporting state.
	REPORTING: "REPORTING",
	// Facet by entity type.
	TYPE: "TYPE",
}

// EntitySearchQueryBuilderDomain - The domain to search
type EntitySearchQueryBuilderDomain string

var EntitySearchQueryBuilderDomainTypes = struct {
	// Any APM entity
	APM EntitySearchQueryBuilderDomain
	// Any Browser entity
	BROWSER EntitySearchQueryBuilderDomain
	// Any External entity
	EXT EntitySearchQueryBuilderDomain
	// Any Infrastructure entity
	INFRA EntitySearchQueryBuilderDomain
	// Any Mobile entity
	MOBILE EntitySearchQueryBuilderDomain
	// Any Synthetics entity
	SYNTH EntitySearchQueryBuilderDomain
}{
	// Any APM entity
	APM: "APM",
	// Any Browser entity
	BROWSER: "BROWSER",
	// Any External entity
	EXT: "EXT",
	// Any Infrastructure entity
	INFRA: "INFRA",
	// Any Mobile entity
	MOBILE: "MOBILE",
	// Any Synthetics entity
	SYNTH: "SYNTH",
}

// EntitySearchQueryBuilderType - The type of entity
type EntitySearchQueryBuilderType string

var EntitySearchQueryBuilderTypeTypes = struct {
	// An application
	APPLICATION EntitySearchQueryBuilderType
	// A dashboard
	DASHBOARD EntitySearchQueryBuilderType
	// A host
	HOST EntitySearchQueryBuilderType
	// A monitor
	MONITOR EntitySearchQueryBuilderType
	// A workload
	WORKLOAD EntitySearchQueryBuilderType
}{
	// An application
	APPLICATION: "APPLICATION",
	// A dashboard
	DASHBOARD: "DASHBOARD",
	// A host
	HOST: "HOST",
	// A monitor
	MONITOR: "MONITOR",
	// A workload
	WORKLOAD: "WORKLOAD",
}

// EntitySearchSortCriteria - Possible entity sorting criteria.
type EntitySearchSortCriteria string

var EntitySearchSortCriteriaTypes = struct {
	// Sort by alert severity.
	ALERT_SEVERITY EntitySearchSortCriteria
	// Sort by entity domain.
	DOMAIN EntitySearchSortCriteria
	// Sort by relevance. Note that these results can't be paginated.
	MOST_RELEVANT EntitySearchSortCriteria
	// Sort by entity name.
	NAME EntitySearchSortCriteria
	// Sort by reporting state.
	REPORTING EntitySearchSortCriteria
	// Sort by entity type.
	TYPE EntitySearchSortCriteria
}{
	// Sort by alert severity.
	ALERT_SEVERITY: "ALERT_SEVERITY",
	// Sort by entity domain.
	DOMAIN: "DOMAIN",
	// Sort by relevance. Note that these results can't be paginated.
	MOST_RELEVANT: "MOST_RELEVANT",
	// Sort by entity name.
	NAME: "NAME",
	// Sort by reporting state.
	REPORTING: "REPORTING",
	// Sort by entity type.
	TYPE: "TYPE",
}

// EntityType - The specific type of entity
type EntityType string

var EntityTypeTypes = struct {
	// An APM Application
	APM_APPLICATION_ENTITY EntityType
	// A database instance seen by an APM Application
	APM_DATABASE_INSTANCE_ENTITY EntityType
	// An external service seen by an APM Application
	APM_EXTERNAL_SERVICE_ENTITY EntityType
	// A Browser Application
	BROWSER_APPLICATION_ENTITY EntityType
	// A Dashboard entity
	DASHBOARD_ENTITY EntityType
	// An External entity. For more information about defining External entities, see the [open source documentation](https://github.com/newrelic-experimental/entity-synthesis-definitions).
	EXTERNAL_ENTITY EntityType
	// A Generic entity with no detailed data
	GENERIC_ENTITY EntityType
	// An Infrastructure entity
	GENERIC_INFRASTRUCTURE_ENTITY EntityType
	// An Infrastructure Integration AWS Lambda Function entity
	INFRASTRUCTURE_AWS_LAMBDA_FUNCTION_ENTITY EntityType
	// An Infrastructure Host entity
	INFRASTRUCTURE_HOST_ENTITY EntityType
	// A Key Transaction entity
	KEY_TRANSACTION_ENTITY EntityType
	// A Mobile Application
	MOBILE_APPLICATION_ENTITY EntityType
	// A Secure Credential entity
	SECURE_CREDENTIAL_ENTITY EntityType
	// A Synthetic Monitor entity
	SYNTHETIC_MONITOR_ENTITY EntityType
	// A Team Entity
	TEAM_ENTITY EntityType
	// A Third Party Service entity
	THIRD_PARTY_SERVICE_ENTITY EntityType
	// A entity that is unavailable
	UNAVAILABLE_ENTITY EntityType
	// A Workload entity
	WORKLOAD_ENTITY EntityType
}{
	// An APM Application
	APM_APPLICATION_ENTITY: "APM_APPLICATION_ENTITY",
	// A database instance seen by an APM Application
	APM_DATABASE_INSTANCE_ENTITY: "APM_DATABASE_INSTANCE_ENTITY",
	// An external service seen by an APM Application
	APM_EXTERNAL_SERVICE_ENTITY: "APM_EXTERNAL_SERVICE_ENTITY",
	// A Browser Application
	BROWSER_APPLICATION_ENTITY: "BROWSER_APPLICATION_ENTITY",
	// A Dashboard entity
	DASHBOARD_ENTITY: "DASHBOARD_ENTITY",
	// An External entity. For more information about defining External entities, see the [open source documentation](https://github.com/newrelic-experimental/entity-synthesis-definitions).
	EXTERNAL_ENTITY: "EXTERNAL_ENTITY",
	// A Generic entity with no detailed data
	GENERIC_ENTITY: "GENERIC_ENTITY",
	// An Infrastructure entity
	GENERIC_INFRASTRUCTURE_ENTITY: "GENERIC_INFRASTRUCTURE_ENTITY",
	// An Infrastructure Integration AWS Lambda Function entity
	INFRASTRUCTURE_AWS_LAMBDA_FUNCTION_ENTITY: "INFRASTRUCTURE_AWS_LAMBDA_FUNCTION_ENTITY",
	// An Infrastructure Host entity
	INFRASTRUCTURE_HOST_ENTITY: "INFRASTRUCTURE_HOST_ENTITY",
	// A Key Transaction entity
	KEY_TRANSACTION_ENTITY: "KEY_TRANSACTION_ENTITY",
	// A Mobile Application
	MOBILE_APPLICATION_ENTITY: "MOBILE_APPLICATION_ENTITY",
	// A Secure Credential entity
	SECURE_CREDENTIAL_ENTITY: "SECURE_CREDENTIAL_ENTITY",
	// A Synthetic Monitor entity
	SYNTHETIC_MONITOR_ENTITY: "SYNTHETIC_MONITOR_ENTITY",
	// A Team Entity
	TEAM_ENTITY: "TEAM_ENTITY",
	// A Third Party Service entity
	THIRD_PARTY_SERVICE_ENTITY: "THIRD_PARTY_SERVICE_ENTITY",
	// A entity that is unavailable
	UNAVAILABLE_ENTITY: "UNAVAILABLE_ENTITY",
	// A Workload entity
	WORKLOAD_ENTITY: "WORKLOAD_ENTITY",
}

// MetricNormalizationRuleAction - The different rule actions.
type MetricNormalizationRuleAction string

var MetricNormalizationRuleActionTypes = struct {
	// Deny new metrics.
	DENY_NEW_METRICS MetricNormalizationRuleAction
	// Ignore matching metrics.
	IGNORE MetricNormalizationRuleAction
	// Replace metrics.
	REPLACE MetricNormalizationRuleAction
}{
	// Deny new metrics.
	DENY_NEW_METRICS: "DENY_NEW_METRICS",
	// Ignore matching metrics.
	IGNORE: "IGNORE",
	// Replace metrics.
	REPLACE: "REPLACE",
}

// SortBy - The `SortBy` enum is for designating sort order.
type SortBy string

var SortByTypes = struct {
	// Sort in ascending order.
	ASC SortBy
	// Sort in descending order.
	DESC SortBy
}{
	// Sort in ascending order.
	ASC: "ASC",
	// Sort in descending order.
	DESC: "DESC",
}

type SyntheticMonitorStatus string

var SyntheticMonitorStatusTypes = struct {
	DELETED  SyntheticMonitorStatus
	DISABLED SyntheticMonitorStatus
	ENABLED  SyntheticMonitorStatus
	FAULTY   SyntheticMonitorStatus
	MUTED    SyntheticMonitorStatus
	PAUSED   SyntheticMonitorStatus
}{
	DELETED:  "DELETED",
	DISABLED: "DISABLED",
	ENABLED:  "ENABLED",
	FAULTY:   "FAULTY",
	MUTED:    "MUTED",
	PAUSED:   "PAUSED",
}

// SyntheticMonitorType - The types of Synthetic Monitors.
type SyntheticMonitorType string

var SyntheticMonitorTypeTypes = struct {
	BROKEN_LINKS   SyntheticMonitorType
	BROWSER        SyntheticMonitorType
	CERT_CHECK     SyntheticMonitorType
	SCRIPT_API     SyntheticMonitorType
	SCRIPT_BROWSER SyntheticMonitorType
	SIMPLE         SyntheticMonitorType
	STEP_MONITOR   SyntheticMonitorType
}{
	BROKEN_LINKS:   "BROKEN_LINKS",
	BROWSER:        "BROWSER",
	CERT_CHECK:     "CERT_CHECK",
	SCRIPT_API:     "SCRIPT_API",
	SCRIPT_BROWSER: "SCRIPT_BROWSER",
	SIMPLE:         "SIMPLE",
	STEP_MONITOR:   "STEP_MONITOR",
}

// TaggingMutationErrorType - The different types of errors the API can return.
type TaggingMutationErrorType string

var TaggingMutationErrorTypeTypes = struct {
	// Too many concurrent tasks for the same GUID are being sent and we cannot process. Please serialize your requests for the given GUID.
	CONCURRENT_TASK_EXCEPTION TaggingMutationErrorType
	// Domain Type invalid. The decoded domain type from the provided GUID is not valid. Please provide a correct GUID.
	INVALID_DOMAIN_TYPE TaggingMutationErrorType
	// We could not decode the provided GUID. Entity guid needs to be base64 encoded.
	INVALID_ENTITY_GUID TaggingMutationErrorType
	// The tag key is not valid. Char length has been reached, contains a disallowed character(eg :) or is empty
	INVALID_KEY TaggingMutationErrorType
	// The tag value is not valid. Char length has been reached, contains a disallowed character(eg :) or is empty
	INVALID_VALUE TaggingMutationErrorType
	// The given GUID or tag you're looking for does not exist.
	NOT_FOUND TaggingMutationErrorType
	// You've attempted to do something your Domain/EntityType is not permitted to do. Its also possible that an api key is required.
	NOT_PERMITTED TaggingMutationErrorType
	// One of the query filters exceeds the character limit.
	TOO_MANY_CHARS_QUERY_FILTER TaggingMutationErrorType
	// The given entity has reached its tag key count limit. You will need to delete existing tags for the given GUID before continuing.
	TOO_MANY_TAG_KEYS TaggingMutationErrorType
	// The given entity has reached its tag value count limit. You will need to delete existing values for the given GUID before continuing.
	TOO_MANY_TAG_VALUES TaggingMutationErrorType
	// The changes will be reflected in the entity with some delay
	UPDATE_WILL_BE_DELAYED TaggingMutationErrorType
}{
	// Too many concurrent tasks for the same GUID are being sent and we cannot process. Please serialize your requests for the given GUID.
	CONCURRENT_TASK_EXCEPTION: "CONCURRENT_TASK_EXCEPTION",
	// Domain Type invalid. The decoded domain type from the provided GUID is not valid. Please provide a correct GUID.
	INVALID_DOMAIN_TYPE: "INVALID_DOMAIN_TYPE",
	// We could not decode the provided GUID. Entity guid needs to be base64 encoded.
	INVALID_ENTITY_GUID: "INVALID_ENTITY_GUID",
	// The tag key is not valid. Char length has been reached, contains a disallowed character(eg :) or is empty
	INVALID_KEY: "INVALID_KEY",
	// The tag value is not valid. Char length has been reached, contains a disallowed character(eg :) or is empty
	INVALID_VALUE: "INVALID_VALUE",
	// The given GUID or tag you're looking for does not exist.
	NOT_FOUND: "NOT_FOUND",
	// You've attempted to do something your Domain/EntityType is not permitted to do. Its also possible that an api key is required.
	NOT_PERMITTED: "NOT_PERMITTED",
	// One of the query filters exceeds the character limit.
	TOO_MANY_CHARS_QUERY_FILTER: "TOO_MANY_CHARS_QUERY_FILTER",
	// The given entity has reached its tag key count limit. You will need to delete existing tags for the given GUID before continuing.
	TOO_MANY_TAG_KEYS: "TOO_MANY_TAG_KEYS",
	// The given entity has reached its tag value count limit. You will need to delete existing values for the given GUID before continuing.
	TOO_MANY_TAG_VALUES: "TOO_MANY_TAG_VALUES",
	// The changes will be reflected in the entity with some delay
	UPDATE_WILL_BE_DELAYED: "UPDATE_WILL_BE_DELAYED",
}

// WorkloadStatusSource - Indicates where the status value derives from.
type WorkloadStatusSource string

var WorkloadStatusSourceTypes = struct {
	// Refers to the result of an automatic rule defined for a workload.
	ROLLUP_RULE WorkloadStatusSource
	// Refers to a static status defined for a workload.
	STATIC WorkloadStatusSource
	// Refers to an undetermined status source.
	UNKNOWN WorkloadStatusSource
	// Refers to the override policy that is applied to a set of partial results within a workload. Any static status always overrides any other status values calculated automatically. Otherwise, the worst status of the partial results is rolled up.
	WORKLOAD WorkloadStatusSource
}{
	// Refers to the result of an automatic rule defined for a workload.
	ROLLUP_RULE: "ROLLUP_RULE",
	// Refers to a static status defined for a workload.
	STATIC: "STATIC",
	// Refers to an undetermined status source.
	UNKNOWN: "UNKNOWN",
	// Refers to the override policy that is applied to a set of partial results within a workload. Any static status always overrides any other status values calculated automatically. Otherwise, the worst status of the partial results is rolled up.
	WORKLOAD: "WORKLOAD",
}

// WorkloadStatusValue - The status of the workload, which is derived from the static and the automatic statuses configured. Any static status always overrides any other status values calculated automatically.
type WorkloadStatusValue string

var WorkloadStatusValueTypes = struct {
	// The status of the workload is degraded.
	DEGRADED WorkloadStatusValue
	// The status of the workload is disrupted.
	DISRUPTED WorkloadStatusValue
	// The status of the workload is operational.
	OPERATIONAL WorkloadStatusValue
	// The status of the workload is unknown.
	UNKNOWN WorkloadStatusValue
}{
	// The status of the workload is degraded.
	DEGRADED: "DEGRADED",
	// The status of the workload is disrupted.
	DISRUPTED: "DISRUPTED",
	// The status of the workload is operational.
	OPERATIONAL: "OPERATIONAL",
	// The status of the workload is unknown.
	UNKNOWN: "UNKNOWN",
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// Fetch a list of entities.
	//
	// You can fetch a max of 25 entities in one query.
	//
	// For more details on entities, visit our [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
	Entities []EntityInterface `json:"entities,omitempty"`
	// Fetch a single entity.
	//
	// For more details on entities, visit our [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
	Entity EntityInterface `json:"entity,omitempty"`
	// Search for entities using a custom query.
	//
	// For more details on how to create a custom query
	// and what entity data you can request, visit our
	// [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
	//
	// Note: you must supply either a `query` OR a `queryBuilder` argument, not both.
	EntitySearch EntitySearch `json:"entitySearch,omitempty"`
}

// AgentApplicationSegmentsBrowserSegmentAllowList - The allow list object for browser applications.
type AgentApplicationSegmentsBrowserSegmentAllowList struct {
	// The url segments that are allowed.
	Segments []string `json:"segments,omitempty"`
}

// AgentApplicationSegmentsSegmentAllowListFilters - Filter the allow lists by fields specified in this object.
type AgentApplicationSegmentsSegmentAllowListFilters struct {
	// INTERNAL or USER. Defaults to USER
	ListType AgentApplicationSegmentsListType `json:"listType,omitempty"`
}

// AgentApplicationSettingsApmBase - Settings that are applicable to APM applications and their agents.
type AgentApplicationSettingsApmBase struct {
	// The name for the application
	Alias string `json:"alias,omitempty"`
	// Access general settings for the application.
	ApmConfig AgentApplicationSettingsApmConfig `json:"apmConfig"`
	// Enable or disable the capture of memcache keys.
	CaptureMemcacheKeys bool `json:"captureMemcacheKeys,omitempty"`
	// Access error collector settings for the application. The error collector captures information about uncaught exceptions and sends them to New Relic for viewing.
	ErrorCollector AgentApplicationSettingsErrorCollector `json:"errorCollector,omitempty"`
	// Access enabled state for the Java Flight Recorder. This is available only for the Java language agent version 8.0.0 or later.
	Jfr AgentApplicationSettingsJfr `json:"jfr,omitempty"`
	// The name originally given to the application for reporting.
	OriginalName string `json:"originalName,omitempty"`
	// In APM, when transaction traces are collected, there may be additional Slow query data available.
	SlowSql AgentApplicationSettingsSlowSql `json:"slowSql,omitempty"`
	// Measures wall clock time, CPU time, and method call counts in your application's threads as they run.
	ThreadProfiler AgentApplicationSettingsThreadProfiler `json:"threadProfiler,omitempty"`
	// Type of tracer used. APM's cross application tracing links transactions between APM apps in your service-oriented architecture (SOA).  Distributed tracing is an improvement on the cross application tracing feature, and is recommended for large, distributed systems.
	TracerType AgentApplicationSettingsTracer `json:"tracerType,omitempty"`
	// Access transaction tracer settings for the application.
	TransactionTracer AgentApplicationSettingsTransactionTracer `json:"transactionTracer,omitempty"`
}

// AgentApplicationSettingsApmConfig - General settings related to APM applications.
type AgentApplicationSettingsApmConfig struct {
	// The desired target for the APDEX measurement of this APM application.
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// Sets if agents for this APM application should get some of their configuration from the server.
	UseServerSideConfig bool `json:"useServerSideConfig,omitempty"`
}

// AgentApplicationSettingsApplicationExitInfo - Reports on application exits, which can be used to determine if an application is not responding.
type AgentApplicationSettingsApplicationExitInfo struct {
	// Whether or not application exit info is collected.
	Enabled bool `json:"enabled"`
}

// AgentApplicationSettingsBrowserAjax - Enables ajax traces in the browser app.
type AgentApplicationSettingsBrowserAjax struct {
	// List of domains excluded from Ajax traces by the browser agent.
	DenyList []string `json:"denyList"`
}

// AgentApplicationSettingsBrowserBase - Settings that are applicable to browser applications.
type AgentApplicationSettingsBrowserBase struct {
	// Access general settings for the application.
	BrowserConfig AgentApplicationSettingsBrowserConfig `json:"browserConfig"`
	// browser monitoring provides real user monitoring (RUM) that measures the speed and performance of end users as they navigate the application using different web browsers, devices, operating systems, and networks.
	BrowserMonitoring AgentApplicationSettingsBrowserMonitoring `json:"browserMonitoring"`
	// Session Replay configuration.
	SessionReplay AgentApplicationSettingsSessionReplay `json:"sessionReplay"`
	// Session Trace configuration.
	SessionTrace AgentApplicationSettingsSessionTrace `json:"sessionTrace"`
}

// AgentApplicationSettingsBrowserConfig - General settings related to APM applications.
type AgentApplicationSettingsBrowserConfig struct {
	// The desired target for the APDEX measurement of this browser application.
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
}

// AgentApplicationSettingsBrowserDistributedTracing - Distributed tracing type. See [documentation](https://docs.newrelic.com/docs/browser/new-relic-browser/browser-pro-features/browser-data-distributed-tracing/) for further information.
type AgentApplicationSettingsBrowserDistributedTracing struct {
	// List of allowed origins for use with distributed tracing.
	AllowedOrigins []string `json:"allowedOrigins"`
	// Whether or not CORS is enabled in distributed tracing.
	CorsEnabled bool `json:"corsEnabled,omitempty"`
	// Whether or not CORS uses the `newrelic` header in distributed tracing.
	CorsUseNewrelicHeader bool `json:"corsUseNewrelicHeader,omitempty"`
	// Whether or not CORS uses tracecontext headers in distributed tracing.
	CorsUseTracecontextHeaders bool `json:"corsUseTracecontextHeaders,omitempty"`
	// Whether or not distributed tracing is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// Whether or not to exclude the `newrelic` header in distributed tracing.
	ExcludeNewrelicHeader bool `json:"excludeNewrelicHeader,omitempty"`
}

// AgentApplicationSettingsBrowserMonitoring - Provides fields to set browser monitoring application settings.
type AgentApplicationSettingsBrowserMonitoring struct {
	// Enables ajax traces in the browser app.
	Ajax AgentApplicationSettingsBrowserAjax `json:"ajax,omitempty"`
	// Distributed tracing type. See [documentation](https://docs.newrelic.com/docs/browser/new-relic-browser/browser-pro-features/browser-data-distributed-tracing/) for further information.
	DistributedTracing AgentApplicationSettingsBrowserDistributedTracing `json:"distributedTracing"`
	// The type of browser agent that will be loaded.
	Loader AgentApplicationSettingsBrowserLoader `json:"loader"`
	// Specify the semantic version of the browser agent that you would like your app to use. Leave this blank to use the most recent version. Use 'x' in place of a numeric digit to represent the latest release within the version range. For example, '1.x.x'
	PinnedVersion string `json:"pinnedVersion,omitempty"`
	// Browser privacy. See [documentation](https://docs.newrelic.com/docs/browser/browser-monitoring/page-load-timing-resources/cookie-collection-session-tracking/) for further information.
	Privacy AgentApplicationSettingsBrowserPrivacy `json:"privacy"`
}

// AgentApplicationSettingsBrowserPrivacy - Browser privacy. See [documentation](https://docs.newrelic.com/docs/browser/browser-monitoring/page-load-timing-resources/cookie-collection-session-tracking/) for further information.
type AgentApplicationSettingsBrowserPrivacy struct {
	// Whether or not cookies are enabled.
	CookiesEnabled bool `json:"cookiesEnabled"`
}

// AgentApplicationSettingsBrowserProperties - General Properties related to browser applications.
type AgentApplicationSettingsBrowserProperties struct {
	// The configuration required to run the npm version of the JS agent. This is the "pure" JSON configuration block without surrounding HTML <script> tags.
	JsConfig AgentApplicationSettingsRawJsConfiguration `json:"jsConfig,omitempty"`
	// The configuration block required to run the npm version of the JS agent. This includes the HTML <script> tags.
	JsConfigScript string `json:"jsConfigScript,omitempty"`
	// The snippet of JavaScript used to copy/paste into your JavaScript app if you aren’t using an auto-instrumentating agent on the backend.
	JsLoaderScript string `json:"jsLoaderScript,omitempty"`
}

// AgentApplicationSettingsErrorCollector - The error collector captures information about uncaught exceptions and sends them to New Relic for viewing. For more information about what these settings do and which ones are applicable for your application, please see https://docs.newrelic.com for more information about agent configuration for your language agent.
type AgentApplicationSettingsErrorCollector struct {
	// Enables error collector.
	Enabled bool `json:"enabled,omitempty"`
	// Prevents specified exception classes from affecting error rate or Apdex score while still reporting the errors to APM.
	ExpectedErrorClasses []string `json:"expectedErrorClasses"`
	// An array of individual HTTP status codes to be marked as expected and thus prevented from affecting error rate or Apdex score.
	ExpectedErrorCodes []AgentApplicationSettingsErrorCollectorHttpStatus `json:"expectedErrorCodes"`
	// Specified exception class names will be ignored and will not affect error rate or Apdex score, or be reported to APM.
	IgnoredErrorClasses []string `json:"ignoredErrorClasses"`
	// An array of individual HTTP status codes that should not be treated as errors.
	IgnoredErrorCodes []AgentApplicationSettingsErrorCollectorHttpStatus `json:"ignoredErrorCodes"`
}

// AgentApplicationSettingsIgnoredStatusCodeRule - A configuration setting used ignore status codes associated with different hosts.
type AgentApplicationSettingsIgnoredStatusCodeRule struct {
	// An array of hosts to apply the status code rule to.
	Hosts []string `json:"hosts"`
	// An array of status codes to be be ignored on these hosts.
	StatusCodes []string `json:"statusCodes"`
}

// AgentApplicationSettingsJfr - Access to the enabled state of the Java Flight Recorder. This feature only available on the Java language agent version 8.0.0 or later.
type AgentApplicationSettingsJfr struct {
	// If true, the java agent collects Java Flight Recorder data. (Java Agent version 8.0.0 required.)
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsMaskInputOptions - Mask specific kinds of input options as *.
type AgentApplicationSettingsMaskInputOptions struct {
	// Mask 'color' input type.
	Color bool `json:"color"`
	// Mask 'date' input type.
	Date bool `json:"date"`
	// Mask 'datetime_local' input type.
	DatetimeLocal bool `json:"datetimeLocal"`
	// Mask 'email' input type.
	Email bool `json:"email"`
	// Mask 'month' input type.
	Month bool `json:"month"`
	// Mask 'number' input type.
	Number bool `json:"number"`
	// Mask 'range' input type.
	Range bool `json:"range"`
	// Mask 'search' input type.
	Search bool `json:"search"`
	// Mask 'select' input type.
	Select bool `json:"select"`
	// Mask 'tel' input type.
	Tel bool `json:"tel"`
	// Mask 'text' input type.
	Text bool `json:"text"`
	// Mask 'textarea' input type.
	TextArea bool `json:"textArea"`
	// Mask 'time' input type.
	Time bool `json:"time"`
	// Mask 'url' input type.
	URL bool `json:"url"`
	// Mask 'week' input type.
	Week bool `json:"week"`
}

// AgentApplicationSettingsMobileBase - Settings that are applicable to mobile applications
type AgentApplicationSettingsMobileBase struct {
	// Reports on application exits, which can be used to determine if an application is not responding.
	ApplicationExitInfo AgentApplicationSettingsApplicationExitInfo `json:"applicationExitInfo"`
	// Network settings associated with the mobile application.
	NetworkSettings AgentApplicationSettingsMobileNetworkSettings `json:"networkSettings,omitempty"`
	// Enables viewing in-depth reports for mobile application crashes.
	UseCrashReports bool `json:"useCrashReports,omitempty"`
}

// AgentApplicationSettingsMobileNetworkSettings - Network settings associated with the mobile application.
type AgentApplicationSettingsMobileNetworkSettings struct {
	// A list of configuration settings that map host to alias names for grouping and identification purposes.
	Aliases []AgentApplicationSettingsNetworkAlias `json:"aliases"`
	// Configuration setting to apply either the show or hide strategy for network filtering.
	FilterMode AgentApplicationSettingsNetworkFilterMode `json:"filterMode,omitempty"`
	// A list of hostnames that would be applied to our filter settings when the filterMode is 'HIDE.'
	HideList []string `json:"hideList"`
	// A list of rules to ignore status codes associated with different hosts.
	IgnoredStatusCodeRules []AgentApplicationSettingsIgnoredStatusCodeRule `json:"ignoredStatusCodeRules"`
	// A list of hostnames that would be applied to our filter settings when the filterMode is 'SHOW.'
	ShowList []string `json:"showList"`
}

// AgentApplicationSettingsMobileProperties - General properties related to mobile applications.
type AgentApplicationSettingsMobileProperties struct {
	// A token used to authenticate your mobile application for data ingest.
	ApplicationToken SecureValue `json:"applicationToken,omitempty"`
}

// AgentApplicationSettingsNetworkAlias - A configuration setting that maps hosts to alias names for grouping and identification purposes.
type AgentApplicationSettingsNetworkAlias struct {
	// An alternative name that can be used to reference the hostnames.
	Alias string `json:"alias,omitempty"`
	// A list of hostnames to associate with an alias.
	Hosts []string `json:"hosts"`
}

// AgentApplicationSettingsSessionReplay - Session Replay configuration.
type AgentApplicationSettingsSessionReplay struct {
	// When true, Session Replay will activate normally (this is the default). If set to false, Session Replay will not record automatically, but the agent will allow recording to be turned on via it's API. Please see [here](https://docs.newrelic.com/docs/browser/new-relic-browser/browser-apis/start/) for more details.
	AutoStart bool `json:"autoStart"`
	// String to configure which selector should be blocked
	BlockSelector string `json:"blockSelector"`
	// Indicates whether the agent will serialize fonts for collection without public asset url.
	CollectFonts bool `json:"collectFonts"`
	// Session Replay enabled.
	Enabled bool `json:"enabled"`
	// Percentage from 0-10 specifying how many of all user sessions that contain errors should be recorded.
	ErrorSamplingRate float64 `json:"errorSamplingRate"`
	// Indicates whether the agent will serialize images for collection without public asset url
	InlineImages bool `json:"inlineImages"`
	// Indicates whether the agent will serialize css for collection without public asset url.
	InlineStylesheet bool `json:"inlineStylesheet"`
	// Mask all input content as *
	MaskAllInputs bool `json:"maskAllInputs"`
	// Mask specific kinds of input options as *.
	MaskInputOptions AgentApplicationSettingsMaskInputOptions `json:"maskInputOptions"`
	// String to configure which selector should be masked.
	MaskTextSelector string `json:"maskTextSelector,omitempty"`
	// Percentage from 0-10 specifying how many of all user sessions should be recorded.
	SamplingRate float64 `json:"samplingRate"`
}

// AgentApplicationSettingsSessionTrace - Session Trace configuration.
type AgentApplicationSettingsSessionTrace struct {
	// Session Trace enabled.
	Enabled bool `json:"enabled"`
	// Percentage from 0-100 specifying how many of all user sessions that contain errors should be recorded.
	ErrorSamplingRate float64 `json:"errorSamplingRate"`
	// Default (fixed_rate) or custom (probabilistic) option used to collect session traces.
	Mode AgentApplicationSettingsSessionTraceMode `json:"mode,omitempty"`
	// Percentage from 0-100 specifying how many of all user sessions should be recorded.
	SamplingRate float64 `json:"samplingRate"`
}

// AgentApplicationSettingsSlowSql - In APM, when transaction traces are collected, there may be additional Slow query data available.
type AgentApplicationSettingsSlowSql struct {
	// If true, the agent collects slow SQL queries.
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsThreadProfiler - Measures wall clock time, CPU time, and method call counts in your application's threads as they run.
type AgentApplicationSettingsThreadProfiler struct {
	// Whether or not the Thread Profiler is enabled for your application.
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsTransactionTracer - Transaction tracer settings related to APM applications. For more information about what these settings do and which ones are applicable for your application, please see https://docs.newrelic.com for more information about agent configuration for your language agent.
type AgentApplicationSettingsTransactionTracer struct {
	// DEPRECATED: Please use capture_memcache_keys on parent type.
	CaptureMemcacheKeys bool `json:"captureMemcacheKeys,omitempty"`
	// If true, this enables the transaction tracer feature, enabling collection of transaction traces.
	Enabled bool `json:"enabled,omitempty"`
	// If true, enables the collection of explain plans in transaction traces. This setting will also apply to explain plans in slow SQL traces if slow_sql.explain_enabled is not set separately.
	ExplainEnabled bool `json:"explainEnabled,omitempty"`
	// Relevant only when explain_enabled is true. Can be set to automatic configuration (APDEX_F) or manual (see explainThresholdValue).
	ExplainThresholdType AgentApplicationSettingsThresholdTypeEnum `json:"explainThresholdType,omitempty"`
	// Threshold (in seconds) above which the agent will collect explain plans. Relevant only when explainEnabled is true and explainThresholdType is set to VALUE.
	ExplainThresholdValue nrtime.Seconds `json:"explainThresholdValue,omitempty"`
	// Set to true to enable logging of queries to the agent log file instead of uploading to New Relic. Queries are logged using the record_sql mode.
	LogSql bool `json:"logSql,omitempty"`
	// Obfuscation level for SQL queries reported in transaction trace nodes.
	RecordSql AgentApplicationSettingsRecordSqlEnum `json:"recordSql,omitempty"`
	// Specify a threshold in seconds. The agent includes stack traces in transaction trace nodes when the stack trace duration exceeds this threshold.
	StackTraceThreshold nrtime.Seconds `json:"stackTraceThreshold,omitempty"`
	// Relevant only when TransactionTracer is enabled. Can be set to automatic configuration (APDEX_F) or manual (see TransactionThresholdValue).
	TransactionThresholdType AgentApplicationSettingsThresholdTypeEnum `json:"transactionThresholdType,omitempty"`
	// Threshold (in seconds) that transactions with a duration longer than this threshold are eligible for transaction traces.  Relevant only when transaction tracer is enabled and transaction_threshold_type is set to VALUE.
	TransactionThresholdValue nrtime.Seconds `json:"transactionThresholdValue,omitempty"`
}

// AgentEnvironmentApplicationInstance - Representation of the New Relic agent collecting data.
type AgentEnvironmentApplicationInstance struct {
	// Contains environment attributes regarding the reported setting of the reporting agent.
	AgentSettingsAttributes []AgentEnvironmentAttribute `json:"agentSettingsAttributes"`
	// Information of the application instance, such as host and language.
	Details AgentEnvironmentApplicationInstanceDetails `json:"details"`
	// Contains general environment attributes from the same environment where the application instance is running.
	EnvironmentAttributes []AgentEnvironmentAttribute `json:"environmentAttributes"`
	// Contains environment attributes regarding modules loaded by the application instance. Used only by the Java agent.
	Modules []AgentEnvironmentApplicationLoadedModule `json:"modules"`
}

// AgentEnvironmentApplicationInstanceDetails - Details of an application instance such as host and language.
type AgentEnvironmentApplicationInstanceDetails struct {
	// Host of the application instance.
	Host string `json:"host"`
	// Host display name of the application instance.
	HostDisplayName string `json:"hostDisplayName"`
	// ID of the application instance.
	ID string `json:"id"`
	// Instance name generated by language, host and name
	InstanceName string `json:"instanceName"`
	// Language of the application instance.
	Language string `json:"language"`
	// Name of the application instance.
	Name string `json:"name"`
}

// AgentEnvironmentApplicationInstancesResult - List of APM application instances with pagination data.
type AgentEnvironmentApplicationInstancesResult struct {
	// List of APM application instances .
	ApplicationInstances []AgentEnvironmentApplicationInstance `json:"applicationInstances"`
	// If nextCursor is a String value, set it to the cursor input field while searching in order to get the next page of results.
	NextCursor string `json:"nextCursor,omitempty"`
}

// AgentEnvironmentApplicationLoadedModule - Represents a module loaded by the apm application.
type AgentEnvironmentApplicationLoadedModule struct {
	// Extra module attributes.
	Attributes []AgentEnvironmentLoadedModuleAttribute `json:"attributes"`
	// Module name.
	Name string `json:"name"`
	// Module version.
	Version string `json:"version,omitempty"`
}

// AgentEnvironmentAttribute - Represents one attribute from within the environment on which an agent is running.
type AgentEnvironmentAttribute struct {
	// Environment attribute name.
	Attribute string `json:"attribute"`
	// Value of the environment attribute.
	Value string `json:"value"`
}

// AgentEnvironmentFilter - A filter that can be applied to filter results.
type AgentEnvironmentFilter struct {
	// A string to filter results that includes this string anywhere. Case insensitive.
	Contains string `json:"contains,omitempty"`
	// A string to filter out results that includes this string anywhere. Case insensitive.
	DoesNotContain string `json:"doesNotContain,omitempty"`
	// A string to filter results that are exactly as the string provided. Case sensitive.
	Equals string `json:"equals,omitempty"`
	// A string to filter results that starts with this string. Case insensitive.
	StartsWith string `json:"startsWith,omitempty"`
}

// AgentEnvironmentLoadedModuleAttribute - Attribute belonging to a loaded module.
type AgentEnvironmentLoadedModuleAttribute struct {
	// Name of the module attribute.
	Name string `json:"name"`
	// Value of the module attribute.
	Value string `json:"value"`
}

// AiNotificationsChannel - Channel object
type AiNotificationsChannel struct {
	// The accountId of the creator of the channel
	AccountID int `json:"accountId"`
	// Is channel active
	Active bool `json:"active"`
	// Channel creation time
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// Related destination type
	DestinationId string `json:"destinationId"`
	// Channel id
	ID string `json:"id"`
	// Channel name
	Name string `json:"name"`
	// Related product type
	Product AiNotificationsProduct `json:"product"`
	// List of destination property types
	Properties []AiNotificationsProperty `json:"properties"`
	// Channel Status
	Status AiNotificationsChannelStatus `json:"status"`
	// Channel type
	Type AiNotificationsChannelType `json:"type"`
	// Channel last update time
	UpdatedAt nrtime.DateTime `json:"updatedAt"`
	// Message template creator userId
	UpdatedBy int `json:"updatedBy"`
}

// AiNotificationsDestination - Destination Object
type AiNotificationsDestination struct {
	// The accountId of the creator of the destination
	AccountID int `json:"accountId"`
	// Destination active
	Active bool `json:"active"`
	// Authentication for this destination
	Auth AiNotificationsAuth `json:"auth,omitempty"`
	// Destination created at
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// Entity Id of the Destination
	GUID common.EntityGUID `json:"guid"`
	// Destination id
	ID string `json:"id"`
	// Indicates whether the user is authenticated with the destination
	IsUserAuthenticated bool `json:"isUserAuthenticated"`
	// Last time a notification was sent
	LastSent nrtime.DateTime `json:"lastSent,omitempty"`
	// Destination name
	Name string `json:"name"`
	// List of destination property types
	Properties []AiNotificationsProperty `json:"properties"`
	// URL in secure format
	SecureURL AiNotificationsSecureURL `json:"secureUrl,omitempty"`
	// Destination status
	Status AiNotificationsDestinationStatus `json:"status"`
	// Destination type
	Type AiNotificationsDestinationType `json:"type"`
	// Destination updated at
	UpdatedAt nrtime.DateTime `json:"updatedAt"`
	// Destination updated by
	UpdatedBy int `json:"updatedBy"`
}

// AiNotificationsProperty - Channel property Object
type AiNotificationsProperty struct {
	// Channel property display key
	DisplayValue string `json:"displayValue,omitempty"`
	// Channel property key
	Key string `json:"key"`
	// Channel property display key
	Label string `json:"label,omitempty"`
	// Channel property value
	Value string `json:"value"`
}

// AiNotificationsSecureURL - URL in secure format
type AiNotificationsSecureURL struct {
	// URL prefix
	Prefix string `json:"prefix"`
}

// AiNotificationsSuggestion - Suggestion object
type AiNotificationsSuggestion struct {
	// Suggestion label
	DisplayValue string `json:"displayValue"`
	// Should suggestion be the default selection
	Icon string `json:"icon,omitempty"`
	// Suggestion key
	Value string `json:"value"`
}

// AiNotificationsVariable - Variable object
type AiNotificationsVariable struct {
	// Is variable active
	Active bool `json:"active"`
	// Variable category
	Category AiNotificationsVariableCategory `json:"category"`
	// Variable creation time
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// Variable description
	Description string `json:"description,omitempty"`
	// Variable example
	Example string `json:"example"`
	// Variable id
	ID string `json:"id"`
	// Variable key
	Key string `json:"key"`
	// Variable label
	Label string `json:"label,omitempty"`
	// Variable name
	Name string `json:"name"`
	// Related product type
	Product AiNotificationsProduct `json:"product"`
	// Variable type
	Type AiNotificationsVariableType `json:"type"`
	// Variable update time
	UpdatedAt nrtime.DateTime `json:"updatedAt"`
	// Variable creator userId
	UpdatedBy int `json:"updatedBy"`
}

// AiWorkflowsDestinationConfiguration - Destination Configuration Object
type AiWorkflowsDestinationConfiguration struct {
	// Channel Id of the Destination Configuration
	ChannelId string `json:"channelId"`
	// Name of the Destination Configuration
	Name string `json:"name"`
	// Notification triggers of the Destination Configuration
	NotificationTriggers []AiWorkflowsNotificationTrigger `json:"notificationTriggers"`
	// Type of the Destination Configuration
	Type AiWorkflowsDestinationType `json:"type"`
	// Update original notification message (Slack channels only)
	UpdateOriginalMessage bool `json:"updateOriginalMessage,omitempty"`
}

// AiWorkflowsEnrichment - Makes it possible to augment the notification with additional data from the New Relic platform
type AiWorkflowsEnrichment struct {
	// Account Id of the Enrichment
	AccountID int `json:"accountId"`
	// List of configurations for the enrichment
	Configurations []AiWorkflowsConfiguration `json:"configurations"`
	// The time the Enrichment was created
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// Enrichment Id
	ID string `json:"id"`
	// Name of the Enrichment
	Name string `json:"name"`
	// Type of the Enrichment
	Type AiWorkflowsEnrichmentType `json:"type"`
	// The time the Enrichment was last updated
	UpdatedAt nrtime.DateTime `json:"updatedAt"`
}

// AiWorkflowsFilter - Filter Object
type AiWorkflowsFilter struct {
	// Account Id of this Filter
	AccountID int `json:"accountId"`
	// Filter Id
	ID string `json:"id"`
	// Name of the Filter
	Name string `json:"name"`
	// Expressions that determine which issues will be handled
	Predicates []AiWorkflowsPredicate `json:"predicates"`
	// The type of the Filter
	Type AiWorkflowsFilterType `json:"type"`
}

// AiWorkflowsPredicate - Predicate Object
type AiWorkflowsPredicate struct {
	// Field name in the issue event
	Attribute string `json:"attribute"`
	// Type of operator used to match the values
	Operator AiWorkflowsOperator `json:"operator"`
	// Values to compare
	Values []string `json:"values"`
}

// AiWorkflowsWorkflow - Workflow object
type AiWorkflowsWorkflow struct {
	// Account Id of this Workflow
	AccountID int `json:"accountId"`
	// The time this workflow was created
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// Specifies where to send the notifications
	DestinationConfigurations []AiWorkflowsDestinationConfiguration `json:"destinationConfigurations"`
	// Are Destinations enabled
	DestinationsEnabled bool `json:"destinationsEnabled"`
	// List of enrichments that are attached to the notifications
	Enrichments []AiWorkflowsEnrichment `json:"enrichments"`
	// Are Enrichments enabled
	EnrichmentsEnabled bool `json:"enrichmentsEnabled"`
	// Entity Id of the workflow
	GUID common.EntityGUID `json:"guid"`
	// Workflow Id
	ID string `json:"id"`
	// Specifies which issues the workflow will handle
	IssuesFilter AiWorkflowsFilter `json:"issuesFilter"`
	// Last time a notification was sent regarding this workflow
	LastRun nrtime.DateTime `json:"lastRun,omitempty"`
	// Describes how to handle muted issues
	MutingRulesHandling AiWorkflowsMutingRulesHandling `json:"mutingRulesHandling"`
	// Name of the Workflow
	Name string `json:"name"`
	// The time this workflow was updated
	UpdatedAt nrtime.DateTime `json:"updatedAt"`
	// Is Workflow enabled
	WorkflowEnabled bool `json:"workflowEnabled"`
}

type AlertableEntity struct {
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the timewindow or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from AlertableEntity
func (x AlertableEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from AlertableEntity
func (x AlertableEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from AlertableEntity
func (x AlertableEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

func (x *AlertableEntity) ImplementsAlertableEntity() {}

type AlertableEntityOutline struct {
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from AlertableEntityOutline
func (x AlertableEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

func (x *AlertableEntityOutline) ImplementsAlertableEntityOutline() {}

// ApmApplicationDeployment - An APM application deployment marker
type ApmApplicationDeployment struct {
	// The changelog of the deployment
	Changelog string `json:"changelog,omitempty"`
	// Description of the deployment
	Description string `json:"description,omitempty"`
	// A link to view the deployment in the UI
	Permalink string `json:"permalink,omitempty"`
	// The revision of the app that was deployed
	Revision string `json:"revision,omitempty"`
	// The moment the deployment occured
	Timestamp *nrtime.EpochMilliseconds `json:"timestamp,omitempty"`
	// The user who triggered the deployment
	User string `json:"user,omitempty"`
}

// ApmApplicationEntity - An APM Application entity.
type ApmApplicationEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Summary statistics about the Browser App injected by an APM Application.
	ApmBrowserSummary ApmBrowserApplicationSummaryData `json:"apmBrowserSummary,omitempty"`
	// Settings that are common across APM applications.
	ApmSettings AgentApplicationSettingsApmBase `json:"apmSettings,omitempty"`
	// Summary statistics about the APM App.
	ApmSummary ApmApplicationSummaryData `json:"apmSummary,omitempty"`
	// The ID of the APM Application.
	ApplicationID int `json:"applicationId,omitempty"`
	// List of APM application instances.
	ApplicationInstances []AgentEnvironmentApplicationInstance `json:"applicationInstances"`
	// Paginated list of APM application instances.
	ApplicationInstancesV2 AgentEnvironmentApplicationInstancesResult `json:"applicationInstancesV2"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// Deployments of the APM Application.
	Deployments []ApmApplicationDeployment `json:"deployments,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// An Exception that occurred in your Application.
	Exception StackTraceApmException `json:"exception,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// Retrieves a flamegraph for the specific entity over the time period specified.
	Flamegraph JavaFlightRecorderFlamegraph `json:"flamegraph,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The programming language of the APM Application.
	Language string `json:"language,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Retrieves the entity metric grouping issues.
	MetricGroupingIssues []MetricNormalizationRuleMetricGroupingIssue `json:"metricGroupingIssues"`
	// Retrieves a rule.
	MetricNormalizationRule MetricNormalizationRule `json:"metricNormalizationRule,omitempty"`
	// Retrieves the rules for the application.
	MetricNormalizationRules []MetricNormalizationRule `json:"metricNormalizationRules"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The running versions of the language agent in the APM Application.
	RunningAgentVersions ApmApplicationRunningAgentVersions `json:"runningAgentVersions,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// Configuration settings for the APM Application
	Settings ApmApplicationSettings `json:"settings,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ApmApplicationEntity
func (x ApmApplicationEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ApmApplicationEntity
func (x ApmApplicationEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ApmApplicationEntity
func (x ApmApplicationEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from ApmApplicationEntity
func (x ApmApplicationEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetApmBrowserSummary returns a pointer to the value of ApmBrowserSummary from ApmApplicationEntity
func (x ApmApplicationEntity) GetApmBrowserSummary() ApmBrowserApplicationSummaryData {
	return x.ApmBrowserSummary
}

// GetApmSettings returns a pointer to the value of ApmSettings from ApmApplicationEntity
func (x ApmApplicationEntity) GetApmSettings() AgentApplicationSettingsApmBase {
	return x.ApmSettings
}

// GetApmSummary returns a pointer to the value of ApmSummary from ApmApplicationEntity
func (x ApmApplicationEntity) GetApmSummary() ApmApplicationSummaryData {
	return x.ApmSummary
}

// GetApplicationID returns a pointer to the value of ApplicationID from ApmApplicationEntity
func (x ApmApplicationEntity) GetApplicationID() int {
	return x.ApplicationID
}

// GetApplicationInstances returns a pointer to the value of ApplicationInstances from ApmApplicationEntity
func (x ApmApplicationEntity) GetApplicationInstances() []AgentEnvironmentApplicationInstance {
	return x.ApplicationInstances
}

// GetApplicationInstancesV2 returns a pointer to the value of ApplicationInstancesV2 from ApmApplicationEntity
func (x ApmApplicationEntity) GetApplicationInstancesV2() AgentEnvironmentApplicationInstancesResult {
	return x.ApplicationInstancesV2
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from ApmApplicationEntity
func (x ApmApplicationEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDeployments returns a pointer to the value of Deployments from ApmApplicationEntity
func (x ApmApplicationEntity) GetDeployments() []ApmApplicationDeployment {
	return x.Deployments
}

// GetDomain returns a pointer to the value of Domain from ApmApplicationEntity
func (x ApmApplicationEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ApmApplicationEntity
func (x ApmApplicationEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetException returns a pointer to the value of Exception from ApmApplicationEntity
func (x ApmApplicationEntity) GetException() StackTraceApmException {
	return x.Exception
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ApmApplicationEntity
func (x ApmApplicationEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetFlamegraph returns a pointer to the value of Flamegraph from ApmApplicationEntity
func (x ApmApplicationEntity) GetFlamegraph() JavaFlightRecorderFlamegraph {
	return x.Flamegraph
}

// GetGUID returns a pointer to the value of GUID from ApmApplicationEntity
func (x ApmApplicationEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ApmApplicationEntity
func (x ApmApplicationEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ApmApplicationEntity
func (x ApmApplicationEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ApmApplicationEntity
func (x ApmApplicationEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLanguage returns a pointer to the value of Language from ApmApplicationEntity
func (x ApmApplicationEntity) GetLanguage() string {
	return x.Language
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ApmApplicationEntity
func (x ApmApplicationEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetMetricGroupingIssues returns a pointer to the value of MetricGroupingIssues from ApmApplicationEntity
func (x ApmApplicationEntity) GetMetricGroupingIssues() []MetricNormalizationRuleMetricGroupingIssue {
	return x.MetricGroupingIssues
}

// GetMetricNormalizationRule returns a pointer to the value of MetricNormalizationRule from ApmApplicationEntity
func (x ApmApplicationEntity) GetMetricNormalizationRule() MetricNormalizationRule {
	return x.MetricNormalizationRule
}

// GetMetricNormalizationRules returns a pointer to the value of MetricNormalizationRules from ApmApplicationEntity
func (x ApmApplicationEntity) GetMetricNormalizationRules() []MetricNormalizationRule {
	return x.MetricNormalizationRules
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from ApmApplicationEntity
func (x ApmApplicationEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from ApmApplicationEntity
func (x ApmApplicationEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from ApmApplicationEntity
func (x ApmApplicationEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from ApmApplicationEntity
func (x ApmApplicationEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from ApmApplicationEntity
func (x ApmApplicationEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from ApmApplicationEntity
func (x ApmApplicationEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from ApmApplicationEntity
func (x ApmApplicationEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from ApmApplicationEntity
func (x ApmApplicationEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from ApmApplicationEntity
func (x ApmApplicationEntity) GetReporting() bool {
	return x.Reporting
}

// GetRunningAgentVersions returns a pointer to the value of RunningAgentVersions from ApmApplicationEntity
func (x ApmApplicationEntity) GetRunningAgentVersions() ApmApplicationRunningAgentVersions {
	return x.RunningAgentVersions
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ApmApplicationEntity
func (x ApmApplicationEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetSettings returns a pointer to the value of Settings from ApmApplicationEntity
func (x ApmApplicationEntity) GetSettings() ApmApplicationSettings {
	return x.Settings
}

// GetTags returns a pointer to the value of Tags from ApmApplicationEntity
func (x ApmApplicationEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from ApmApplicationEntity
func (x ApmApplicationEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from ApmApplicationEntity
func (x ApmApplicationEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from ApmApplicationEntity
func (x ApmApplicationEntity) GetType() string {
	return x.Type
}

func (x *ApmApplicationEntity) ImplementsAlertableEntity() {}

func (x *ApmApplicationEntity) ImplementsApmBrowserApplicationEntity() {}

func (x *ApmApplicationEntity) ImplementsEntity() {}

// ApmApplicationEntityOutline - An APM Application entity outline.
type ApmApplicationEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Summary statistics about the Browser App injected by an APM Application.
	ApmBrowserSummary ApmBrowserApplicationSummaryData `json:"apmBrowserSummary,omitempty"`
	// Summary statistics about the APM App.
	ApmSummary ApmApplicationSummaryData `json:"apmSummary,omitempty"`
	// The ID of the APM Application.
	ApplicationID int `json:"applicationId,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The programming language of the APM Application.
	Language string `json:"language,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The running versions of the language agent in the APM Application.
	RunningAgentVersions ApmApplicationRunningAgentVersions `json:"runningAgentVersions,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// Configuration settings for the APM Application
	Settings ApmApplicationSettings `json:"settings,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetApmBrowserSummary returns a pointer to the value of ApmBrowserSummary from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetApmBrowserSummary() ApmBrowserApplicationSummaryData {
	return x.ApmBrowserSummary
}

// GetApmSummary returns a pointer to the value of ApmSummary from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetApmSummary() ApmApplicationSummaryData {
	return x.ApmSummary
}

// GetApplicationID returns a pointer to the value of ApplicationID from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetApplicationID() int {
	return x.ApplicationID
}

// GetDomain returns a pointer to the value of Domain from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLanguage returns a pointer to the value of Language from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetLanguage() string {
	return x.Language
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetRunningAgentVersions returns a pointer to the value of RunningAgentVersions from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetRunningAgentVersions() ApmApplicationRunningAgentVersions {
	return x.RunningAgentVersions
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetSettings returns a pointer to the value of Settings from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetSettings() ApmApplicationSettings {
	return x.Settings
}

// GetTags returns a pointer to the value of Tags from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from ApmApplicationEntityOutline
func (x ApmApplicationEntityOutline) GetType() string {
	return x.Type
}

func (x *ApmApplicationEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *ApmApplicationEntityOutline) ImplementsApmBrowserApplicationEntityOutline() {}

func (x *ApmApplicationEntityOutline) ImplementsEntityOutline() {}

// ApmApplicationRunningAgentVersions - Represents the currently running agent versions in an APM Application.
// An application could be running multiple versions of an agent (across different hosts, for example).
type ApmApplicationRunningAgentVersions struct {
	// The maximum (newest) language agent version running in the APM Application.
	MaxVersion string `json:"maxVersion,omitempty"`
	// The minimum (oldest) language agent version running in the APM Application.
	MinVersion string `json:"minVersion,omitempty"`
}

// ApmApplicationSettings - Configuration settings for the APM Application
type ApmApplicationSettings struct {
	// The current Apdex target setting
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// State of server-side configuration setting
	ServerSideConfig bool `json:"serverSideConfig,omitempty"`
}

// ApmApplicationSummaryData - Summary statistics about the APM App.
type ApmApplicationSummaryData struct {
	// The apdex score. For more details on the use of apdex, visit [our docs](https://docs.newrelic.com/docs/apm/new-relic-apm/apdex/apdex-measure-user-satisfaction).
	ApdexScore float64 `json:"apdexScore,omitempty"`
	// The percentage of responses to all transactions with an error.
	ErrorRate float64 `json:"errorRate,omitempty"`
	// The number of hosts this application is running on.
	HostCount int `json:"hostCount,omitempty"`
	// The number of instances of this application running.
	InstanceCount int `json:"instanceCount,omitempty"`
	// The average response time for non-web transactions in seconds.
	NonWebResponseTimeAverage nrtime.Seconds `json:"nonWebResponseTimeAverage,omitempty"`
	// The number of non-web transactions per minute.
	NonWebThroughput float64 `json:"nonWebThroughput,omitempty"`
	// The average response time for all transactions in seconds.
	ResponseTimeAverage nrtime.Seconds `json:"responseTimeAverage,omitempty"`
	// The number of all transactions per minute.
	Throughput float64 `json:"throughput,omitempty"`
	// The average response time for web transactions in seconds.
	WebResponseTimeAverage nrtime.Seconds `json:"webResponseTimeAverage,omitempty"`
	// The number of web transactions per minute.
	WebThroughput float64 `json:"webThroughput,omitempty"`
}

// ApmBrowserApplicationEntity - The `ApmBrowserApplicationEntity` interface provides detailed information for the Browser App injected by an APM Application.
type ApmBrowserApplicationEntity struct {
	ApmBrowserSummary ApmBrowserApplicationSummaryData `json:"apmBrowserSummary,omitempty"`
}

// GetApmBrowserSummary returns a pointer to the value of ApmBrowserSummary from ApmBrowserApplicationEntity
func (x ApmBrowserApplicationEntity) GetApmBrowserSummary() ApmBrowserApplicationSummaryData {
	return x.ApmBrowserSummary
}

func (x *ApmBrowserApplicationEntity) ImplementsApmBrowserApplicationEntity() {}

// ApmBrowserApplicationEntityOutline - The `ApmBrowserApplicationEntityOutline` interface provides detailed information for the Browser App injected by an APM Application.
type ApmBrowserApplicationEntityOutline struct {
	ApmBrowserSummary ApmBrowserApplicationSummaryData `json:"apmBrowserSummary,omitempty"`
}

// GetApmBrowserSummary returns a pointer to the value of ApmBrowserSummary from ApmBrowserApplicationEntityOutline
func (x ApmBrowserApplicationEntityOutline) GetApmBrowserSummary() ApmBrowserApplicationSummaryData {
	return x.ApmBrowserSummary
}

func (x *ApmBrowserApplicationEntityOutline) ImplementsApmBrowserApplicationEntityOutline() {}

// ApmBrowserApplicationSummaryData - Summary statistics about the Browser App injected by the APM Application.
type ApmBrowserApplicationSummaryData struct {
	// The number of AJAX requests per minute
	AjaxRequestThroughput float64 `json:"ajaxRequestThroughput,omitempty"`
	// The average AJAX response time in seconds.
	AjaxResponseTimeAverage nrtime.Seconds `json:"ajaxResponseTimeAverage,omitempty"`
	// The percentage of page views with a JS error.
	JsErrorRate float64 `json:"jsErrorRate,omitempty"`
	// The number of page loads per minute
	PageLoadThroughput float64 `json:"pageLoadThroughput,omitempty"`
	// The average page view time in seconds.
	PageLoadTimeAverage float64 `json:"pageLoadTimeAverage,omitempty"`
}

// ApmDatabaseInstanceEntity - A database instance seen by an APM Application
type ApmDatabaseInstanceEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The host the database instance is running on.
	Host string `json:"host,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The port or path the database instance is running on. ex: `3306` | `/tmp/mysql.sock`
	PortOrPath string `json:"portOrPath,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// The type of database. ex: `Postgres` | `Redis`
	Vendor string `json:"vendor,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetHost returns a pointer to the value of Host from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetHost() string {
	return x.Host
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetPermalink() string {
	return x.Permalink
}

// GetPortOrPath returns a pointer to the value of PortOrPath from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetPortOrPath() string {
	return x.PortOrPath
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetType() string {
	return x.Type
}

// GetVendor returns a pointer to the value of Vendor from ApmDatabaseInstanceEntity
func (x ApmDatabaseInstanceEntity) GetVendor() string {
	return x.Vendor
}

func (x *ApmDatabaseInstanceEntity) ImplementsAlertableEntity() {}

func (x *ApmDatabaseInstanceEntity) ImplementsEntity() {}

// ApmDatabaseInstanceEntityOutline - A database instance seen by an APM Application
type ApmDatabaseInstanceEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The host the database instance is running on.
	Host string `json:"host,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The port or path the database instance is running on. ex: `3306` | `/tmp/mysql.sock`
	PortOrPath string `json:"portOrPath,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// The type of database. ex: `Postgres` | `Redis`
	Vendor string `json:"vendor,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetHost returns a pointer to the value of Host from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetHost() string {
	return x.Host
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetPortOrPath returns a pointer to the value of PortOrPath from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetPortOrPath() string {
	return x.PortOrPath
}

// GetReporting returns a pointer to the value of Reporting from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetType() string {
	return x.Type
}

// GetVendor returns a pointer to the value of Vendor from ApmDatabaseInstanceEntityOutline
func (x ApmDatabaseInstanceEntityOutline) GetVendor() string {
	return x.Vendor
}

func (x *ApmDatabaseInstanceEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *ApmDatabaseInstanceEntityOutline) ImplementsEntityOutline() {}

// ApmExternalServiceEntity - An external service seen by an APM Application.
type ApmExternalServiceEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType      EntityType                    `json:"entityType,omitempty"`
	ExternalSummary ApmExternalServiceSummaryData `json:"externalSummary,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The host of the external service.
	Host string `json:"host,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetExternalSummary returns a pointer to the value of ExternalSummary from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetExternalSummary() ApmExternalServiceSummaryData {
	return x.ExternalSummary
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetHost returns a pointer to the value of Host from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetHost() string {
	return x.Host
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from ApmExternalServiceEntity
func (x ApmExternalServiceEntity) GetType() string {
	return x.Type
}

func (x *ApmExternalServiceEntity) ImplementsAlertableEntity() {}

func (x *ApmExternalServiceEntity) ImplementsEntity() {}

// ApmExternalServiceEntityOutline - An external service seen by an APM Application.
type ApmExternalServiceEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType      EntityType                    `json:"entityType,omitempty"`
	ExternalSummary ApmExternalServiceSummaryData `json:"externalSummary,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The host of the external service.
	Host string `json:"host,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetExternalSummary returns a pointer to the value of ExternalSummary from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetExternalSummary() ApmExternalServiceSummaryData {
	return x.ExternalSummary
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetHost returns a pointer to the value of Host from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetHost() string {
	return x.Host
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from ApmExternalServiceEntityOutline
func (x ApmExternalServiceEntityOutline) GetType() string {
	return x.Type
}

func (x *ApmExternalServiceEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *ApmExternalServiceEntityOutline) ImplementsEntityOutline() {}

// ApmExternalServiceSummaryData - Summary statistics about an External Service called by an APM App.
type ApmExternalServiceSummaryData struct {
	// The average response time for external service calls in seconds.
	ResponseTimeAverage nrtime.Seconds `json:"responseTimeAverage,omitempty"`
	// The number of external service calls per minute.
	Throughput float64 `json:"throughput,omitempty"`
}

// BrowserApplicationEntity - A Browser Application entity.
type BrowserApplicationEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The type of Browser agent installed for this application.
	AgentInstallType BrowserAgentInstallType `json:"agentInstallType,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// The ID of the Browser App.
	ApplicationID int `json:"applicationId,omitempty"`
	// Access general properties for the application.
	BrowserProperties AgentApplicationSettingsBrowserProperties `json:"browserProperties,omitempty"`
	// Settings that are common across browser applications.
	BrowserSettings AgentApplicationSettingsBrowserBase `json:"browserSettings,omitempty"`
	// Summary statistics about the Browser App.
	BrowserSummary BrowserApplicationSummaryData `json:"browserSummary,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// An Exception that occurred in your Browser Application.
	Exception StackTraceBrowserException `json:"exception,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Retrieves the entity metric grouping issues.
	MetricGroupingIssues []MetricNormalizationRuleMetricGroupingIssue `json:"metricGroupingIssues"`
	// Retrieves a rule
	MetricNormalizationRule MetricNormalizationRule `json:"metricNormalizationRule,omitempty"`
	// Retrieves the rules for the application.
	MetricNormalizationRules []MetricNormalizationRule `json:"metricNormalizationRules"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The running versions of the agent in the Browser App.
	RunningAgentVersions BrowserApplicationRunningAgentVersions `json:"runningAgentVersions,omitempty"`
	// The allow list for browser applications that contains a set of allowed url segments that will appear in groupings on the Page views and AJAX pages.
	SegmentAllowListAggregate AgentApplicationSegmentsBrowserSegmentAllowList `json:"segmentAllowListAggregate,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The ID of the APM Application that serves this Browser App.
	ServingApmApplicationID int `json:"servingApmApplicationId,omitempty"`
	// Configuration settings for the Browser App
	Settings BrowserApplicationSettings `json:"settings,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetAccountID() int {
	return x.AccountID
}

// GetAgentInstallType returns a pointer to the value of AgentInstallType from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetAgentInstallType() BrowserAgentInstallType {
	return x.AgentInstallType
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetApplicationID returns a pointer to the value of ApplicationID from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetApplicationID() int {
	return x.ApplicationID
}

// GetBrowserProperties returns a pointer to the value of BrowserProperties from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetBrowserProperties() AgentApplicationSettingsBrowserProperties {
	return x.BrowserProperties
}

// GetBrowserSettings returns a pointer to the value of BrowserSettings from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetBrowserSettings() AgentApplicationSettingsBrowserBase {
	return x.BrowserSettings
}

// GetBrowserSummary returns a pointer to the value of BrowserSummary from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetBrowserSummary() BrowserApplicationSummaryData {
	return x.BrowserSummary
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetException returns a pointer to the value of Exception from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetException() StackTraceBrowserException {
	return x.Exception
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetMetricGroupingIssues returns a pointer to the value of MetricGroupingIssues from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetMetricGroupingIssues() []MetricNormalizationRuleMetricGroupingIssue {
	return x.MetricGroupingIssues
}

// GetMetricNormalizationRule returns a pointer to the value of MetricNormalizationRule from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetMetricNormalizationRule() MetricNormalizationRule {
	return x.MetricNormalizationRule
}

// GetMetricNormalizationRules returns a pointer to the value of MetricNormalizationRules from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetMetricNormalizationRules() []MetricNormalizationRule {
	return x.MetricNormalizationRules
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetReporting() bool {
	return x.Reporting
}

// GetRunningAgentVersions returns a pointer to the value of RunningAgentVersions from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetRunningAgentVersions() BrowserApplicationRunningAgentVersions {
	return x.RunningAgentVersions
}

// GetSegmentAllowListAggregate returns a pointer to the value of SegmentAllowListAggregate from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetSegmentAllowListAggregate() AgentApplicationSegmentsBrowserSegmentAllowList {
	return x.SegmentAllowListAggregate
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetServingApmApplicationID returns a pointer to the value of ServingApmApplicationID from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetServingApmApplicationID() int {
	return x.ServingApmApplicationID
}

// GetSettings returns a pointer to the value of Settings from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetSettings() BrowserApplicationSettings {
	return x.Settings
}

// GetTags returns a pointer to the value of Tags from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from BrowserApplicationEntity
func (x BrowserApplicationEntity) GetType() string {
	return x.Type
}

func (x *BrowserApplicationEntity) ImplementsAlertableEntity() {}

func (x *BrowserApplicationEntity) ImplementsEntity() {}

// BrowserApplicationEntityOutline - A Browser Application entity outline.
type BrowserApplicationEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The type of Browser agent installed for this application.
	AgentInstallType BrowserAgentInstallType `json:"agentInstallType,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The ID of the Browser App.
	ApplicationID int `json:"applicationId,omitempty"`
	// Summary statistics about the Browser App.
	BrowserSummary BrowserApplicationSummaryData `json:"browserSummary,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The running versions of the agent in the Browser App.
	RunningAgentVersions BrowserApplicationRunningAgentVersions `json:"runningAgentVersions,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The ID of the APM Application that serves this Browser App.
	ServingApmApplicationID int `json:"servingApmApplicationId,omitempty"`
	// Configuration settings for the Browser App
	Settings BrowserApplicationSettings `json:"settings,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAgentInstallType returns a pointer to the value of AgentInstallType from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetAgentInstallType() BrowserAgentInstallType {
	return x.AgentInstallType
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetApplicationID returns a pointer to the value of ApplicationID from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetApplicationID() int {
	return x.ApplicationID
}

// GetBrowserSummary returns a pointer to the value of BrowserSummary from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetBrowserSummary() BrowserApplicationSummaryData {
	return x.BrowserSummary
}

// GetDomain returns a pointer to the value of Domain from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetRunningAgentVersions returns a pointer to the value of RunningAgentVersions from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetRunningAgentVersions() BrowserApplicationRunningAgentVersions {
	return x.RunningAgentVersions
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetServingApmApplicationID returns a pointer to the value of ServingApmApplicationID from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetServingApmApplicationID() int {
	return x.ServingApmApplicationID
}

// GetSettings returns a pointer to the value of Settings from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetSettings() BrowserApplicationSettings {
	return x.Settings
}

// GetTags returns a pointer to the value of Tags from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from BrowserApplicationEntityOutline
func (x BrowserApplicationEntityOutline) GetType() string {
	return x.Type
}

func (x *BrowserApplicationEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *BrowserApplicationEntityOutline) ImplementsEntityOutline() {}

// BrowserApplicationRunningAgentVersions - Represents the currently running agent versions in a Browser App.
// An app could be running multiple versions of an agent (across different browsers, for example).
type BrowserApplicationRunningAgentVersions struct {
	// The maximum (newest) agent version running in the Browser App, represented as a semantic version string.
	MaxSemanticVersion SemVer `json:"maxSemanticVersion,omitempty"`
	// The maximum (newest) agent version running in the Browser App.
	MaxVersion int `json:"maxVersion,omitempty"`
	// The minimum (oldest) agent version running in the Browser App, represented as a semantic version string.
	MinSemanticVersion SemVer `json:"minSemanticVersion,omitempty"`
	// The minimum (oldest) agent version running in the Browser App.
	MinVersion int `json:"minVersion,omitempty"`
}

// BrowserApplicationSettings - Configuration settings for the Browser App
type BrowserApplicationSettings struct {
	// The current Apdex target setting
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
}

// BrowserApplicationSummaryData - Summary statistics about the Browser App.
type BrowserApplicationSummaryData struct {
	// The number of AJAX requests per minute
	AjaxRequestThroughput float64 `json:"ajaxRequestThroughput,omitempty"`
	// The average AJAX response time in seconds.
	AjaxResponseTimeAverage nrtime.Seconds `json:"ajaxResponseTimeAverage,omitempty"`
	// The percentage of page views with a JS error.
	JsErrorRate float64 `json:"jsErrorRate,omitempty"`
	// The number of page loads per minute
	PageLoadThroughput float64 `json:"pageLoadThroughput,omitempty"`
	// The average page view time in seconds.
	PageLoadTimeAverage float64 `json:"pageLoadTimeAverage,omitempty"`
	// The median page view time in seconds.
	PageLoadTimeMedian float64 `json:"pageLoadTimeMedian,omitempty"`
	// The average SPA response time in seconds.
	SpaResponseTimeAverage nrtime.Seconds `json:"spaResponseTimeAverage,omitempty"`
	// The median SPA response time in seconds.
	SpaResponseTimeMedian nrtime.Seconds `json:"spaResponseTimeMedian,omitempty"`
}

// ChangeTrackingDeployment - A deployment.
type ChangeTrackingDeployment struct {
	// A URL to the changelog or, if not linkable, a list of changes.
	Changelog string `json:"changelog,omitempty"`
	// The commit identifier, for example, a Git commit SHA.
	Commit string `json:"commit,omitempty"`
	// A link to the system that generated the deployment.
	DeepLink string `json:"deepLink,omitempty"`
	// A unique deployment identifier.
	DeploymentId string `json:"deploymentId,omitempty"`
	// The type of deployment, for example, ‘Blue green’ or ‘Rolling’.
	DeploymentType ChangeTrackingDeploymentType `json:"deploymentType,omitempty"`
	// A description of the deployment.
	Description string `json:"description,omitempty"`
	// The NR entity that was deployed.
	EntityGUID common.EntityGUID `json:"entityGuid"`
	// An identifier used to correlate account-wide changes across entities. These changes are shown together in the `Changes in group` section of the change event details UI.
	GroupId string `json:"groupId,omitempty"`
	// The start time of the deployment as the number of milliseconds since the Unix epoch.
	Timestamp *nrtime.EpochMilliseconds `json:"timestamp"`
	// The username of the deployer or bot.
	User string `json:"user,omitempty"`
	// The version of the deployed software, for example, something like v1.1.
	Version string `json:"version"`
}

// ChangeTrackingDeploymentSearchResult - The result of the deployment search query.
type ChangeTrackingDeploymentSearchResult struct {
	// The list of deployment events in the given time window.
	Results []ChangeTrackingDeployment `json:"results,omitempty"`
}

// ChangeTrackingSearchFilter - The object contains the filters to be applied to the search.
type ChangeTrackingSearchFilter struct {
	// Maximum number of deployments to be returned. Default value is 100 deployments.
	// There is a maximum limit value of 2,000. If you set the limit greater than 2,000, the service will only return the latest 2,000 deployments."
	Limit int `json:"limit,omitempty"`
	// Deployment search query string. The query string can search for a match on users and deployment IDs, and any other deployment event attributes.
	//
	// Operators available: Any valid NRQL operators, other than subqueries. For example, =, OR, AND, IN, LIKE, RLIKE, NO.
	//
	// For the full list of operators, see the where clause documentation [here](https://docs.newrelic.com/docs/query-your-data/nrql-new-relic-query-language/get-started/nrql-syntax-clauses-functions/#sel-where)
	//
	// Note: Do not include keywords like SELECT, WHERE, SINCE, FACET, and TIMESERIES.
	//
	// Examples:
	//
	//     • "user = 'Test User'"
	//     • "user LIKE '%Test User%' AND deploymentType IN ('BLUE_GREEN', 'CANARY')"
	//     • "user RLIKE r'Test.*|test.*'"
	//     • "version = '1.0' OR deploymentType IN ('BASIC')"
	//     • "deploymentId IN ('1234', '4567')"
	//     • "((user = 'Test User' AND version = '1.0') OR deploymentType in ('BLUE_GREEN', 'CANARY'))"
	Query string `json:"query,omitempty"`
	// Search time window. If not specified, defaults to the past hour.
	TimeWindow ChangeTrackingTimeWindowInputWithDefaults `json:"timeWindow,omitempty"`
}

// ChangeTrackingTimeWindowInputWithDefaults - A time window input with default values.
type ChangeTrackingTimeWindowInputWithDefaults struct {
	// The end time of the time window. If not specified, it defaults to the current time.
	EndTime *nrtime.EpochMilliseconds `json:"endTime,omitempty"`
	// The start time of the time window. If not specified, it defaults to 60 minutes before the endTime.
	StartTime *nrtime.EpochMilliseconds `json:"startTime,omitempty"`
}

// CollectionEntity - A group of entities defined by entity search queries and specific GUIDs
type CollectionEntity struct {
	Collection EntityCollection  `json:"collection,omitempty"`
	GUID       common.EntityGUID `json:"guid,omitempty"`
}

// GetCollection returns a pointer to the value of Collection from CollectionEntity
func (x CollectionEntity) GetCollection() EntityCollection {
	return x.Collection
}

// GetGUID returns a pointer to the value of GUID from CollectionEntity
func (x CollectionEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

func (x *CollectionEntity) ImplementsCollectionEntity() {}

// DashboardAreaWidgetConfiguration - Configuration for visualization type 'viz.area'
type DashboardAreaWidgetConfiguration struct {
	// NRQL queries.
	NRQLQueries []DashboardWidgetNRQLQuery `json:"nrqlQueries,omitempty"`
}

// DashboardBarWidgetConfiguration - Configuration for visualization type 'viz.bar'
type DashboardBarWidgetConfiguration struct {
	// NRQL queries.
	NRQLQueries []DashboardWidgetNRQLQuery `json:"nrqlQueries,omitempty"`
}

// DashboardBillboardWidgetConfiguration - Configuration for visualization type 'viz.billboard'
type DashboardBillboardWidgetConfiguration struct {
	// NRQL queries.
	NRQLQueries []DashboardWidgetNRQLQuery `json:"nrqlQueries,omitempty"`
	// Array of thresholds to categorize the results of the query in different groups.
	Thresholds []DashboardBillboardWidgetThreshold `json:"thresholds,omitempty"`
}

// DashboardBillboardWidgetThreshold - Billboard widget threshold.
type DashboardBillboardWidgetThreshold struct {
	// Alert severity.
	AlertSeverity DashboardAlertSeverity `json:"alertSeverity,omitempty"`
	// Alert value.
	Value float64 `json:"value,omitempty"`
}

// DashboardEntity - A Dashboard entity.
type DashboardEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// The date and time the dashboard was created
	CreatedAt nrtime.DateTime `json:"createdAt,omitempty"`
	// The parent entity `guid` of the dashboard.
	DashboardParentGUID common.EntityGUID `json:"dashboardParentGuid,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// Dashboard description.
	Description string `json:"description,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The owner information of the dashboard.
	Owner DashboardEntityOwnerInfo `json:"owner,omitempty"`
	// A nested block of all pages belonging to the dashboard.
	Pages []DashboardPage `json:"pages,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The permissions of the dashboard.
	Permissions DashboardEntityPermissions `json:"permissions,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// The date and time the dashboard was updated
	UpdatedAt nrtime.DateTime `json:"updatedAt,omitempty"`
	// Dashboard-local variable definitions.
	Variables []DashboardVariable `json:"variables,omitempty"`
}

// GetAccount returns a pointer to the value of Account from DashboardEntity
func (x DashboardEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from DashboardEntity
func (x DashboardEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from DashboardEntity
func (x DashboardEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from DashboardEntity
func (x DashboardEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetCreatedAt returns a pointer to the value of CreatedAt from DashboardEntity
func (x DashboardEntity) GetCreatedAt() nrtime.DateTime {
	return x.CreatedAt
}

// GetDashboardParentGUID returns a pointer to the value of DashboardParentGUID from DashboardEntity
func (x DashboardEntity) GetDashboardParentGUID() common.EntityGUID {
	return x.DashboardParentGUID
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from DashboardEntity
func (x DashboardEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDescription returns a pointer to the value of Description from DashboardEntity
func (x DashboardEntity) GetDescription() string {
	return x.Description
}

// GetDomain returns a pointer to the value of Domain from DashboardEntity
func (x DashboardEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from DashboardEntity
func (x DashboardEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from DashboardEntity
func (x DashboardEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from DashboardEntity
func (x DashboardEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from DashboardEntity
func (x DashboardEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from DashboardEntity
func (x DashboardEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from DashboardEntity
func (x DashboardEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from DashboardEntity
func (x DashboardEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from DashboardEntity
func (x DashboardEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from DashboardEntity
func (x DashboardEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from DashboardEntity
func (x DashboardEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from DashboardEntity
func (x DashboardEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetOwner returns a pointer to the value of Owner from DashboardEntity
func (x DashboardEntity) GetOwner() DashboardEntityOwnerInfo {
	return x.Owner
}

// GetPages returns a pointer to the value of Pages from DashboardEntity
func (x DashboardEntity) GetPages() []DashboardPage {
	return x.Pages
}

// GetPermalink returns a pointer to the value of Permalink from DashboardEntity
func (x DashboardEntity) GetPermalink() string {
	return x.Permalink
}

// GetPermissions returns a pointer to the value of Permissions from DashboardEntity
func (x DashboardEntity) GetPermissions() DashboardEntityPermissions {
	return x.Permissions
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from DashboardEntity
func (x DashboardEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from DashboardEntity
func (x DashboardEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from DashboardEntity
func (x DashboardEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from DashboardEntity
func (x DashboardEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from DashboardEntity
func (x DashboardEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from DashboardEntity
func (x DashboardEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from DashboardEntity
func (x DashboardEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from DashboardEntity
func (x DashboardEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from DashboardEntity
func (x DashboardEntity) GetType() string {
	return x.Type
}

// GetUpdatedAt returns a pointer to the value of UpdatedAt from DashboardEntity
func (x DashboardEntity) GetUpdatedAt() nrtime.DateTime {
	return x.UpdatedAt
}

// GetVariables returns a pointer to the value of Variables from DashboardEntity
func (x DashboardEntity) GetVariables() []DashboardVariable {
	return x.Variables
}

func (x *DashboardEntity) ImplementsAlertableEntity() {}

func (x *DashboardEntity) ImplementsEntity() {}

// DashboardEntityOutline - A Dashboard entity outline.
type DashboardEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The date and time the dashboard was created
	CreatedAt nrtime.DateTime `json:"createdAt,omitempty"`
	// The parent entity `guid` of the dashboard.
	DashboardParentGUID common.EntityGUID `json:"dashboardParentGuid,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The owner information of the dashboard.
	Owner DashboardEntityOwnerInfo `json:"owner,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The permissions of the dashboard.
	Permissions DashboardEntityPermissions `json:"permissions,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// The date and time the dashboard was updated
	UpdatedAt nrtime.DateTime `json:"updatedAt,omitempty"`
}

// GetAccount returns a pointer to the value of Account from DashboardEntityOutline
func (x DashboardEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from DashboardEntityOutline
func (x DashboardEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from DashboardEntityOutline
func (x DashboardEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetCreatedAt returns a pointer to the value of CreatedAt from DashboardEntityOutline
func (x DashboardEntityOutline) GetCreatedAt() nrtime.DateTime {
	return x.CreatedAt
}

// GetDashboardParentGUID returns a pointer to the value of DashboardParentGUID from DashboardEntityOutline
func (x DashboardEntityOutline) GetDashboardParentGUID() common.EntityGUID {
	return x.DashboardParentGUID
}

// GetDomain returns a pointer to the value of Domain from DashboardEntityOutline
func (x DashboardEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from DashboardEntityOutline
func (x DashboardEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from DashboardEntityOutline
func (x DashboardEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from DashboardEntityOutline
func (x DashboardEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from DashboardEntityOutline
func (x DashboardEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from DashboardEntityOutline
func (x DashboardEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from DashboardEntityOutline
func (x DashboardEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from DashboardEntityOutline
func (x DashboardEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from DashboardEntityOutline
func (x DashboardEntityOutline) GetName() string {
	return x.Name
}

// GetOwner returns a pointer to the value of Owner from DashboardEntityOutline
func (x DashboardEntityOutline) GetOwner() DashboardEntityOwnerInfo {
	return x.Owner
}

// GetPermalink returns a pointer to the value of Permalink from DashboardEntityOutline
func (x DashboardEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetPermissions returns a pointer to the value of Permissions from DashboardEntityOutline
func (x DashboardEntityOutline) GetPermissions() DashboardEntityPermissions {
	return x.Permissions
}

// GetReporting returns a pointer to the value of Reporting from DashboardEntityOutline
func (x DashboardEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from DashboardEntityOutline
func (x DashboardEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from DashboardEntityOutline
func (x DashboardEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from DashboardEntityOutline
func (x DashboardEntityOutline) GetType() string {
	return x.Type
}

// GetUpdatedAt returns a pointer to the value of UpdatedAt from DashboardEntityOutline
func (x DashboardEntityOutline) GetUpdatedAt() nrtime.DateTime {
	return x.UpdatedAt
}

func (x *DashboardEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *DashboardEntityOutline) ImplementsEntityOutline() {}

// DashboardEntityOwnerInfo - Dashboard owner
type DashboardEntityOwnerInfo struct {
	// The email of the dashboard owner
	Email string `json:"email,omitempty"`
	// The user ID of the dashboard owner
	UserID int `json:"userId,omitempty"`
}

// DashboardLineWidgetConfiguration - Configuration for visualization type 'viz.line'
type DashboardLineWidgetConfiguration struct {
	// NRQL queries.
	NRQLQueries []DashboardWidgetNRQLQuery `json:"nrqlQueries,omitempty"`
}

// DashboardMarkdownWidgetConfiguration - Configuration for visualization type 'viz.markdown'
type DashboardMarkdownWidgetConfiguration struct {
	// Markdown content of the widget.
	Text string `json:"text"`
}

// DashboardOwnerInfo - Information on the owner of a dashboard or page.
type DashboardOwnerInfo struct {
	// New Relic user email.
	Email string `json:"email,omitempty"`
	// New Relic user ID.
	UserID int `json:"userId,omitempty"`
}

// DashboardPage - Page in a dashboard entity.
type DashboardPage struct {
	// Page creation timestamp.
	CreatedAt nrtime.DateTime `json:"createdAt,omitempty"`
	// Brief text describing the page.
	Description string `json:"description,omitempty"`
	// Unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The name of the page.
	Name string `json:"name,omitempty"`
	// Information of the user that owns the page.
	Owner DashboardOwnerInfo `json:"owner,omitempty"`
	// Page update timestamp.
	UpdatedAt nrtime.DateTime `json:"updatedAt,omitempty"`
	// A nested block of all widgets belonging to the page.
	Widgets []DashboardWidget `json:"widgets,omitempty"`
}

// DashboardPieWidgetConfiguration - Configuration for visualization type 'viz.pie'
type DashboardPieWidgetConfiguration struct {
	// NRQL queries.
	NRQLQueries []DashboardWidgetNRQLQuery `json:"nrqlQueries,omitempty"`
}

// DashboardTableWidgetConfiguration - Configuration for visualization type 'viz.table'
type DashboardTableWidgetConfiguration struct {
	// NRQL queries.
	NRQLQueries []DashboardWidgetNRQLQuery `json:"nrqlQueries,omitempty"`
}

// DashboardVariableDefaultItem - Represents a possible default value item.
type DashboardVariableDefaultItem struct {
	// The value of this default item.
	Value *DashboardVariableDefaultValue `json:"value,omitempty"`
}

// DashboardVariableDefaultValue - Specifies a default value for variables.
type DashboardVariableDefaultValue struct {
	// Default string value.
	String string `json:"string,omitempty"`
}

// DashboardVariableEnumItem - Represents a possible value for a variable of type ENUM.
type DashboardVariableEnumItem struct {
	// A human-friendly display string for this value.
	Title string `json:"title,omitempty"`
	// A possible variable value.
	Value string `json:"value,omitempty"`
}

// DashboardVariableNRQLQuery - Configuration for variables of type NRQL.
type DashboardVariableNRQLQuery struct {
	// New Relic account ID(s) to issue the query against.
	AccountIDs []int `json:"accountIds,omitempty"`
	// NRQL formatted query.
	Query nrdb.NRQL `json:"query"`
}

// DashboardVariableOptions - Options applied to the variable.
type DashboardVariableOptions struct {
	// With this turned on, query condition defined with the variable will not be included in the query.
	Excluded bool `json:"excluded,omitempty"`
	// Only applies to variables of type NRQL. With this turned on, the time range for the NRQL query will override the time picker on dashboards and other pages. Turn this off to use the time picker as normal.
	IgnoreTimeRange bool `json:"ignoreTimeRange,omitempty"`
}

// DashboardWidget - Widgets in a Dashboard Page.
type DashboardWidget struct {
	// Typed widgets are area, bar, billboard, line, markdown, pie, and table.
	Configuration DashboardWidgetConfiguration `json:"configuration,omitempty"`
	// ID of the widget.
	ID string `json:"id"`
	// The widget's position and size in the dashboard.
	Layout DashboardWidgetLayout `json:"layout,omitempty"`
	// Entities related to the widget. Currently only supports one Dashboard entity guid, but may allow other cases in the future.
	LinkedEntities []EntityOutlineInterface `json:"linkedEntities,omitempty"`
	// Untyped widgets are all other widgets, such as bullet, histogram, inventory, etc.
	RawConfiguration DashboardWidgetRawConfiguration `json:"rawConfiguration"`
	// A title for the widget.
	Title string `json:"title,omitempty"`
	// Specifies how this widget will be visualized.
	Visualization DashboardWidgetVisualization `json:"visualization"`
}

// special
func (x *DashboardWidget) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "configuration":
			err = json.Unmarshal(*v, &x.Configuration)
			if err != nil {
				return err
			}
		case "id":
			err = json.Unmarshal(*v, &x.ID)
			if err != nil {
				return err
			}
		case "layout":
			err = json.Unmarshal(*v, &x.Layout)
			if err != nil {
				return err
			}
		case "linkedEntities":
			if v == nil {
				continue
			}
			var rawMessageLinkedEntities []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageLinkedEntities)
			if err != nil {
				return err
			}

			for _, m := range rawMessageLinkedEntities {
				xxx, err := UnmarshalEntityOutlineInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.LinkedEntities = append(x.LinkedEntities, *xxx)
				}
			}
		case "rawConfiguration":
			err = json.Unmarshal(*v, &x.RawConfiguration)
			if err != nil {
				return err
			}
		case "title":
			err = json.Unmarshal(*v, &x.Title)
			if err != nil {
				return err
			}
		case "visualization":
			err = json.Unmarshal(*v, &x.Visualization)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// DashboardWidgetConfiguration - Typed configuration for known visualizations. Only one (at most) will be populated for a given widget.
type DashboardWidgetConfiguration struct {
	// Configuration for visualization type 'viz.area'
	Area DashboardAreaWidgetConfiguration `json:"area,omitempty"`
	// Configuration for visualization type 'viz.bar'
	Bar DashboardBarWidgetConfiguration `json:"bar,omitempty"`
	// Configuration for visualization type 'viz.billboard'
	Billboard DashboardBillboardWidgetConfiguration `json:"billboard,omitempty"`
	// Configuration for visualization type 'viz.line'
	Line DashboardLineWidgetConfiguration `json:"line,omitempty"`
	// Configuration for visualization type 'viz.markdown'
	Markdown DashboardMarkdownWidgetConfiguration `json:"markdown,omitempty"`
	// Configuration for visualization type 'viz.pie'
	Pie DashboardPieWidgetConfiguration `json:"pie,omitempty"`
	// Configuration for visualization type 'viz.table'
	Table DashboardTableWidgetConfiguration `json:"table,omitempty"`
}

// DashboardWidgetLayout - Widget layout.
type DashboardWidgetLayout struct {
	// Column position of widget from top left, starting at 1.
	Column int `json:"column,omitempty"`
	// Height of the widget. Valid values are 1 to 12 inclusive. Defaults to 3.
	Height int `json:"height,omitempty"`
	// Row position of widget from top left, starting at 1.
	Row int `json:"row,omitempty"`
	// Width of the widget. Valid values are 1 to 12 inclusive. Defaults to 4.
	Width int `json:"width,omitempty"`
}

// DashboardWidgetNRQLQuery - Single NRQL query for a widget.
type DashboardWidgetNRQLQuery struct {
	// New Relic account ID to issue the query against.
	AccountID int `json:"accountId"`
	// NRQL formatted query.
	Query nrdb.NRQL `json:"query"`
}

// DashboardWidgetVisualization - Visualization configuration.
type DashboardWidgetVisualization struct {
	// This field can either have a known type like `viz.area` or `<nerdpack-id>.<visualization-id>` in the case of custom visualizations.
	ID string `json:"id,omitempty"`
}

// DistributedTracingEntityTracingSummary - Details tracing summary data for the provided `EntityGuid` that occurred during the provided `startTime` and `endTime`
type DistributedTracingEntityTracingSummary struct {
	// The number of traces where this entity produced an error
	ErrorTraceCount int `json:"errorTraceCount,omitempty"`
	// The percentage of error traces produced by this entity compared to all error traces in the system
	PercentOfAllErrorTraces float64 `json:"percentOfAllErrorTraces,omitempty"`
}

// DomainTypeInput - Input for getting details about an entity type
type DomainTypeInput struct {
	// The domain of the entity.
	//
	// The domain must be a value matching /[A-Z][A-Z0-9_]{2,14}/.
	Domain string `json:"domain"`
	// The type of the entity.
	//
	// The type must be a value matching /[A-Z][A-Z0-9_]{2,49}/.
	//
	// Some examples are APPLICATION, HOST or CONTAINER.
	Type string `json:"type"`
}

// Entity - The `Entity` interface allows fetching detailed entity information for a single entity.
//
// To understand more about entities and entity types, look at [our docs](https://docs.newrelic.com/docs/what-are-new-relic-entities).
type Entity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

func (x *Entity) ImplementsAlertableEntity() {}

func (x *Entity) ImplementsEntity() {}

// EntityAlertViolation - The alert violation for an entity
type EntityAlertViolation struct {
	// A link to the agent in the time window in which the violation occurred.
	AgentURL string `json:"agentUrl,omitempty"`
	// The severity of the violation.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Timestamp of when the violation was closed.
	ClosedAt *nrtime.EpochMilliseconds `json:"closedAt,omitempty"`
	// The description of the violation.
	Label string `json:"label,omitempty"`
	// The priority of the violation.
	Level string `json:"level,omitempty"`
	// Timestamp of when the violation was opened.
	OpenedAt *nrtime.EpochMilliseconds `json:"openedAt,omitempty"`
	// The id of the violation.
	ViolationId EntityAlertViolationInt `json:"violationId,omitempty"`
	// A link to the violation if it is connected to an incident.
	ViolationURL string `json:"violationUrl,omitempty"`
}

// EntityCollection - A collection of user defined Entities and Entity Search queries.
type EntityCollection struct {
	// The account the collection is part of
	Account accounts.AccountReference `json:"account,omitempty"`
	// The user who created the collection
	CreatedBy users.UserReference `json:"createdBy,omitempty"`
	// The definition of the collection.
	Definition EntityCollectionDefinition `json:"definition,omitempty"`
	// The GUID of the Entity
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The result of searching for the members of the collection.
	Members EntitySearch `json:"members,omitempty"`
	// The name of the collection.
	Name string `json:"name,omitempty"`
	// The type of Collection
	Type EntityCollectionType `json:"type,omitempty"`
}

// EntityCollectionDefinition - The definition of a collection.
type EntityCollectionDefinition struct {
	// A list of entity GUIDs. These entities will belong to the collection as long as their accounts are included in the scope accounts of the collection.
	EntityGUIDs []common.EntityGUID `json:"entityGuids,omitempty"`
	// The Entity Search query that returns the full collection of entities.
	EntitySearchQuery string `json:"entitySearchQuery,omitempty"`
	// The Accounts that will be used to scope the collection.
	ScopeAccounts EntityCollectionScopeAccounts `json:"scopeAccounts,omitempty"`
	// A list of entity search queries. The resulting entities will be limited to the scope accounts of the collection.
	SearchQueries []string `json:"searchQueries,omitempty"`
}

// EntityCollectionScopeAccounts - The Accounts used to scope a collection.
type EntityCollectionScopeAccounts struct {
	// The Account IDs that make up the account scoping.
	AccountIDs []int `json:"accountIds,omitempty"`
}

// EntityGoldenContext - An object that represent the context.
type EntityGoldenContext struct {
	// Account context.
	Account int `json:"account,omitempty"`
	// Collection guid context.
	GUID common.EntityGUID `json:"guid,omitempty"`
}

// EntityGoldenContextInput - Input type used to define the context for the golden metrics.
type EntityGoldenContextInput struct {
	// Account context.
	Account int `json:"account,omitempty"`
	// Collection guid context.
	GUID common.EntityGUID `json:"guid,omitempty"`
}

// EntityGoldenContextScopedGoldenMetrics - An object that represents the golden metrics scoped by context
type EntityGoldenContextScopedGoldenMetrics struct {
	// Context for the golden metric
	Context EntityGoldenContext `json:"context"`
	// Metrics for the domain and type
	Metrics []EntityGoldenMetric `json:"metrics"`
}

// EntityGoldenContextScopedGoldenTags - An object that represents the golden tags scoped by context
type EntityGoldenContextScopedGoldenTags struct {
	// Context for the golden tags
	Context EntityGoldenContext `json:"context"`
	// Tags for the domain and type
	Tags []EntityGoldenTag `json:"tags"`
}

// EntityGoldenMetric - An object that represents a golden metric.
type EntityGoldenMetric struct {
	// The definition of the golden metric.
	Definition EntityGoldenMetricDefinition `json:"definition"`
	// The synthesised metric name. i.e: newrelic.goldenmetrics.apm.application.throughput
	MetricName string `json:"metricName"`
	// The name of the golden metric.
	Name string `json:"name"`
	// The definitions of the golden metric as they are defined in the public repo https://github.com/newrelic/entity-definitions.
	OriginalDefinitions []EntityGoldenOriginalDefinitionWithSelector `json:"originalDefinitions"`
	// Original queries as they are defined in the public repo https://github.com/newrelic/entity-definitions.
	OriginalQueries []EntityGoldenOriginalQueryWithSelector `json:"originalQueries"`
	// The golden metric NRQL query.
	Query string `json:"query"`
	// The title of the golden metric.
	Title string `json:"title"`
	// The unit used to represent the golden metric.
	Unit EntityGoldenMetricUnit `json:"unit"`
}

// EntityGoldenMetricDefinition - The definition of the metric.
type EntityGoldenMetricDefinition struct {
	// The field used to filter the entity in the metric. This will be added to the WHERE by default.
	EventId string `json:"eventId"`
	// Indicates if the eventId field references a GUID, a domainId or an entity name.
	EventObjectId EntityGoldenEventObjectId `json:"eventObjectId"`
	// The field to FACET by.
	Facet string `json:"facet"`
	// The FROM clause of the query.
	From string `json:"from"`
	// The SELECT clause of the query.
	Select string `json:"select"`
	// If a complementary WHERE clause is required to identify the entity type this field will contain it.
	Where string `json:"where,omitempty"`
}

// EntityGoldenNRQLTimeWindowInput - Time range to apply to the golden metric NRQL query
type EntityGoldenNRQLTimeWindowInput struct {
	// Start time.
	Since nrdb.NRQL `json:"since,omitempty"`
	// End time.
	Until nrdb.NRQL `json:"until,omitempty"`
}

// EntityGoldenOriginalDefinitionWithSelector - Represents a metric definition for a give metric selector value.
type EntityGoldenOriginalDefinitionWithSelector struct {
	// The definition of the golden metric.
	Definition EntityGoldenMetricDefinition `json:"definition"`
	// The value of the selector. Currently, this is the value of the instrumentation provider.
	SelectorValue string `json:"selectorValue"`
}

// EntityGoldenOriginalQueryWithSelector - Object that represents a nrql metric with its metric selector
type EntityGoldenOriginalQueryWithSelector struct {
	// The golden metric NRQL query.
	Query string `json:"query"`
	// The value of the selector. Currently, this is the value of the instrumentation provider.
	SelectorValue string `json:"selectorValue"`
}

// EntityGoldenTag - An object that represents a golden tag.
type EntityGoldenTag struct {
	// The golden tag key.
	Key string `json:"key"`
}

// EntityManagementActor - Represents an actor.
type EntityManagementActor struct {
	// Id of the actor.
	ID string `json:"id"`
}

func (x *EntityManagementActor) ImplementsEntityManagementActor() {}

// EntityManagementAgentConfigurationEntity - A configuration that can contain multiple immutable versions and can be deployed to a fleet
type EntityManagementAgentConfigurationEntity struct {
	// The agentType
	AgentType string `json:"agentType"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// A unique user provided name for the configuration
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
	// The total number of versions that have been created for this configuration
	VersionCount int `json:"versionCount,omitempty"`
}

func (x *EntityManagementAgentConfigurationEntity) ImplementsEntityManagementEntity() {}

// EntityManagementAgentConfigurationVersionEntity - A version of an agent configuration
type EntityManagementAgentConfigurationVersionEntity struct {
	// EntityGuid of the parent AgentConfiguration object
	AgentConfiguration string `json:"agentConfiguration"`
	// Metadata about the configuration blob
	Blob EntityManagementBlob `json:"blob,omitempty"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
	// Monotonically increasing version number
	Version int `json:"version"`
}

func (x *EntityManagementAgentConfigurationVersionEntity) ImplementsEntityManagementEntity() {}

// EntityManagementAgentDeployment - A set of configurations that are currently deployed
type EntityManagementAgentDeployment struct {
	// Deployment finish
	CompletedAt *nrtime.EpochMilliseconds `json:"completedAt,omitempty"`
	// Deployment started
	DeployedAt *nrtime.EpochMilliseconds `json:"deployedAt"`
	// Deployment status
	Status string `json:"status,omitempty"`
}

// EntityManagementAgentEffectiveConfigurationEntity - The configuration that is actively being used to configure an agent
type EntityManagementAgentEffectiveConfigurationEntity struct {
	// Metadata about the effective configuration blob
	Blob EntityManagementBlob `json:"blob"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementAgentEffectiveConfigurationEntity) ImplementsEntityManagementEntity() {}

// EntityManagementAgentEntity - A software component that collects or processes telemetry
type EntityManagementAgentEntity struct {
	// The agentType
	AgentType string `json:"agentType"`
	// Properties specific to fleet control
	FleetControlProperties EntityManagementFleetControlProperties `json:"fleetControlProperties"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementAgentEntity) ImplementsEntityManagementEntity() {}

// EntityManagementAgentTypeDefinitionEntity - An Agent Type Definition
type EntityManagementAgentTypeDefinitionEntity struct {
	// The agent type
	AgentType string `json:"agentType"`
	// The display name of the agent
	DisplayName string `json:"displayName"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementAgentTypeDefinitionEntity) ImplementsEntityManagementEntity() {}

// EntityManagementBlob - Metadata used by the blob service to read blob contents
type EntityManagementBlob struct {
	// The checksum of the blob content
	Checksum string `json:"checksum,omitempty"`
	// The checksum algorithm used to calculate the checksum of the blob content
	ChecksumAlgorithm string `json:"checksumAlgorithm,omitempty"`
	// The content type of the blob
	ContentType string `json:"contentType"`
	// The URL to download the blob content
	URL string `json:"url"`
}

// EntityManagementCollectionEntity - An entity type to represent collections of entities
type EntityManagementCollectionEntity struct {
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementCollectionEntity) ImplementsEntityManagementEntity() {}

// EntityManagementDiscoverySettings - Discovery related settings.
type EntityManagementDiscoverySettings struct {
	// If discovery is enabled for that organization or not.
	Enabled bool `json:"enabled"`
	// Tag keys used for discovery for the organization.
	TagKeys []string `json:"tagKeys"`
}

// EntityManagementEntity - The Entity interface.
type EntityManagementEntity struct {
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementEntity) ImplementsEntityManagementEntity() {}

// EntityManagementEntitySearchResult - The result of an entities query.
type EntityManagementEntitySearchResult struct {
	// The current page of results.
	Entities []EntityManagementEntityInterface `json:"entities"`
	// Cursor pointing to the next page of results.
	NextCursor string `json:"nextCursor,omitempty"`
}

// special
func (x *EntityManagementEntitySearchResult) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "entities":
			if v == nil {
				continue
			}
			var rawMessageEntities []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageEntities)
			if err != nil {
				return err
			}

			for _, m := range rawMessageEntities {
				xxx, err := UnmarshalEntityManagementEntityInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.Entities = append(x.Entities, *xxx)
				}
			}
		case "nextCursor":
			err = json.Unmarshal(*v, &x.NextCursor)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// EntityManagementFleetControlProperties - Properties specific to fleet control
type EntityManagementFleetControlProperties struct {
	// Object holds state of current deployment
	CurrentDeployment EntityManagementAgentDeployment `json:"currentDeployment,omitempty"`
	// Environment the agent is running in
	Environment string `json:"environment,omitempty"`
	// True if the Agent is up and healthy
	Healthy bool `json:"healthy,omitempty"`
	// Error message returned by the agent when it is unhealthy
	LastError string `json:"lastError,omitempty"`
	// Error message returned when the last remote configuration deploy is not successful
	LastRemoteConfigError string `json:"lastRemoteConfigError,omitempty"`
	// Status of the last remote configuration deploy
	LastRemoteConfigStatus string `json:"lastRemoteConfigStatus,omitempty"`
	// Timestamp indicating when the agent was started
	StartTime *nrtime.EpochMilliseconds `json:"startTime,omitempty"`
	// The UID of this agent
	Uid string `json:"uid,omitempty"`
}

// EntityManagementFleetDeployment - A set of configurations that are currently deployed
type EntityManagementFleetDeployment struct {
	// The number of configurations changed during this deployment
	ConfigsChanged int `json:"configsChanged"`
	// A list of configurations included in this deployment
	ConfigurationVersions []string `json:"configurationVersions"`
	// Deployment started
	DeployedAt *nrtime.EpochMilliseconds `json:"deployedAt"`
	// Deployment description
	Description string `json:"description,omitempty"`
	// The number of entities changed during this deployment
	EntitiesChanged int `json:"entitiesChanged"`
	// Deployment name
	Name string `json:"name"`
	// Deployment status
	Status string `json:"status,omitempty"`
}

// EntityManagementFleetEntity - A fleet of entities that are managed by NRAgentControl
type EntityManagementFleetEntity struct {
	// Object holds state of current deployment
	CurrentDeployment EntityManagementFleetDeployment `json:"currentDeployment,omitempty"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// CollectionEntity that associates with managed entities for Fleet
	ManagedEntities EntityManagementCollectionEntity `json:"managedEntities,omitempty"`
	// The type of entity the fleet will manage. e.g. HOST
	ManagedEntityType EntityManagementManagedEntityType `json:"managedEntityType"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// A unique user provided name for the fleet
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementFleetEntity) ImplementsEntityManagementEntity() {}

// EntityManagementGenericEntity - A generic entity.
type EntityManagementGenericEntity struct {
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementGenericEntity) ImplementsEntityManagementEntity() {}

// EntityManagementMetadata - Metadata about an entity.
type EntityManagementMetadata struct {
	// The entity's creation time.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// Actor that created this entity.
	CreatedBy EntityManagementActorInterface `json:"createdBy,omitempty"`
	// The entity's last update time.
	UpdatedAt *nrtime.EpochMilliseconds `json:"updatedAt,omitempty"`
}

// special
func (x *EntityManagementMetadata) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "createdAt":
			err = json.Unmarshal(*v, &x.CreatedAt)
			if err != nil {
				return err
			}
		case "createdBy":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalEntityManagementActorInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.CreatedBy = *xxx
			}
		case "updatedAt":
			err = json.Unmarshal(*v, &x.UpdatedAt)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// EntityManagementNRQLRuleEngine - NRQL engine configuration.
type EntityManagementNRQLRuleEngine struct {
	// The accounts to be queried.
	Accounts []int `json:"accounts"`
	// The query to be executed.
	Query string `json:"query"`
}

// EntityManagementScopedReference - An entity with scope.
type EntityManagementScopedReference struct {
	// The unique reference identifier of the an object within the given scope
	ID string `json:"id"`
	// The scope of the entity
	Type EntityManagementEntityScope `json:"type"`
}

// EntityManagementScorecardEntity - An entity with collection of scorecard rules.
type EntityManagementScorecardEntity struct {
	// The scorecard description.
	Description string `json:"description,omitempty"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// A unique user provided name for the scorecard.
	Name string `json:"name"`
	// List of rules in the scorecard.
	Rules EntityManagementCollectionEntity `json:"rules,omitempty"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementScorecardEntity) ImplementsEntityManagementEntity() {}

// EntityManagementScorecardRuleEntity - An entity representing rule in scorecards.
type EntityManagementScorecardRuleEntity struct {
	// The rule description.
	Description string `json:"description,omitempty"`
	// Is rule enabled.
	Enabled bool `json:"enabled"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The NRQL rule engine.
	NRQLEngine EntityManagementNRQLRuleEngine `json:"nrqlEngine"`
	// A unique user provided name for the rule
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementScorecardRuleEntity) ImplementsEntityManagementEntity() {}

// EntityManagementSystemActor - A system actor.
type EntityManagementSystemActor struct {
	// Id of the actor.
	ID string `json:"id"`
}

func (x *EntityManagementSystemActor) ImplementsEntityManagementActor() {}

// EntityManagementTag - An entity tag.
type EntityManagementTag struct {
	// The key or name of the tag.
	Key string `json:"key"`
	// The list of values of the tag.
	Values []string `json:"values"`
}

// EntityManagementTeamEntities - A list of entities owned by a Team.
type EntityManagementTeamEntities struct {
	// List of the static entities owned by the team.
	Static []EntityManagementEntityInterface `json:"static"`
}

// special
func (x *EntityManagementTeamEntities) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "static":
			if v == nil {
				continue
			}
			var rawMessageStatic []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageStatic)
			if err != nil {
				return err
			}

			for _, m := range rawMessageStatic {
				xxx, err := UnmarshalEntityManagementEntityInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.Static = append(x.Static, *xxx)
				}
			}
		}
	}

	return nil
}

// EntityManagementTeamEntity - An entity representing a New Relic Team.
type EntityManagementTeamEntity struct {
	// List of aliases associated to the team.
	Aliases []string `json:"aliases"`
	// Further information about team.
	Description string `json:"description,omitempty"`
	// List of the entities owned by the team.
	Entities EntityManagementTeamEntities `json:"entities,omitempty"`
	// External Integration with another system.
	ExternalIntegration EntityManagementTeamExternalIntegration `json:"externalIntegration,omitempty"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// List of members belonging to the team.
	Members []EntityManagementTeamMember `json:"members"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// List of resources attached to the team.
	Resources []EntityManagementTeamResource `json:"resources"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementTeamEntity) ImplementsEntityManagementEntity() {}

// EntityManagementTeamExternalIntegration - Integration with an external system.
type EntityManagementTeamExternalIntegration struct {
	// The id in the external system.
	ExternalId string `json:"externalId"`
	// The type of the Integration.
	Type EntityManagementTeamExternalIntegrationType `json:"type,omitempty"`
}

// EntityManagementTeamMember - Any user belonging to a Team.
type EntityManagementTeamMember struct {
	// List of roles of the user.
	Roles []string `json:"roles"`
	// The user who performed the action..
	User EntityManagementUserEntity `json:"user"`
}

// EntityManagementTeamResource - Any extra information attached to a Team.
type EntityManagementTeamResource struct {
	// Holds the content of the resource.
	Content string `json:"content"`
	// Main text for the resource, use the content if null.
	Title string `json:"title,omitempty"`
	// Type of resource, the UI might be enriched based on the value.
	Type string `json:"type"`
}

// EntityManagementTeamsOrganizationSettingsEntity - Teams global settings per organization.
type EntityManagementTeamsOrganizationSettingsEntity struct {
	// Discovery settings.
	Discovery EntityManagementDiscoverySettings `json:"discovery,omitempty"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
}

func (x *EntityManagementTeamsOrganizationSettingsEntity) ImplementsEntityManagementEntity() {}

// EntityManagementUserActor - A user actor.
type EntityManagementUserActor struct {
	// Id of the actor.
	ID string `json:"id"`
}

func (x *EntityManagementUserActor) ImplementsEntityManagementActor() {}

// EntityManagementUserEntity - An entity representing a New Relic User.
type EntityManagementUserEntity struct {
	// The represented user email.
	Email string `json:"email"`
	// The entity's global unique identifier.
	ID string `json:"id"`
	// Metadata about the entity.
	Metadata EntityManagementMetadata `json:"metadata"`
	// The name of this entity.
	Name string `json:"name"`
	// The entity's scope.
	Scope EntityManagementScopedReference `json:"scope"`
	// Collection of tags.
	Tags []EntityManagementTag `json:"tags"`
	// The entity type.
	Type string `json:"type"`
	// User domain identifier.
	UserID int `json:"userId"`
}

func (x *EntityManagementUserEntity) ImplementsEntityManagementEntity() {}

// EntityOutline - The `EntityOutline` interface object allows fetching basic entity data for many entities at a time.
//
// To understand more about entities and entity types, look at [our docs](https://docs.newrelic.com/docs/what-are-new-relic-entities).
type EntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

func (x *EntityOutline) ImplementsAlertableEntityOutline() {}

func (x *EntityOutline) ImplementsEntityOutline() {}

// EntityRelationship - An entity relationship
type EntityRelationship struct {
	// The source entity of the relationship.
	Source EntityRelationshipNode `json:"source,omitempty"`
	// The target entity of the relationship.
	Target EntityRelationshipNode `json:"target,omitempty"`
	// The type of the relationship. For details, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Type EntityRelationshipType `json:"type,omitempty"`
}

// EntityRelationshipDetectedEdge - An entity relationship automatically detected by NewRelic.
type EntityRelationshipDetectedEdge struct {
	// The time the relationship was created.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt"`
	// The source entity of the relationship.
	Source EntityRelationshipVertex `json:"source"`
	// The target entity of the relationship.
	Target EntityRelationshipVertex `json:"target"`
	// The type of the relationship.
	Type EntityRelationshipEdgeType `json:"type"`
}

func (x *EntityRelationshipDetectedEdge) ImplementsEntityRelationshipEdge() {}

// EntityRelationshipEdge - An entity relationship.
type EntityRelationshipEdge struct {
	// The time the relationship was created.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt"`
	// The source entity of the relationship.
	Source EntityRelationshipVertex `json:"source"`
	// The target entity of the relationship.
	Target EntityRelationshipVertex `json:"target"`
	// The type of the relationship.
	Type EntityRelationshipEdgeType `json:"type"`
}

func (x *EntityRelationshipEdge) ImplementsEntityRelationshipEdge() {}

// EntityRelationshipEdgeFilter - EntityRelationship edge filter.
type EntityRelationshipEdgeFilter struct {
	// Filter by direction of relationship.
	Direction EntityRelationshipEdgeDirection `json:"direction,omitempty"`
	// Filter on entity domain-types.
	EntityDomainTypes EntityRelationshipEntityDomainTypeFilter `json:"entityDomainTypes,omitempty"`
	// Filter on relationship types.
	RelationshipTypes EntityRelationshipEdgeTypeFilter `json:"relationshipTypes,omitempty"`
}

// EntityRelationshipEdgeTypeFilter - Filter on relationship types.
type EntityRelationshipEdgeTypeFilter struct {
	// Filter the relationships to those that are not of specific relationship types.
	Exclude []EntityRelationshipEdgeType `json:"exclude"`
	// Filter the relationships to those of specific relationship types.
	Include []EntityRelationshipEdgeType `json:"include"`
}

// EntityRelationshipEntityDomainTypeFilter - Filter on entity domain-types.
type EntityRelationshipEntityDomainTypeFilter struct {
	// Filter the relationships to those between entities that are not of specific domain-types.
	Exclude []DomainTypeInput `json:"exclude,omitempty"`
	// Filter the relationships to those between entities of specific domain-types.
	Include []DomainTypeInput `json:"include,omitempty"`
}

// EntityRelationshipFilter - Relationship filter
type EntityRelationshipFilter struct {
	// Filter the relationships to those that contain a specific entity type.
	EntityType []EntityType `json:"entityType,omitempty"`
	// Filter the relationships to those that contain a specific Infrastructure integration entity type
	InfrastructureIntegrationType []EntityInfrastructureIntegrationType `json:"infrastructureIntegrationType,omitempty"`
}

// EntityRelationshipNode - A node in an Entity relationship.
type EntityRelationshipNode struct {
	// The Account ID for the relationship node.
	AccountID int                    `json:"accountId,omitempty"`
	Entity    EntityOutlineInterface `json:"entity,omitempty"`
	// The `EntityType` of the relationship node.
	EntityType EntityType `json:"entityType,omitempty"`
	// The Entity `guid` for the relationship node.
	GUID common.EntityGUID `json:"guid,omitempty"`
}

// special
func (x *EntityRelationshipNode) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "accountId":
			err = json.Unmarshal(*v, &x.AccountID)
			if err != nil {
				return err
			}
		case "entity":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalEntityOutlineInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Entity = *xxx
			}
		case "entityType":
			err = json.Unmarshal(*v, &x.EntityType)
			if err != nil {
				return err
			}
		case "guid":
			err = json.Unmarshal(*v, &x.GUID)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// EntityRelationshipRelatedEntitiesResult - Response containing entity relationships.
type EntityRelationshipRelatedEntitiesResult struct {
	// The next cursor for fetching additional paginated results.
	NextCursor string `json:"nextCursor,omitempty"`
	// The list of  entity relationships.
	Results []EntityRelationshipEdgeInterface `json:"results"`
}

// special
func (x *EntityRelationshipRelatedEntitiesResult) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "nextCursor":
			err = json.Unmarshal(*v, &x.NextCursor)
			if err != nil {
				return err
			}
		case "results":
			if v == nil {
				continue
			}
			var rawMessageResults []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageResults)
			if err != nil {
				return err
			}

			for _, m := range rawMessageResults {
				xxx, err := UnmarshalEntityRelationshipEdgeInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.Results = append(x.Results, *xxx)
				}
			}
		}
	}

	return nil
}

// EntityRelationshipUserDefinedEdge - An entity user-defined relationship.
type EntityRelationshipUserDefinedEdge struct {
	// The time the relationship was created.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt"`
	// The user that created the relationship.
	CreatedByUser users.UserReference `json:"createdByUser,omitempty"`
	// The source entity of the relationship.
	Source EntityRelationshipVertex `json:"source"`
	// The target entity of the relationship.
	Target EntityRelationshipVertex `json:"target"`
	// The type of the relationship.
	Type EntityRelationshipEdgeType `json:"type"`
}

func (x *EntityRelationshipUserDefinedEdge) ImplementsEntityRelationshipEdge() {}

// EntityRelationshipVertex - A vertex in an entity relationship edge.
type EntityRelationshipVertex struct {
	// The account ID of the relationship node.
	AccountID int `json:"accountId"`
	// The entity of the relationship node.
	Entity EntityOutlineInterface `json:"entity,omitempty"`
	// The entity guid of the relationship node.
	GUID common.EntityGUID `json:"guid"`
}

// special
func (x *EntityRelationshipVertex) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "accountId":
			err = json.Unmarshal(*v, &x.AccountID)
			if err != nil {
				return err
			}
		case "entity":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalEntityOutlineInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Entity = *xxx
			}
		case "guid":
			err = json.Unmarshal(*v, &x.GUID)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// EntitySearch - A data structure that contains the detailed response of an entity search.
//
// The direct search result is available through `results`. Information about the
// query itself is available through `query`, `types`, and `count`.
type EntitySearch struct {
	// The number of entities returned by the entity search.
	Count int `json:"count,omitempty"`
	// A count of the Entity Search results faceted by a chosen set of criteria.
	//
	// Note: Unlike a NRQL facet, the facet results do not include entities where the facet value does not exist. Additionally, entities can be tagged with multiple tag values for one tag key. For these reasons, depending on the facet values chosen, the `counts` field will not always equal the `entitySearch.count` field.
	Counts []EntitySearchCounts `json:"counts,omitempty"`
	// The entity search query string that was generated by the `query` argument or the `queryBuilder` argument.
	Query string `json:"query,omitempty"`
	// The paginated results of the entity search.
	Results EntitySearchResult `json:"results,omitempty"`
	// The entity types returned by the entity search.
	Types []EntitySearchTypes `json:"types,omitempty"`
}

// EntitySearchCounts - The groupings and counts of entities returned for the specified criteria.
type EntitySearchCounts struct {
	// The number of entities that match the specified criteria.
	Count int `json:"count,omitempty"`
	// The group of entities returned for the specified criteria.
	Facet AttributeMap `json:"facet,omitempty"`
}

// EntitySearchOptions - Additional entity search options.
type EntitySearchOptions struct {
	// Whether or not matching on tag keys and values should be case-sensitive.
	CaseSensitiveTagMatching bool `json:"caseSensitiveTagMatching,omitempty"`
	// A limit to apply to the number of entities returned. Note: this option can only _lower_ the default limits.
	Limit int `json:"limit,omitempty"`
	// Specify which tags to include with search results. Does not affect which entities are returned.
	TagFilter []string `json:"tagFilter"`
}

// EntitySearchQueryBuilder - An object that can be used to discover and create the entity search query argument.
type EntitySearchQueryBuilder struct {
	// The alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The alertable status of the entity
	Alertable bool `json:"alertable,omitempty"`
	// The entity domain. This is not a complete list of entity domains available; it is a way to explore the most popular domains.
	Domain EntitySearchQueryBuilderDomain `json:"domain,omitempty"`
	// **WARNING! This argument is deprecated and will not be updated with new infrastructure integration types.** If you want to query for a type not in this list, use the `query` argument instead of `queryBuilder`. To see the query string that is generated by your `queryBuilder` search, ask for the `query` field in the result object. You can then use this to build a query supplied to the `query` argument and remove your `queryBuilder`.
	//
	// The Infrastructure integration type. This should be used in place of the `type` field to search for Infrastructure integration specific types.
	InfrastructureIntegrationType EntityInfrastructureIntegrationType `json:"infrastructureIntegrationType,omitempty"`
	// The entity name.
	Name string `json:"name,omitempty"`
	// The reporting status of the entity.
	Reporting bool `json:"reporting,omitempty"`
	// A list of tags applied to the entity.
	Tags []EntitySearchQueryBuilderTag `json:"tags,omitempty"`
	// The entity type.
	//
	// This is not a complete list of entity types available; it is a way to explore the most popular types.
	//
	// If you are querying for Infrastructure integration types, use the `infrastructureIntegrationType` field instead of `type`.
	Type EntitySearchQueryBuilderType `json:"type,omitempty"`
}

// EntitySearchQueryBuilderTag - An entity tag.
type EntitySearchQueryBuilderTag struct {
	// The tag key. You can search using a `tags.` prefix or omit it and receive the same results.
	//
	// Examples: `tags.environment`, `environment`.
	Key string `json:"key"`
	// The tag value.
	Value string `json:"value"`
}

// EntitySearchResult - A section of the entity search results. If there is a `nextCursor` present, there are more results available.
type EntitySearchResult struct {
	// The entities contained in this section of the entity search results.
	//
	// For information on New Relic entities, visit [our docs](https://docs.newrelic.com/docs/what-are-new-relic-entities).
	//
	// To see some query examples of entity information,
	// visit [our entity GraphQL API docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
	Entities []EntityOutlineInterface `json:"entities,omitempty"`
	// The next cursor for fetching additional paginated entity search results.
	NextCursor string `json:"nextCursor,omitempty"`
}

// special
func (x *EntitySearchResult) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "entities":
			if v == nil {
				continue
			}
			var rawMessageEntities []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageEntities)
			if err != nil {
				return err
			}

			for _, m := range rawMessageEntities {
				xxx, err := UnmarshalEntityOutlineInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.Entities = append(x.Entities, *xxx)
				}
			}
		case "nextCursor":
			err = json.Unmarshal(*v, &x.NextCursor)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// EntitySearchTypes - A detailed entity search response object type.
type EntitySearchTypes struct {
	// The number of results with this type.
	Count int `json:"count,omitempty"`
	// The domain of the search result group.
	Domain string `json:"domain,omitempty"`
	// The combined domain & type of the search result group.
	EntityType EntityType `json:"entityType,omitempty"`
	// The type of the search result group.
	Type string `json:"type,omitempty"`
}

// EntityTag - A tag that has been applied to an entity.
type EntityTag struct {
	// The tag's key
	Key string `json:"key,omitempty"`
	// A list of the tag values
	Values []string `json:"values,omitempty"`
}

// EntityTagValueWithMetadata - The value and metadata of a single entity tag.
type EntityTagValueWithMetadata struct {
	// Whether or not the tag can be mutated by the user.
	Mutable bool `json:"mutable,omitempty"`
	// The tag value.
	Value string `json:"value,omitempty"`
}

// EntityTagWithMetadata - The tags with metadata of the entity.
type EntityTagWithMetadata struct {
	// The tag's key.
	Key string `json:"key,omitempty"`
	// A list of tag values with metadata information.
	Values []EntityTagValueWithMetadata `json:"values,omitempty"`
}

// ExternalEntity - An External entity.
type ExternalEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ExternalEntity
func (x ExternalEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ExternalEntity
func (x ExternalEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ExternalEntity
func (x ExternalEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from ExternalEntity
func (x ExternalEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from ExternalEntity
func (x ExternalEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from ExternalEntity
func (x ExternalEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ExternalEntity
func (x ExternalEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ExternalEntity
func (x ExternalEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ExternalEntity
func (x ExternalEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ExternalEntity
func (x ExternalEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ExternalEntity
func (x ExternalEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ExternalEntity
func (x ExternalEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ExternalEntity
func (x ExternalEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from ExternalEntity
func (x ExternalEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from ExternalEntity
func (x ExternalEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from ExternalEntity
func (x ExternalEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from ExternalEntity
func (x ExternalEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from ExternalEntity
func (x ExternalEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from ExternalEntity
func (x ExternalEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from ExternalEntity
func (x ExternalEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from ExternalEntity
func (x ExternalEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from ExternalEntity
func (x ExternalEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ExternalEntity
func (x ExternalEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ExternalEntity
func (x ExternalEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from ExternalEntity
func (x ExternalEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from ExternalEntity
func (x ExternalEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from ExternalEntity
func (x ExternalEntity) GetType() string {
	return x.Type
}

func (x *ExternalEntity) ImplementsAlertableEntity() {}

func (x *ExternalEntity) ImplementsEntity() {}

// ExternalEntityOutline - An External entity outline.
type ExternalEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ExternalEntityOutline
func (x ExternalEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ExternalEntityOutline
func (x ExternalEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ExternalEntityOutline
func (x ExternalEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from ExternalEntityOutline
func (x ExternalEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ExternalEntityOutline
func (x ExternalEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ExternalEntityOutline
func (x ExternalEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ExternalEntityOutline
func (x ExternalEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ExternalEntityOutline
func (x ExternalEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ExternalEntityOutline
func (x ExternalEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ExternalEntityOutline
func (x ExternalEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ExternalEntityOutline
func (x ExternalEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from ExternalEntityOutline
func (x ExternalEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from ExternalEntityOutline
func (x ExternalEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from ExternalEntityOutline
func (x ExternalEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ExternalEntityOutline
func (x ExternalEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ExternalEntityOutline
func (x ExternalEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from ExternalEntityOutline
func (x ExternalEntityOutline) GetType() string {
	return x.Type
}

func (x *ExternalEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *ExternalEntityOutline) ImplementsEntityOutline() {}

// GenericEntity - A generic entity.
type GenericEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from GenericEntity
func (x GenericEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from GenericEntity
func (x GenericEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from GenericEntity
func (x GenericEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from GenericEntity
func (x GenericEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from GenericEntity
func (x GenericEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from GenericEntity
func (x GenericEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from GenericEntity
func (x GenericEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from GenericEntity
func (x GenericEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from GenericEntity
func (x GenericEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from GenericEntity
func (x GenericEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from GenericEntity
func (x GenericEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from GenericEntity
func (x GenericEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from GenericEntity
func (x GenericEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from GenericEntity
func (x GenericEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from GenericEntity
func (x GenericEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from GenericEntity
func (x GenericEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from GenericEntity
func (x GenericEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from GenericEntity
func (x GenericEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from GenericEntity
func (x GenericEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from GenericEntity
func (x GenericEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from GenericEntity
func (x GenericEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from GenericEntity
func (x GenericEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from GenericEntity
func (x GenericEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from GenericEntity
func (x GenericEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from GenericEntity
func (x GenericEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from GenericEntity
func (x GenericEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from GenericEntity
func (x GenericEntity) GetType() string {
	return x.Type
}

func (x *GenericEntity) ImplementsAlertableEntity() {}

func (x *GenericEntity) ImplementsEntity() {}

// GenericEntityOutline - A generic entity outline.
type GenericEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from GenericEntityOutline
func (x GenericEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from GenericEntityOutline
func (x GenericEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from GenericEntityOutline
func (x GenericEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from GenericEntityOutline
func (x GenericEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from GenericEntityOutline
func (x GenericEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from GenericEntityOutline
func (x GenericEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from GenericEntityOutline
func (x GenericEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from GenericEntityOutline
func (x GenericEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from GenericEntityOutline
func (x GenericEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from GenericEntityOutline
func (x GenericEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from GenericEntityOutline
func (x GenericEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from GenericEntityOutline
func (x GenericEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from GenericEntityOutline
func (x GenericEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from GenericEntityOutline
func (x GenericEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from GenericEntityOutline
func (x GenericEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from GenericEntityOutline
func (x GenericEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from GenericEntityOutline
func (x GenericEntityOutline) GetType() string {
	return x.Type
}

func (x *GenericEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *GenericEntityOutline) ImplementsEntityOutline() {}

// GenericInfrastructureEntity - An Infrastructure entity.
type GenericInfrastructureEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt           *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	IntegrationTypeCode string                    `json:"integrationTypeCode,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetIntegrationTypeCode returns a pointer to the value of IntegrationTypeCode from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetIntegrationTypeCode() string {
	return x.IntegrationTypeCode
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from GenericInfrastructureEntity
func (x GenericInfrastructureEntity) GetType() string {
	return x.Type
}

func (x *GenericInfrastructureEntity) ImplementsAlertableEntity() {}

func (x *GenericInfrastructureEntity) ImplementsEntity() {}

func (x *GenericInfrastructureEntity) ImplementsInfrastructureIntegrationEntity() {}

// GenericInfrastructureEntityOutline - An Infrastructure entity outline.
type GenericInfrastructureEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt           *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	IntegrationTypeCode string                    `json:"integrationTypeCode,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetIntegrationTypeCode returns a pointer to the value of IntegrationTypeCode from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetIntegrationTypeCode() string {
	return x.IntegrationTypeCode
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from GenericInfrastructureEntityOutline
func (x GenericInfrastructureEntityOutline) GetType() string {
	return x.Type
}

func (x *GenericInfrastructureEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *GenericInfrastructureEntityOutline) ImplementsEntityOutline() {}

func (x *GenericInfrastructureEntityOutline) ImplementsInfrastructureIntegrationEntityOutline() {}

// InfrastructureAwsLambdaFunctionEntity - An AWS Lambda Function entity.
type InfrastructureAwsLambdaFunctionEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt           *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	IntegrationTypeCode string                    `json:"integrationTypeCode,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool   `json:"reporting,omitempty"`
	Runtime   string `json:"runtime,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetIntegrationTypeCode returns a pointer to the value of IntegrationTypeCode from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetIntegrationTypeCode() string {
	return x.IntegrationTypeCode
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetReporting() bool {
	return x.Reporting
}

// GetRuntime returns a pointer to the value of Runtime from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetRuntime() string {
	return x.Runtime
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from InfrastructureAwsLambdaFunctionEntity
func (x InfrastructureAwsLambdaFunctionEntity) GetType() string {
	return x.Type
}

func (x *InfrastructureAwsLambdaFunctionEntity) ImplementsAlertableEntity() {}

func (x *InfrastructureAwsLambdaFunctionEntity) ImplementsEntity() {}

func (x *InfrastructureAwsLambdaFunctionEntity) ImplementsInfrastructureIntegrationEntity() {}

// InfrastructureAwsLambdaFunctionEntityOutline - An AWS Lambda Function entity outline.
type InfrastructureAwsLambdaFunctionEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt           *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	IntegrationTypeCode string                    `json:"integrationTypeCode,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool   `json:"reporting,omitempty"`
	Runtime   string `json:"runtime,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetIntegrationTypeCode returns a pointer to the value of IntegrationTypeCode from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetIntegrationTypeCode() string {
	return x.IntegrationTypeCode
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetRuntime returns a pointer to the value of Runtime from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetRuntime() string {
	return x.Runtime
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from InfrastructureAwsLambdaFunctionEntityOutline
func (x InfrastructureAwsLambdaFunctionEntityOutline) GetType() string {
	return x.Type
}

func (x *InfrastructureAwsLambdaFunctionEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *InfrastructureAwsLambdaFunctionEntityOutline) ImplementsEntityOutline() {}

func (x *InfrastructureAwsLambdaFunctionEntityOutline) ImplementsInfrastructureIntegrationEntityOutline() {
}

// InfrastructureHostEntity - An Infrastructure Host entity.
type InfrastructureHostEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags  EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	HostSummary InfrastructureHostSummaryData       `json:"hostSummary,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetHostSummary returns a pointer to the value of HostSummary from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetHostSummary() InfrastructureHostSummaryData {
	return x.HostSummary
}

// GetIndexedAt returns a pointer to the value of IndexedAt from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from InfrastructureHostEntity
func (x InfrastructureHostEntity) GetType() string {
	return x.Type
}

func (x *InfrastructureHostEntity) ImplementsAlertableEntity() {}

func (x *InfrastructureHostEntity) ImplementsEntity() {}

// InfrastructureHostEntityOutline - An Infrastructure Host entity outline.
type InfrastructureHostEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags  EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	HostSummary InfrastructureHostSummaryData       `json:"hostSummary,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetHostSummary returns a pointer to the value of HostSummary from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetHostSummary() InfrastructureHostSummaryData {
	return x.HostSummary
}

// GetIndexedAt returns a pointer to the value of IndexedAt from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from InfrastructureHostEntityOutline
func (x InfrastructureHostEntityOutline) GetType() string {
	return x.Type
}

func (x *InfrastructureHostEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *InfrastructureHostEntityOutline) ImplementsEntityOutline() {}

// InfrastructureHostSummaryData - Summary statistics about the Infra Host.
type InfrastructureHostSummaryData struct {
	// Total CPU utilization as a percentage.
	CpuUtilizationPercent float64 `json:"cpuUtilizationPercent,omitempty"`
	// The cumulative disk fullness percentage.
	DiskUsedPercent float64 `json:"diskUsedPercent,omitempty"`
	// Total memory utilization as a percentage.
	MemoryUsedPercent float64 `json:"memoryUsedPercent,omitempty"`
	// The number of bytes per second received during the sampling period.
	NetworkReceiveRate float64 `json:"networkReceiveRate,omitempty"`
	// The number of bytes sent per second during the sampling period.
	NetworkTransmitRate float64 `json:"networkTransmitRate,omitempty"`
	// Number of services running on the host.
	ServicesCount int `json:"servicesCount,omitempty"`
}

type InfrastructureIntegrationEntity struct {
	IntegrationTypeCode string `json:"integrationTypeCode,omitempty"`
}

// GetIntegrationTypeCode returns a pointer to the value of IntegrationTypeCode from InfrastructureIntegrationEntity
func (x InfrastructureIntegrationEntity) GetIntegrationTypeCode() string {
	return x.IntegrationTypeCode
}

func (x *InfrastructureIntegrationEntity) ImplementsInfrastructureIntegrationEntity() {}

type InfrastructureIntegrationEntityOutline struct {
	IntegrationTypeCode string `json:"integrationTypeCode,omitempty"`
}

// GetIntegrationTypeCode returns a pointer to the value of IntegrationTypeCode from InfrastructureIntegrationEntityOutline
func (x InfrastructureIntegrationEntityOutline) GetIntegrationTypeCode() string {
	return x.IntegrationTypeCode
}

func (x *InfrastructureIntegrationEntityOutline) ImplementsInfrastructureIntegrationEntityOutline() {}

// JavaFlightRecorderFlamegraph - The flamegraph built from the strack trace samples
type JavaFlightRecorderFlamegraph struct {
	// List of stack frames for the flamegraph
	AllFrames []JavaFlightRecorderStackFrame `json:"allFrames"`
}

// JavaFlightRecorderStackFrame - A method within the flamegraph
type JavaFlightRecorderStackFrame struct {
	// The number of stack traces that this frame is in
	Count int `json:"count"`
	// This stackframe's id
	ID string `json:"id"`
	// The stackframe's class and method name
	Name string `json:"name"`
	// This stackframe's parent id
	ParentId string `json:"parentId,omitempty"`
}

// KeyTransactionApplication - The application wrapper.
type KeyTransactionApplication struct {
	// The application outline.
	Entity EntityOutlineInterface `json:"entity,omitempty"`
	// The guid of the application.
	GUID common.EntityGUID `json:"guid"`
}

// special
func (x *KeyTransactionApplication) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "entity":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalEntityOutlineInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Entity = *xxx
			}
		case "guid":
			err = json.Unmarshal(*v, &x.GUID)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// KeyTransactionEntity - A Key Transaction entity.
type KeyTransactionEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// The acceptable amount of time spent in the backend before customers get frustrated (Apdex target).
	ApdexTarget float64 `json:"apdexTarget"`
	// The application associated with this key transaction
	Application KeyTransactionApplication `json:"application"`
	// The acceptable amount of time for rendering a page in a browser before customers get frustrated (browser Apdex target).
	BrowserApdexTarget float64 `json:"browserApdexTarget,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of the metric underlying this key transaction.
	MetricName string `json:"metricName"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from KeyTransactionEntity
func (x KeyTransactionEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from KeyTransactionEntity
func (x KeyTransactionEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from KeyTransactionEntity
func (x KeyTransactionEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from KeyTransactionEntity
func (x KeyTransactionEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetApdexTarget returns a pointer to the value of ApdexTarget from KeyTransactionEntity
func (x KeyTransactionEntity) GetApdexTarget() float64 {
	return x.ApdexTarget
}

// GetApplication returns a pointer to the value of Application from KeyTransactionEntity
func (x KeyTransactionEntity) GetApplication() KeyTransactionApplication {
	return x.Application
}

// GetBrowserApdexTarget returns a pointer to the value of BrowserApdexTarget from KeyTransactionEntity
func (x KeyTransactionEntity) GetBrowserApdexTarget() float64 {
	return x.BrowserApdexTarget
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from KeyTransactionEntity
func (x KeyTransactionEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from KeyTransactionEntity
func (x KeyTransactionEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from KeyTransactionEntity
func (x KeyTransactionEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from KeyTransactionEntity
func (x KeyTransactionEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from KeyTransactionEntity
func (x KeyTransactionEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from KeyTransactionEntity
func (x KeyTransactionEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from KeyTransactionEntity
func (x KeyTransactionEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from KeyTransactionEntity
func (x KeyTransactionEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from KeyTransactionEntity
func (x KeyTransactionEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetMetricName returns a pointer to the value of MetricName from KeyTransactionEntity
func (x KeyTransactionEntity) GetMetricName() string {
	return x.MetricName
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from KeyTransactionEntity
func (x KeyTransactionEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from KeyTransactionEntity
func (x KeyTransactionEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from KeyTransactionEntity
func (x KeyTransactionEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from KeyTransactionEntity
func (x KeyTransactionEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from KeyTransactionEntity
func (x KeyTransactionEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from KeyTransactionEntity
func (x KeyTransactionEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from KeyTransactionEntity
func (x KeyTransactionEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from KeyTransactionEntity
func (x KeyTransactionEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from KeyTransactionEntity
func (x KeyTransactionEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from KeyTransactionEntity
func (x KeyTransactionEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from KeyTransactionEntity
func (x KeyTransactionEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from KeyTransactionEntity
func (x KeyTransactionEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from KeyTransactionEntity
func (x KeyTransactionEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from KeyTransactionEntity
func (x KeyTransactionEntity) GetType() string {
	return x.Type
}

func (x *KeyTransactionEntity) ImplementsAlertableEntity() {}

func (x *KeyTransactionEntity) ImplementsEntity() {}

// KeyTransactionEntityOutline - A Key Transaction entity outline.
type KeyTransactionEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from KeyTransactionEntityOutline
func (x KeyTransactionEntityOutline) GetType() string {
	return x.Type
}

func (x *KeyTransactionEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *KeyTransactionEntityOutline) ImplementsEntityOutline() {}

// MetricNormalizationRule - An object that represents a metric rename rule.
type MetricNormalizationRule struct {
	// Rule action.
	Action MetricNormalizationRuleAction `json:"action,omitempty"`
	// Application GUID
	ApplicationGUID common.EntityGUID `json:"applicationGuid,omitempty"`
	// Application Name
	ApplicationName string `json:"applicationName,omitempty"`
	// Date of rule creation.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// Is rule enabled?
	Enabled bool `json:"enabled"`
	// Rule evaluation order
	EvalOrder int `json:"evalOrder,omitempty"`
	// Rule Id
	ID int `json:"id"`
	// Metric Match Expression.
	MatchExpression string `json:"matchExpression"`
	// Notes.
	Notes string `json:"notes,omitempty"`
	// Metric Replacement Expression.
	Replacement string `json:"replacement,omitempty"`
	// Whether it terminates the evaluation chain or not
	TerminateChain bool `json:"terminateChain,omitempty"`
}

// MetricNormalizationRuleMetricGroupingIssue - An object that represents a metric grouping issue.
type MetricNormalizationRuleMetricGroupingIssue struct {
	// Total number of received and denied new metrics.
	DeniedMetricsCount int `json:"deniedMetricsCount,omitempty"`
	// Rate of received and denied new metrics per minute.
	DeniedMetricsRatePerMinute float64 `json:"deniedMetricsRatePerMinute,omitempty"`
	// Metric normalization rule id
	MetricNormalizationRuleId int `json:"metricNormalizationRuleId"`
	// Whether the issue is mitigated or still active
	Mitigated bool `json:"mitigated,omitempty"`
	// The new metrics rate threshold to consider the issue mitigated.
	MitigationRateThreshold float64 `json:"mitigationRateThreshold,omitempty"`
	// The minute time window to calculate if the issue was mitigated.
	MitigationRateWindowSize int `json:"mitigationRateWindowSize,omitempty"`
}

// MobileAppSummaryData - Mobile application summary data
type MobileAppSummaryData struct {
	// The number of times the app has been launched.
	AppLaunchCount int `json:"appLaunchCount,omitempty"`
	// The number of crashes.
	CrashCount int `json:"crashCount,omitempty"`
	// Crash rate is percentage of crashes per sessions.
	CrashRate float64 `json:"crashRate,omitempty"`
	// Error rate is the percentage of http errors per successful requests.
	HttpErrorRate float64 `json:"httpErrorRate,omitempty"`
	// The number of http requests.
	HttpRequestCount int `json:"httpRequestCount,omitempty"`
	// The rate of http requests per minute.
	HttpRequestRate float64 `json:"httpRequestRate,omitempty"`
	// The average response time for all http calls.
	HttpResponseTimeAverage nrtime.Seconds `json:"httpResponseTimeAverage,omitempty"`
	// The number of mobile sessions.
	MobileSessionCount int `json:"mobileSessionCount,omitempty"`
	// Network failure rate is the percentage of network failures per successful requests.
	NetworkFailureRate float64 `json:"networkFailureRate,omitempty"`
	// The number of users affected by crashes.
	UsersAffectedCount int `json:"usersAffectedCount,omitempty"`
}

// MobileApplicationEntity - A Mobile Application entity.
type MobileApplicationEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// The ID of the Mobile App.
	ApplicationID int `json:"applicationId,omitempty"`
	// A Crash that occurred in your Mobile Application.
	Crash StackTraceMobileCrash `json:"crash,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// A Handled Exception that occurred in your Mobile Application.
	Exception StackTraceMobileException `json:"exception,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Retrieves the entity metric grouping issues.
	MetricGroupingIssues []MetricNormalizationRuleMetricGroupingIssue `json:"metricGroupingIssues"`
	// Retrieves a rule.
	MetricNormalizationRule MetricNormalizationRule `json:"metricNormalizationRule,omitempty"`
	// Retrieves the rules for the application.
	MetricNormalizationRules []MetricNormalizationRule `json:"metricNormalizationRules"`
	// Access general properties for the application.
	MobileProperties AgentApplicationSettingsMobileProperties `json:"mobileProperties,omitempty"`
	// Settings that are common across mobile applications.
	MobileSettings AgentApplicationSettingsMobileBase `json:"mobileSettings,omitempty"`
	// Summary statistics about the Mobile App.
	MobileSummary MobileAppSummaryData `json:"mobileSummary,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from MobileApplicationEntity
func (x MobileApplicationEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from MobileApplicationEntity
func (x MobileApplicationEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from MobileApplicationEntity
func (x MobileApplicationEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from MobileApplicationEntity
func (x MobileApplicationEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetApplicationID returns a pointer to the value of ApplicationID from MobileApplicationEntity
func (x MobileApplicationEntity) GetApplicationID() int {
	return x.ApplicationID
}

// GetCrash returns a pointer to the value of Crash from MobileApplicationEntity
func (x MobileApplicationEntity) GetCrash() StackTraceMobileCrash {
	return x.Crash
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from MobileApplicationEntity
func (x MobileApplicationEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from MobileApplicationEntity
func (x MobileApplicationEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from MobileApplicationEntity
func (x MobileApplicationEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetException returns a pointer to the value of Exception from MobileApplicationEntity
func (x MobileApplicationEntity) GetException() StackTraceMobileException {
	return x.Exception
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from MobileApplicationEntity
func (x MobileApplicationEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from MobileApplicationEntity
func (x MobileApplicationEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from MobileApplicationEntity
func (x MobileApplicationEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from MobileApplicationEntity
func (x MobileApplicationEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from MobileApplicationEntity
func (x MobileApplicationEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from MobileApplicationEntity
func (x MobileApplicationEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetMetricGroupingIssues returns a pointer to the value of MetricGroupingIssues from MobileApplicationEntity
func (x MobileApplicationEntity) GetMetricGroupingIssues() []MetricNormalizationRuleMetricGroupingIssue {
	return x.MetricGroupingIssues
}

// GetMetricNormalizationRule returns a pointer to the value of MetricNormalizationRule from MobileApplicationEntity
func (x MobileApplicationEntity) GetMetricNormalizationRule() MetricNormalizationRule {
	return x.MetricNormalizationRule
}

// GetMetricNormalizationRules returns a pointer to the value of MetricNormalizationRules from MobileApplicationEntity
func (x MobileApplicationEntity) GetMetricNormalizationRules() []MetricNormalizationRule {
	return x.MetricNormalizationRules
}

// GetMobileProperties returns a pointer to the value of MobileProperties from MobileApplicationEntity
func (x MobileApplicationEntity) GetMobileProperties() AgentApplicationSettingsMobileProperties {
	return x.MobileProperties
}

// GetMobileSettings returns a pointer to the value of MobileSettings from MobileApplicationEntity
func (x MobileApplicationEntity) GetMobileSettings() AgentApplicationSettingsMobileBase {
	return x.MobileSettings
}

// GetMobileSummary returns a pointer to the value of MobileSummary from MobileApplicationEntity
func (x MobileApplicationEntity) GetMobileSummary() MobileAppSummaryData {
	return x.MobileSummary
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from MobileApplicationEntity
func (x MobileApplicationEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from MobileApplicationEntity
func (x MobileApplicationEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from MobileApplicationEntity
func (x MobileApplicationEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from MobileApplicationEntity
func (x MobileApplicationEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from MobileApplicationEntity
func (x MobileApplicationEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from MobileApplicationEntity
func (x MobileApplicationEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from MobileApplicationEntity
func (x MobileApplicationEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from MobileApplicationEntity
func (x MobileApplicationEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from MobileApplicationEntity
func (x MobileApplicationEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from MobileApplicationEntity
func (x MobileApplicationEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from MobileApplicationEntity
func (x MobileApplicationEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from MobileApplicationEntity
func (x MobileApplicationEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from MobileApplicationEntity
func (x MobileApplicationEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from MobileApplicationEntity
func (x MobileApplicationEntity) GetType() string {
	return x.Type
}

func (x *MobileApplicationEntity) ImplementsAlertableEntity() {}

func (x *MobileApplicationEntity) ImplementsEntity() {}

// MobileApplicationEntityOutline - A Mobile Application entity outline.
type MobileApplicationEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The ID of the Mobile App.
	ApplicationID int `json:"applicationId,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Summary statistics about the Mobile App.
	MobileSummary MobileAppSummaryData `json:"mobileSummary,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetApplicationID returns a pointer to the value of ApplicationID from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetApplicationID() int {
	return x.ApplicationID
}

// GetDomain returns a pointer to the value of Domain from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetMobileSummary returns a pointer to the value of MobileSummary from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetMobileSummary() MobileAppSummaryData {
	return x.MobileSummary
}

// GetName returns a pointer to the value of Name from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from MobileApplicationEntityOutline
func (x MobileApplicationEntityOutline) GetType() string {
	return x.Type
}

func (x *MobileApplicationEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *MobileApplicationEntityOutline) ImplementsEntityOutline() {}

// NRQLQueryOptions - Additional options for NRQL queries.
type NRQLQueryOptions struct {
	// Limit the NRQL query to return results from the chosen Event Namespaces.
	//
	// You must supply at least 1 valid event namespace when using this option.
	// Invalid event namespaces will be filtered out.
	//
	// If omitted, the default list will be `["Default"]`
	//
	// For more details about Event Namespaces, visit our [docs](https://docs.newrelic.com/docs/accounts/original-accounts-billing/original-product-based-pricing/introduction-new-relic-subscription-usage-data/#namespace).
	EventNamespaces []string `json:"eventNamespaces"`
}

type NerdStorageCollectionMember struct {
	// The NerdStorage document.
	Document NerdStorageDocument `json:"document,omitempty"`
	// The documentId.
	ID string `json:"id,omitempty"`
}

type NerdStorageEntityScope struct {
	Collection []NerdStorageCollectionMember `json:"collection,omitempty"`
	Document   NerdStorageDocument           `json:"document,omitempty"`
}

// SecureCredentialEntity - A secure credential entity.
type SecureCredentialEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The description of the entity.
	Description string `json:"description,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The domain-specific identifier for the entity.
	SecureCredentialId string `json:"secureCredentialId,omitempty"`
	// Summary statistics for the Synthetic Monitor Secure Credential.
	SecureCredentialSummary SecureCredentialSummaryData `json:"secureCredentialSummary,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// The time at which the entity was last updated.
	UpdatedAt *nrtime.EpochMilliseconds `json:"updatedAt,omitempty"`
}

// GetAccount returns a pointer to the value of Account from SecureCredentialEntity
func (x SecureCredentialEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from SecureCredentialEntity
func (x SecureCredentialEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from SecureCredentialEntity
func (x SecureCredentialEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from SecureCredentialEntity
func (x SecureCredentialEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from SecureCredentialEntity
func (x SecureCredentialEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDescription returns a pointer to the value of Description from SecureCredentialEntity
func (x SecureCredentialEntity) GetDescription() string {
	return x.Description
}

// GetDomain returns a pointer to the value of Domain from SecureCredentialEntity
func (x SecureCredentialEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from SecureCredentialEntity
func (x SecureCredentialEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from SecureCredentialEntity
func (x SecureCredentialEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from SecureCredentialEntity
func (x SecureCredentialEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from SecureCredentialEntity
func (x SecureCredentialEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from SecureCredentialEntity
func (x SecureCredentialEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from SecureCredentialEntity
func (x SecureCredentialEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from SecureCredentialEntity
func (x SecureCredentialEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from SecureCredentialEntity
func (x SecureCredentialEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from SecureCredentialEntity
func (x SecureCredentialEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from SecureCredentialEntity
func (x SecureCredentialEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from SecureCredentialEntity
func (x SecureCredentialEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from SecureCredentialEntity
func (x SecureCredentialEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from SecureCredentialEntity
func (x SecureCredentialEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from SecureCredentialEntity
func (x SecureCredentialEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from SecureCredentialEntity
func (x SecureCredentialEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from SecureCredentialEntity
func (x SecureCredentialEntity) GetReporting() bool {
	return x.Reporting
}

// GetSecureCredentialId returns a pointer to the value of SecureCredentialId from SecureCredentialEntity
func (x SecureCredentialEntity) GetSecureCredentialId() string {
	return x.SecureCredentialId
}

// GetSecureCredentialSummary returns a pointer to the value of SecureCredentialSummary from SecureCredentialEntity
func (x SecureCredentialEntity) GetSecureCredentialSummary() SecureCredentialSummaryData {
	return x.SecureCredentialSummary
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from SecureCredentialEntity
func (x SecureCredentialEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from SecureCredentialEntity
func (x SecureCredentialEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from SecureCredentialEntity
func (x SecureCredentialEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from SecureCredentialEntity
func (x SecureCredentialEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from SecureCredentialEntity
func (x SecureCredentialEntity) GetType() string {
	return x.Type
}

// GetUpdatedAt returns a pointer to the value of UpdatedAt from SecureCredentialEntity
func (x SecureCredentialEntity) GetUpdatedAt() *nrtime.EpochMilliseconds {
	return x.UpdatedAt
}

func (x *SecureCredentialEntity) ImplementsAlertableEntity() {}

func (x *SecureCredentialEntity) ImplementsEntity() {}

// SecureCredentialEntityOutline - A secure credential entity outline.
type SecureCredentialEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The description of the entity.
	Description string `json:"description,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The domain-specific identifier for the entity.
	SecureCredentialId string `json:"secureCredentialId,omitempty"`
	// Summary statistics for the Synthetic Monitor Secure Credential.
	SecureCredentialSummary SecureCredentialSummaryData `json:"secureCredentialSummary,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// The time at which the entity was last updated.
	UpdatedAt *nrtime.EpochMilliseconds `json:"updatedAt,omitempty"`
}

// GetAccount returns a pointer to the value of Account from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDescription returns a pointer to the value of Description from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetDescription() string {
	return x.Description
}

// GetDomain returns a pointer to the value of Domain from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetSecureCredentialId returns a pointer to the value of SecureCredentialId from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetSecureCredentialId() string {
	return x.SecureCredentialId
}

// GetSecureCredentialSummary returns a pointer to the value of SecureCredentialSummary from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetSecureCredentialSummary() SecureCredentialSummaryData {
	return x.SecureCredentialSummary
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetType() string {
	return x.Type
}

// GetUpdatedAt returns a pointer to the value of UpdatedAt from SecureCredentialEntityOutline
func (x SecureCredentialEntityOutline) GetUpdatedAt() *nrtime.EpochMilliseconds {
	return x.UpdatedAt
}

func (x *SecureCredentialEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *SecureCredentialEntityOutline) ImplementsEntityOutline() {}

// SecureCredentialSummaryData - Summary statistics for the Synthetic Monitor Secure Credential.
type SecureCredentialSummaryData struct {
	// The number of monitors that contain this secure credential and failed their last check.
	FailingMonitorCount int `json:"failingMonitorCount,omitempty"`
	// The number of monitors that contain this secure credential.
	MonitorCount int `json:"monitorCount,omitempty"`
}

// ServiceLevelDefinition - The service level defined for a specific entity.
type ServiceLevelDefinition struct {
	// The SLIs attached to the entity.
	Indicators []servicelevel.ServiceLevelIndicator `json:"indicators"`
}

// SortCriterionWithDirection - Possible entity sorting criterion with direction
type SortCriterionWithDirection struct {
	// Sort entities by attribute. Mutally exclusive with the `tag` argument
	Attribute EntitySearchSortCriteria `json:"attribute,omitempty"`
	// The direction to sort results
	Direction SortBy `json:"direction,omitempty"`
	// Sort entities by tag. Mutally exclusive with the `attribute` argument
	Tag string `json:"tag,omitempty"`
}

// StackTraceApmException - A structured representation of an exception for an APM application.
type StackTraceApmException struct {
	// The top level message associated with the exception.
	Message string `json:"message,omitempty"`
	// The stack trace associated with the exception.
	StackTrace StackTraceApmStackTrace `json:"stackTrace,omitempty"`
}

// StackTraceApmStackTrace - A structured representation of a stack trace for an APM application.
type StackTraceApmStackTrace struct {
	// Stack trace frames.
	Frames []StackTraceApmStackTraceFrame `json:"frames,omitempty"`
}

// StackTraceApmStackTraceFrame - An object representing a stack trace segment
type StackTraceApmStackTraceFrame struct {
	// Frame filepath
	Filepath string `json:"filepath,omitempty"`
	// Formatted frame
	Formatted string `json:"formatted"`
	// Frame line number
	Line int `json:"line,omitempty"`
	// Frame name
	Name string `json:"name,omitempty"`
}

// StackTraceBrowserException - A structured representation of an exception for a Browser application.
type StackTraceBrowserException struct {
	// The top level message associated to the stack trace.
	Message string `json:"message,omitempty"`
	// The stack trace associated with the exception.
	StackTrace StackTraceBrowserStackTrace `json:"stackTrace,omitempty"`
}

// StackTraceBrowserStackTrace - A structured representation of a stack trace for a Browser application.
type StackTraceBrowserStackTrace struct {
	// Stack trace frames.
	Frames []StackTraceBrowserStackTraceFrame `json:"frames,omitempty"`
}

// StackTraceBrowserStackTraceFrame - An object representing a stack trace segment
type StackTraceBrowserStackTraceFrame struct {
	// Frame column number
	Column int `json:"column,omitempty"`
	// Formatted frame
	Formatted string `json:"formatted"`
	// Frame line number
	Line int `json:"line,omitempty"`
	// Frame name
	Name string `json:"name,omitempty"`
}

// StackTraceMobileCrash - A structured representation of a crash occurring in a mobile application.
type StackTraceMobileCrash struct {
	// A structured representation of a stack trace for a crash that occurs on a mobile application.
	StackTrace StackTraceMobileCrashStackTrace `json:"stackTrace,omitempty"`
}

// StackTraceMobileCrashStackTrace - A structured representation of a stack trace of a crash in a mobile application.
type StackTraceMobileCrashStackTrace struct {
	// Stack trace frames.
	Frames []StackTraceMobileCrashStackTraceFrame `json:"frames,omitempty"`
}

// StackTraceMobileCrashStackTraceFrame - An object representing a stack trace segment
type StackTraceMobileCrashStackTraceFrame struct {
	// Frame filepath
	Filepath string `json:"filepath,omitempty"`
	// Formatted frame
	Formatted string `json:"formatted"`
	// Frame line number
	Line int `json:"line,omitempty"`
	// Frame name
	Name string `json:"name,omitempty"`
}

// StackTraceMobileException - A structured representation of a handled exception occurring in a mobile application.
type StackTraceMobileException struct {
	// A structured representation of a handled exception in a mobile application.
	StackTrace StackTraceMobileExceptionStackTrace `json:"stackTrace,omitempty"`
}

// StackTraceMobileExceptionStackTrace - A structured representation of a handled exception in a mobile application.
type StackTraceMobileExceptionStackTrace struct {
	// Stack trace frames.
	Frames []StackTraceMobileExceptionStackTraceFrame `json:"frames,omitempty"`
}

// StackTraceMobileExceptionStackTraceFrame - An object representing a stack trace segment
type StackTraceMobileExceptionStackTraceFrame struct {
	// Frame filepath
	Filepath string `json:"filepath,omitempty"`
	// Formatted frame
	Formatted string `json:"formatted"`
	// Frame line number
	Line int `json:"line,omitempty"`
	// Frame name
	Name string `json:"name,omitempty"`
}

// SyntheticMonitorEntity - A Synthetic Monitor entity.
type SyntheticMonitorEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Assets produced during the execution of the check, such as screenshots
	Assets []SyntheticsSyntheticMonitorAsset `json:"assets,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The Synthetic Monitor ID
	MonitorId string `json:"monitorId,omitempty"`
	// Summary statistics for the Synthetic Monitor.
	MonitorSummary SyntheticMonitorSummaryData `json:"monitorSummary,omitempty"`
	// The Synthetic Monitor type
	MonitorType SyntheticMonitorType `json:"monitorType,omitempty"`
	// The URL being monitored by a `SIMPLE` or `BROWSER` monitor type.
	MonitoredURL string `json:"monitoredUrl,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The duration in minutes between Synthetic Monitor runs.
	Period nrtime.Minutes `json:"period,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetAssets returns a pointer to the value of Assets from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetAssets() []SyntheticsSyntheticMonitorAsset {
	return x.Assets
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetMonitorId returns a pointer to the value of MonitorId from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetMonitorId() string {
	return x.MonitorId
}

// GetMonitorSummary returns a pointer to the value of MonitorSummary from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetMonitorSummary() SyntheticMonitorSummaryData {
	return x.MonitorSummary
}

// GetMonitorType returns a pointer to the value of MonitorType from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetMonitorType() SyntheticMonitorType {
	return x.MonitorType
}

// GetMonitoredURL returns a pointer to the value of MonitoredURL from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetMonitoredURL() string {
	return x.MonitoredURL
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPeriod returns a pointer to the value of Period from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetPeriod() nrtime.Minutes {
	return x.Period
}

// GetPermalink returns a pointer to the value of Permalink from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from SyntheticMonitorEntity
func (x SyntheticMonitorEntity) GetType() string {
	return x.Type
}

func (x *SyntheticMonitorEntity) ImplementsAlertableEntity() {}

func (x *SyntheticMonitorEntity) ImplementsEntity() {}

// SyntheticMonitorEntityOutline - A Synthetic Monitor entity outline.
type SyntheticMonitorEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The Synthetic Monitor ID
	MonitorId string `json:"monitorId,omitempty"`
	// Summary statistics for the Synthetic Monitor.
	MonitorSummary SyntheticMonitorSummaryData `json:"monitorSummary,omitempty"`
	// The Synthetic Monitor type
	MonitorType SyntheticMonitorType `json:"monitorType,omitempty"`
	// The URL being monitored by a `SIMPLE` or `BROWSER` monitor type.
	MonitoredURL string `json:"monitoredUrl,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The duration in minutes between Synthetic Monitor runs.
	Period nrtime.Minutes `json:"period,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetMonitorId returns a pointer to the value of MonitorId from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetMonitorId() string {
	return x.MonitorId
}

// GetMonitorSummary returns a pointer to the value of MonitorSummary from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetMonitorSummary() SyntheticMonitorSummaryData {
	return x.MonitorSummary
}

// GetMonitorType returns a pointer to the value of MonitorType from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetMonitorType() SyntheticMonitorType {
	return x.MonitorType
}

// GetMonitoredURL returns a pointer to the value of MonitoredURL from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetMonitoredURL() string {
	return x.MonitoredURL
}

// GetName returns a pointer to the value of Name from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetName() string {
	return x.Name
}

// GetPeriod returns a pointer to the value of Period from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetPeriod() nrtime.Minutes {
	return x.Period
}

// GetPermalink returns a pointer to the value of Permalink from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from SyntheticMonitorEntityOutline
func (x SyntheticMonitorEntityOutline) GetType() string {
	return x.Type
}

func (x *SyntheticMonitorEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *SyntheticMonitorEntityOutline) ImplementsEntityOutline() {}

// SyntheticMonitorSummaryData - Summary statistics for the Synthetic Monitor.
type SyntheticMonitorSummaryData struct {
	// The number of locations that are currently failing.
	LocationsFailing int `json:"locationsFailing,omitempty"`
	// The number of locations that are currently running.
	LocationsRunning int                    `json:"locationsRunning,omitempty"`
	Status           SyntheticMonitorStatus `json:"status,omitempty"`
	// The percentage of successful synthetic monitor checks in the last 24 hours.
	SuccessRate float64 `json:"successRate,omitempty"`
}

// SyntheticsSyntheticMonitorAsset - Asset produced during the execution of the check
type SyntheticsSyntheticMonitorAsset struct {
	// MIME type of asset
	Type string `json:"type,omitempty"`
	// Temporary url at which the asset is available for download
	URL string `json:"url,omitempty"`
}

// TaggingMutationError - An error object for tag mutations.
type TaggingMutationError struct {
	// A message explaining what the errors is about.
	Message string `json:"message,omitempty"`
	// The type of error.
	Type TaggingMutationErrorType `json:"type,omitempty"`
}

// TaggingMutationResult - The result of a tag mutation
type TaggingMutationResult struct {
	// An array containing errors, if any. These are expected errors listed in TagMutationErrorType which a request should be capable of handling appropriately.
	Errors []TaggingMutationError `json:"errors,omitempty"`
}

// TaggingTagInput - An object that represents a tag key-values pair.
type TaggingTagInput struct {
	// The tag key.
	Key string `json:"key"`
	// The tag values.
	Values []string `json:"values,omitempty"`
}

// TaggingTagValueInput - An object that represents a tag key-value pair
type TaggingTagValueInput struct {
	// The tag key.
	Key string `json:"key"`
	// The tag value.
	Value string `json:"value"`
}

// TeamEntity - A Team entity.
type TeamEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	Collection      EntityCollection       `json:"collection,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from TeamEntity
func (x TeamEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from TeamEntity
func (x TeamEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from TeamEntity
func (x TeamEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from TeamEntity
func (x TeamEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetCollection returns a pointer to the value of Collection from TeamEntity
func (x TeamEntity) GetCollection() EntityCollection {
	return x.Collection
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from TeamEntity
func (x TeamEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from TeamEntity
func (x TeamEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from TeamEntity
func (x TeamEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from TeamEntity
func (x TeamEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from TeamEntity
func (x TeamEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from TeamEntity
func (x TeamEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from TeamEntity
func (x TeamEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from TeamEntity
func (x TeamEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from TeamEntity
func (x TeamEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from TeamEntity
func (x TeamEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from TeamEntity
func (x TeamEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from TeamEntity
func (x TeamEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from TeamEntity
func (x TeamEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from TeamEntity
func (x TeamEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from TeamEntity
func (x TeamEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from TeamEntity
func (x TeamEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from TeamEntity
func (x TeamEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from TeamEntity
func (x TeamEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from TeamEntity
func (x TeamEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from TeamEntity
func (x TeamEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from TeamEntity
func (x TeamEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from TeamEntity
func (x TeamEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from TeamEntity
func (x TeamEntity) GetType() string {
	return x.Type
}

func (x *TeamEntity) ImplementsAlertableEntity() {}

func (x *TeamEntity) ImplementsCollectionEntity() {}

func (x *TeamEntity) ImplementsEntity() {}

// TeamEntityOutline - A Team entity outline.
type TeamEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from TeamEntityOutline
func (x TeamEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from TeamEntityOutline
func (x TeamEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from TeamEntityOutline
func (x TeamEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from TeamEntityOutline
func (x TeamEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from TeamEntityOutline
func (x TeamEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from TeamEntityOutline
func (x TeamEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from TeamEntityOutline
func (x TeamEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from TeamEntityOutline
func (x TeamEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from TeamEntityOutline
func (x TeamEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from TeamEntityOutline
func (x TeamEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from TeamEntityOutline
func (x TeamEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from TeamEntityOutline
func (x TeamEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from TeamEntityOutline
func (x TeamEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from TeamEntityOutline
func (x TeamEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from TeamEntityOutline
func (x TeamEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from TeamEntityOutline
func (x TeamEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from TeamEntityOutline
func (x TeamEntityOutline) GetType() string {
	return x.Type
}

func (x *TeamEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *TeamEntityOutline) ImplementsEntityOutline() {}

// ThirdPartyServiceEntity - A third party service entity.
type ThirdPartyServiceEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from ThirdPartyServiceEntity
func (x ThirdPartyServiceEntity) GetType() string {
	return x.Type
}

func (x *ThirdPartyServiceEntity) ImplementsAlertableEntity() {}

func (x *ThirdPartyServiceEntity) ImplementsEntity() {}

// ThirdPartyServiceEntityOutline - A third party service entity outline.
type ThirdPartyServiceEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from ThirdPartyServiceEntityOutline
func (x ThirdPartyServiceEntityOutline) GetType() string {
	return x.Type
}

func (x *ThirdPartyServiceEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *ThirdPartyServiceEntityOutline) ImplementsEntityOutline() {}

// TimeWindowInput - Represents a time window input.
type TimeWindowInput struct {
	// The end time of the time window the number of milliseconds since the Unix epoch.
	EndTime *nrtime.EpochMilliseconds `json:"endTime"`
	// The start time of the time window the number of milliseconds since the Unix epoch.
	StartTime *nrtime.EpochMilliseconds `json:"startTime"`
}

// UnavailableEntity - An entity that is unavailable.
type UnavailableEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from UnavailableEntity
func (x UnavailableEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from UnavailableEntity
func (x UnavailableEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from UnavailableEntity
func (x UnavailableEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from UnavailableEntity
func (x UnavailableEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from UnavailableEntity
func (x UnavailableEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from UnavailableEntity
func (x UnavailableEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from UnavailableEntity
func (x UnavailableEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from UnavailableEntity
func (x UnavailableEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from UnavailableEntity
func (x UnavailableEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from UnavailableEntity
func (x UnavailableEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from UnavailableEntity
func (x UnavailableEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from UnavailableEntity
func (x UnavailableEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from UnavailableEntity
func (x UnavailableEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from UnavailableEntity
func (x UnavailableEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from UnavailableEntity
func (x UnavailableEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from UnavailableEntity
func (x UnavailableEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from UnavailableEntity
func (x UnavailableEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from UnavailableEntity
func (x UnavailableEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from UnavailableEntity
func (x UnavailableEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from UnavailableEntity
func (x UnavailableEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from UnavailableEntity
func (x UnavailableEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from UnavailableEntity
func (x UnavailableEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from UnavailableEntity
func (x UnavailableEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from UnavailableEntity
func (x UnavailableEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from UnavailableEntity
func (x UnavailableEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from UnavailableEntity
func (x UnavailableEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from UnavailableEntity
func (x UnavailableEntity) GetType() string {
	return x.Type
}

func (x *UnavailableEntity) ImplementsAlertableEntity() {}

func (x *UnavailableEntity) ImplementsEntity() {}

// UnavailableEntityOutline - An entity outline that is unavailable.
type UnavailableEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
}

// GetAccount returns a pointer to the value of Account from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetDomain returns a pointer to the value of Domain from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from UnavailableEntityOutline
func (x UnavailableEntityOutline) GetType() string {
	return x.Type
}

func (x *UnavailableEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *UnavailableEntityOutline) ImplementsEntityOutline() {}

// WorkloadEntity - A workload entity.
type WorkloadEntity struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// Violations on the entity that were open during the specified time window. This will return up to 500 violations - if there are more in the time window selected, you must narrow the time window or look at fewer entities.
	AlertViolations []EntityAlertViolation `json:"alertViolations,omitempty"`
	Collection      EntityCollection       `json:"collection,omitempty"`
	// When the workload was created.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The user that created the workload.
	CreatedByUser users.UserReference `json:"createdByUser,omitempty"`
	// Retrieve the deployment event(s). Ordered by timestamp DESC.
	DeploymentSearch ChangeTrackingDeploymentSearchResult `json:"deploymentSearch,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// Make an `Entity` scoped query to NRDB with a NRQL string.
	//
	// A relevant `WHERE` clause will be added to your query to scope data to the entity in question.
	//
	// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about generating a query string.
	NRDBQuery nrdb.NRDBResultContainer `json:"nrdbQuery,omitempty"`
	// Poll for the results of a previously-executed asychronous NRDB query.
	//
	// The `queryId` is available in the `queryProgress` data returned by the original asynchronous query.
	//
	// See [this page](https://docs.newrelic.com/docs/apis/nerdgraph/examples/async-queries-nrql-tutorial) for additional asynchronous query documentation.
	NRDBQueryProgress nrdb.NRDBResultContainer `json:"nrdbQueryProgress,omitempty"`
	// The name of this entity.
	Name        string                 `json:"name,omitempty"`
	NerdStorage NerdStorageEntityScope `json:"nerdStorage,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// Recent violations on the entity.
	RecentAlertViolations []EntityAlertViolation `json:"recentAlertViolations,omitempty"`
	// Related entities result with optional filtering.
	RelatedEntities EntityRelationshipRelatedEntitiesResult `json:"relatedEntities,omitempty"`
	// A list of the entities' relationships.
	//
	// For more information, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-relationships-api-tutorial).
	Relationships []EntityRelationship `json:"relationships,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The tags applied to the entity with their metadata.
	TagsWithMetadata []EntityTagWithMetadata `json:"tagsWithMetadata,omitempty"`
	// Look up Distributed Tracing summary data for the selected `EntityGuid`
	TracingSummary DistributedTracingEntityTracingSummary `json:"tracingSummary,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// When the workload was last updated.
	UpdatedAt *nrtime.EpochMilliseconds `json:"updatedAt,omitempty"`
	// Status of the workload.
	WorkloadStatus WorkloadStatus `json:"workloadStatus,omitempty"`
}

// GetAccount returns a pointer to the value of Account from WorkloadEntity
func (x WorkloadEntity) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from WorkloadEntity
func (x WorkloadEntity) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from WorkloadEntity
func (x WorkloadEntity) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetAlertViolations returns a pointer to the value of AlertViolations from WorkloadEntity
func (x WorkloadEntity) GetAlertViolations() []EntityAlertViolation {
	return x.AlertViolations
}

// GetCollection returns a pointer to the value of Collection from WorkloadEntity
func (x WorkloadEntity) GetCollection() EntityCollection {
	return x.Collection
}

// GetCreatedAt returns a pointer to the value of CreatedAt from WorkloadEntity
func (x WorkloadEntity) GetCreatedAt() *nrtime.EpochMilliseconds {
	return x.CreatedAt
}

// GetCreatedByUser returns a pointer to the value of CreatedByUser from WorkloadEntity
func (x WorkloadEntity) GetCreatedByUser() users.UserReference {
	return x.CreatedByUser
}

// GetDeploymentSearch returns a pointer to the value of DeploymentSearch from WorkloadEntity
func (x WorkloadEntity) GetDeploymentSearch() ChangeTrackingDeploymentSearchResult {
	return x.DeploymentSearch
}

// GetDomain returns a pointer to the value of Domain from WorkloadEntity
func (x WorkloadEntity) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from WorkloadEntity
func (x WorkloadEntity) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from WorkloadEntity
func (x WorkloadEntity) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from WorkloadEntity
func (x WorkloadEntity) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from WorkloadEntity
func (x WorkloadEntity) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from WorkloadEntity
func (x WorkloadEntity) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from WorkloadEntity
func (x WorkloadEntity) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from WorkloadEntity
func (x WorkloadEntity) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetNRDBQuery returns a pointer to the value of NRDBQuery from WorkloadEntity
func (x WorkloadEntity) GetNRDBQuery() nrdb.NRDBResultContainer {
	return x.NRDBQuery
}

// GetNRDBQueryProgress returns a pointer to the value of NRDBQueryProgress from WorkloadEntity
func (x WorkloadEntity) GetNRDBQueryProgress() nrdb.NRDBResultContainer {
	return x.NRDBQueryProgress
}

// GetName returns a pointer to the value of Name from WorkloadEntity
func (x WorkloadEntity) GetName() string {
	return x.Name
}

// GetNerdStorage returns a pointer to the value of NerdStorage from WorkloadEntity
func (x WorkloadEntity) GetNerdStorage() NerdStorageEntityScope {
	return x.NerdStorage
}

// GetPermalink returns a pointer to the value of Permalink from WorkloadEntity
func (x WorkloadEntity) GetPermalink() string {
	return x.Permalink
}

// GetRecentAlertViolations returns a pointer to the value of RecentAlertViolations from WorkloadEntity
func (x WorkloadEntity) GetRecentAlertViolations() []EntityAlertViolation {
	return x.RecentAlertViolations
}

// GetRelatedEntities returns a pointer to the value of RelatedEntities from WorkloadEntity
func (x WorkloadEntity) GetRelatedEntities() EntityRelationshipRelatedEntitiesResult {
	return x.RelatedEntities
}

// GetRelationships returns a pointer to the value of Relationships from WorkloadEntity
func (x WorkloadEntity) GetRelationships() []EntityRelationship {
	return x.Relationships
}

// GetReporting returns a pointer to the value of Reporting from WorkloadEntity
func (x WorkloadEntity) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from WorkloadEntity
func (x WorkloadEntity) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from WorkloadEntity
func (x WorkloadEntity) GetTags() []EntityTag {
	return x.Tags
}

// GetTagsWithMetadata returns a pointer to the value of TagsWithMetadata from WorkloadEntity
func (x WorkloadEntity) GetTagsWithMetadata() []EntityTagWithMetadata {
	return x.TagsWithMetadata
}

// GetTracingSummary returns a pointer to the value of TracingSummary from WorkloadEntity
func (x WorkloadEntity) GetTracingSummary() DistributedTracingEntityTracingSummary {
	return x.TracingSummary
}

// GetType returns a pointer to the value of Type from WorkloadEntity
func (x WorkloadEntity) GetType() string {
	return x.Type
}

// GetUpdatedAt returns a pointer to the value of UpdatedAt from WorkloadEntity
func (x WorkloadEntity) GetUpdatedAt() *nrtime.EpochMilliseconds {
	return x.UpdatedAt
}

// GetWorkloadStatus returns a pointer to the value of WorkloadStatus from WorkloadEntity
func (x WorkloadEntity) GetWorkloadStatus() WorkloadStatus {
	return x.WorkloadStatus
}

func (x *WorkloadEntity) ImplementsAlertableEntity() {}

func (x *WorkloadEntity) ImplementsCollectionEntity() {}

func (x *WorkloadEntity) ImplementsEntity() {}

// WorkloadEntityOutline - A workload entity outline.
type WorkloadEntityOutline struct {
	Account accounts.AccountOutline `json:"account,omitempty"`
	// The New Relic account ID associated with this entity.
	AccountID int `json:"accountId,omitempty"`
	// The current alerting severity of the entity.
	AlertSeverity EntityAlertSeverity `json:"alertSeverity,omitempty"`
	// When the workload was created.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The user that created the workload.
	CreatedByUser users.UserReference `json:"createdByUser,omitempty"`
	// The entity's domain
	Domain string `json:"domain,omitempty"`
	// A value representing the combination of the entity's domain and type.
	EntityType EntityType `json:"entityType,omitempty"`
	// The date of last time the entity has updated any of its fields.
	FirstIndexedAt *nrtime.EpochMilliseconds `json:"firstIndexedAt,omitempty"`
	// A unique entity identifier.
	GUID common.EntityGUID `json:"guid,omitempty"`
	// The list of golden metrics for a specific entity
	GoldenMetrics EntityGoldenContextScopedGoldenMetrics `json:"goldenMetrics,omitempty"`
	// The list of golden tags for a specific entityType.
	GoldenTags EntityGoldenContextScopedGoldenTags `json:"goldenTags,omitempty"`
	// The time the entity was indexed.
	IndexedAt *nrtime.EpochMilliseconds `json:"indexedAt,omitempty"`
	// The last time the entity's reporting status changed.
	LastReportingChangeAt *nrtime.EpochMilliseconds `json:"lastReportingChangeAt,omitempty"`
	// The name of this entity.
	Name string `json:"name,omitempty"`
	// The url to the entity.
	Permalink string `json:"permalink,omitempty"`
	// The reporting status of the entity. If New Relic is successfully collecting data from your application, this will be true.
	Reporting bool `json:"reporting,omitempty"`
	// The service level defined for the entity.
	ServiceLevel ServiceLevelDefinition `json:"serviceLevel,omitempty"`
	// The tags applied to the entity.
	//
	// For details on tags, as well as query and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/graphql-tagging-api-tutorial).
	Tags []EntityTag `json:"tags,omitempty"`
	// The entity's type
	Type string `json:"type,omitempty"`
	// When the workload was last updated.
	UpdatedAt *nrtime.EpochMilliseconds `json:"updatedAt,omitempty"`
	// Status of the workload.
	WorkloadStatus WorkloadStatus `json:"workloadStatus,omitempty"`
}

// GetAccount returns a pointer to the value of Account from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetAccount() accounts.AccountOutline {
	return x.Account
}

// GetAccountID returns a pointer to the value of AccountID from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetAccountID() int {
	return x.AccountID
}

// GetAlertSeverity returns a pointer to the value of AlertSeverity from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetAlertSeverity() EntityAlertSeverity {
	return x.AlertSeverity
}

// GetCreatedAt returns a pointer to the value of CreatedAt from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetCreatedAt() *nrtime.EpochMilliseconds {
	return x.CreatedAt
}

// GetCreatedByUser returns a pointer to the value of CreatedByUser from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetCreatedByUser() users.UserReference {
	return x.CreatedByUser
}

// GetDomain returns a pointer to the value of Domain from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetDomain() string {
	return x.Domain
}

// GetEntityType returns a pointer to the value of EntityType from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetEntityType() EntityType {
	return x.EntityType
}

// GetFirstIndexedAt returns a pointer to the value of FirstIndexedAt from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetFirstIndexedAt() *nrtime.EpochMilliseconds {
	return x.FirstIndexedAt
}

// GetGUID returns a pointer to the value of GUID from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetGUID() common.EntityGUID {
	return x.GUID
}

// GetGoldenMetrics returns a pointer to the value of GoldenMetrics from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetGoldenMetrics() EntityGoldenContextScopedGoldenMetrics {
	return x.GoldenMetrics
}

// GetGoldenTags returns a pointer to the value of GoldenTags from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetGoldenTags() EntityGoldenContextScopedGoldenTags {
	return x.GoldenTags
}

// GetIndexedAt returns a pointer to the value of IndexedAt from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetIndexedAt() *nrtime.EpochMilliseconds {
	return x.IndexedAt
}

// GetLastReportingChangeAt returns a pointer to the value of LastReportingChangeAt from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetLastReportingChangeAt() *nrtime.EpochMilliseconds {
	return x.LastReportingChangeAt
}

// GetName returns a pointer to the value of Name from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetName() string {
	return x.Name
}

// GetPermalink returns a pointer to the value of Permalink from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetPermalink() string {
	return x.Permalink
}

// GetReporting returns a pointer to the value of Reporting from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetReporting() bool {
	return x.Reporting
}

// GetServiceLevel returns a pointer to the value of ServiceLevel from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetServiceLevel() ServiceLevelDefinition {
	return x.ServiceLevel
}

// GetTags returns a pointer to the value of Tags from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetTags() []EntityTag {
	return x.Tags
}

// GetType returns a pointer to the value of Type from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetType() string {
	return x.Type
}

// GetUpdatedAt returns a pointer to the value of UpdatedAt from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetUpdatedAt() *nrtime.EpochMilliseconds {
	return x.UpdatedAt
}

// GetWorkloadStatus returns a pointer to the value of WorkloadStatus from WorkloadEntityOutline
func (x WorkloadEntityOutline) GetWorkloadStatus() WorkloadStatus {
	return x.WorkloadStatus
}

func (x *WorkloadEntityOutline) ImplementsAlertableEntityOutline() {}

func (x *WorkloadEntityOutline) ImplementsEntityOutline() {}

// WorkloadEntityRef - A reference to a New Relic entity.
type WorkloadEntityRef struct {
	// The unique entity identifier in New Relic.
	GUID common.EntityGUID `json:"guid,omitempty"`
}

// WorkloadStatus - Detailed information about the status of a workload.
type WorkloadStatus struct {
	// A description that provides additional details about the status of the workload.
	Description string `json:"description,omitempty"`
	// Indicates where the status value derives from.
	StatusSource WorkloadStatusSource `json:"statusSource,omitempty"`
	// The status of the workload.
	StatusValue WorkloadStatusValue `json:"statusValue,omitempty"`
	// A short description of the status of the workload.
	Summary string `json:"summary,omitempty"`
}

type entitiesResponse struct {
	Actor Actor `json:"actor"`
}

type entityResponse struct {
	Actor Actor `json:"actor"`
}

type entitySearchResponse struct {
	Actor Actor `json:"actor"`
}

// AgentApplicationSettingsErrorCollectorHttpStatus - A list of HTTP status codes, such as "404" or "500."
type AgentApplicationSettingsErrorCollectorHttpStatus string

// AgentApplicationSettingsRawJsConfiguration - The "raw" configuration values for configuring the javascript client.
type AgentApplicationSettingsRawJsConfiguration map[string]interface{}

// AttributeMap - This scalar represents a map of attributes in the form of key-value pairs.
type AttributeMap map[string]interface{}

// DashboardWidgetRawConfiguration - Raw JSON payload with full configuration of a widget.
type DashboardWidgetRawConfiguration []byte

// EntityAlertViolationInt - The `ViolationInt` scalar type represents 52-bit signed integers
type EntityAlertViolationInt int

// Float - The `Float` scalar type represents signed double-precision fractional
// values as specified by
// [IEEE 754](https://en.wikipedia.org/wiki/IEEE_754).
type Float string

// NerdStorageDocument - This scalar represents a NerdStorage document.
type NerdStorageDocument string

// SecureValue - The `SecureValue` scalar represents a secure value, ie a password, an API key, etc.
type SecureValue string

// SemVer - The `SemVer` scalar represents a version designation conforming to the SemVer specification.
type SemVer string
type AlertableEntityInterface interface {
	ImplementsAlertableEntity()
}

// UnmarshalAlertableEntityInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalAlertableEntityInterface(b []byte) (*AlertableEntityInterface, error) {
	var err error

	var rawMessageAlertableEntity map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageAlertableEntity)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageAlertableEntity) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageAlertableEntity["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "ApmApplicationEntity":
			var interfaceType ApmApplicationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "ApmDatabaseInstanceEntity":
			var interfaceType ApmDatabaseInstanceEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "ApmExternalServiceEntity":
			var interfaceType ApmExternalServiceEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "BrowserApplicationEntity":
			var interfaceType BrowserApplicationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "DashboardEntity":
			var interfaceType DashboardEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "ExternalEntity":
			var interfaceType ExternalEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "GenericEntity":
			var interfaceType GenericEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "GenericInfrastructureEntity":
			var interfaceType GenericInfrastructureEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureAwsLambdaFunctionEntity":
			var interfaceType InfrastructureAwsLambdaFunctionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureHostEntity":
			var interfaceType InfrastructureHostEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "KeyTransactionEntity":
			var interfaceType KeyTransactionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "MobileApplicationEntity":
			var interfaceType MobileApplicationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "SecureCredentialEntity":
			var interfaceType SecureCredentialEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "SyntheticMonitorEntity":
			var interfaceType SyntheticMonitorEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "TeamEntity":
			var interfaceType TeamEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "ThirdPartyServiceEntity":
			var interfaceType ThirdPartyServiceEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "UnavailableEntity":
			var interfaceType UnavailableEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		case "WorkloadEntity":
			var interfaceType WorkloadEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageAlertableEntity {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface AlertableEntity did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface AlertableEntity was not matched against all PossibleTypes: %s", typeName)
}

type AlertableEntityOutlineInterface interface {
	ImplementsAlertableEntityOutline()
}

// UnmarshalAlertableEntityOutlineInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalAlertableEntityOutlineInterface(b []byte) (*AlertableEntityOutlineInterface, error) {
	var err error

	var rawMessageAlertableEntityOutline map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageAlertableEntityOutline)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageAlertableEntityOutline) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageAlertableEntityOutline["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "ApmApplicationEntityOutline":
			var interfaceType ApmApplicationEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ApmDatabaseInstanceEntityOutline":
			var interfaceType ApmDatabaseInstanceEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ApmExternalServiceEntityOutline":
			var interfaceType ApmExternalServiceEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "BrowserApplicationEntityOutline":
			var interfaceType BrowserApplicationEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "DashboardEntityOutline":
			var interfaceType DashboardEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ExternalEntityOutline":
			var interfaceType ExternalEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "GenericEntityOutline":
			var interfaceType GenericEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "GenericInfrastructureEntityOutline":
			var interfaceType GenericInfrastructureEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureAwsLambdaFunctionEntityOutline":
			var interfaceType InfrastructureAwsLambdaFunctionEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureHostEntityOutline":
			var interfaceType InfrastructureHostEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "KeyTransactionEntityOutline":
			var interfaceType KeyTransactionEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "MobileApplicationEntityOutline":
			var interfaceType MobileApplicationEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "SecureCredentialEntityOutline":
			var interfaceType SecureCredentialEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "SyntheticMonitorEntityOutline":
			var interfaceType SyntheticMonitorEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "TeamEntityOutline":
			var interfaceType TeamEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ThirdPartyServiceEntityOutline":
			var interfaceType ThirdPartyServiceEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "UnavailableEntityOutline":
			var interfaceType UnavailableEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "WorkloadEntityOutline":
			var interfaceType WorkloadEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertableEntityOutlineInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageAlertableEntityOutline {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface AlertableEntityOutline did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface AlertableEntityOutline was not matched against all PossibleTypes: %s", typeName)
}

// ApmBrowserApplicationEntity - The `ApmBrowserApplicationEntity` interface provides detailed information for the Browser App injected by an APM Application.
type ApmBrowserApplicationEntityInterface interface {
	ImplementsApmBrowserApplicationEntity()
}

// UnmarshalApmBrowserApplicationEntityInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalApmBrowserApplicationEntityInterface(b []byte) (*ApmBrowserApplicationEntityInterface, error) {
	var err error

	var rawMessageApmBrowserApplicationEntity map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageApmBrowserApplicationEntity)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageApmBrowserApplicationEntity) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageApmBrowserApplicationEntity["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "ApmApplicationEntity":
			var interfaceType ApmApplicationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx ApmBrowserApplicationEntityInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageApmBrowserApplicationEntity {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface ApmBrowserApplicationEntity did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface ApmBrowserApplicationEntity was not matched against all PossibleTypes: %s", typeName)
}

// ApmBrowserApplicationEntityOutline - The `ApmBrowserApplicationEntityOutline` interface provides detailed information for the Browser App injected by an APM Application.
type ApmBrowserApplicationEntityOutlineInterface interface {
	ImplementsApmBrowserApplicationEntityOutline()
}

// UnmarshalApmBrowserApplicationEntityOutlineInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalApmBrowserApplicationEntityOutlineInterface(b []byte) (*ApmBrowserApplicationEntityOutlineInterface, error) {
	var err error

	var rawMessageApmBrowserApplicationEntityOutline map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageApmBrowserApplicationEntityOutline)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageApmBrowserApplicationEntityOutline) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageApmBrowserApplicationEntityOutline["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "ApmApplicationEntityOutline":
			var interfaceType ApmApplicationEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx ApmBrowserApplicationEntityOutlineInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageApmBrowserApplicationEntityOutline {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface ApmBrowserApplicationEntityOutline did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface ApmBrowserApplicationEntityOutline was not matched against all PossibleTypes: %s", typeName)
}

// CollectionEntity - A group of entities defined by entity search queries and specific GUIDs
type CollectionEntityInterface interface {
	ImplementsCollectionEntity()
}

// UnmarshalCollectionEntityInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalCollectionEntityInterface(b []byte) (*CollectionEntityInterface, error) {
	var err error

	var rawMessageCollectionEntity map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageCollectionEntity)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageCollectionEntity) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageCollectionEntity["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "TeamEntity":
			var interfaceType TeamEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CollectionEntityInterface = &interfaceType

			return &xxx, nil
		case "WorkloadEntity":
			var interfaceType WorkloadEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CollectionEntityInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageCollectionEntity {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface CollectionEntity did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface CollectionEntity was not matched against all PossibleTypes: %s", typeName)
}

// Entity - The `Entity` interface allows fetching detailed entity information for a single entity.
//
// To understand more about entities and entity types, look at [our docs](https://docs.newrelic.com/docs/what-are-new-relic-entities).
type EntityInterface interface {
	ImplementsEntity()
	GetAccountID() int
	GetDomain() string
	GetGUID() common.EntityGUID
	GetName() string
	GetTags() []EntityTag
	GetType() string
	GetServiceLevel() ServiceLevelDefinition
}

// UnmarshalEntityInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalEntityInterface(b []byte) (*EntityInterface, error) {
	var err error

	var rawMessageEntity map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageEntity)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageEntity) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageEntity["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "ApmApplicationEntity":
			var interfaceType ApmApplicationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "ApmDatabaseInstanceEntity":
			var interfaceType ApmDatabaseInstanceEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "ApmExternalServiceEntity":
			var interfaceType ApmExternalServiceEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "BrowserApplicationEntity":
			var interfaceType BrowserApplicationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "DashboardEntity":
			var interfaceType DashboardEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "ExternalEntity":
			var interfaceType ExternalEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "GenericEntity":
			var interfaceType GenericEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "GenericInfrastructureEntity":
			var interfaceType GenericInfrastructureEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureAwsLambdaFunctionEntity":
			var interfaceType InfrastructureAwsLambdaFunctionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureHostEntity":
			var interfaceType InfrastructureHostEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "KeyTransactionEntity":
			var interfaceType KeyTransactionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "MobileApplicationEntity":
			var interfaceType MobileApplicationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "SecureCredentialEntity":
			var interfaceType SecureCredentialEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "SyntheticMonitorEntity":
			var interfaceType SyntheticMonitorEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "TeamEntity":
			var interfaceType TeamEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "ThirdPartyServiceEntity":
			var interfaceType ThirdPartyServiceEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "UnavailableEntity":
			var interfaceType UnavailableEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		case "WorkloadEntity":
			var interfaceType WorkloadEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageEntity {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface Entity did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface Entity was not matched against all PossibleTypes: %s", typeName)
}

// EntityManagementActor - Represents an actor.
type EntityManagementActorInterface interface {
	ImplementsEntityManagementActor()
}

// UnmarshalEntityManagementActorInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalEntityManagementActorInterface(b []byte) (*EntityManagementActorInterface, error) {
	var err error

	var rawMessageEntityManagementActor map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageEntityManagementActor)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageEntityManagementActor) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageEntityManagementActor["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "EntityManagementSystemActor":
			var interfaceType EntityManagementSystemActor
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementActorInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementUserActor":
			var interfaceType EntityManagementUserActor
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementActorInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageEntityManagementActor {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface EntityManagementActor did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface EntityManagementActor was not matched against all PossibleTypes: %s", typeName)
}

// EntityManagementEntity - The Entity interface.
type EntityManagementEntityInterface interface {
	ImplementsEntityManagementEntity()
}

// UnmarshalEntityManagementEntityInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalEntityManagementEntityInterface(b []byte) (*EntityManagementEntityInterface, error) {
	var err error

	var rawMessageEntityManagementEntity map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageEntityManagementEntity)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageEntityManagementEntity) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageEntityManagementEntity["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "EntityManagementAgentConfigurationEntity":
			var interfaceType EntityManagementAgentConfigurationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementAgentConfigurationVersionEntity":
			var interfaceType EntityManagementAgentConfigurationVersionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementAgentEffectiveConfigurationEntity":
			var interfaceType EntityManagementAgentEffectiveConfigurationEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementAgentEntity":
			var interfaceType EntityManagementAgentEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementAgentTypeDefinitionEntity":
			var interfaceType EntityManagementAgentTypeDefinitionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementCollectionEntity":
			var interfaceType EntityManagementCollectionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementFleetEntity":
			var interfaceType EntityManagementFleetEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementGenericEntity":
			var interfaceType EntityManagementGenericEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementScorecardEntity":
			var interfaceType EntityManagementScorecardEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementScorecardRuleEntity":
			var interfaceType EntityManagementScorecardRuleEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementTeamEntity":
			var interfaceType EntityManagementTeamEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementTeamsOrganizationSettingsEntity":
			var interfaceType EntityManagementTeamsOrganizationSettingsEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		case "EntityManagementUserEntity":
			var interfaceType EntityManagementUserEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityManagementEntityInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageEntityManagementEntity {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface EntityManagementEntity did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface EntityManagementEntity was not matched against all PossibleTypes: %s", typeName)
}

// EntityOutline - The `EntityOutline` interface object allows fetching basic entity data for many entities at a time.
//
// To understand more about entities and entity types, look at [our docs](https://docs.newrelic.com/docs/what-are-new-relic-entities).
type EntityOutlineInterface interface {
	ImplementsEntityOutline()
	GetAccountID() int
	GetDomain() string
	GetGUID() common.EntityGUID
	GetName() string
	GetType() string
	GetTags() []EntityTag
}

// UnmarshalEntityOutlineInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalEntityOutlineInterface(b []byte) (*EntityOutlineInterface, error) {
	var err error

	var rawMessageEntityOutline map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageEntityOutline)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageEntityOutline) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageEntityOutline["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "ApmApplicationEntityOutline":
			var interfaceType ApmApplicationEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ApmDatabaseInstanceEntityOutline":
			var interfaceType ApmDatabaseInstanceEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ApmExternalServiceEntityOutline":
			var interfaceType ApmExternalServiceEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "BrowserApplicationEntityOutline":
			var interfaceType BrowserApplicationEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "DashboardEntityOutline":
			var interfaceType DashboardEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ExternalEntityOutline":
			var interfaceType ExternalEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "GenericEntityOutline":
			var interfaceType GenericEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "GenericInfrastructureEntityOutline":
			var interfaceType GenericInfrastructureEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureAwsLambdaFunctionEntityOutline":
			var interfaceType InfrastructureAwsLambdaFunctionEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureHostEntityOutline":
			var interfaceType InfrastructureHostEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "KeyTransactionEntityOutline":
			var interfaceType KeyTransactionEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "MobileApplicationEntityOutline":
			var interfaceType MobileApplicationEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "SecureCredentialEntityOutline":
			var interfaceType SecureCredentialEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "SyntheticMonitorEntityOutline":
			var interfaceType SyntheticMonitorEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "TeamEntityOutline":
			var interfaceType TeamEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "ThirdPartyServiceEntityOutline":
			var interfaceType ThirdPartyServiceEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "UnavailableEntityOutline":
			var interfaceType UnavailableEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "WorkloadEntityOutline":
			var interfaceType WorkloadEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityOutlineInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageEntityOutline {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface EntityOutline did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface EntityOutline was not matched against all PossibleTypes: %s", typeName)
}

// EntityRelationshipEdge - An entity relationship.
type EntityRelationshipEdgeInterface interface {
	ImplementsEntityRelationshipEdge()
}

// UnmarshalEntityRelationshipEdgeInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalEntityRelationshipEdgeInterface(b []byte) (*EntityRelationshipEdgeInterface, error) {
	var err error

	var rawMessageEntityRelationshipEdge map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageEntityRelationshipEdge)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageEntityRelationshipEdge) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageEntityRelationshipEdge["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "EntityRelationshipDetectedEdge":
			var interfaceType EntityRelationshipDetectedEdge
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityRelationshipEdgeInterface = &interfaceType

			return &xxx, nil
		case "EntityRelationshipUserDefinedEdge":
			var interfaceType EntityRelationshipUserDefinedEdge
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx EntityRelationshipEdgeInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageEntityRelationshipEdge {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface EntityRelationshipEdge did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface EntityRelationshipEdge was not matched against all PossibleTypes: %s", typeName)
}

type InfrastructureIntegrationEntityInterface interface {
	ImplementsInfrastructureIntegrationEntity()
}

// UnmarshalInfrastructureIntegrationEntityInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalInfrastructureIntegrationEntityInterface(b []byte) (*InfrastructureIntegrationEntityInterface, error) {
	var err error

	var rawMessageInfrastructureIntegrationEntity map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageInfrastructureIntegrationEntity)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageInfrastructureIntegrationEntity) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageInfrastructureIntegrationEntity["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "GenericInfrastructureEntity":
			var interfaceType GenericInfrastructureEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx InfrastructureIntegrationEntityInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureAwsLambdaFunctionEntity":
			var interfaceType InfrastructureAwsLambdaFunctionEntity
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx InfrastructureIntegrationEntityInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageInfrastructureIntegrationEntity {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface InfrastructureIntegrationEntity did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface InfrastructureIntegrationEntity was not matched against all PossibleTypes: %s", typeName)
}

type InfrastructureIntegrationEntityOutlineInterface interface {
	ImplementsInfrastructureIntegrationEntityOutline()
}

// UnmarshalInfrastructureIntegrationEntityOutlineInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalInfrastructureIntegrationEntityOutlineInterface(b []byte) (*InfrastructureIntegrationEntityOutlineInterface, error) {
	var err error

	var rawMessageInfrastructureIntegrationEntityOutline map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageInfrastructureIntegrationEntityOutline)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageInfrastructureIntegrationEntityOutline) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageInfrastructureIntegrationEntityOutline["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "GenericInfrastructureEntityOutline":
			var interfaceType GenericInfrastructureEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx InfrastructureIntegrationEntityOutlineInterface = &interfaceType

			return &xxx, nil
		case "InfrastructureAwsLambdaFunctionEntityOutline":
			var interfaceType InfrastructureAwsLambdaFunctionEntityOutline
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx InfrastructureIntegrationEntityOutlineInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageInfrastructureIntegrationEntityOutline {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface InfrastructureIntegrationEntityOutline did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface InfrastructureIntegrationEntityOutline was not matched against all PossibleTypes: %s", typeName)
}
