// Code generated by tutone: DO NOT EDIT
package entities

import (
	"context"

	"github.com/newrelic/newrelic-client-go/v2/pkg/common"
	"github.com/newrelic/newrelic-client-go/v2/pkg/errors"
)

// Adds the provided tags to your specified entity, without deleting existing ones.
// The maximum number of tag-values per entity is 100; if the sum of existing and new tag-values if over the limit this mutation will fail.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingAddTagsToEntity(
	gUID common.EntityGUID,
	tags []TaggingTagInput,
) (*TaggingMutationResult, error) {
	return a.TaggingAddTagsToEntityWithContext(context.Background(),
		gUID,
		tags,
	)
}

// Adds the provided tags to your specified entity, without deleting existing ones.
// The maximum number of tag-values per entity is 100; if the sum of existing and new tag-values if over the limit this mutation will fail.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingAddTagsToEntityWithContext(
	ctx context.Context,
	gUID common.EntityGUID,
	tags []TaggingTagInput,
) (*TaggingMutationResult, error) {

	resp := TaggingAddTagsToEntityQueryResponse{}
	vars := map[string]interface{}{
		"guid": gUID,
		"tags": tags,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, TaggingAddTagsToEntityMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.TaggingMutationResult, nil
}

type TaggingAddTagsToEntityQueryResponse struct {
	TaggingMutationResult TaggingMutationResult `json:"TaggingAddTagsToEntity"`
}

const TaggingAddTagsToEntityMutation = `mutation(
	$guid: EntityGuid!,
	$tags: [TaggingTagInput!]!,
) { taggingAddTagsToEntity(
	guid: $guid,
	tags: $tags,
) {
	errors {
		message
		type
	}
} }`

// Delete specific tag keys from the entity.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingDeleteTagFromEntity(
	gUID common.EntityGUID,
	tagKeys []string,
) (*TaggingMutationResult, error) {
	return a.TaggingDeleteTagFromEntityWithContext(context.Background(),
		gUID,
		tagKeys,
	)
}

// Delete specific tag keys from the entity.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingDeleteTagFromEntityWithContext(
	ctx context.Context,
	gUID common.EntityGUID,
	tagKeys []string,
) (*TaggingMutationResult, error) {

	resp := TaggingDeleteTagFromEntityQueryResponse{}
	vars := map[string]interface{}{
		"guid":    gUID,
		"tagKeys": tagKeys,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, TaggingDeleteTagFromEntityMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.TaggingMutationResult, nil
}

type TaggingDeleteTagFromEntityQueryResponse struct {
	TaggingMutationResult TaggingMutationResult `json:"TaggingDeleteTagFromEntity"`
}

const TaggingDeleteTagFromEntityMutation = `mutation(
	$guid: EntityGuid!,
	$tagKeys: [String!]!,
) { taggingDeleteTagFromEntity(
	guid: $guid,
	tagKeys: $tagKeys,
) {
	errors {
		message
		type
	}
} }`

// Delete specific tag key-values from the entity.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingDeleteTagValuesFromEntity(
	gUID common.EntityGUID,
	tagValues []TaggingTagValueInput,
) (*TaggingMutationResult, error) {
	return a.TaggingDeleteTagValuesFromEntityWithContext(context.Background(),
		gUID,
		tagValues,
	)
}

// Delete specific tag key-values from the entity.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingDeleteTagValuesFromEntityWithContext(
	ctx context.Context,
	gUID common.EntityGUID,
	tagValues []TaggingTagValueInput,
) (*TaggingMutationResult, error) {

	resp := TaggingDeleteTagValuesFromEntityQueryResponse{}
	vars := map[string]interface{}{
		"guid":      gUID,
		"tagValues": tagValues,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, TaggingDeleteTagValuesFromEntityMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.TaggingMutationResult, nil
}

type TaggingDeleteTagValuesFromEntityQueryResponse struct {
	TaggingMutationResult TaggingMutationResult `json:"TaggingDeleteTagValuesFromEntity"`
}

const TaggingDeleteTagValuesFromEntityMutation = `mutation(
	$guid: EntityGuid!,
	$tagValues: [TaggingTagValueInput!]!,
) { taggingDeleteTagValuesFromEntity(
	guid: $guid,
	tagValues: $tagValues,
) {
	errors {
		message
		type
	}
} }`

// Replaces the entity's entire set of tags with the provided tag set.
// The maximum number of tag-values per entity is 100; if more than 100 tag-values are provided this mutation will fail.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingReplaceTagsOnEntity(
	gUID common.EntityGUID,
	tags []TaggingTagInput,
) (*TaggingMutationResult, error) {
	return a.TaggingReplaceTagsOnEntityWithContext(context.Background(),
		gUID,
		tags,
	)
}

// Replaces the entity's entire set of tags with the provided tag set.
// The maximum number of tag-values per entity is 100; if more than 100 tag-values are provided this mutation will fail.
//
// For details and mutation examples, visit [our docs](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-tagging-api-tutorial).
func (a *Entities) TaggingReplaceTagsOnEntityWithContext(
	ctx context.Context,
	gUID common.EntityGUID,
	tags []TaggingTagInput,
) (*TaggingMutationResult, error) {

	resp := TaggingReplaceTagsOnEntityQueryResponse{}
	vars := map[string]interface{}{
		"guid": gUID,
		"tags": tags,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, TaggingReplaceTagsOnEntityMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.TaggingMutationResult, nil
}

type TaggingReplaceTagsOnEntityQueryResponse struct {
	TaggingMutationResult TaggingMutationResult `json:"TaggingReplaceTagsOnEntity"`
}

const TaggingReplaceTagsOnEntityMutation = `mutation(
	$guid: EntityGuid!,
	$tags: [TaggingTagInput!]!,
) { taggingReplaceTagsOnEntity(
	guid: $guid,
	tags: $tags,
) {
	errors {
		message
		type
	}
} }`

// Fetch a list of entities.
//
// You can fetch a max of 25 entities in one query.
//
// For more details on entities, visit our [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
func (a *Entities) GetEntities(
	gUIDs []common.EntityGUID,
) (*[]EntityInterface, error) {
	return a.GetEntitiesWithContext(context.Background(),
		gUIDs,
	)
}

// Fetch a list of entities.
//
// You can fetch a max of 25 entities in one query.
//
// For more details on entities, visit our [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
func (a *Entities) GetEntitiesWithContext(
	ctx context.Context,
	gUIDs []common.EntityGUID,
) (*[]EntityInterface, error) {

	resp := entitiesResponse{}
	vars := map[string]interface{}{
		"guids": gUIDs,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, getEntitiesQuery, vars, &resp); err != nil {
		return nil, err
	}

	if len(resp.Actor.Entities) == 0 {
		return nil, errors.NewNotFound("")
	}

	return &resp.Actor.Entities, nil
}

const getEntitiesQuery = `query(
	$guids: [EntityGuid]!,
) { actor { entities(
	guids: $guids,
) {
	account {
		id
		name
		reportingEventTypes
	}
	accountId
	alertSeverity
	deploymentSearch {
		results {
			changelog
			commit
			deepLink
			deploymentId
			deploymentType
			description
			entityGuid
			groupId
			timestamp
			user
			version
		}
	}
	domain
	entityType
	firstIndexedAt
	goldenMetrics {
		context {
			account
			guid
		}
		metrics {
			metricName
			name
			query
			title
			unit
		}
	}
	goldenTags {
		context {
			account
			guid
		}
		tags {
			key
		}
	}
	guid
	indexedAt
	lastReportingChangeAt
	name
	permalink
	recentAlertViolations {
		agentUrl
		alertSeverity
		closedAt
		label
		level
		openedAt
		violationId
		violationUrl
	}
	relatedEntities {
		nextCursor
		results {
			__typename
			createdAt
			type
			... on EntityRelationshipDetectedEdge {
				__typename
			}
			... on EntityRelationshipUserDefinedEdge {
				__typename
			}
		}
	}
	reporting
	serviceLevel {
		indicators {
			createdAt
			description
			entityGuid
			guid
			id
			name
			updatedAt
		}
	}
	tags {
		key
		values
	}
	tagsWithMetadata {
		key
		values {
			mutable
			value
		}
	}
	tracingSummary {
		errorTraceCount
		percentOfAllErrorTraces
	}
	type
	... on ApmApplicationEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		apmBrowserSummary {
			ajaxRequestThroughput
			ajaxResponseTimeAverage
			jsErrorRate
			pageLoadThroughput
			pageLoadTimeAverage
		}
		apmSettings {
			alias
			captureMemcacheKeys
			originalName
			tracerType
		}
		apmSummary {
			apdexScore
			errorRate
			hostCount
			instanceCount
			nonWebResponseTimeAverage
			nonWebThroughput
			responseTimeAverage
			throughput
			webResponseTimeAverage
			webThroughput
		}
		applicationId
		applicationInstancesV2 {
			nextCursor
		}
		deployments {
			changelog
			description
			permalink
			revision
			timestamp
			user
		}
		language
		metricGroupingIssues {
			deniedMetricsCount
			deniedMetricsRatePerMinute
			metricNormalizationRuleId
			mitigated
			mitigationRateThreshold
			mitigationRateWindowSize
		}
		metricNormalizationRules {
			action
			applicationGuid
			applicationName
			createdAt
			enabled
			evalOrder
			id
			matchExpression
			notes
			replacement
			terminateChain
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		runningAgentVersions {
			maxVersion
			minVersion
		}
		settings {
			apdexTarget
			serverSideConfig
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on ApmDatabaseInstanceEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		host
		portOrPath
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		vendor
	}
	... on ApmExternalServiceEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		externalSummary {
			responseTimeAverage
			throughput
		}
		host
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on BrowserApplicationEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		agentInstallType
		applicationId
		browserProperties {
			jsConfig
			jsConfigScript
			jsLoaderScript
		}
		browserSummary {
			ajaxRequestThroughput
			ajaxResponseTimeAverage
			jsErrorRate
			pageLoadThroughput
			pageLoadTimeAverage
			pageLoadTimeMedian
			spaResponseTimeAverage
			spaResponseTimeMedian
		}
		metricGroupingIssues {
			deniedMetricsCount
			deniedMetricsRatePerMinute
			metricNormalizationRuleId
			mitigated
			mitigationRateThreshold
			mitigationRateWindowSize
		}
		metricNormalizationRules {
			action
			applicationGuid
			applicationName
			createdAt
			enabled
			evalOrder
			id
			matchExpression
			notes
			replacement
			terminateChain
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		runningAgentVersions {
			maxSemanticVersion
			maxVersion
			minSemanticVersion
			minVersion
		}
		segmentAllowListAggregate {
			segments
		}
		servingApmApplicationId
		settings {
			apdexTarget
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on DashboardEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		createdAt
		dashboardParentGuid
		description
		owner {
			email
			userId
		}
		pages {
			createdAt
			description
			guid
			name
			updatedAt
		}
		permissions
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		updatedAt
		variables {
			isMultiSelection
			name
			replacementStrategy
			title
			type
		}
	}
	... on ExternalEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on GenericEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on GenericInfrastructureEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		integrationTypeCode
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on InfrastructureAwsLambdaFunctionEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		integrationTypeCode
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		runtime
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on InfrastructureHostEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		hostSummary {
			cpuUtilizationPercent
			diskUsedPercent
			memoryUsedPercent
			networkReceiveRate
			networkTransmitRate
			servicesCount
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on KeyTransactionEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		apdexTarget
		application {
			guid
		}
		browserApdexTarget
		metricName
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on MobileApplicationEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		applicationId
		metricGroupingIssues {
			deniedMetricsCount
			deniedMetricsRatePerMinute
			metricNormalizationRuleId
			mitigated
			mitigationRateThreshold
			mitigationRateWindowSize
		}
		metricNormalizationRules {
			action
			applicationGuid
			applicationName
			createdAt
			enabled
			evalOrder
			id
			matchExpression
			notes
			replacement
			terminateChain
		}
		mobileProperties {
			applicationToken
		}
		mobileSettings {
			useCrashReports
		}
		mobileSummary {
			appLaunchCount
			crashCount
			crashRate
			httpErrorRate
			httpRequestCount
			httpRequestRate
			httpResponseTimeAverage
			mobileSessionCount
			networkFailureRate
			usersAffectedCount
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on SecureCredentialEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		description
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		secureCredentialId
		secureCredentialSummary {
			failingMonitorCount
			monitorCount
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		updatedAt
	}
	... on SyntheticMonitorEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		monitorId
		monitorSummary {
			locationsFailing
			locationsRunning
			status
			successRate
		}
		monitorType
		monitoredUrl
		period
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on TeamEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on ThirdPartyServiceEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on UnavailableEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on WorkloadEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		createdAt
		createdByUser {
			email
			gravatar
			id
			name
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		updatedAt
		workloadStatus {
			description
			statusSource
			statusValue
			summary
		}
	}
} } }`

// Fetch a single entity.
//
// For more details on entities, visit our [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
func (a *Entities) GetEntity(
	gUID common.EntityGUID,
) (*EntityInterface, error) {
	return a.GetEntityWithContext(context.Background(),
		gUID,
	)
}

// Fetch a single entity.
//
// For more details on entities, visit our [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
func (a *Entities) GetEntityWithContext(
	ctx context.Context,
	gUID common.EntityGUID,
) (*EntityInterface, error) {

	resp := entityResponse{}
	vars := map[string]interface{}{
		"guid": gUID,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, getEntityQuery, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.Actor.Entity, nil
}

const getEntityQuery = `query(
	$guid: EntityGuid!,
) { actor { entity(
	guid: $guid,
) {
	account {
		id
		name
		reportingEventTypes
	}
	accountId
	alertSeverity
	deploymentSearch {
		results {
			changelog
			commit
			deepLink
			deploymentId
			deploymentType
			description
			entityGuid
			groupId
			timestamp
			user
			version
		}
	}
	domain
	entityType
	firstIndexedAt
	goldenMetrics {
		context {
			account
			guid
		}
		metrics {
			definition {
				eventId
				eventObjectId
				facet
				from
				select
				where
			}
			metricName
			name
			originalDefinitions {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				selectorValue
			}
			originalQueries {
				query
				selectorValue
			}
			query
			title
			unit
		}
	}
	goldenTags {
		context {
			account
			guid
		}
		tags {
			key
		}
	}
	guid
	indexedAt
	lastReportingChangeAt
	name
	permalink
	recentAlertViolations {
		agentUrl
		alertSeverity
		closedAt
		label
		level
		openedAt
		violationId
		violationUrl
	}
	relatedEntities {
		nextCursor
		results {
			__typename
			createdAt
			source {
				accountId
				entity {
					__typename
					accountId
					alertSeverity
					domain
					entityType
					firstIndexedAt
					guid
					indexedAt
					lastReportingChangeAt
					name
					permalink
					reporting
					type
					... on ApmApplicationEntityOutline {
						__typename
						applicationId
						language
					}
					... on ApmDatabaseInstanceEntityOutline {
						__typename
						host
						portOrPath
						vendor
					}
					... on ApmExternalServiceEntityOutline {
						__typename
						host
					}
					... on BrowserApplicationEntityOutline {
						__typename
						agentInstallType
						applicationId
						servingApmApplicationId
					}
					... on DashboardEntityOutline {
						__typename
						createdAt
						dashboardParentGuid
						permissions
						updatedAt
					}
					... on ExternalEntityOutline {
						__typename
					}
					... on GenericEntityOutline {
						__typename
					}
					... on GenericInfrastructureEntityOutline {
						__typename
						integrationTypeCode
					}
					... on InfrastructureAwsLambdaFunctionEntityOutline {
						__typename
						integrationTypeCode
						runtime
					}
					... on InfrastructureHostEntityOutline {
						__typename
					}
					... on KeyTransactionEntityOutline {
						__typename
					}
					... on MobileApplicationEntityOutline {
						__typename
						applicationId
					}
					... on SecureCredentialEntityOutline {
						__typename
						description
						secureCredentialId
						updatedAt
					}
					... on SyntheticMonitorEntityOutline {
						__typename
						monitorId
						monitorType
						monitoredUrl
						period
					}
					... on TeamEntityOutline {
						__typename
					}
					... on ThirdPartyServiceEntityOutline {
						__typename
					}
					... on UnavailableEntityOutline {
						__typename
					}
					... on WorkloadEntityOutline {
						__typename
						createdAt
						updatedAt
					}
				}
				guid
			}
			target {
				accountId
				entity {
					__typename
					accountId
					alertSeverity
					domain
					entityType
					firstIndexedAt
					guid
					indexedAt
					lastReportingChangeAt
					name
					permalink
					reporting
					type
					... on ApmApplicationEntityOutline {
						__typename
						applicationId
						language
					}
					... on ApmDatabaseInstanceEntityOutline {
						__typename
						host
						portOrPath
						vendor
					}
					... on ApmExternalServiceEntityOutline {
						__typename
						host
					}
					... on BrowserApplicationEntityOutline {
						__typename
						agentInstallType
						applicationId
						servingApmApplicationId
					}
					... on DashboardEntityOutline {
						__typename
						createdAt
						dashboardParentGuid
						permissions
						updatedAt
					}
					... on ExternalEntityOutline {
						__typename
					}
					... on GenericEntityOutline {
						__typename
					}
					... on GenericInfrastructureEntityOutline {
						__typename
						integrationTypeCode
					}
					... on InfrastructureAwsLambdaFunctionEntityOutline {
						__typename
						integrationTypeCode
						runtime
					}
					... on InfrastructureHostEntityOutline {
						__typename
					}
					... on KeyTransactionEntityOutline {
						__typename
					}
					... on MobileApplicationEntityOutline {
						__typename
						applicationId
					}
					... on SecureCredentialEntityOutline {
						__typename
						description
						secureCredentialId
						updatedAt
					}
					... on SyntheticMonitorEntityOutline {
						__typename
						monitorId
						monitorType
						monitoredUrl
						period
					}
					... on TeamEntityOutline {
						__typename
					}
					... on ThirdPartyServiceEntityOutline {
						__typename
					}
					... on UnavailableEntityOutline {
						__typename
					}
					... on WorkloadEntityOutline {
						__typename
						createdAt
						updatedAt
					}
				}
				guid
			}
			type
			... on EntityRelationshipDetectedEdge {
				__typename
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
			}
			... on EntityRelationshipUserDefinedEdge {
				__typename
				createdByUser {
					email
					gravatar
					id
					name
				}
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
			}
		}
	}
	reporting
	serviceLevel {
		indicators {
			createdAt
			createdBy {
				email
				gravatar
				id
				name
			}
			description
			entityGuid
			events {
				account {
					id
					name
				}
				badEvents {
					from
					where
				}
				goodEvents {
					from
					where
				}
				validEvents {
					from
					where
				}
			}
			guid
			id
			name
			objectives {
				description
				name
				target
			}
			resultQueries {
				goodEvents {
					nrql
				}
				indicator {
					nrql
				}
				validEvents {
					nrql
				}
			}
			updatedAt
			updatedBy {
				email
				gravatar
				id
				name
			}
		}
	}
	tags {
		key
		values
	}
	tagsWithMetadata {
		key
		values {
			mutable
			value
		}
	}
	tracingSummary {
		errorTraceCount
		percentOfAllErrorTraces
	}
	type
	... on ApmApplicationEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		apmBrowserSummary {
			ajaxRequestThroughput
			ajaxResponseTimeAverage
			jsErrorRate
			pageLoadThroughput
			pageLoadTimeAverage
		}
		apmSettings {
			alias
			apmConfig {
				apdexTarget
				useServerSideConfig
			}
			captureMemcacheKeys
			errorCollector {
				enabled
				expectedErrorClasses
				expectedErrorCodes
				ignoredErrorClasses
				ignoredErrorCodes
			}
			jfr {
				enabled
			}
			originalName
			slowSql {
				enabled
			}
			threadProfiler {
				enabled
			}
			tracerType
			transactionTracer {
				captureMemcacheKeys
				enabled
				explainEnabled
				explainThresholdType
				explainThresholdValue
				logSql
				recordSql
				stackTraceThreshold
				transactionThresholdType
				transactionThresholdValue
			}
		}
		apmSummary {
			apdexScore
			errorRate
			hostCount
			instanceCount
			nonWebResponseTimeAverage
			nonWebThroughput
			responseTimeAverage
			throughput
			webResponseTimeAverage
			webThroughput
		}
		applicationId
		applicationInstances {
			agentSettingsAttributes {
				attribute
				value
			}
			details {
				host
				hostDisplayName
				id
				instanceName
				language
				name
			}
			environmentAttributes {
				attribute
				value
			}
			modules {
				attributes {
					name
					value
				}
				name
				version
			}
		}
		applicationInstancesV2 {
			applicationInstances {
				agentSettingsAttributes {
					attribute
					value
				}
				details {
					host
					hostDisplayName
					id
					instanceName
					language
					name
				}
				environmentAttributes {
					attribute
					value
				}
				modules {
					name
					version
				}
			}
			nextCursor
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		deployments {
			changelog
			description
			permalink
			revision
			timestamp
			user
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		language
		metricGroupingIssues {
			deniedMetricsCount
			deniedMetricsRatePerMinute
			metricNormalizationRuleId
			mitigated
			mitigationRateThreshold
			mitigationRateWindowSize
		}
		metricNormalizationRules {
			action
			applicationGuid
			applicationName
			createdAt
			enabled
			evalOrder
			id
			matchExpression
			notes
			replacement
			terminateChain
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		runningAgentVersions {
			maxVersion
			minVersion
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		settings {
			apdexTarget
			serverSideConfig
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on ApmDatabaseInstanceEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		host
		portOrPath
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		vendor
	}
	... on ApmExternalServiceEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		externalSummary {
			responseTimeAverage
			throughput
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		host
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on BrowserApplicationEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		agentInstallType
		applicationId
		browserProperties {
			jsConfig
			jsConfigScript
			jsLoaderScript
		}
		browserSettings {
			browserConfig {
				apdexTarget
			}
			browserMonitoring {
				ajax {
					denyList
				}
				distributedTracing {
					allowedOrigins
					corsEnabled
					corsUseNewrelicHeader
					corsUseTracecontextHeaders
					enabled
					excludeNewrelicHeader
				}
				loader
				pinnedVersion
				privacy {
					cookiesEnabled
				}
			}
			sessionReplay {
				autoStart
				blockSelector
				collectFonts
				enabled
				errorSamplingRate
				inlineImages
				inlineStylesheet
				maskAllInputs
				maskInputOptions {
					color
					date
					datetimeLocal
					email
					month
					number
					range
					search
					select
					tel
					text
					textArea
					time
					url
					week
				}
				maskTextSelector
				samplingRate
			}
			sessionTrace {
				enabled
				errorSamplingRate
				mode
				samplingRate
			}
		}
		browserSummary {
			ajaxRequestThroughput
			ajaxResponseTimeAverage
			jsErrorRate
			pageLoadThroughput
			pageLoadTimeAverage
			pageLoadTimeMedian
			spaResponseTimeAverage
			spaResponseTimeMedian
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		metricGroupingIssues {
			deniedMetricsCount
			deniedMetricsRatePerMinute
			metricNormalizationRuleId
			mitigated
			mitigationRateThreshold
			mitigationRateWindowSize
		}
		metricNormalizationRules {
			action
			applicationGuid
			applicationName
			createdAt
			enabled
			evalOrder
			id
			matchExpression
			notes
			replacement
			terminateChain
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		runningAgentVersions {
			maxSemanticVersion
			maxVersion
			minSemanticVersion
			minVersion
		}
		segmentAllowListAggregate {
			segments
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		servingApmApplicationId
		settings {
			apdexTarget
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on DashboardEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		createdAt
		dashboardParentGuid
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		description
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		owner {
			email
			userId
		}
		pages {
			createdAt
			description
			guid
			name
			owner {
				email
				userId
			}
			updatedAt
			widgets {
				id
				layout {
					column
					height
					row
					width
				}
				linkedEntities {
					__typename
					accountId
					alertSeverity
					domain
					entityType
					firstIndexedAt
					guid
					indexedAt
					lastReportingChangeAt
					name
					permalink
					reporting
					type
					... on ApmApplicationEntityOutline {
						__typename
						applicationId
						language
					}
					... on ApmDatabaseInstanceEntityOutline {
						__typename
						host
						portOrPath
						vendor
					}
					... on ApmExternalServiceEntityOutline {
						__typename
						host
					}
					... on BrowserApplicationEntityOutline {
						__typename
						agentInstallType
						applicationId
						servingApmApplicationId
					}
					... on DashboardEntityOutline {
						__typename
						createdAt
						dashboardParentGuid
						permissions
						updatedAt
					}
					... on ExternalEntityOutline {
						__typename
					}
					... on GenericEntityOutline {
						__typename
					}
					... on GenericInfrastructureEntityOutline {
						__typename
						integrationTypeCode
					}
					... on InfrastructureAwsLambdaFunctionEntityOutline {
						__typename
						integrationTypeCode
						runtime
					}
					... on InfrastructureHostEntityOutline {
						__typename
					}
					... on KeyTransactionEntityOutline {
						__typename
					}
					... on MobileApplicationEntityOutline {
						__typename
						applicationId
					}
					... on SecureCredentialEntityOutline {
						__typename
						description
						secureCredentialId
						updatedAt
					}
					... on SyntheticMonitorEntityOutline {
						__typename
						monitorId
						monitorType
						monitoredUrl
						period
					}
					... on TeamEntityOutline {
						__typename
					}
					... on ThirdPartyServiceEntityOutline {
						__typename
					}
					... on UnavailableEntityOutline {
						__typename
					}
					... on WorkloadEntityOutline {
						__typename
						createdAt
						updatedAt
					}
				}
				rawConfiguration
				title
				visualization {
					id
				}
			}
		}
		permissions
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		updatedAt
		variables {
			defaultValue {
				string
			}
			defaultValues {
				value {
					string
				}
			}
			isMultiSelection
			items {
				title
				value
			}
			name
			nrqlQuery {
				accountIds
				query
			}
			options {
				excluded
				ignoreTimeRange
			}
			replacementStrategy
			title
			type
		}
	}
	... on ExternalEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on GenericEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on GenericInfrastructureEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		integrationTypeCode
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on InfrastructureAwsLambdaFunctionEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		integrationTypeCode
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		runtime
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on InfrastructureHostEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		hostSummary {
			cpuUtilizationPercent
			diskUsedPercent
			memoryUsedPercent
			networkReceiveRate
			networkTransmitRate
			servicesCount
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on KeyTransactionEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		apdexTarget
		application {
			entity {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				accountId
				alertSeverity
				domain
				entityType
				firstIndexedAt
				guid
				indexedAt
				lastReportingChangeAt
				name
				permalink
				reporting
				tags {
					key
					values
				}
				type
				... on ApmApplicationEntityOutline {
					__typename
					applicationId
					language
				}
				... on ApmDatabaseInstanceEntityOutline {
					__typename
					host
					portOrPath
					vendor
				}
				... on ApmExternalServiceEntityOutline {
					__typename
					host
				}
				... on BrowserApplicationEntityOutline {
					__typename
					agentInstallType
					applicationId
					servingApmApplicationId
				}
				... on DashboardEntityOutline {
					__typename
					createdAt
					dashboardParentGuid
					permissions
					updatedAt
				}
				... on ExternalEntityOutline {
					__typename
				}
				... on GenericEntityOutline {
					__typename
				}
				... on GenericInfrastructureEntityOutline {
					__typename
					integrationTypeCode
				}
				... on InfrastructureAwsLambdaFunctionEntityOutline {
					__typename
					integrationTypeCode
					runtime
				}
				... on InfrastructureHostEntityOutline {
					__typename
				}
				... on KeyTransactionEntityOutline {
					__typename
				}
				... on MobileApplicationEntityOutline {
					__typename
					applicationId
				}
				... on SecureCredentialEntityOutline {
					__typename
					description
					secureCredentialId
					updatedAt
				}
				... on SyntheticMonitorEntityOutline {
					__typename
					monitorId
					monitorType
					monitoredUrl
					period
				}
				... on TeamEntityOutline {
					__typename
				}
				... on ThirdPartyServiceEntityOutline {
					__typename
				}
				... on UnavailableEntityOutline {
					__typename
				}
				... on WorkloadEntityOutline {
					__typename
					createdAt
					updatedAt
				}
			}
			guid
		}
		browserApdexTarget
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		metricName
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on MobileApplicationEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		applicationId
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		exception {
			stackTrace {
				frames {
					filepath
					formatted
					line
					name
				}
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		metricGroupingIssues {
			deniedMetricsCount
			deniedMetricsRatePerMinute
			metricNormalizationRuleId
			mitigated
			mitigationRateThreshold
			mitigationRateWindowSize
		}
		metricNormalizationRules {
			action
			applicationGuid
			applicationName
			createdAt
			enabled
			evalOrder
			id
			matchExpression
			notes
			replacement
			terminateChain
		}
		mobileProperties {
			applicationToken
		}
		mobileSettings {
			applicationExitInfo {
				enabled
			}
			networkSettings {
				aliases {
					alias
					hosts
				}
				filterMode
				hideList
				ignoredStatusCodeRules {
					hosts
					statusCodes
				}
				showList
			}
			useCrashReports
		}
		mobileSummary {
			appLaunchCount
			crashCount
			crashRate
			httpErrorRate
			httpRequestCount
			httpRequestRate
			httpResponseTimeAverage
			mobileSessionCount
			networkFailureRate
			usersAffectedCount
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on SecureCredentialEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		description
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		secureCredentialId
		secureCredentialSummary {
			failingMonitorCount
			monitorCount
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		updatedAt
	}
	... on SyntheticMonitorEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		monitorId
		monitorSummary {
			locationsFailing
			locationsRunning
			status
			successRate
		}
		monitorType
		monitoredUrl
		period
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on TeamEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on ThirdPartyServiceEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on UnavailableEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
	}
	... on WorkloadEntity {
		__typename
		account {
			id
			name
			reportingEventTypes
		}
		createdAt
		createdByUser {
			email
			gravatar
			id
			name
		}
		deploymentSearch {
			results {
				changelog
				commit
				deepLink
				deploymentId
				deploymentType
				description
				entityGuid
				groupId
				timestamp
				user
				version
			}
		}
		goldenMetrics {
			context {
				account
				guid
			}
			metrics {
				definition {
					eventId
					eventObjectId
					facet
					from
					select
					where
				}
				metricName
				name
				originalDefinitions {
					selectorValue
				}
				originalQueries {
					query
					selectorValue
				}
				query
				title
				unit
			}
		}
		goldenTags {
			context {
				account
				guid
			}
			tags {
				key
			}
		}
		recentAlertViolations {
			agentUrl
			alertSeverity
			closedAt
			label
			level
			openedAt
			violationId
			violationUrl
		}
		relatedEntities {
			nextCursor
			results {
				__typename
				createdAt
				source {
					accountId
					guid
				}
				target {
					accountId
					guid
				}
				type
				... on EntityRelationshipDetectedEdge {
					__typename
				}
				... on EntityRelationshipUserDefinedEdge {
					__typename
				}
			}
		}
		serviceLevel {
			indicators {
				createdAt
				createdBy {
					email
					gravatar
					id
					name
				}
				description
				entityGuid
				guid
				id
				name
				objectives {
					description
					name
					target
				}
				updatedAt
				updatedBy {
					email
					gravatar
					id
					name
				}
			}
		}
		tags {
			key
			values
		}
		tagsWithMetadata {
			key
			values {
				mutable
				value
			}
		}
		tracingSummary {
			errorTraceCount
			percentOfAllErrorTraces
		}
		updatedAt
		workloadStatus {
			description
			statusSource
			statusValue
			summary
		}
	}
} } }`

// Search for entities using a custom query.
//
// For more details on how to create a custom query
// and what entity data you can request, visit our
// [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
//
// Note: you must supply either a `query` OR a `queryBuilder` argument, not both.
func (a *Entities) GetEntitySearch(
	options EntitySearchOptions,
	query string,
	queryBuilder EntitySearchQueryBuilder,
	sortBy []EntitySearchSortCriteria,
	sortByWithDirection []SortCriterionWithDirection,
) (*EntitySearch, error) {
	return a.GetEntitySearchWithContext(context.Background(),
		options,
		query,
		queryBuilder,
		sortBy,
		sortByWithDirection,
	)
}

// Search for entities using a custom query.
//
// For more details on how to create a custom query
// and what entity data you can request, visit our
// [entity docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/use-new-relic-graphql-api-query-entities).
//
// Note: you must supply either a `query` OR a `queryBuilder` argument, not both.
func (a *Entities) GetEntitySearchWithContext(
	ctx context.Context,
	options EntitySearchOptions,
	query string,
	queryBuilder EntitySearchQueryBuilder,
	sortBy []EntitySearchSortCriteria,
	sortByWithDirection []SortCriterionWithDirection,
) (*EntitySearch, error) {

	resp := entitySearchResponse{}
	vars := map[string]interface{}{
		"options":             options,
		"query":               query,
		"queryBuilder":        queryBuilder,
		"sortBy":              sortBy,
		"sortByWithDirection": sortByWithDirection,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, getEntitySearchQuery, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.Actor.EntitySearch, nil
}

const getEntitySearchQuery = `query(
	$queryBuilder: EntitySearchQueryBuilder,
) { actor { entitySearch(
	queryBuilder: $queryBuilder,
) {
	count
	query
	results {
		entities {
			__typename
			account {
				id
				name
				reportingEventTypes
			}
			accountId
			alertSeverity
			domain
			entityType
			firstIndexedAt
			goldenMetrics {
				context {
					account
					guid
				}
				metrics {
					metricName
					name
					query
					title
					unit
				}
			}
			goldenTags {
				context {
					account
					guid
				}
				tags {
					key
				}
			}
			guid
			indexedAt
			lastReportingChangeAt
			name
			permalink
			reporting
			serviceLevel {
				indicators {
					createdAt
					description
					entityGuid
					guid
					id
					name
					updatedAt
				}
			}
			tags {
				key
				values
			}
			type
			... on ApmApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				apmBrowserSummary {
					ajaxRequestThroughput
					ajaxResponseTimeAverage
					jsErrorRate
					pageLoadThroughput
					pageLoadTimeAverage
				}
				apmSummary {
					apdexScore
					errorRate
					hostCount
					instanceCount
					nonWebResponseTimeAverage
					nonWebThroughput
					responseTimeAverage
					throughput
					webResponseTimeAverage
					webThroughput
				}
				applicationId
				language
				runningAgentVersions {
					maxVersion
					minVersion
				}
				settings {
					apdexTarget
					serverSideConfig
				}
				tags {
					key
					values
				}
			}
			... on ApmDatabaseInstanceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				host
				portOrPath
				tags {
					key
					values
				}
				vendor
			}
			... on ApmExternalServiceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				externalSummary {
					responseTimeAverage
					throughput
				}
				host
				tags {
					key
					values
				}
			}
			... on BrowserApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				agentInstallType
				applicationId
				browserSummary {
					ajaxRequestThroughput
					ajaxResponseTimeAverage
					jsErrorRate
					pageLoadThroughput
					pageLoadTimeAverage
					pageLoadTimeMedian
					spaResponseTimeAverage
					spaResponseTimeMedian
				}
				runningAgentVersions {
					maxSemanticVersion
					maxVersion
					minSemanticVersion
					minVersion
				}
				servingApmApplicationId
				settings {
					apdexTarget
				}
				tags {
					key
					values
				}
			}
			... on DashboardEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				createdAt
				dashboardParentGuid
				owner {
					email
					userId
				}
				permissions
				tags {
					key
					values
				}
				updatedAt
			}
			... on ExternalEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on GenericEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on GenericInfrastructureEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				integrationTypeCode
				tags {
					key
					values
				}
			}
			... on InfrastructureAwsLambdaFunctionEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				integrationTypeCode
				runtime
				tags {
					key
					values
				}
			}
			... on InfrastructureHostEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				hostSummary {
					cpuUtilizationPercent
					diskUsedPercent
					memoryUsedPercent
					networkReceiveRate
					networkTransmitRate
					servicesCount
				}
				tags {
					key
					values
				}
			}
			... on KeyTransactionEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on MobileApplicationEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				applicationId
				mobileSummary {
					appLaunchCount
					crashCount
					crashRate
					httpErrorRate
					httpRequestCount
					httpRequestRate
					httpResponseTimeAverage
					mobileSessionCount
					networkFailureRate
					usersAffectedCount
				}
				tags {
					key
					values
				}
			}
			... on SecureCredentialEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				description
				secureCredentialId
				secureCredentialSummary {
					failingMonitorCount
					monitorCount
				}
				tags {
					key
					values
				}
				updatedAt
			}
			... on SyntheticMonitorEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				monitorId
				monitorSummary {
					locationsFailing
					locationsRunning
					status
					successRate
				}
				monitorType
				monitoredUrl
				period
				tags {
					key
					values
				}
			}
			... on TeamEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on ThirdPartyServiceEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on UnavailableEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				tags {
					key
					values
				}
			}
			... on WorkloadEntityOutline {
				__typename
				account {
					id
					name
					reportingEventTypes
				}
				createdAt
				createdByUser {
					email
					gravatar
					id
					name
				}
				tags {
					key
					values
				}
				updatedAt
				workloadStatus {
					description
					statusSource
					statusValue
					summary
				}
			}
		}
		nextCursor
	}
	types {
		count
		domain
		entityType
		type
	}
} } }`
