// Code generated by tutone: DO NOT EDIT
package dashboards

import (
	"context"
	"fmt"

	"github.com/newrelic/newrelic-client-go/v2/pkg/common"
)

// Create a `DashboardEntity`
func (a *Dashboards) DashboardCreate(
	accountID int,
	dashboard DashboardInput,
) (*DashboardCreateResult, error) {
	return a.DashboardCreateWithContext(context.Background(),
		accountID,
		dashboard,
	)
}

// Create a `DashboardEntity`
func (a *Dashboards) DashboardCreateWithContext(
	ctx context.Context,
	accountID int,
	dashboard DashboardInput,
) (*DashboardCreateResult, error) {

	resp := DashboardCreateQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"dashboard": dashboard,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, DashboardCreateMutation, vars, &resp); err != nil {
		return nil, err
	}

	if len(resp.DashboardCreateResult.Errors) > 0 {
		errs := fmt.Errorf("query error")
		for _, err := range resp.DashboardCreateResult.Errors {
			errs = fmt.Errorf("%w; %s", errs, err.Description)
		}
		return nil, errs
	}

	return &resp.DashboardCreateResult, nil
}

type DashboardCreateQueryResponse struct {
	DashboardCreateResult DashboardCreateResult `json:"DashboardCreate"`
}

const DashboardCreateMutation = `mutation(
	$accountId: Int!,
	$dashboard: DashboardInput!,
) { dashboardCreate(
	accountId: $accountId,
	dashboard: $dashboard,
) {
	entityResult {
		accountId
		createdAt
		description
		guid
		name
		owner {
			email
			userId
		}
		pages {
			createdAt
			description
			guid
			name
			owner {
				email
				userId
			}
			updatedAt
			widgets {
				configuration {
					area {
						nrqlQueries {
							accountId
							query
						}
					}
					bar {
						nrqlQueries {
							accountId
							query
						}
					}
					billboard {
						nrqlQueries {
							accountId
							query
						}
						thresholds {
							alertSeverity
							value
						}
					}
					line {
						nrqlQueries {
							accountId
							query
						}
					}
					markdown {
						text
					}
					pie {
						nrqlQueries {
							accountId
							query
						}
					}
					table {
						nrqlQueries {
							accountId
							query
						}
					}
				}
				id
				layout {
					column
					height
					row
					width
				}
				linkedEntities {
					__typename
					account {
						id
						name
						reportingEventTypes
					}
					accountId
					alertSeverity
					domain
					entityType
					firstIndexedAt
					guid
					indexedAt
					lastReportingChangeAt
					name
					permalink
					reporting
					serviceLevel {
						indicators {
							createdAt
							createdBy {
								email
								gravatar
								id
								name
							}
							description
							entityGuid
							events {
								account {
									id
									name
								}
								badEvents {
									from
									select {
										attribute
										function
										threshold
									}
									where
								}
								goodEvents {
									from
									select {
										attribute
										function
										threshold
									}
									where
								}
								validEvents {
									from
									select {
										attribute
										function
										threshold
									}
									where
								}
							}
							guid
							id
							name
							objectives {
								description
								name
								resultQueries {
									attainment {
										nrql
									}
								}
								target
								timeWindow {
									rolling {
										count
										unit
									}
								}
							}
							resultQueries {
								goodEvents {
									nrql
								}
								indicator {
									nrql
								}
								validEvents {
									nrql
								}
							}
							slug
							updatedAt
							updatedBy {
								email
								gravatar
								id
								name
							}
						}
					}
					tags {
						key
						values
					}
					type
					... on ApmApplicationEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						apmBrowserSummary {
							ajaxRequestThroughput
							ajaxResponseTimeAverage
							jsErrorRate
							pageLoadThroughput
							pageLoadTimeAverage
						}
						apmSummary {
							apdexScore
							errorRate
							hostCount
							instanceCount
							nonWebResponseTimeAverage
							nonWebThroughput
							responseTimeAverage
							throughput
							webResponseTimeAverage
							webThroughput
						}
						applicationId
						language
						runningAgentVersions {
							maxVersion
							minVersion
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						settings {
							apdexTarget
							serverSideConfig
						}
						tags {
							key
							values
						}
					}
					... on ApmDatabaseInstanceEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						host
						portOrPath
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						vendor
					}
					... on ApmExternalServiceEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						externalSummary {
							responseTimeAverage
							throughput
						}
						host
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on BrowserApplicationEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						agentInstallType
						applicationId
						browserSummary {
							ajaxRequestThroughput
							ajaxResponseTimeAverage
							jsErrorRate
							pageLoadThroughput
							pageLoadTimeAverage
							pageLoadTimeMedian
							spaResponseTimeAverage
							spaResponseTimeMedian
						}
						runningAgentVersions {
							maxSemanticVersion
							maxVersion
							minSemanticVersion
							minVersion
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						servingApmApplicationId
						settings {
							apdexTarget
						}
						tags {
							key
							values
						}
					}
					... on DashboardEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						createdAt
						dashboardParentGuid
						owner {
							email
							userId
						}
						permissions
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						updatedAt
					}
					... on ExternalEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on GenericEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on GenericInfrastructureEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						integrationTypeCode
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on InfrastructureAwsLambdaFunctionEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						integrationTypeCode
						runtime
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on InfrastructureHostEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						hostSummary {
							cpuUtilizationPercent
							diskUsedPercent
							memoryUsedPercent
							networkReceiveRate
							networkTransmitRate
							servicesCount
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on KeyTransactionEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on MobileApplicationEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						applicationId
						mobileSummary {
							appLaunchCount
							crashCount
							crashRate
							httpErrorRate
							httpRequestCount
							httpRequestRate
							httpResponseTimeAverage
							mobileSessionCount
							networkFailureRate
							usersAffectedCount
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on SecureCredentialEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						description
						secureCredentialId
						secureCredentialSummary {
							failingMonitorCount
							monitorCount
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						updatedAt
					}
					... on SyntheticMonitorEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						monitorId
						monitorSummary {
							locationsFailing
							locationsRunning
							status
							successRate
						}
						monitorType
						monitoredUrl
						period
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on TeamEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on ThirdPartyServiceEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on UnavailableEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on WorkloadEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						createdAt
						createdByUser {
							email
							gravatar
							id
							name
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						updatedAt
						workloadStatus {
							description
							statusSource
							statusValue
							summary
						}
					}
				}
				rawConfiguration
				title
				visualization {
					id
				}
			}
		}
		permissions
		updatedAt
		variables {
			defaultValue {
				string
			}
			defaultValues {
				value {
					string
				}
			}
			isMultiSelection
			items {
				title
				value
			}
			name
			nrqlQuery {
				accountIds
				query
			}
			options {
				excluded
				ignoreTimeRange
			}
			replacementStrategy
			title
			type
		}
	}
	errors {
		description
		type
	}
} }`

// Delete an existing `DashboardEntity`
func (a *Dashboards) DashboardDelete(
	gUID common.EntityGUID,
) (*DashboardDeleteResult, error) {
	return a.DashboardDeleteWithContext(context.Background(),
		gUID,
	)
}

// Delete an existing `DashboardEntity`
func (a *Dashboards) DashboardDeleteWithContext(
	ctx context.Context,
	gUID common.EntityGUID,
) (*DashboardDeleteResult, error) {

	resp := DashboardDeleteQueryResponse{}
	vars := map[string]interface{}{
		"guid": gUID,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, DashboardDeleteMutation, vars, &resp); err != nil {
		return nil, err
	}

	// If we got errors back, wrap them all up
	if len(resp.DashboardDeleteResult.Errors) > 0 {
		errs := fmt.Errorf("query error")
		for _, err := range resp.DashboardDeleteResult.Errors {
			errs = fmt.Errorf("%w; %s", errs, err.Description)
		}
		return nil, errs
	}

	return &resp.DashboardDeleteResult, nil
}

type DashboardDeleteQueryResponse struct {
	DashboardDeleteResult DashboardDeleteResult `json:"DashboardDelete"`
}

const DashboardDeleteMutation = `mutation(
	$guid: EntityGuid!,
) { dashboardDelete(
	guid: $guid,
) {
	errors {
		description
		type
	}
	status
} }`

// Update an existing `DashboardEntity`
func (a *Dashboards) DashboardUpdate(
	dashboard DashboardInput,
	gUID common.EntityGUID,
) (*DashboardUpdateResult, error) {
	return a.DashboardUpdateWithContext(context.Background(),
		dashboard,
		gUID,
	)
}

// Update an existing `DashboardEntity`
func (a *Dashboards) DashboardUpdateWithContext(
	ctx context.Context,
	dashboard DashboardInput,
	gUID common.EntityGUID,
) (*DashboardUpdateResult, error) {

	resp := DashboardUpdateQueryResponse{}
	vars := map[string]interface{}{
		"dashboard": dashboard,
		"guid":      gUID,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, DashboardUpdateMutation, vars, &resp); err != nil {
		return nil, err
	}

	// If we got errors back, wrap them all up
	if len(resp.DashboardUpdateResult.Errors) > 0 {
		errs := fmt.Errorf("query error")
		for _, err := range resp.DashboardUpdateResult.Errors {
			errs = fmt.Errorf("%w; %s", errs, err.Description)
		}
		return nil, errs
	}

	return &resp.DashboardUpdateResult, nil
}

type DashboardUpdateQueryResponse struct {
	DashboardUpdateResult DashboardUpdateResult `json:"DashboardUpdate"`
}

const DashboardUpdateMutation = `mutation(
	$dashboard: DashboardInput!,
	$guid: EntityGuid!,
) { dashboardUpdate(
	dashboard: $dashboard,
	guid: $guid,
) {
	entityResult {
		accountId
		createdAt
		description
		guid
		name
		owner {
			email
			userId
		}
		pages {
			createdAt
			description
			guid
			name
			owner {
				email
				userId
			}
			updatedAt
			widgets {
				configuration {
					area {
						nrqlQueries {
							accountId
							query
						}
					}
					bar {
						nrqlQueries {
							accountId
							query
						}
					}
					billboard {
						nrqlQueries {
							accountId
							query
						}
						thresholds {
							alertSeverity
							value
						}
					}
					line {
						nrqlQueries {
							accountId
							query
						}
					}
					markdown {
						text
					}
					pie {
						nrqlQueries {
							accountId
							query
						}
					}
					table {
						nrqlQueries {
							accountId
							query
						}
					}
				}
				id
				layout {
					column
					height
					row
					width
				}
				linkedEntities {
					__typename
					account {
						id
						name
						reportingEventTypes
					}
					accountId
					alertSeverity
					domain
					entityType
					firstIndexedAt
					guid
					indexedAt
					lastReportingChangeAt
					name
					permalink
					reporting
					serviceLevel {
						indicators {
							createdAt
							createdBy {
								email
								gravatar
								id
								name
							}
							description
							entityGuid
							events {
								account {
									id
									name
								}
								badEvents {
									from
									select {
										attribute
										function
										threshold
									}
									where
								}
								goodEvents {
									from
									select {
										attribute
										function
										threshold
									}
									where
								}
								validEvents {
									from
									select {
										attribute
										function
										threshold
									}
									where
								}
							}
							guid
							id
							name
							objectives {
								description
								name
								resultQueries {
									attainment {
										nrql
									}
								}
								target
								timeWindow {
									rolling {
										count
										unit
									}
								}
							}
							resultQueries {
								goodEvents {
									nrql
								}
								indicator {
									nrql
								}
								validEvents {
									nrql
								}
							}
							slug
							updatedAt
							updatedBy {
								email
								gravatar
								id
								name
							}
						}
					}
					tags {
						key
						values
					}
					type
					... on ApmApplicationEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						apmBrowserSummary {
							ajaxRequestThroughput
							ajaxResponseTimeAverage
							jsErrorRate
							pageLoadThroughput
							pageLoadTimeAverage
						}
						apmSummary {
							apdexScore
							errorRate
							hostCount
							instanceCount
							nonWebResponseTimeAverage
							nonWebThroughput
							responseTimeAverage
							throughput
							webResponseTimeAverage
							webThroughput
						}
						applicationId
						language
						runningAgentVersions {
							maxVersion
							minVersion
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						settings {
							apdexTarget
							serverSideConfig
						}
						tags {
							key
							values
						}
					}
					... on ApmDatabaseInstanceEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						host
						portOrPath
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						vendor
					}
					... on ApmExternalServiceEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						externalSummary {
							responseTimeAverage
							throughput
						}
						host
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on BrowserApplicationEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						agentInstallType
						applicationId
						browserSummary {
							ajaxRequestThroughput
							ajaxResponseTimeAverage
							jsErrorRate
							pageLoadThroughput
							pageLoadTimeAverage
							pageLoadTimeMedian
							spaResponseTimeAverage
							spaResponseTimeMedian
						}
						runningAgentVersions {
							maxSemanticVersion
							maxVersion
							minSemanticVersion
							minVersion
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						servingApmApplicationId
						settings {
							apdexTarget
						}
						tags {
							key
							values
						}
					}
					... on DashboardEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						createdAt
						dashboardParentGuid
						owner {
							email
							userId
						}
						permissions
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						updatedAt
					}
					... on ExternalEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on GenericEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on GenericInfrastructureEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						integrationTypeCode
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on InfrastructureAwsLambdaFunctionEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						integrationTypeCode
						runtime
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on InfrastructureHostEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						hostSummary {
							cpuUtilizationPercent
							diskUsedPercent
							memoryUsedPercent
							networkReceiveRate
							networkTransmitRate
							servicesCount
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on KeyTransactionEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on MobileApplicationEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						applicationId
						mobileSummary {
							appLaunchCount
							crashCount
							crashRate
							httpErrorRate
							httpRequestCount
							httpRequestRate
							httpResponseTimeAverage
							mobileSessionCount
							networkFailureRate
							usersAffectedCount
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on SecureCredentialEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						description
						secureCredentialId
						secureCredentialSummary {
							failingMonitorCount
							monitorCount
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						updatedAt
					}
					... on SyntheticMonitorEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						monitorId
						monitorSummary {
							locationsFailing
							locationsRunning
							status
							successRate
						}
						monitorType
						monitoredUrl
						period
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on TeamEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on ThirdPartyServiceEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on UnavailableEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
					}
					... on WorkloadEntityOutline {
						__typename
						account {
							id
							name
							reportingEventTypes
						}
						createdAt
						createdByUser {
							email
							gravatar
							id
							name
						}
						serviceLevel {
							indicators {
								createdAt
								createdBy {
									email
									gravatar
									id
									name
								}
								description
								entityGuid
								events {
									account {
										id
										name
									}
									badEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									goodEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
									validEvents {
										from
										select {
											attribute
											function
											threshold
										}
										where
									}
								}
								guid
								id
								name
								objectives {
									description
									name
									resultQueries {
										attainment {
											nrql
										}
									}
									target
									timeWindow {
										rolling {
											count
											unit
										}
									}
								}
								resultQueries {
									goodEvents {
										nrql
									}
									indicator {
										nrql
									}
									validEvents {
										nrql
									}
								}
								slug
								updatedAt
								updatedBy {
									email
									gravatar
									id
									name
								}
							}
						}
						tags {
							key
							values
						}
						updatedAt
						workloadStatus {
							description
							statusSource
							statusValue
							summary
						}
					}
				}
				rawConfiguration
				title
				visualization {
					id
				}
			}
		}
		permissions
		updatedAt
		variables {
			defaultValue {
				string
			}
			defaultValues {
				value {
					string
				}
			}
			isMultiSelection
			items {
				title
				value
			}
			name
			nrqlQuery {
				accountIds
				query
			}
			options {
				excluded
				ignoreTimeRange
			}
			replacementStrategy
			title
			type
		}
	}
	errors {
		description
		type
	}
} }`
