// Code generated by tutone: DO NOT EDIT
package cloud

import (
	"encoding/json"
	"fmt"

	"github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"
)

// CloudMetricCollectionMode - How metrics will be collected.
type CloudMetricCollectionMode string

var CloudMetricCollectionModeTypes = struct {
	// Metrics will be pulled by NewRelic
	PULL CloudMetricCollectionMode
	// Metrics will be pushed by the provider
	PUSH CloudMetricCollectionMode
}{
	// Metrics will be pulled by NewRelic
	PULL: "PULL",
	// Metrics will be pushed by the provider
	PUSH: "PUSH",
}

// Account - The `Account` object provides general data about the account, as well as
// being the entry point into more detailed data about a single account.
//
// Account configuration data is queried through this object, as well as
// telemetry data that is specific to a single account.
type Account struct {
	// The `cloud` field provides access to cloud integrations configuration data.
	//
	// For details and query examples visit
	// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
	Cloud      CloudAccountFields `json:"cloud,omitempty"`
	ID         int                `json:"id,omitempty"`
	LicenseKey string             `json:"licenseKey,omitempty"`
	Name       string             `json:"name,omitempty"`
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `cloud` field provides access to cloud integrations configuration data scoped to the Actor.
	Cloud CloudActorFields `json:"cloud,omitempty"`
	// The `account` field is the entry point into data that is scoped to a single account.
	Account Account `json:"account,omitempty"`
}

// CloudAPIgatewayIntegration - API Gateway Integration
type CloudAPIgatewayIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify each name or prefix for the Stages that you want to monitor. Filter values are case-sensitive.
	StagePrefixes []string `json:"stagePrefixes,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAPIgatewayIntegration) ImplementsCloudIntegration() {}

// CloudAPIgatewayIntegrationInput - Amazon API Gateway
type CloudAPIgatewayIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each name or prefix for the Stages that you want to monitor. Filter values are case-sensitive.
	StagePrefixes []string `json:"stagePrefixes,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudAccountFields - Cloud integrations related data, including configured integrations and
// all available cloud provider service integrations.
type CloudAccountFields struct {
	// Get one linked provider account.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// Get all linked cloud provider accounts.
	LinkedAccounts []CloudLinkedAccount `json:"linkedAccounts,omitempty"`
	// Get one cloud provider by short name.
	Provider CloudProviderInterface `json:"provider,omitempty"`
	// Get all available cloud providers.
	Providers []CloudProviderInterface `json:"providers,omitempty"`
}

// CloudAccountMutationError - Account Mutation Error
type CloudAccountMutationError struct {
	// The passed linked account identifier.
	LinkedAccountId int `json:"linkedAccountId,omitempty"`
	// The error message.
	Message string `json:"message"`
	// The passed newrelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The passed provider slug.
	ProviderSlug string `json:"providerSlug,omitempty"`
	// The error status.
	Type string `json:"type"`
}

type CloudActorFields struct {
	// Get all linked cloud provider accounts scoped to the Actor.
	LinkedAccounts []CloudLinkedAccount `json:"linkedAccounts,omitempty"`
}

// CloudAlbIntegration - ALB/NLB Integration
type CloudAlbIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// Specify each name or prefix for the LBs that you want to monitor. Filter values are case-sensitive.
	LoadBalancerPrefixes []string `json:"loadBalancerPrefixes,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAlbIntegration) ImplementsCloudIntegration() {}

// CloudAlbIntegrationInput - Elastic Load Balancing - Application Load Balancer (ALB)
type CloudAlbIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// Specify each name or prefix for the LBs that you want to monitor. Filter values are case-sensitive.
	LoadBalancerPrefixes []string `json:"loadBalancerPrefixes,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudAutoscalingIntegration - AutoScaling Integration
type CloudAutoscalingIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAutoscalingIntegration) ImplementsCloudIntegration() {}

// CloudAutoscalingIntegrationInput - AWS Auto Scaling
type CloudAutoscalingIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsAppsyncIntegration - AppSync Integration
type CloudAwsAppsyncIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsAppsyncIntegration) ImplementsCloudIntegration() {}

// CloudAwsAppsyncIntegrationInput - AppSync
type CloudAwsAppsyncIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsAthenaIntegration - Athena Integration
type CloudAwsAthenaIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsAthenaIntegration) ImplementsCloudIntegration() {}

// CloudAwsAthenaIntegrationInput - Athena
type CloudAwsAthenaIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsCognitoIntegration - Cognito Integration
type CloudAwsCognitoIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsCognitoIntegration) ImplementsCloudIntegration() {}

// CloudAwsCognitoIntegrationInput - Cognito
type CloudAwsCognitoIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsConnectIntegration - Connect Integration
type CloudAwsConnectIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsConnectIntegration) ImplementsCloudIntegration() {}

// CloudAwsConnectIntegrationInput - Connect
type CloudAwsConnectIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsDirectconnectIntegration - Direct Connect Integration
type CloudAwsDirectconnectIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsDirectconnectIntegration) ImplementsCloudIntegration() {}

// CloudAwsDirectconnectIntegrationInput - Direct Connect
type CloudAwsDirectconnectIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsDisableIntegrationsInput - List of integrations
type CloudAwsDisableIntegrationsInput struct {
	// API Gateway integration
	APIgateway []CloudDisableAccountIntegrationInput `json:"apigateway,omitempty"`
	// ALB/NLB integration
	Alb []CloudDisableAccountIntegrationInput `json:"alb,omitempty"`
	// AutoScaling integration
	Autoscaling []CloudDisableAccountIntegrationInput `json:"autoscaling,omitempty"`
	// AppSync integration
	AwsAppsync []CloudDisableAccountIntegrationInput `json:"awsAppsync,omitempty"`
	// Athena integration
	AwsAthena []CloudDisableAccountIntegrationInput `json:"awsAthena,omitempty"`
	// Cognito integration
	AwsCognito []CloudDisableAccountIntegrationInput `json:"awsCognito,omitempty"`
	// Connect integration
	AwsConnect []CloudDisableAccountIntegrationInput `json:"awsConnect,omitempty"`
	// Direct Connect integration
	AwsDirectconnect []CloudDisableAccountIntegrationInput `json:"awsDirectconnect,omitempty"`
	// DocumentDB integration
	AwsDocdb []CloudDisableAccountIntegrationInput `json:"awsDocdb,omitempty"`
	// FSx integration
	AwsFsx []CloudDisableAccountIntegrationInput `json:"awsFsx,omitempty"`
	// Glue integration
	AwsGlue []CloudDisableAccountIntegrationInput `json:"awsGlue,omitempty"`
	// Kinesis Data Analytics integration
	AwsKinesisanalytics []CloudDisableAccountIntegrationInput `json:"awsKinesisanalytics,omitempty"`
	// Elemental MediaConvert integration
	AwsMediaconvert []CloudDisableAccountIntegrationInput `json:"awsMediaconvert,omitempty"`
	// MediaPackage VOD integration
	AwsMediapackagevod []CloudDisableAccountIntegrationInput `json:"awsMediapackagevod,omitempty"`
	// Fetch Metadata for AWS integrations integration
	AwsMetadata []CloudDisableAccountIntegrationInput `json:"awsMetadata,omitempty"`
	// MQ integration
	AwsMq []CloudDisableAccountIntegrationInput `json:"awsMq,omitempty"`
	// Fetch ElastiCache entities integration
	AwsMsElasticache []CloudDisableAccountIntegrationInput `json:"awsMsElasticache,omitempty"`
	// Managed Kafka integration
	AwsMsk []CloudDisableAccountIntegrationInput `json:"awsMsk,omitempty"`
	// Neptune integration
	AwsNeptune []CloudDisableAccountIntegrationInput `json:"awsNeptune,omitempty"`
	// QLDB integration
	AwsQldb []CloudDisableAccountIntegrationInput `json:"awsQldb,omitempty"`
	// Route53 Resolver integration
	AwsRoute53resolver []CloudDisableAccountIntegrationInput `json:"awsRoute53resolver,omitempty"`
	// Step Functions integration
	AwsStates []CloudDisableAccountIntegrationInput `json:"awsStates,omitempty"`
	// Fetch tags for all integrations integration
	AwsTagsGlobal []CloudDisableAccountIntegrationInput `json:"awsTagsGlobal,omitempty"`
	// Transit Gateway integration
	AwsTransitgateway []CloudDisableAccountIntegrationInput `json:"awsTransitgateway,omitempty"`
	// WAF integration
	AwsWaf []CloudDisableAccountIntegrationInput `json:"awsWaf,omitempty"`
	// WAFV2 integration
	AwsWafv2 []CloudDisableAccountIntegrationInput `json:"awsWafv2,omitempty"`
	// X-Ray integration
	AwsXray []CloudDisableAccountIntegrationInput `json:"awsXray,omitempty"`
	// Billing integration
	Billing []CloudDisableAccountIntegrationInput `json:"billing,omitempty"`
	// CloudFront integration
	Cloudfront []CloudDisableAccountIntegrationInput `json:"cloudfront,omitempty"`
	// CloudTrail integration
	Cloudtrail []CloudDisableAccountIntegrationInput `json:"cloudtrail,omitempty"`
	// DynamoDB integration
	Dynamodb []CloudDisableAccountIntegrationInput `json:"dynamodb,omitempty"`
	// EBS integration
	Ebs []CloudDisableAccountIntegrationInput `json:"ebs,omitempty"`
	// EC2 integration
	Ec2 []CloudDisableAccountIntegrationInput `json:"ec2,omitempty"`
	// ECS integration
	Ecs []CloudDisableAccountIntegrationInput `json:"ecs,omitempty"`
	// EFS integration
	Efs []CloudDisableAccountIntegrationInput `json:"efs,omitempty"`
	// ElastiCache integration
	Elasticache []CloudDisableAccountIntegrationInput `json:"elasticache,omitempty"`
	// Elastic Beanstalk integration
	Elasticbeanstalk []CloudDisableAccountIntegrationInput `json:"elasticbeanstalk,omitempty"`
	// Elasticsearch Service integration
	Elasticsearch []CloudDisableAccountIntegrationInput `json:"elasticsearch,omitempty"`
	// ELB (Classic) integration
	Elb []CloudDisableAccountIntegrationInput `json:"elb,omitempty"`
	// EMR integration
	Emr []CloudDisableAccountIntegrationInput `json:"emr,omitempty"`
	// Health integration
	Health []CloudDisableAccountIntegrationInput `json:"health,omitempty"`
	// IAM integration
	Iam []CloudDisableAccountIntegrationInput `json:"iam,omitempty"`
	// IoT integration
	Iot []CloudDisableAccountIntegrationInput `json:"iot,omitempty"`
	// Kinesis Streams integration
	Kinesis []CloudDisableAccountIntegrationInput `json:"kinesis,omitempty"`
	// Kinesis Firehose integration
	KinesisFirehose []CloudDisableAccountIntegrationInput `json:"kinesisFirehose,omitempty"`
	// Lambda integration
	Lambda []CloudDisableAccountIntegrationInput `json:"lambda,omitempty"`
	// RDS integration
	Rds []CloudDisableAccountIntegrationInput `json:"rds,omitempty"`
	// Redshift integration
	Redshift []CloudDisableAccountIntegrationInput `json:"redshift,omitempty"`
	// Route 53 integration
	Route53 []CloudDisableAccountIntegrationInput `json:"route53,omitempty"`
	// S3 integration
	S3 []CloudDisableAccountIntegrationInput `json:"s3,omitempty"`
	// SES integration
	Ses []CloudDisableAccountIntegrationInput `json:"ses,omitempty"`
	// SNS integration
	Sns []CloudDisableAccountIntegrationInput `json:"sns,omitempty"`
	// SQS integration
	Sqs []CloudDisableAccountIntegrationInput `json:"sqs,omitempty"`
	// Trusted Advisor integration
	Trustedadvisor []CloudDisableAccountIntegrationInput `json:"trustedadvisor,omitempty"`
	// VPC integration
	Vpc []CloudDisableAccountIntegrationInput `json:"vpc,omitempty"`
}

// CloudAwsDocdbIntegration - DocumentDB Integration
type CloudAwsDocdbIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsDocdbIntegration) ImplementsCloudIntegration() {}

// CloudAwsDocdbIntegrationInput - DocumentDB
type CloudAwsDocdbIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsFsxIntegration - FSx Integration
type CloudAwsFsxIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsFsxIntegration) ImplementsCloudIntegration() {}

// CloudAwsFsxIntegrationInput - FSx
type CloudAwsFsxIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsGlueIntegration - Glue Integration
type CloudAwsGlueIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsGlueIntegration) ImplementsCloudIntegration() {}

// CloudAwsGlueIntegrationInput - Glue
type CloudAwsGlueIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsGovCloudLinkAccountInput - Information required to link an AWS GovCloud account to a NewRelic account.
type CloudAwsGovCloudLinkAccountInput struct {
	// The key used to make requests to AWS service APIs
	AccessKeyId string `json:"accessKeyId"`
	// The AWS account id
	AwsAccountId string `json:"awsAccountId"`
	// How metrics will be collected.
	MetricCollectionMode CloudMetricCollectionMode `json:"metricCollectionMode,omitempty"`
	// The linked account name.
	Name string `json:"name"`
	// The secret key used to make requests to AWS service APIs
	SecretAccessKey SecureValue `json:"secretAccessKey"`
}

// CloudAwsGovCloudProvider - The Amazon Web Services cloud provider (GovCloud)
type CloudAwsGovCloudProvider struct {
	// The AWS Account ID
	AwsAccountId string `json:"awsAccountId"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud provider identifier in NewRelic.
	ID int `json:"id"`
	// The cloud provider icon name.
	Icon string `json:"icon"`
	// The cloud provider name.
	Name string `json:"name"`
	// Get details of one cloud provider service.
	Service CloudService `json:"service,omitempty"`
	// Get details of all the cloud provider services available for integration.
	Services []CloudService `json:"services"`
	// The cloud provider short name.
	Slug string `json:"slug"`
	// Get template params of one cloud provider service.
	TemplateParams []CloudTemplateParam `json:"templateParams"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsGovCloudProvider) ImplementsCloudProvider() {}

// CloudAwsGovCloudUpdateAccountInput - Information required to update an AWS GovCloud account to a NewRelic account.
type CloudAwsGovCloudUpdateAccountInput struct {
	// The key used to make requests to AWS service APIs
	AccessKeyId string `json:"accessKeyId,omitempty"`
	// The AWS account id
	AwsAccountId string `json:"awsAccountId,omitempty"`
	// Disable the linked account.
	Disabled bool `json:"disabled,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The linked account new name.
	Name string `json:"name,omitempty"`
	// The secret key used to make requests to AWS service APIs
	SecretAccessKey SecureValue `json:"secretAccessKey,omitempty"`
}

// CloudAwsGovcloudDisableIntegrationsInput - List of integrations
type CloudAwsGovcloudDisableIntegrationsInput struct {
	// API Gateway integration
	APIgateway []CloudDisableAccountIntegrationInput `json:"apigateway,omitempty"`
	// ALB/NLB integration
	Alb []CloudDisableAccountIntegrationInput `json:"alb,omitempty"`
	// AutoScaling integration
	Autoscaling []CloudDisableAccountIntegrationInput `json:"autoscaling,omitempty"`
	// Direct Connect integration
	AwsDirectconnect []CloudDisableAccountIntegrationInput `json:"awsDirectconnect,omitempty"`
	// Step Functions integration
	AwsStates []CloudDisableAccountIntegrationInput `json:"awsStates,omitempty"`
	// CloudTrail integration
	Cloudtrail []CloudDisableAccountIntegrationInput `json:"cloudtrail,omitempty"`
	// DynamoDB integration
	Dynamodb []CloudDisableAccountIntegrationInput `json:"dynamodb,omitempty"`
	// EBS integration
	Ebs []CloudDisableAccountIntegrationInput `json:"ebs,omitempty"`
	// EC2 integration
	Ec2 []CloudDisableAccountIntegrationInput `json:"ec2,omitempty"`
	// Elasticsearch Service integration
	Elasticsearch []CloudDisableAccountIntegrationInput `json:"elasticsearch,omitempty"`
	// ELB (Classic) integration
	Elb []CloudDisableAccountIntegrationInput `json:"elb,omitempty"`
	// EMR integration
	Emr []CloudDisableAccountIntegrationInput `json:"emr,omitempty"`
	// IAM integration
	Iam []CloudDisableAccountIntegrationInput `json:"iam,omitempty"`
	// Lambda integration
	Lambda []CloudDisableAccountIntegrationInput `json:"lambda,omitempty"`
	// RDS integration
	Rds []CloudDisableAccountIntegrationInput `json:"rds,omitempty"`
	// Redshift integration
	Redshift []CloudDisableAccountIntegrationInput `json:"redshift,omitempty"`
	// Route 53 integration
	Route53 []CloudDisableAccountIntegrationInput `json:"route53,omitempty"`
	// S3 integration
	S3 []CloudDisableAccountIntegrationInput `json:"s3,omitempty"`
	// SNS integration
	Sns []CloudDisableAccountIntegrationInput `json:"sns,omitempty"`
	// SQS integration
	Sqs []CloudDisableAccountIntegrationInput `json:"sqs,omitempty"`
}

// CloudAwsGovcloudIntegrationsInput - List of integrations
type CloudAwsGovcloudIntegrationsInput struct {
	// API Gateway integration
	APIgateway []CloudAPIgatewayIntegrationInput `json:"apigateway,omitempty"`
	// ALB/NLB integration
	Alb []CloudAlbIntegrationInput `json:"alb,omitempty"`
	// AutoScaling integration
	Autoscaling []CloudAutoscalingIntegrationInput `json:"autoscaling,omitempty"`
	// Direct Connect integration
	AwsDirectconnect []CloudAwsDirectconnectIntegrationInput `json:"awsDirectconnect,omitempty"`
	// Step Functions integration
	AwsStates []CloudAwsStatesIntegrationInput `json:"awsStates,omitempty"`
	// CloudTrail integration
	Cloudtrail []CloudCloudtrailIntegrationInput `json:"cloudtrail,omitempty"`
	// DynamoDB integration
	Dynamodb []CloudDynamodbIntegrationInput `json:"dynamodb,omitempty"`
	// EBS integration
	Ebs []CloudEbsIntegrationInput `json:"ebs,omitempty"`
	// EC2 integration
	Ec2 []CloudEc2IntegrationInput `json:"ec2,omitempty"`
	// Elasticsearch Service integration
	Elasticsearch []CloudElasticsearchIntegrationInput `json:"elasticsearch,omitempty"`
	// ELB (Classic) integration
	Elb []CloudElbIntegrationInput `json:"elb,omitempty"`
	// EMR integration
	Emr []CloudEmrIntegrationInput `json:"emr,omitempty"`
	// IAM integration
	Iam []CloudIamIntegrationInput `json:"iam,omitempty"`
	// Lambda integration
	Lambda []CloudLambdaIntegrationInput `json:"lambda,omitempty"`
	// RDS integration
	Rds []CloudRdsIntegrationInput `json:"rds,omitempty"`
	// Redshift integration
	Redshift []CloudRedshiftIntegrationInput `json:"redshift,omitempty"`
	// Route 53 integration
	Route53 []CloudRoute53IntegrationInput `json:"route53,omitempty"`
	// S3 integration
	S3 []CloudS3IntegrationInput `json:"s3,omitempty"`
	// SNS integration
	Sns []CloudSnsIntegrationInput `json:"sns,omitempty"`
	// SQS integration
	Sqs []CloudSqsIntegrationInput `json:"sqs,omitempty"`
}

// CloudAwsIntegrationsInput - List of integrations
type CloudAwsIntegrationsInput struct {
	// API Gateway integration
	APIgateway []CloudAPIgatewayIntegrationInput `json:"apigateway,omitempty"`
	// ALB/NLB integration
	Alb []CloudAlbIntegrationInput `json:"alb,omitempty"`
	// AutoScaling integration
	Autoscaling []CloudAutoscalingIntegrationInput `json:"autoscaling,omitempty"`
	// AppSync integration
	AwsAppsync []CloudAwsAppsyncIntegrationInput `json:"awsAppsync,omitempty"`
	// Athena integration
	AwsAthena []CloudAwsAthenaIntegrationInput `json:"awsAthena,omitempty"`
	// Cognito integration
	AwsCognito []CloudAwsCognitoIntegrationInput `json:"awsCognito,omitempty"`
	// Connect integration
	AwsConnect []CloudAwsConnectIntegrationInput `json:"awsConnect,omitempty"`
	// Direct Connect integration
	AwsDirectconnect []CloudAwsDirectconnectIntegrationInput `json:"awsDirectconnect,omitempty"`
	// DocumentDB integration
	AwsDocdb []CloudAwsDocdbIntegrationInput `json:"awsDocdb,omitempty"`
	// FSx integration
	AwsFsx []CloudAwsFsxIntegrationInput `json:"awsFsx,omitempty"`
	// Glue integration
	AwsGlue []CloudAwsGlueIntegrationInput `json:"awsGlue,omitempty"`
	// Kinesis Data Analytics integration
	AwsKinesisanalytics []CloudAwsKinesisanalyticsIntegrationInput `json:"awsKinesisanalytics,omitempty"`
	// Elemental MediaConvert integration
	AwsMediaconvert []CloudAwsMediaconvertIntegrationInput `json:"awsMediaconvert,omitempty"`
	// MediaPackage VOD integration
	AwsMediapackagevod []CloudAwsMediapackagevodIntegrationInput `json:"awsMediapackagevod,omitempty"`
	// Fetch Metadata for AWS integrations integration
	AwsMetadata []CloudAwsMetadataIntegrationInput `json:"awsMetadata,omitempty"`
	// MQ integration
	AwsMq []CloudAwsMqIntegrationInput `json:"awsMq,omitempty"`
	// Fetch ElastiCache entities integration
	AwsMsElasticache []CloudAwsMsElasticacheIntegrationInput `json:"awsMsElasticache,omitempty"`
	// Managed Kafka integration
	AwsMsk []CloudAwsMskIntegrationInput `json:"awsMsk,omitempty"`
	// Neptune integration
	AwsNeptune []CloudAwsNeptuneIntegrationInput `json:"awsNeptune,omitempty"`
	// QLDB integration
	AwsQldb []CloudAwsQldbIntegrationInput `json:"awsQldb,omitempty"`
	// Route53 Resolver integration
	AwsRoute53resolver []CloudAwsRoute53resolverIntegrationInput `json:"awsRoute53resolver,omitempty"`
	// Step Functions integration
	AwsStates []CloudAwsStatesIntegrationInput `json:"awsStates,omitempty"`
	// Fetch tags for all integrations integration
	AwsTagsGlobal []CloudAwsTagsGlobalIntegrationInput `json:"awsTagsGlobal,omitempty"`
	// Transit Gateway integration
	AwsTransitgateway []CloudAwsTransitgatewayIntegrationInput `json:"awsTransitgateway,omitempty"`
	// WAF integration
	AwsWaf []CloudAwsWafIntegrationInput `json:"awsWaf,omitempty"`
	// WAFV2 integration
	AwsWafv2 []CloudAwsWafv2IntegrationInput `json:"awsWafv2,omitempty"`
	// X-Ray integration
	AwsXray []CloudAwsXrayIntegrationInput `json:"awsXray,omitempty"`
	// Billing integration
	Billing []CloudBillingIntegrationInput `json:"billing,omitempty"`
	// CloudFront integration
	Cloudfront []CloudCloudfrontIntegrationInput `json:"cloudfront,omitempty"`
	// CloudTrail integration
	Cloudtrail []CloudCloudtrailIntegrationInput `json:"cloudtrail,omitempty"`
	// DynamoDB integration
	Dynamodb []CloudDynamodbIntegrationInput `json:"dynamodb,omitempty"`
	// EBS integration
	Ebs []CloudEbsIntegrationInput `json:"ebs,omitempty"`
	// EC2 integration
	Ec2 []CloudEc2IntegrationInput `json:"ec2,omitempty"`
	// ECS integration
	Ecs []CloudEcsIntegrationInput `json:"ecs,omitempty"`
	// EFS integration
	Efs []CloudEfsIntegrationInput `json:"efs,omitempty"`
	// ElastiCache integration
	Elasticache []CloudElasticacheIntegrationInput `json:"elasticache,omitempty"`
	// Elastic Beanstalk integration
	Elasticbeanstalk []CloudElasticbeanstalkIntegrationInput `json:"elasticbeanstalk,omitempty"`
	// Elasticsearch Service integration
	Elasticsearch []CloudElasticsearchIntegrationInput `json:"elasticsearch,omitempty"`
	// ELB (Classic) integration
	Elb []CloudElbIntegrationInput `json:"elb,omitempty"`
	// EMR integration
	Emr []CloudEmrIntegrationInput `json:"emr,omitempty"`
	// Health integration
	Health []CloudHealthIntegrationInput `json:"health,omitempty"`
	// IAM integration
	Iam []CloudIamIntegrationInput `json:"iam,omitempty"`
	// IoT integration
	Iot []CloudIotIntegrationInput `json:"iot,omitempty"`
	// Kinesis Streams integration
	Kinesis []CloudKinesisIntegrationInput `json:"kinesis,omitempty"`
	// Kinesis Firehose integration
	KinesisFirehose []CloudKinesisFirehoseIntegrationInput `json:"kinesisFirehose,omitempty"`
	// Lambda integration
	Lambda []CloudLambdaIntegrationInput `json:"lambda,omitempty"`
	// RDS integration
	Rds []CloudRdsIntegrationInput `json:"rds,omitempty"`
	// Redshift integration
	Redshift []CloudRedshiftIntegrationInput `json:"redshift,omitempty"`
	// Route 53 integration
	Route53 []CloudRoute53IntegrationInput `json:"route53,omitempty"`
	// S3 integration
	S3 []CloudS3IntegrationInput `json:"s3,omitempty"`
	// SES integration
	Ses []CloudSesIntegrationInput `json:"ses,omitempty"`
	// SNS integration
	Sns []CloudSnsIntegrationInput `json:"sns,omitempty"`
	// SQS integration
	Sqs []CloudSqsIntegrationInput `json:"sqs,omitempty"`
	// Trusted Advisor integration
	Trustedadvisor []CloudTrustedadvisorIntegrationInput `json:"trustedadvisor,omitempty"`
	// VPC integration
	Vpc []CloudVpcIntegrationInput `json:"vpc,omitempty"`
}

// CloudAwsKinesisanalyticsIntegration - Kinesis Data Analytics Integration
type CloudAwsKinesisanalyticsIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsKinesisanalyticsIntegration) ImplementsCloudIntegration() {}

// CloudAwsKinesisanalyticsIntegrationInput - Kinesis Data Analytics
type CloudAwsKinesisanalyticsIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsLinkAccountInput - Information required to link a AWS account to a NewRelic account.
type CloudAwsLinkAccountInput struct {
	// The AWS role ARN (used to fetch data).
	Arn string `json:"arn"`
	// How metrics will be collected.
	MetricCollectionMode CloudMetricCollectionMode `json:"metricCollectionMode,omitempty"`
	// The linked account name.
	Name string `json:"name"`
}

// CloudAwsMediaconvertIntegration - Elemental MediaConvert Integration
type CloudAwsMediaconvertIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsMediaconvertIntegration) ImplementsCloudIntegration() {}

// CloudAwsMediaconvertIntegrationInput - Elemental MediaConvert
type CloudAwsMediaconvertIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsMediapackagevodIntegration - MediaPackage VOD Integration
type CloudAwsMediapackagevodIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsMediapackagevodIntegration) ImplementsCloudIntegration() {}

// CloudAwsMediapackagevodIntegrationInput - MediaPackage VOD
type CloudAwsMediapackagevodIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsMetadataIntegration - Fetch Metadata for AWS integrations Integration
type CloudAwsMetadataIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsMetadataIntegration) ImplementsCloudIntegration() {}

// CloudAwsMetadataIntegrationInput - Fetch Metadata for AWS integrations
type CloudAwsMetadataIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsMqIntegration - MQ Integration
type CloudAwsMqIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsMqIntegration) ImplementsCloudIntegration() {}

// CloudAwsMqIntegrationInput - MQ
type CloudAwsMqIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsMsElasticacheIntegration - Fetch ElastiCache entities Integration
type CloudAwsMsElasticacheIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsMsElasticacheIntegration) ImplementsCloudIntegration() {}

// CloudAwsMsElasticacheIntegrationInput - Fetch ElastiCache entities
type CloudAwsMsElasticacheIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsMskIntegration - Managed Kafka Integration
type CloudAwsMskIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsMskIntegration) ImplementsCloudIntegration() {}

// CloudAwsMskIntegrationInput - Managed Kafka
type CloudAwsMskIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsNeptuneIntegration - Neptune Integration
type CloudAwsNeptuneIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsNeptuneIntegration) ImplementsCloudIntegration() {}

// CloudAwsNeptuneIntegrationInput - Neptune
type CloudAwsNeptuneIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsProvider - The Amazon Web Services cloud provider
type CloudAwsProvider struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud provider identifier in NewRelic.
	ID int `json:"id"`
	// The cloud provider icon name.
	Icon string `json:"icon"`
	// The cloud provider name.
	Name string `json:"name"`
	// The New Relic AWS Account ID that will use the Role.
	RoleAccountId string `json:"roleAccountId"`
	// The external ID required to assume the Role by the New Relic Account.
	RoleExternalId string `json:"roleExternalId"`
	// Get details of one cloud provider service.
	Service CloudService `json:"service,omitempty"`
	// Get details of all the cloud provider services available for integration.
	Services []CloudService `json:"services"`
	// The cloud provider short name.
	Slug string `json:"slug"`
	// Get template params of one cloud provider service.
	TemplateParams []CloudTemplateParam `json:"templateParams"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsProvider) ImplementsCloudProvider() {}

// CloudAwsQldbIntegration - QLDB Integration
type CloudAwsQldbIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsQldbIntegration) ImplementsCloudIntegration() {}

// CloudAwsQldbIntegrationInput - QLDB
type CloudAwsQldbIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsRoute53resolverIntegration - Route53 Resolver Integration
type CloudAwsRoute53resolverIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsRoute53resolverIntegration) ImplementsCloudIntegration() {}

// CloudAwsRoute53resolverIntegrationInput - Route53 Resolver
type CloudAwsRoute53resolverIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsStatesIntegration - Step Functions Integration
type CloudAwsStatesIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsStatesIntegration) ImplementsCloudIntegration() {}

// CloudAwsStatesIntegrationInput - Step Functions
type CloudAwsStatesIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsTagsGlobalIntegration - Fetch tags for all integrations Integration
type CloudAwsTagsGlobalIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsTagsGlobalIntegration) ImplementsCloudIntegration() {}

// CloudAwsTagsGlobalIntegrationInput - Fetch tags for all integrations
type CloudAwsTagsGlobalIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsTransitgatewayIntegration - Transit Gateway Integration
type CloudAwsTransitgatewayIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsTransitgatewayIntegration) ImplementsCloudIntegration() {}

// CloudAwsTransitgatewayIntegrationInput - Transit Gateway
type CloudAwsTransitgatewayIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsUpdateAccountInput - Information required to update a AWS account to a NewRelic account.
type CloudAwsUpdateAccountInput struct {
	// The AWS role ARN (used to fetch data).
	Arn string `json:"arn,omitempty"`
	// Disable the linked account.
	Disabled bool `json:"disabled,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The linked account new name.
	Name string `json:"name,omitempty"`
}

// CloudAwsWafIntegration - WAF Integration
type CloudAwsWafIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsWafIntegration) ImplementsCloudIntegration() {}

// CloudAwsWafIntegrationInput - WAF
type CloudAwsWafIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsWafv2Integration - WAFV2 Integration
type CloudAwsWafv2Integration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsWafv2Integration) ImplementsCloudIntegration() {}

// CloudAwsWafv2IntegrationInput - WAFV2
type CloudAwsWafv2IntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAwsXrayIntegration - X-Ray Integration
type CloudAwsXrayIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAwsXrayIntegration) ImplementsCloudIntegration() {}

// CloudAwsXrayIntegrationInput - X-Ray
type CloudAwsXrayIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudAzureAPImanagementIntegration - Api Management Integration
type CloudAzureAPImanagementIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureAPImanagementIntegration) ImplementsCloudIntegration() {}

// CloudAzureAPImanagementIntegrationInput - Api Management
type CloudAzureAPImanagementIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureAppgatewayIntegration - App Gateway Integration
type CloudAzureAppgatewayIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureAppgatewayIntegration) ImplementsCloudIntegration() {}

// CloudAzureAppgatewayIntegrationInput - App Gateway
type CloudAzureAppgatewayIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureAppserviceIntegration - App Service Integration
type CloudAzureAppserviceIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureAppserviceIntegration) ImplementsCloudIntegration() {}

// CloudAzureAppserviceIntegrationInput - Azure App Service
type CloudAzureAppserviceIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureContainersIntegration - Containers Integration
type CloudAzureContainersIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureContainersIntegration) ImplementsCloudIntegration() {}

// CloudAzureContainersIntegrationInput - Containers
type CloudAzureContainersIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureCosmosdbIntegration - Cosmos DB Integration
type CloudAzureCosmosdbIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureCosmosdbIntegration) ImplementsCloudIntegration() {}

// CloudAzureCosmosdbIntegrationInput - Azure Cosmos DB
type CloudAzureCosmosdbIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureCostmanagementIntegration - Cost Management Integration
type CloudAzureCostmanagementIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify if additional cost data per tag should be collected. This field is case sensitive.
	TagKeys []string `json:"tagKeys,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureCostmanagementIntegration) ImplementsCloudIntegration() {}

// CloudAzureCostmanagementIntegrationInput - Cost Management
type CloudAzureCostmanagementIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify if additional cost data per tag should be collected. This field is case sensitive.
	TagKeys []string `json:"tagKeys,omitempty"`
}

// CloudAzureDatafactoryIntegration - Data Factory Integration
type CloudAzureDatafactoryIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureDatafactoryIntegration) ImplementsCloudIntegration() {}

// CloudAzureDatafactoryIntegrationInput - Data Factory
type CloudAzureDatafactoryIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureDisableIntegrationsInput - List of integrations
type CloudAzureDisableIntegrationsInput struct {
	// Api Management integration
	AzureAPImanagement []CloudDisableAccountIntegrationInput `json:"azureApimanagement,omitempty"`
	// App Gateway integration
	AzureAppgateway []CloudDisableAccountIntegrationInput `json:"azureAppgateway,omitempty"`
	// App Service integration
	AzureAppservice []CloudDisableAccountIntegrationInput `json:"azureAppservice,omitempty"`
	// Containers integration
	AzureContainers []CloudDisableAccountIntegrationInput `json:"azureContainers,omitempty"`
	// Cosmos DB integration
	AzureCosmosdb []CloudDisableAccountIntegrationInput `json:"azureCosmosdb,omitempty"`
	// Cost Management integration
	AzureCostmanagement []CloudDisableAccountIntegrationInput `json:"azureCostmanagement,omitempty"`
	// Data Factory integration
	AzureDatafactory []CloudDisableAccountIntegrationInput `json:"azureDatafactory,omitempty"`
	// Event Hub integration
	AzureEventhub []CloudDisableAccountIntegrationInput `json:"azureEventhub,omitempty"`
	// Express Route integration
	AzureExpressroute []CloudDisableAccountIntegrationInput `json:"azureExpressroute,omitempty"`
	// Firewalls integration
	AzureFirewalls []CloudDisableAccountIntegrationInput `json:"azureFirewalls,omitempty"`
	// Front Door integration
	AzureFrontdoor []CloudDisableAccountIntegrationInput `json:"azureFrontdoor,omitempty"`
	// Functions integration
	AzureFunctions []CloudDisableAccountIntegrationInput `json:"azureFunctions,omitempty"`
	// Key Vault integration
	AzureKeyvault []CloudDisableAccountIntegrationInput `json:"azureKeyvault,omitempty"`
	// Load Balancer integration
	AzureLoadbalancer []CloudDisableAccountIntegrationInput `json:"azureLoadbalancer,omitempty"`
	// Logic Apps integration
	AzureLogicapps []CloudDisableAccountIntegrationInput `json:"azureLogicapps,omitempty"`
	// Machine Learning integration
	AzureMachinelearning []CloudDisableAccountIntegrationInput `json:"azureMachinelearning,omitempty"`
	// Database for MariaDB integration
	AzureMariadb []CloudDisableAccountIntegrationInput `json:"azureMariadb,omitempty"`
	// Azure Monitor metrics integration
	AzureMonitor []CloudDisableAccountIntegrationInput `json:"azureMonitor,omitempty"`
	// Database for MySQL integration
	AzureMysql []CloudDisableAccountIntegrationInput `json:"azureMysql,omitempty"`
	// MySQL Flexible Server integration
	AzureMysqlflexible []CloudDisableAccountIntegrationInput `json:"azureMysqlflexible,omitempty"`
	// Database for PostgreSQL integration
	AzurePostgresql []CloudDisableAccountIntegrationInput `json:"azurePostgresql,omitempty"`
	// PostgreSQL Flexible Server integration
	AzurePostgresqlflexible []CloudDisableAccountIntegrationInput `json:"azurePostgresqlflexible,omitempty"`
	// Power BI Dedicated integration
	AzurePowerbidedicated []CloudDisableAccountIntegrationInput `json:"azurePowerbidedicated,omitempty"`
	// Redis Cache integration
	AzureRediscache []CloudDisableAccountIntegrationInput `json:"azureRediscache,omitempty"`
	// Service Bus integration
	AzureServicebus []CloudDisableAccountIntegrationInput `json:"azureServicebus,omitempty"`
	// SQL Database integration
	AzureSql []CloudDisableAccountIntegrationInput `json:"azureSql,omitempty"`
	// SQL Managed Instances integration
	AzureSqlmanaged []CloudDisableAccountIntegrationInput `json:"azureSqlmanaged,omitempty"`
	// Storage integration
	AzureStorage []CloudDisableAccountIntegrationInput `json:"azureStorage,omitempty"`
	// Virtual machine scale sets integration
	AzureVirtualmachine []CloudDisableAccountIntegrationInput `json:"azureVirtualmachine,omitempty"`
	// Virtual Network integration
	AzureVirtualnetworks []CloudDisableAccountIntegrationInput `json:"azureVirtualnetworks,omitempty"`
	// Virtual Machines integration
	AzureVms []CloudDisableAccountIntegrationInput `json:"azureVms,omitempty"`
	// VPN Gateways integration
	AzureVpngateways []CloudDisableAccountIntegrationInput `json:"azureVpngateways,omitempty"`
}

// CloudAzureEventhubIntegration - Event Hub Integration
type CloudAzureEventhubIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureEventhubIntegration) ImplementsCloudIntegration() {}

// CloudAzureEventhubIntegrationInput - Event Hub
type CloudAzureEventhubIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureExpressrouteIntegration - Express Route Integration
type CloudAzureExpressrouteIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureExpressrouteIntegration) ImplementsCloudIntegration() {}

// CloudAzureExpressrouteIntegrationInput - Express Route
type CloudAzureExpressrouteIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureFirewallsIntegration - Firewalls Integration
type CloudAzureFirewallsIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureFirewallsIntegration) ImplementsCloudIntegration() {}

// CloudAzureFirewallsIntegrationInput - Firewalls
type CloudAzureFirewallsIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureFrontdoorIntegration - Front Door Integration
type CloudAzureFrontdoorIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureFrontdoorIntegration) ImplementsCloudIntegration() {}

// CloudAzureFrontdoorIntegrationInput - Front Door
type CloudAzureFrontdoorIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureFunctionsIntegration - Functions Integration
type CloudAzureFunctionsIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureFunctionsIntegration) ImplementsCloudIntegration() {}

// CloudAzureFunctionsIntegrationInput - Azure Functions
type CloudAzureFunctionsIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureIntegrationsInput - List of integrations
type CloudAzureIntegrationsInput struct {
	// Api Management integration
	AzureAPImanagement []CloudAzureAPImanagementIntegrationInput `json:"azureApimanagement,omitempty"`
	// App Gateway integration
	AzureAppgateway []CloudAzureAppgatewayIntegrationInput `json:"azureAppgateway,omitempty"`
	// App Service integration
	AzureAppservice []CloudAzureAppserviceIntegrationInput `json:"azureAppservice,omitempty"`
	// Containers integration
	AzureContainers []CloudAzureContainersIntegrationInput `json:"azureContainers,omitempty"`
	// Cosmos DB integration
	AzureCosmosdb []CloudAzureCosmosdbIntegrationInput `json:"azureCosmosdb,omitempty"`
	// Cost Management integration
	AzureCostmanagement []CloudAzureCostmanagementIntegrationInput `json:"azureCostmanagement,omitempty"`
	// Data Factory integration
	AzureDatafactory []CloudAzureDatafactoryIntegrationInput `json:"azureDatafactory,omitempty"`
	// Event Hub integration
	AzureEventhub []CloudAzureEventhubIntegrationInput `json:"azureEventhub,omitempty"`
	// Express Route integration
	AzureExpressroute []CloudAzureExpressrouteIntegrationInput `json:"azureExpressroute,omitempty"`
	// Firewalls integration
	AzureFirewalls []CloudAzureFirewallsIntegrationInput `json:"azureFirewalls,omitempty"`
	// Front Door integration
	AzureFrontdoor []CloudAzureFrontdoorIntegrationInput `json:"azureFrontdoor,omitempty"`
	// Functions integration
	AzureFunctions []CloudAzureFunctionsIntegrationInput `json:"azureFunctions,omitempty"`
	// Key Vault integration
	AzureKeyvault []CloudAzureKeyvaultIntegrationInput `json:"azureKeyvault,omitempty"`
	// Load Balancer integration
	AzureLoadbalancer []CloudAzureLoadbalancerIntegrationInput `json:"azureLoadbalancer,omitempty"`
	// Logic Apps integration
	AzureLogicapps []CloudAzureLogicappsIntegrationInput `json:"azureLogicapps,omitempty"`
	// Machine Learning integration
	AzureMachinelearning []CloudAzureMachinelearningIntegrationInput `json:"azureMachinelearning,omitempty"`
	// Database for MariaDB integration
	AzureMariadb []CloudAzureMariadbIntegrationInput `json:"azureMariadb,omitempty"`
	// Azure Monitor metrics integration
	AzureMonitor []CloudAzureMonitorIntegrationInput `json:"azureMonitor,omitempty"`
	// Database for MySQL integration
	AzureMysql []CloudAzureMysqlIntegrationInput `json:"azureMysql,omitempty"`
	// MySQL Flexible Server integration
	AzureMysqlflexible []CloudAzureMysqlflexibleIntegrationInput `json:"azureMysqlflexible,omitempty"`
	// Database for PostgreSQL integration
	AzurePostgresql []CloudAzurePostgresqlIntegrationInput `json:"azurePostgresql,omitempty"`
	// PostgreSQL Flexible Server integration
	AzurePostgresqlflexible []CloudAzurePostgresqlflexibleIntegrationInput `json:"azurePostgresqlflexible,omitempty"`
	// Power BI Dedicated integration
	AzurePowerbidedicated []CloudAzurePowerbidedicatedIntegrationInput `json:"azurePowerbidedicated,omitempty"`
	// Redis Cache integration
	AzureRediscache []CloudAzureRediscacheIntegrationInput `json:"azureRediscache,omitempty"`
	// Service Bus integration
	AzureServicebus []CloudAzureServicebusIntegrationInput `json:"azureServicebus,omitempty"`
	// SQL Database integration
	AzureSql []CloudAzureSqlIntegrationInput `json:"azureSql,omitempty"`
	// SQL Managed Instances integration
	AzureSqlmanaged []CloudAzureSqlmanagedIntegrationInput `json:"azureSqlmanaged,omitempty"`
	// Storage integration
	AzureStorage []CloudAzureStorageIntegrationInput `json:"azureStorage,omitempty"`
	// Virtual machine scale sets integration
	AzureVirtualmachine []CloudAzureVirtualmachineIntegrationInput `json:"azureVirtualmachine,omitempty"`
	// Virtual Network integration
	AzureVirtualnetworks []CloudAzureVirtualnetworksIntegrationInput `json:"azureVirtualnetworks,omitempty"`
	// Virtual Machines integration
	AzureVms []CloudAzureVmsIntegrationInput `json:"azureVms,omitempty"`
	// VPN Gateways integration
	AzureVpngateways []CloudAzureVpngatewaysIntegrationInput `json:"azureVpngateways,omitempty"`
}

// CloudAzureKeyvaultIntegration - Key Vault Integration
type CloudAzureKeyvaultIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureKeyvaultIntegration) ImplementsCloudIntegration() {}

// CloudAzureKeyvaultIntegrationInput - Key Vault
type CloudAzureKeyvaultIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureLinkAccountInput - Information required to link a Azure account to a NewRelic account.
type CloudAzureLinkAccountInput struct {
	// The Azure account application identifier (used to fetch data).
	ApplicationID string `json:"applicationId"`
	// The Azure account application secret key.
	ClientSecret SecureValue `json:"clientSecret"`
	// The linked account name.
	Name string `json:"name"`
	// The Azure account subscription identifier.
	SubscriptionId string `json:"subscriptionId"`
	// The Azure account tenant identifier.
	TenantId string `json:"tenantId"`
}

// CloudAzureLoadbalancerIntegration - Load Balancer Integration
type CloudAzureLoadbalancerIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureLoadbalancerIntegration) ImplementsCloudIntegration() {}

// CloudAzureLoadbalancerIntegrationInput - Azure Load Balancer
type CloudAzureLoadbalancerIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureLogicappsIntegration - Logic Apps Integration
type CloudAzureLogicappsIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureLogicappsIntegration) ImplementsCloudIntegration() {}

// CloudAzureLogicappsIntegrationInput - Logic Apps
type CloudAzureLogicappsIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureMachinelearningIntegration - Machine Learning Integration
type CloudAzureMachinelearningIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureMachinelearningIntegration) ImplementsCloudIntegration() {}

// CloudAzureMachinelearningIntegrationInput - Machine Learning
type CloudAzureMachinelearningIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureMariadbIntegration - Database for MariaDB Integration
type CloudAzureMariadbIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureMariadbIntegration) ImplementsCloudIntegration() {}

// CloudAzureMariadbIntegrationInput - Database for MariaDB
type CloudAzureMariadbIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureMonitorIntegration - Azure Monitor metrics Integration
type CloudAzureMonitorIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if integration is active
	Enabled bool `json:"enabled,omitempty"`
	// Specify resource tags (in 'key:value' form) associated with the resources that you want to exclude from monitoring. Exclusion takes precedence over inclusion.
	ExcludeTags []string `json:"excludeTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// Specify resource tags (in 'key:value' form) associated with the resources that you want to monitor. If empty, all resources will be monitored.
	IncludeTags []string `json:"includeTags,omitempty"`
	// The polling interval for metadata and tags, in seconds.
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The polling interval for metrics, in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// Specify each Azure resource type that you want to monitor.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureMonitorIntegration) ImplementsCloudIntegration() {}

// CloudAzureMonitorIntegrationInput - Azure Monitor metrics
type CloudAzureMonitorIntegrationInput struct {
	// Specify if integration is active
	Enabled bool `json:"enabled,omitempty"`
	// Specify resource tags (in 'key:value' form) associated with the resources that you want to exclude from monitoring. Exclusion takes precedence over inclusion.
	ExcludeTags []string `json:"excludeTags,omitempty"`
	// Specify resource tags (in 'key:value' form) associated with the resources that you want to monitor. If empty, all resources will be monitored.
	IncludeTags []string `json:"includeTags,omitempty"`
	// The polling interval for metadata and tags, in seconds.
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The polling interval for metrics, in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// Specify each Azure resource type that you want to monitor.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
}

// CloudAzureMysqlIntegration - Database for MySQL Integration
type CloudAzureMysqlIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureMysqlIntegration) ImplementsCloudIntegration() {}

// CloudAzureMysqlIntegrationInput - Database for MySQL
type CloudAzureMysqlIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureMysqlflexibleIntegration - MySQL Flexible Server Integration
type CloudAzureMysqlflexibleIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureMysqlflexibleIntegration) ImplementsCloudIntegration() {}

// CloudAzureMysqlflexibleIntegrationInput - MySQL Flexible Server
type CloudAzureMysqlflexibleIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzurePostgresqlIntegration - Database for PostgreSQL Integration
type CloudAzurePostgresqlIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzurePostgresqlIntegration) ImplementsCloudIntegration() {}

// CloudAzurePostgresqlIntegrationInput - Database for PostgreSQL
type CloudAzurePostgresqlIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzurePostgresqlflexibleIntegration - PostgreSQL Flexible Server Integration
type CloudAzurePostgresqlflexibleIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzurePostgresqlflexibleIntegration) ImplementsCloudIntegration() {}

// CloudAzurePostgresqlflexibleIntegrationInput - PostgreSQL Flexible Server
type CloudAzurePostgresqlflexibleIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzurePowerbidedicatedIntegration - Power BI Dedicated Integration
type CloudAzurePowerbidedicatedIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzurePowerbidedicatedIntegration) ImplementsCloudIntegration() {}

// CloudAzurePowerbidedicatedIntegrationInput - Power BI Dedicated
type CloudAzurePowerbidedicatedIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureRediscacheIntegration - Redis Cache Integration
type CloudAzureRediscacheIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureRediscacheIntegration) ImplementsCloudIntegration() {}

// CloudAzureRediscacheIntegrationInput - Azure Redis Cache
type CloudAzureRediscacheIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureServicebusIntegration - Service Bus Integration
type CloudAzureServicebusIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureServicebusIntegration) ImplementsCloudIntegration() {}

// CloudAzureServicebusIntegrationInput - Azure Service Bus
type CloudAzureServicebusIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureSqlIntegration - SQL Database Integration
type CloudAzureSqlIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureSqlIntegration) ImplementsCloudIntegration() {}

// CloudAzureSqlIntegrationInput - Azure SQL Database
type CloudAzureSqlIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureSqlmanagedIntegration - SQL Managed Instances Integration
type CloudAzureSqlmanagedIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureSqlmanagedIntegration) ImplementsCloudIntegration() {}

// CloudAzureSqlmanagedIntegrationInput - SQL Managed Instances
type CloudAzureSqlmanagedIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureStorageIntegration - Storage Integration
type CloudAzureStorageIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureStorageIntegration) ImplementsCloudIntegration() {}

// CloudAzureStorageIntegrationInput - Azure Storage
type CloudAzureStorageIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureUpdateAccountInput - Information required to update a Azure account to a NewRelic account.
type CloudAzureUpdateAccountInput struct {
	// The Azure account application identifier (used to fetch data).
	ApplicationID string `json:"applicationId,omitempty"`
	// The Azure account application secret key.
	ClientSecret SecureValue `json:"clientSecret,omitempty"`
	// Disable the linked account.
	Disabled *bool `json:"disabled,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The linked account new name.
	Name string `json:"name,omitempty"`
	// The Azure account subscription identifier.
	SubscriptionId string `json:"subscriptionId,omitempty"`
	// The Azure account tenant identifier.
	TenantId string `json:"tenantId,omitempty"`
}

// CloudAzureVirtualmachineIntegration - Virtual machine scale sets Integration
type CloudAzureVirtualmachineIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureVirtualmachineIntegration) ImplementsCloudIntegration() {}

// CloudAzureVirtualmachineIntegrationInput - Virtual machine scale sets
type CloudAzureVirtualmachineIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureVirtualnetworksIntegration - Virtual Network Integration
type CloudAzureVirtualnetworksIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureVirtualnetworksIntegration) ImplementsCloudIntegration() {}

// CloudAzureVirtualnetworksIntegrationInput - Azure Virtual Network
type CloudAzureVirtualnetworksIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureVmsIntegration - Virtual Machines Integration
type CloudAzureVmsIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureVmsIntegration) ImplementsCloudIntegration() {}

// CloudAzureVmsIntegrationInput - Azure Virtual Machines
type CloudAzureVmsIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudAzureVpngatewaysIntegration - VPN Gateways Integration
type CloudAzureVpngatewaysIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudAzureVpngatewaysIntegration) ImplementsCloudIntegration() {}

// CloudAzureVpngatewaysIntegrationInput - VPN Gateways
type CloudAzureVpngatewaysIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each Resource group associated with the resources that you want to monitor. Filter values are case-sensitive.
	ResourceGroups []string `json:"resourceGroups,omitempty"`
}

// CloudBaseIntegration - Base Integration Object
type CloudBaseIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudBaseIntegration) ImplementsCloudIntegration() {}

// CloudBaseProvider - Base Provider Object
type CloudBaseProvider struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud provider identifier in NewRelic.
	ID int `json:"id"`
	// The cloud provider icon name.
	Icon string `json:"icon"`
	// The cloud provider name.
	Name string `json:"name"`
	// Get details of one cloud provider service.
	Service CloudService `json:"service,omitempty"`
	// Get details of all the cloud provider services available for integration.
	Services []CloudService `json:"services"`
	// The cloud provider short name.
	Slug string `json:"slug"`
	// Get template params of one cloud provider service.
	TemplateParams []CloudTemplateParam `json:"templateParams"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudBaseProvider) ImplementsCloudProvider() {}

// CloudBillingIntegration - Billing Integration
type CloudBillingIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudBillingIntegration) ImplementsCloudIntegration() {}

// CloudBillingIntegrationInput - AWS Billing
type CloudBillingIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudCloudfrontIntegration - CloudFront Integration
type CloudCloudfrontIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if Lambdas@Edge should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchLambdasAtEdge bool `json:"fetchLambdasAtEdge,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudCloudfrontIntegration) ImplementsCloudIntegration() {}

// CloudCloudfrontIntegrationInput - Amazon CloudFront
type CloudCloudfrontIntegrationInput struct {
	// Specify if Lambdas@Edge should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchLambdasAtEdge bool `json:"fetchLambdasAtEdge,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudCloudtrailIntegration - CloudTrail Integration
type CloudCloudtrailIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudCloudtrailIntegration) ImplementsCloudIntegration() {}

// CloudCloudtrailIntegrationInput - AWS CloudTrail
type CloudCloudtrailIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudConfigureIntegrationPayload - Autogenerated return type of ConfigureIntegration
type CloudConfigureIntegrationPayload struct {
	// The list of errors.
	Errors []CloudIntegrationMutationError `json:"errors"`
	// The created/modified service integrations.
	Integrations []CloudIntegrationInterface `json:"integrations"`
}

// special
func (x *CloudConfigureIntegrationPayload) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "errors":
			err = json.Unmarshal(*v, &x.Errors)
			if err != nil {
				return err
			}
		case "integrations":
			if v == nil {
				continue
			}
			var rawMessageIntegrations []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageIntegrations)
			if err != nil {
				return err
			}

			for _, m := range rawMessageIntegrations {
				xxx, err := UnmarshalCloudIntegrationInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.Integrations = append(x.Integrations, *xxx)
				}
			}
		}
	}

	return nil
}

// CloudConfluentUpdateAccountInput - Information required to update a Confluent Cloud account to a NewRelic account.
type CloudConfluentUpdateAccountInput struct {
	// The Confluent account API key.
	APIKey SecureValue `json:"apiKey"`
	// The Confluent Cloud account API Secret key.
	APISecret SecureValue `json:"apiSecret"`
	// Disable the linked account.
	Disabled bool `json:"disabled,omitempty"`
	// The Confluent Cloud account identifier.
	ExternalId string `json:"externalId,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The linked account new name.
	Name string `json:"name,omitempty"`
}

// CloudDashboardTemplate - A cloud service dashboard template.
type CloudDashboardTemplate struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The dashboard layout position.
	Layout int `json:"layout"`
	// The dashboard template name.
	Name string `json:"name"`
	// The dashboard template slug.
	Slug string `json:"slug"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

// CloudDisableAccountIntegrationInput - Information required to disable a cloud service integration from a linked account.
type CloudDisableAccountIntegrationInput struct {
	// The linked account identifier
	LinkedAccountId int `json:"linkedAccountId"`
}

// CloudDisableIntegrationPayload - Autogenerated return type of DisableIntegration
type CloudDisableIntegrationPayload struct {
	// The list of disabled cloud service integrations.
	DisabledIntegrations []CloudIntegrationInterface `json:"disabledIntegrations"`
	// The list of errors.
	Errors []CloudIntegrationMutationError `json:"errors"`
}

// special
func (x *CloudDisableIntegrationPayload) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "disabledIntegrations":
			if v == nil {
				continue
			}
			var rawMessageDisabledIntegrations []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageDisabledIntegrations)
			if err != nil {
				return err
			}

			for _, m := range rawMessageDisabledIntegrations {
				xxx, err := UnmarshalCloudIntegrationInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.DisabledIntegrations = append(x.DisabledIntegrations, *xxx)
				}
			}
		case "errors":
			err = json.Unmarshal(*v, &x.Errors)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// CloudDisableIntegrationsInput - List of providers
type CloudDisableIntegrationsInput struct {
	// Aws provider
	Aws CloudAwsDisableIntegrationsInput `json:"aws,omitempty"`
	// AwsGovcloud provider
	AwsGovcloud CloudAwsGovcloudDisableIntegrationsInput `json:"awsGovcloud,omitempty"`
	// Azure provider
	Azure CloudAzureDisableIntegrationsInput `json:"azure,omitempty"`
	// Gcp provider
	Gcp CloudGcpDisableIntegrationsInput `json:"gcp,omitempty"`
}

// CloudDynamodbIntegration - DynamoDB Integration
type CloudDynamodbIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudDynamodbIntegration) ImplementsCloudIntegration() {}

// CloudDynamodbIntegrationInput - Amazon DynamoDB
type CloudDynamodbIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudEbsIntegration - EBS Integration
type CloudEbsIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudEbsIntegration) ImplementsCloudIntegration() {}

// CloudEbsIntegrationInput - Amazon Elastic Block Store (EBS)
type CloudEbsIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudEc2Integration - EC2 Integration
type CloudEc2Integration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if the old legacy metadata and tag names have to be kept, it will consume more ingest data size
	DuplicateEc2Tags bool `json:"duplicateEc2Tags,omitempty"`
	// Specify if IP addresses of ec2 instance should be collected
	FetchIpAddresses bool `json:"fetchIpAddresses,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudEc2Integration) ImplementsCloudIntegration() {}

// CloudEc2IntegrationInput - Amazon Elastic Compute Cloud (EC2)
type CloudEc2IntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if the old legacy metadata and tag names have to be kept, it will consume more ingest data size
	DuplicateEc2Tags bool `json:"duplicateEc2Tags,omitempty"`
	// Specify if IP addresses of ec2 instance should be collected
	FetchIpAddresses bool `json:"fetchIpAddresses,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudEcsIntegration - ECS Integration
type CloudEcsIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudEcsIntegration) ImplementsCloudIntegration() {}

// CloudEcsIntegrationInput - Amazon Elastic Container Service (ECS)
type CloudEcsIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudEfsIntegration - EFS Integration
type CloudEfsIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudEfsIntegration) ImplementsCloudIntegration() {}

// CloudEfsIntegrationInput - Amazon Elastic File System (EFS)
type CloudEfsIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudElasticacheIntegration - ElastiCache Integration
type CloudElasticacheIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudElasticacheIntegration) ImplementsCloudIntegration() {}

// CloudElasticacheIntegrationInput - Amazon ElastiCache
type CloudElasticacheIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudElasticbeanstalkIntegration - Elastic Beanstalk Integration
type CloudElasticbeanstalkIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudElasticbeanstalkIntegration) ImplementsCloudIntegration() {}

// CloudElasticbeanstalkIntegrationInput - AWS Elastic Beanstalk
type CloudElasticbeanstalkIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudElasticsearchIntegration - Elasticsearch Service Integration
type CloudElasticsearchIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if metrics should be collected for nodes. Turning it on will increase the number of API calls made to CloudWatch.
	FetchNodes bool `json:"fetchNodes,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudElasticsearchIntegration) ImplementsCloudIntegration() {}

// CloudElasticsearchIntegrationInput - Amazon Elasticsearch Service
type CloudElasticsearchIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if metrics should be collected for nodes. Turning it on will increase the number of API calls made to CloudWatch.
	FetchNodes bool `json:"fetchNodes,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudElbIntegration - ELB (Classic) Integration
type CloudElbIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudElbIntegration) ImplementsCloudIntegration() {}

// CloudElbIntegrationInput - Elastic Load Balancing - Classic Load Balancer (ELB)
type CloudElbIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudEmrIntegration - EMR Integration
type CloudEmrIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if tags and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudEmrIntegration) ImplementsCloudIntegration() {}

// CloudEmrIntegrationInput - Amazon Elastic MapReduce (EMR)
type CloudEmrIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if tags and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudFossaUpdateAccountInput - Information required to update a Fossa account to a NewRelic account.
type CloudFossaUpdateAccountInput struct {
	// The Fossa account application api key(bearer token).
	APIKey SecureValue `json:"apiKey"`
	// Disable the linked account.
	Disabled bool `json:"disabled,omitempty"`
	// The Fossa account identifier.
	ExternalId string `json:"externalId,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The linked account new name.
	Name string `json:"name,omitempty"`
}

// CloudGcpAiplatformIntegration - Vertex AI Integration
type CloudGcpAiplatformIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpAiplatformIntegration) ImplementsCloudIntegration() {}

// CloudGcpAiplatformIntegrationInput - Vertex AI
type CloudGcpAiplatformIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpAlloydbIntegration - AlloyDB Integration
type CloudGcpAlloydbIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpAlloydbIntegration) ImplementsCloudIntegration() {}

// CloudGcpAlloydbIntegrationInput - AlloyDB
type CloudGcpAlloydbIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpAppengineIntegration - App Engine Integration
type CloudGcpAppengineIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpAppengineIntegration) ImplementsCloudIntegration() {}

// CloudGcpAppengineIntegrationInput - Google App Engine
type CloudGcpAppengineIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpBigqueryIntegration - BigQuery Integration
type CloudGcpBigqueryIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Fetch BigQuery Table metrics, disabled by default
	FetchTableMetrics bool `json:"fetchTableMetrics,omitempty"`
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpBigqueryIntegration) ImplementsCloudIntegration() {}

// CloudGcpBigqueryIntegrationInput - BigQuery
type CloudGcpBigqueryIntegrationInput struct {
	// Fetch BigQuery Table metrics, disabled by default
	FetchTableMetrics bool `json:"fetchTableMetrics,omitempty"`
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpBigtableIntegration - Bigtable Integration
type CloudGcpBigtableIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpBigtableIntegration) ImplementsCloudIntegration() {}

// CloudGcpBigtableIntegrationInput - Bigtable
type CloudGcpBigtableIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpComposerIntegration - Composer Integration
type CloudGcpComposerIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpComposerIntegration) ImplementsCloudIntegration() {}

// CloudGcpComposerIntegrationInput - Composer
type CloudGcpComposerIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpDataflowIntegration - Dataflow Integration
type CloudGcpDataflowIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpDataflowIntegration) ImplementsCloudIntegration() {}

// CloudGcpDataflowIntegrationInput - Dataflow
type CloudGcpDataflowIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpDataprocIntegration - Dataproc Integration
type CloudGcpDataprocIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpDataprocIntegration) ImplementsCloudIntegration() {}

// CloudGcpDataprocIntegrationInput - Dataproc
type CloudGcpDataprocIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpDatastoreIntegration - Datastore Integration
type CloudGcpDatastoreIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpDatastoreIntegration) ImplementsCloudIntegration() {}

// CloudGcpDatastoreIntegrationInput - Datastore
type CloudGcpDatastoreIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpDisableIntegrationsInput - List of integrations
type CloudGcpDisableIntegrationsInput struct {
	// Vertex AI integration
	GcpAiplatform []CloudDisableAccountIntegrationInput `json:"gcpAiplatform,omitempty"`
	// AlloyDB integration
	GcpAlloydb []CloudDisableAccountIntegrationInput `json:"gcpAlloydb,omitempty"`
	// App Engine integration
	GcpAppengine []CloudDisableAccountIntegrationInput `json:"gcpAppengine,omitempty"`
	// BigQuery integration
	GcpBigquery []CloudDisableAccountIntegrationInput `json:"gcpBigquery,omitempty"`
	// Bigtable integration
	GcpBigtable []CloudDisableAccountIntegrationInput `json:"gcpBigtable,omitempty"`
	// Composer integration
	GcpComposer []CloudDisableAccountIntegrationInput `json:"gcpComposer,omitempty"`
	// Dataflow integration
	GcpDataflow []CloudDisableAccountIntegrationInput `json:"gcpDataflow,omitempty"`
	// Dataproc integration
	GcpDataproc []CloudDisableAccountIntegrationInput `json:"gcpDataproc,omitempty"`
	// Datastore integration
	GcpDatastore []CloudDisableAccountIntegrationInput `json:"gcpDatastore,omitempty"`
	// Firebase Database integration
	GcpFirebasedatabase []CloudDisableAccountIntegrationInput `json:"gcpFirebasedatabase,omitempty"`
	// Firebase Hosting integration
	GcpFirebasehosting []CloudDisableAccountIntegrationInput `json:"gcpFirebasehosting,omitempty"`
	// Firebase Storage integration
	GcpFirebasestorage []CloudDisableAccountIntegrationInput `json:"gcpFirebasestorage,omitempty"`
	// Firestore integration
	GcpFirestore []CloudDisableAccountIntegrationInput `json:"gcpFirestore,omitempty"`
	// Cloud Functions integration
	GcpFunctions []CloudDisableAccountIntegrationInput `json:"gcpFunctions,omitempty"`
	// Interconnect integration
	GcpInterconnect []CloudDisableAccountIntegrationInput `json:"gcpInterconnect,omitempty"`
	// Kubernetes Engine integration
	GcpKubernetes []CloudDisableAccountIntegrationInput `json:"gcpKubernetes,omitempty"`
	// Cloud Load Balancing integration
	GcpLoadbalancing []CloudDisableAccountIntegrationInput `json:"gcpLoadbalancing,omitempty"`
	// Memcache integration
	GcpMemcache []CloudDisableAccountIntegrationInput `json:"gcpMemcache,omitempty"`
	// Cloud Pub/Sub integration
	GcpPubsub []CloudDisableAccountIntegrationInput `json:"gcpPubsub,omitempty"`
	// Redis integration
	GcpRedis []CloudDisableAccountIntegrationInput `json:"gcpRedis,omitempty"`
	// Router integration
	GcpRouter []CloudDisableAccountIntegrationInput `json:"gcpRouter,omitempty"`
	// Run integration
	GcpRun []CloudDisableAccountIntegrationInput `json:"gcpRun,omitempty"`
	// Cloud Spanner integration
	GcpSpanner []CloudDisableAccountIntegrationInput `json:"gcpSpanner,omitempty"`
	// Cloud SQL integration
	GcpSql []CloudDisableAccountIntegrationInput `json:"gcpSql,omitempty"`
	// Cloud Storage integration
	GcpStorage []CloudDisableAccountIntegrationInput `json:"gcpStorage,omitempty"`
	// Compute Engine integration
	GcpVms []CloudDisableAccountIntegrationInput `json:"gcpVms,omitempty"`
	// VPC Access integration
	GcpVpcaccess []CloudDisableAccountIntegrationInput `json:"gcpVpcaccess,omitempty"`
}

// CloudGcpFirebasedatabaseIntegration - Firebase Database Integration
type CloudGcpFirebasedatabaseIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpFirebasedatabaseIntegration) ImplementsCloudIntegration() {}

// CloudGcpFirebasedatabaseIntegrationInput - Firebase Database
type CloudGcpFirebasedatabaseIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpFirebasehostingIntegration - Firebase Hosting Integration
type CloudGcpFirebasehostingIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpFirebasehostingIntegration) ImplementsCloudIntegration() {}

// CloudGcpFirebasehostingIntegrationInput - Firebase Hosting
type CloudGcpFirebasehostingIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpFirebasestorageIntegration - Firebase Storage Integration
type CloudGcpFirebasestorageIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpFirebasestorageIntegration) ImplementsCloudIntegration() {}

// CloudGcpFirebasestorageIntegrationInput - Firebase Storage
type CloudGcpFirebasestorageIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpFirestoreIntegration - Firestore Integration
type CloudGcpFirestoreIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpFirestoreIntegration) ImplementsCloudIntegration() {}

// CloudGcpFirestoreIntegrationInput - Firestore
type CloudGcpFirestoreIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpFunctionsIntegration - Cloud Functions Integration
type CloudGcpFunctionsIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpFunctionsIntegration) ImplementsCloudIntegration() {}

// CloudGcpFunctionsIntegrationInput - Google Cloud Functions
type CloudGcpFunctionsIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpIntegrationsInput - List of integrations
type CloudGcpIntegrationsInput struct {
	// Vertex AI integration
	GcpAiplatform []CloudGcpAiplatformIntegrationInput `json:"gcpAiplatform,omitempty"`
	// AlloyDB integration
	GcpAlloydb []CloudGcpAlloydbIntegrationInput `json:"gcpAlloydb,omitempty"`
	// App Engine integration
	GcpAppengine []CloudGcpAppengineIntegrationInput `json:"gcpAppengine,omitempty"`
	// BigQuery integration
	GcpBigquery []CloudGcpBigqueryIntegrationInput `json:"gcpBigquery,omitempty"`
	// Bigtable integration
	GcpBigtable []CloudGcpBigtableIntegrationInput `json:"gcpBigtable,omitempty"`
	// Composer integration
	GcpComposer []CloudGcpComposerIntegrationInput `json:"gcpComposer,omitempty"`
	// Dataflow integration
	GcpDataflow []CloudGcpDataflowIntegrationInput `json:"gcpDataflow,omitempty"`
	// Dataproc integration
	GcpDataproc []CloudGcpDataprocIntegrationInput `json:"gcpDataproc,omitempty"`
	// Datastore integration
	GcpDatastore []CloudGcpDatastoreIntegrationInput `json:"gcpDatastore,omitempty"`
	// Firebase Database integration
	GcpFirebasedatabase []CloudGcpFirebasedatabaseIntegrationInput `json:"gcpFirebasedatabase,omitempty"`
	// Firebase Hosting integration
	GcpFirebasehosting []CloudGcpFirebasehostingIntegrationInput `json:"gcpFirebasehosting,omitempty"`
	// Firebase Storage integration
	GcpFirebasestorage []CloudGcpFirebasestorageIntegrationInput `json:"gcpFirebasestorage,omitempty"`
	// Firestore integration
	GcpFirestore []CloudGcpFirestoreIntegrationInput `json:"gcpFirestore,omitempty"`
	// Cloud Functions integration
	GcpFunctions []CloudGcpFunctionsIntegrationInput `json:"gcpFunctions,omitempty"`
	// Interconnect integration
	GcpInterconnect []CloudGcpInterconnectIntegrationInput `json:"gcpInterconnect,omitempty"`
	// Kubernetes Engine integration
	GcpKubernetes []CloudGcpKubernetesIntegrationInput `json:"gcpKubernetes,omitempty"`
	// Cloud Load Balancing integration
	GcpLoadbalancing []CloudGcpLoadbalancingIntegrationInput `json:"gcpLoadbalancing,omitempty"`
	// Memcache integration
	GcpMemcache []CloudGcpMemcacheIntegrationInput `json:"gcpMemcache,omitempty"`
	// Cloud Pub/Sub integration
	GcpPubsub []CloudGcpPubsubIntegrationInput `json:"gcpPubsub,omitempty"`
	// Redis integration
	GcpRedis []CloudGcpRedisIntegrationInput `json:"gcpRedis,omitempty"`
	// Router integration
	GcpRouter []CloudGcpRouterIntegrationInput `json:"gcpRouter,omitempty"`
	// Run integration
	GcpRun []CloudGcpRunIntegrationInput `json:"gcpRun,omitempty"`
	// Cloud Spanner integration
	GcpSpanner []CloudGcpSpannerIntegrationInput `json:"gcpSpanner,omitempty"`
	// Cloud SQL integration
	GcpSql []CloudGcpSqlIntegrationInput `json:"gcpSql,omitempty"`
	// Cloud Storage integration
	GcpStorage []CloudGcpStorageIntegrationInput `json:"gcpStorage,omitempty"`
	// Compute Engine integration
	GcpVms []CloudGcpVmsIntegrationInput `json:"gcpVms,omitempty"`
	// VPC Access integration
	GcpVpcaccess []CloudGcpVpcaccessIntegrationInput `json:"gcpVpcaccess,omitempty"`
}

// CloudGcpInterconnectIntegration - Interconnect Integration
type CloudGcpInterconnectIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpInterconnectIntegration) ImplementsCloudIntegration() {}

// CloudGcpInterconnectIntegrationInput - Interconnect
type CloudGcpInterconnectIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpKubernetesIntegration - Kubernetes Engine Integration
type CloudGcpKubernetesIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpKubernetesIntegration) ImplementsCloudIntegration() {}

// CloudGcpKubernetesIntegrationInput - Google Kubernetes Engine
type CloudGcpKubernetesIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpLinkAccountInput - Information required to link a GCP account to a NewRelic account.
type CloudGcpLinkAccountInput struct {
	// The linked account name.
	Name string `json:"name"`
	// The GCP project identifier.
	ProjectId string `json:"projectId"`
}

// CloudGcpLoadbalancingIntegration - Cloud Load Balancing Integration
type CloudGcpLoadbalancingIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpLoadbalancingIntegration) ImplementsCloudIntegration() {}

// CloudGcpLoadbalancingIntegrationInput - Google Cloud Load Balancing
type CloudGcpLoadbalancingIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpMemcacheIntegration - Memcache Integration
type CloudGcpMemcacheIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpMemcacheIntegration) ImplementsCloudIntegration() {}

// CloudGcpMemcacheIntegrationInput - Memcache
type CloudGcpMemcacheIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpProvider - The Google Cloud Platform cloud provider
type CloudGcpProvider struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud provider identifier in NewRelic.
	ID int `json:"id"`
	// The cloud provider icon name.
	Icon string `json:"icon"`
	// The cloud provider name.
	Name string `json:"name"`
	// Get details of one cloud provider service.
	Service CloudService `json:"service,omitempty"`
	// The service account identifier used to link the GCP project to NewRelic.
	ServiceAccountId string `json:"serviceAccountId"`
	// Get details of all the cloud provider services available for integration.
	Services []CloudService `json:"services"`
	// The cloud provider short name.
	Slug string `json:"slug"`
	// Get template params of one cloud provider service.
	TemplateParams []CloudTemplateParam `json:"templateParams"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpProvider) ImplementsCloudProvider() {}

// CloudGcpPubsubIntegration - Cloud Pub/Sub Integration
type CloudGcpPubsubIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpPubsubIntegration) ImplementsCloudIntegration() {}

// CloudGcpPubsubIntegrationInput - Cloud Pub/Sub
type CloudGcpPubsubIntegrationInput struct {
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpRedisIntegration - Redis Integration
type CloudGcpRedisIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpRedisIntegration) ImplementsCloudIntegration() {}

// CloudGcpRedisIntegrationInput - Redis
type CloudGcpRedisIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpRouterIntegration - Router Integration
type CloudGcpRouterIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpRouterIntegration) ImplementsCloudIntegration() {}

// CloudGcpRouterIntegrationInput - Router
type CloudGcpRouterIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpRunIntegration - Run Integration
type CloudGcpRunIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpRunIntegration) ImplementsCloudIntegration() {}

// CloudGcpRunIntegrationInput - Run
type CloudGcpRunIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpSpannerIntegration - Cloud Spanner Integration
type CloudGcpSpannerIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpSpannerIntegration) ImplementsCloudIntegration() {}

// CloudGcpSpannerIntegrationInput - Cloud Spanner
type CloudGcpSpannerIntegrationInput struct {
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpSqlIntegration - Cloud SQL Integration
type CloudGcpSqlIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpSqlIntegration) ImplementsCloudIntegration() {}

// CloudGcpSqlIntegrationInput - Google Cloud SQL
type CloudGcpSqlIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpStorageIntegration - Cloud Storage Integration
type CloudGcpStorageIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpStorageIntegration) ImplementsCloudIntegration() {}

// CloudGcpStorageIntegrationInput - Google Cloud Storage
type CloudGcpStorageIntegrationInput struct {
	// Specify if labels and the extended inventory should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpUpdateAccountInput - Information required to update a GCP account to a NewRelic account.
type CloudGcpUpdateAccountInput struct {
	// Disable the linked account.
	Disabled bool `json:"disabled,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The linked account new name.
	Name string `json:"name,omitempty"`
	// The GCP project identifier.
	ProjectId string `json:"projectId,omitempty"`
}

// CloudGcpVmsIntegration - Compute Engine Integration
type CloudGcpVmsIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpVmsIntegration) ImplementsCloudIntegration() {}

// CloudGcpVmsIntegrationInput - Google Compute Engine
type CloudGcpVmsIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudGcpVpcaccessIntegration - VPC Access Integration
type CloudGcpVpcaccessIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudGcpVpcaccessIntegration) ImplementsCloudIntegration() {}

// CloudGcpVpcaccessIntegrationInput - VPC Access
type CloudGcpVpcaccessIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudHealthIntegration - Health Integration
type CloudHealthIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudHealthIntegration) ImplementsCloudIntegration() {}

// CloudHealthIntegrationInput - AWS Health
type CloudHealthIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudIamIntegration - IAM Integration
type CloudIamIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudIamIntegration) ImplementsCloudIntegration() {}

// CloudIamIntegrationInput - AWS Identity and Access Management (IAM)
type CloudIamIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudIntegration - The configuration of a cloud service integration for a linked account.
type CloudIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudIntegration) ImplementsCloudIntegration() {}

// CloudIntegrationMutationError - Integration Mutation Error
type CloudIntegrationMutationError struct {
	// The passed integration slug.
	IntegrationSlug string `json:"integrationSlug,omitempty"`
	// The passed linked account identifier.
	LinkedAccountId int `json:"linkedAccountId,omitempty"`
	// The error message.
	Message string `json:"message"`
	// The passed newrelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The error status.
	Type string `json:"type"`
}

// CloudIntegrationsInput - List of providers
type CloudIntegrationsInput struct {
	// Aws provider
	Aws CloudAwsIntegrationsInput `json:"aws,omitempty"`
	// AwsGovcloud provider
	AwsGovcloud CloudAwsGovcloudIntegrationsInput `json:"awsGovcloud,omitempty"`
	// Azure provider
	Azure CloudAzureIntegrationsInput `json:"azure,omitempty"`
	// Gcp provider
	Gcp CloudGcpIntegrationsInput `json:"gcp,omitempty"`
}

// CloudIotIntegration - IoT Integration
type CloudIotIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudIotIntegration) ImplementsCloudIntegration() {}

// CloudIotIntegrationInput - AWS IoT
type CloudIotIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudKinesisFirehoseIntegration - Kinesis Firehose Integration
type CloudKinesisFirehoseIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudKinesisFirehoseIntegration) ImplementsCloudIntegration() {}

// CloudKinesisFirehoseIntegrationInput - Amazon Kinesis Data Firehose
type CloudKinesisFirehoseIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudKinesisIntegration - Kinesis Streams Integration
type CloudKinesisIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if Shards should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchShards bool `json:"fetchShards,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudKinesisIntegration) ImplementsCloudIntegration() {}

// CloudKinesisIntegrationInput - Amazon Kinesis Data Streams
type CloudKinesisIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if Shards should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchShards bool `json:"fetchShards,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudLambdaIntegration - Lambda Integration
type CloudLambdaIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudLambdaIntegration) ImplementsCloudIntegration() {}

// CloudLambdaIntegrationInput - AWS Lambda
type CloudLambdaIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudLinkAccountPayload - Autogenerated return type of LinkAccount
type CloudLinkAccountPayload struct {
	// The list of errors.
	Errors []CloudAccountMutationError `json:"errors"`
	// The created Linked accounts.
	LinkedAccounts []CloudLinkedAccount `json:"linkedAccounts"`
}

// CloudLinkCloudAccountsInput - Specific Cloud provider information required to link the Cloud provider account to a NewRelic account.
type CloudLinkCloudAccountsInput struct {
	// Aws provider
	Aws []CloudAwsLinkAccountInput `json:"aws,omitempty"`
	// AwsGovCloud provider
	AwsGovcloud []CloudAwsGovCloudLinkAccountInput `json:"awsGovcloud,omitempty"`
	// Azure provider
	Azure []CloudAzureLinkAccountInput `json:"azure,omitempty"`
	// Gcp provider
	Gcp []CloudGcpLinkAccountInput `json:"gcp,omitempty"`
}

// CloudLinkedAccount - A cloud account linked to a NewRelic account.
type CloudLinkedAccount struct {
	// The credential. This is a Role ARN for AWS, an application ID for Azure and a service account ID or user account email for GCP.
	AuthLabel string `json:"authLabel"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Indicates whether the account disabled.
	Disabled bool `json:"disabled,omitempty"`
	// The cloud account identifier. This is the Account ID in AWS, the Subscription ID in Azure and the Project ID in GCP.
	ExternalId string `json:"externalId,omitempty"`
	// The linked account identifier in NewRelic.
	ID int `json:"id"`
	// Get details of one cloud service integration.
	Integration CloudIntegrationInterface `json:"integration"`
	// Get details of all cloud service integrations.
	Integrations []CloudIntegrationInterface `json:"integrations"`
	// Indicate how the metrics will be collected (PUSH/PULL)
	MetricCollectionMode CloudMetricCollectionMode `json:"metricCollectionMode"`
	// The linked account name in NewRelic.
	Name string `json:"name"`
	// The New Relic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud provider.
	Provider CloudProviderInterface `json:"provider"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

// special
func (x *CloudLinkedAccount) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "authLabel":
			err = json.Unmarshal(*v, &x.AuthLabel)
			if err != nil {
				return err
			}
		case "createdAt":
			err = json.Unmarshal(*v, &x.CreatedAt)
			if err != nil {
				return err
			}
		case "disabled":
			err = json.Unmarshal(*v, &x.Disabled)
			if err != nil {
				return err
			}
		case "externalId":
			err = json.Unmarshal(*v, &x.ExternalId)
			if err != nil {
				return err
			}
		case "id":
			err = json.Unmarshal(*v, &x.ID)
			if err != nil {
				return err
			}
		case "integration":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalCloudIntegrationInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Integration = *xxx
			}
		case "integrations":
			if v == nil {
				continue
			}
			var rawMessageIntegrations []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageIntegrations)
			if err != nil {
				return err
			}

			for _, m := range rawMessageIntegrations {
				xxx, err := UnmarshalCloudIntegrationInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.Integrations = append(x.Integrations, *xxx)
				}
			}
		case "metricCollectionMode":
			err = json.Unmarshal(*v, &x.MetricCollectionMode)
			if err != nil {
				return err
			}
		case "name":
			err = json.Unmarshal(*v, &x.Name)
			if err != nil {
				return err
			}
		case "nrAccountId":
			err = json.Unmarshal(*v, &x.NrAccountId)
			if err != nil {
				return err
			}
		case "provider":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalCloudProviderInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Provider = *xxx
			}
		case "updatedAt":
			err = json.Unmarshal(*v, &x.UpdatedAt)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// CloudProvider - A cloud services provider.
type CloudProvider struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud provider identifier in NewRelic.
	ID int `json:"id"`
	// The cloud provider icon name.
	Icon string `json:"icon"`
	// The cloud provider name.
	Name string `json:"name"`
	// Get details of one cloud provider service.
	Service CloudService `json:"service,omitempty"`
	// Get details of all the cloud provider services available for integration.
	Services []CloudService `json:"services"`
	// The cloud provider short name.
	Slug string `json:"slug"`
	// Get template params of one cloud provider service.
	TemplateParams []CloudTemplateParam `json:"templateParams"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudProvider) ImplementsCloudProvider() {}

// CloudRdsIntegration - RDS Integration
type CloudRdsIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudRdsIntegration) ImplementsCloudIntegration() {}

// CloudRdsIntegrationInput - Amazon Relation Database Service (RDS)
type CloudRdsIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudRedshiftIntegration - Redshift Integration
type CloudRedshiftIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudRedshiftIntegration) ImplementsCloudIntegration() {}

// CloudRedshiftIntegrationInput - Amazon Redshift
type CloudRedshiftIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudRenameAccountPayload - Autogenerated return type of RenameAccount
type CloudRenameAccountPayload struct {
	// The list of errors.
	Errors []CloudAccountMutationError `json:"errors"`
	// The updated linked accounts.
	LinkedAccounts []CloudLinkedAccount `json:"linkedAccounts"`
}

// CloudRenameAccountsInput - Information required when operating on a Linked Account.
type CloudRenameAccountsInput struct {
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The linked account new name.
	Name string `json:"name"`
}

// CloudRoute53Integration - Route 53 Integration
type CloudRoute53Integration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudRoute53Integration) ImplementsCloudIntegration() {}

// CloudRoute53IntegrationInput - Amazon Route 53
type CloudRoute53IntegrationInput struct {
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudS3Integration - S3 Integration
type CloudS3Integration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudS3Integration) ImplementsCloudIntegration() {}

// CloudS3IntegrationInput - Amazon Simple Storage Service (S3)
type CloudS3IntegrationInput struct {
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudService - A Cloud Provider service available for monitoring.
type CloudService struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service dashboard templates.
	Dashboards []CloudDashboardTemplate `json:"dashboards"`
	// The cloud service identifier in NewRelic.
	ID int `json:"id"`
	// The cloud service icon name.
	Icon string `json:"icon"`
	// Shows if the cloud service is enabled for integrating.
	IsEnabled bool `json:"isEnabled"`
	// The cloud service name.
	Name string `json:"name"`
	// The cloud provider.
	Provider CloudProviderInterface `json:"provider"`
	// The cloud service unique short name.
	Slug string `json:"slug"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

// special
func (x *CloudService) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "createdAt":
			err = json.Unmarshal(*v, &x.CreatedAt)
			if err != nil {
				return err
			}
		case "dashboards":
			err = json.Unmarshal(*v, &x.Dashboards)
			if err != nil {
				return err
			}
		case "id":
			err = json.Unmarshal(*v, &x.ID)
			if err != nil {
				return err
			}
		case "icon":
			err = json.Unmarshal(*v, &x.Icon)
			if err != nil {
				return err
			}
		case "isEnabled":
			err = json.Unmarshal(*v, &x.IsEnabled)
			if err != nil {
				return err
			}
		case "name":
			err = json.Unmarshal(*v, &x.Name)
			if err != nil {
				return err
			}
		case "provider":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalCloudProviderInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Provider = *xxx
			}
		case "slug":
			err = json.Unmarshal(*v, &x.Slug)
			if err != nil {
				return err
			}
		case "updatedAt":
			err = json.Unmarshal(*v, &x.UpdatedAt)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// CloudSesIntegration - SES Integration
type CloudSesIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudSesIntegration) ImplementsCloudIntegration() {}

// CloudSesIntegrationInput - Amazon Simple Email Service (SES)
type CloudSesIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudSnsIntegration - SNS Integration
type CloudSnsIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudSnsIntegration) ImplementsCloudIntegration() {}

// CloudSnsIntegrationInput - Amazon Simple Notification Service (SNS)
type CloudSnsIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudSqsIntegration - SQS Integration
type CloudSqsIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// Specify each name or prefix for the Queues that you want to monitor. Filter values are case-sensitive.
	QueuePrefixes []string `json:"queuePrefixes,omitempty"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudSqsIntegration) ImplementsCloudIntegration() {}

// CloudSqsIntegrationInput - Amazon Simple Queue Service (SQS)
type CloudSqsIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Determine if extra inventory data be collected or not. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchExtendedInventory bool `json:"fetchExtendedInventory,omitempty"`
	// Specify if tags should be collected. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchTags bool `json:"fetchTags,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify each name or prefix for the Queues that you want to monitor. Filter values are case-sensitive.
	QueuePrefixes []string `json:"queuePrefixes,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

// CloudTemplateParam - Provider template form params
type CloudTemplateParam struct {
	// The provider template param autocomplete.
	Autocomplete string `json:"autocomplete,omitempty"`
	// The provider template param immutable.
	Immutable bool `json:"immutable,omitempty"`
	// The provider template param label.
	Label string `json:"label,omitempty"`
	// The provider template param name.
	Name string `json:"name"`
	// The provider template param placeholder.
	Placeholder string `json:"placeholder,omitempty"`
	// The provider template param type.
	Type string `json:"type"`
}

// CloudTrustedadvisorIntegration - Trusted Advisor Integration
type CloudTrustedadvisorIntegration struct {
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudTrustedadvisorIntegration) ImplementsCloudIntegration() {}

// CloudTrustedadvisorIntegrationInput - Trusted Advisor
type CloudTrustedadvisorIntegrationInput struct {
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
}

// CloudUnlinkAccountPayload - Autogenerated return type of UnlinkAccount
type CloudUnlinkAccountPayload struct {
	// The list of errors.
	Errors []CloudAccountMutationError `json:"errors"`
	// The unlinked accounts.
	UnlinkedAccounts []CloudLinkedAccount `json:"unlinkedAccounts"`
}

// CloudUnlinkAccountsInput - Information required to unlink (remove) a linked account.
type CloudUnlinkAccountsInput struct {
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
}

// CloudUpdateAccountPayload - Autogenerated return type of UpdateAccount
type CloudUpdateAccountPayload struct {
	// The updated Linked accounts.
	LinkedAccounts []CloudLinkedAccount `json:"linkedAccounts"`
}

// CloudUpdateCloudAccountsInput - Specific Cloud provider information required to update the Cloud provider account to a NewRelic account.
type CloudUpdateCloudAccountsInput struct {
	// Aws provider
	Aws []CloudAwsUpdateAccountInput `json:"aws,omitempty"`
	// AwsGovCloud provider
	AwsGovcloud []CloudAwsGovCloudUpdateAccountInput `json:"awsGovcloud,omitempty"`
	// Azure provider
	Azure []CloudAzureUpdateAccountInput `json:"azure,omitempty"`
	// Confluent Cloud provider
	Confluent []CloudConfluentUpdateAccountInput `json:"confluent,omitempty"`
	// Fossa provider
	Fossa []CloudFossaUpdateAccountInput `json:"fossa,omitempty"`
	// Gcp provider
	Gcp []CloudGcpUpdateAccountInput `json:"gcp,omitempty"`
}

// CloudVpcIntegration - VPC Integration
type CloudVpcIntegration struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// The object creation date, in epoch (Unix) time
	CreatedAt nrtime.EpochSeconds `json:"createdAt"`
	// Specify if NAT gateway should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchNatGateway bool `json:"fetchNatGateway,omitempty"`
	// Specify if VPN should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchVpn bool `json:"fetchVpn,omitempty"`
	// The cloud service integration identifier.
	ID int `json:"id,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The parent linked account identifier.
	LinkedAccount CloudLinkedAccount `json:"linkedAccount,omitempty"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// The cloud service integration name.
	Name string `json:"name,omitempty"`
	// The parent NewRelic account identifier.
	NrAccountId int `json:"nrAccountId"`
	// The cloud service used in the integration.
	Service CloudService `json:"service,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
	// The object last update date, in epoch (Unix) time
	UpdatedAt nrtime.EpochSeconds `json:"updatedAt"`
}

func (x *CloudVpcIntegration) ImplementsCloudIntegration() {}

// CloudVpcIntegrationInput - Amazon Virtual Private Cloud (VPC)
type CloudVpcIntegrationInput struct {
	// Specify each AWS region that includes the resources that you want to monitor.
	AwsRegions []string `json:"awsRegions,omitempty"`
	// Specify if NAT gateway should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchNatGateway bool `json:"fetchNatGateway,omitempty"`
	// Specify if VPN should be monitored. May affect total data collection time and contribute to the Cloud provider API rate limit.
	FetchVpn bool `json:"fetchVpn,omitempty"`
	// [DEPRECATED] Multiple polling interval is no longer supported, use only metrics_polling_interval
	InventoryPollingInterval int `json:"inventoryPollingInterval,omitempty"`
	// The linked account identifier.
	LinkedAccountId int `json:"linkedAccountId"`
	// The data polling interval in seconds.
	MetricsPollingInterval int `json:"metricsPollingInterval,omitempty"`
	// Specify a Tag key associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagKey string `json:"tagKey,omitempty"`
	// Specify a Tag value associated with the resources that you want to monitor. Filter values are case-sensitive.
	TagValue string `json:"tagValue,omitempty"`
}

type linkedAccountResponse struct {
	Actor Actor `json:"actor"`
}

type linkedAccountsResponse struct {
	Actor Actor `json:"actor"`
}

// SecureValue - The `SecureValue` scalar represents a secure value, ie a password, an API key, etc.
type SecureValue string

// CloudIntegration - The configuration of a cloud service integration for a linked account.
type CloudIntegrationInterface interface {
	ImplementsCloudIntegration()
}

// UnmarshalCloudIntegrationInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalCloudIntegrationInterface(b []byte) (*CloudIntegrationInterface, error) {
	var err error

	var rawMessageCloudIntegration map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageCloudIntegration)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageCloudIntegration) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageCloudIntegration["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "CloudAlbIntegration":
			var interfaceType CloudAlbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudApigatewayIntegration":
			var interfaceType CloudAPIgatewayIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAutoscalingIntegration":
			var interfaceType CloudAutoscalingIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsAppsyncIntegration":
			var interfaceType CloudAwsAppsyncIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsAthenaIntegration":
			var interfaceType CloudAwsAthenaIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsCognitoIntegration":
			var interfaceType CloudAwsCognitoIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsConnectIntegration":
			var interfaceType CloudAwsConnectIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsDirectconnectIntegration":
			var interfaceType CloudAwsDirectconnectIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsDocdbIntegration":
			var interfaceType CloudAwsDocdbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsFsxIntegration":
			var interfaceType CloudAwsFsxIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsGlueIntegration":
			var interfaceType CloudAwsGlueIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsKinesisanalyticsIntegration":
			var interfaceType CloudAwsKinesisanalyticsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsMediaconvertIntegration":
			var interfaceType CloudAwsMediaconvertIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsMediapackagevodIntegration":
			var interfaceType CloudAwsMediapackagevodIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsMetadataIntegration":
			var interfaceType CloudAwsMetadataIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsMqIntegration":
			var interfaceType CloudAwsMqIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsMsElasticacheIntegration":
			var interfaceType CloudAwsMsElasticacheIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsMskIntegration":
			var interfaceType CloudAwsMskIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsNeptuneIntegration":
			var interfaceType CloudAwsNeptuneIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsQldbIntegration":
			var interfaceType CloudAwsQldbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsRoute53resolverIntegration":
			var interfaceType CloudAwsRoute53resolverIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsStatesIntegration":
			var interfaceType CloudAwsStatesIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsTagsGlobalIntegration":
			var interfaceType CloudAwsTagsGlobalIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsTransitgatewayIntegration":
			var interfaceType CloudAwsTransitgatewayIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsWafIntegration":
			var interfaceType CloudAwsWafIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsWafv2Integration":
			var interfaceType CloudAwsWafv2Integration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsXrayIntegration":
			var interfaceType CloudAwsXrayIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureApimanagementIntegration":
			var interfaceType CloudAzureAPImanagementIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureAppgatewayIntegration":
			var interfaceType CloudAzureAppgatewayIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureAppserviceIntegration":
			var interfaceType CloudAzureAppserviceIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureContainersIntegration":
			var interfaceType CloudAzureContainersIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureCosmosdbIntegration":
			var interfaceType CloudAzureCosmosdbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureCostmanagementIntegration":
			var interfaceType CloudAzureCostmanagementIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureDatafactoryIntegration":
			var interfaceType CloudAzureDatafactoryIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureEventhubIntegration":
			var interfaceType CloudAzureEventhubIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureExpressrouteIntegration":
			var interfaceType CloudAzureExpressrouteIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureFirewallsIntegration":
			var interfaceType CloudAzureFirewallsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureFrontdoorIntegration":
			var interfaceType CloudAzureFrontdoorIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureFunctionsIntegration":
			var interfaceType CloudAzureFunctionsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureKeyvaultIntegration":
			var interfaceType CloudAzureKeyvaultIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureLoadbalancerIntegration":
			var interfaceType CloudAzureLoadbalancerIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureLogicappsIntegration":
			var interfaceType CloudAzureLogicappsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureMachinelearningIntegration":
			var interfaceType CloudAzureMachinelearningIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureMariadbIntegration":
			var interfaceType CloudAzureMariadbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureMonitorIntegration":
			var interfaceType CloudAzureMonitorIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureMysqlIntegration":
			var interfaceType CloudAzureMysqlIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureMysqlflexibleIntegration":
			var interfaceType CloudAzureMysqlflexibleIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzurePostgresqlIntegration":
			var interfaceType CloudAzurePostgresqlIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzurePostgresqlflexibleIntegration":
			var interfaceType CloudAzurePostgresqlflexibleIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzurePowerbidedicatedIntegration":
			var interfaceType CloudAzurePowerbidedicatedIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureRediscacheIntegration":
			var interfaceType CloudAzureRediscacheIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureServicebusIntegration":
			var interfaceType CloudAzureServicebusIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureSqlIntegration":
			var interfaceType CloudAzureSqlIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureSqlmanagedIntegration":
			var interfaceType CloudAzureSqlmanagedIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureStorageIntegration":
			var interfaceType CloudAzureStorageIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureVirtualmachineIntegration":
			var interfaceType CloudAzureVirtualmachineIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureVirtualnetworksIntegration":
			var interfaceType CloudAzureVirtualnetworksIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureVmsIntegration":
			var interfaceType CloudAzureVmsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudAzureVpngatewaysIntegration":
			var interfaceType CloudAzureVpngatewaysIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudBaseIntegration":
			var interfaceType CloudBaseIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudBillingIntegration":
			var interfaceType CloudBillingIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudCloudfrontIntegration":
			var interfaceType CloudCloudfrontIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudCloudtrailIntegration":
			var interfaceType CloudCloudtrailIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudDynamodbIntegration":
			var interfaceType CloudDynamodbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudEbsIntegration":
			var interfaceType CloudEbsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudEc2Integration":
			var interfaceType CloudEc2Integration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudEcsIntegration":
			var interfaceType CloudEcsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudEfsIntegration":
			var interfaceType CloudEfsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudElasticacheIntegration":
			var interfaceType CloudElasticacheIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudElasticbeanstalkIntegration":
			var interfaceType CloudElasticbeanstalkIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudElasticsearchIntegration":
			var interfaceType CloudElasticsearchIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudElbIntegration":
			var interfaceType CloudElbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudEmrIntegration":
			var interfaceType CloudEmrIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpAiplatformIntegration":
			var interfaceType CloudGcpAiplatformIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpAlloydbIntegration":
			var interfaceType CloudGcpAlloydbIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpAppengineIntegration":
			var interfaceType CloudGcpAppengineIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpBigqueryIntegration":
			var interfaceType CloudGcpBigqueryIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpBigtableIntegration":
			var interfaceType CloudGcpBigtableIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpComposerIntegration":
			var interfaceType CloudGcpComposerIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpDataflowIntegration":
			var interfaceType CloudGcpDataflowIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpDataprocIntegration":
			var interfaceType CloudGcpDataprocIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpDatastoreIntegration":
			var interfaceType CloudGcpDatastoreIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpFirebasedatabaseIntegration":
			var interfaceType CloudGcpFirebasedatabaseIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpFirebasehostingIntegration":
			var interfaceType CloudGcpFirebasehostingIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpFirebasestorageIntegration":
			var interfaceType CloudGcpFirebasestorageIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpFirestoreIntegration":
			var interfaceType CloudGcpFirestoreIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpFunctionsIntegration":
			var interfaceType CloudGcpFunctionsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpInterconnectIntegration":
			var interfaceType CloudGcpInterconnectIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpKubernetesIntegration":
			var interfaceType CloudGcpKubernetesIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpLoadbalancingIntegration":
			var interfaceType CloudGcpLoadbalancingIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpMemcacheIntegration":
			var interfaceType CloudGcpMemcacheIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpPubsubIntegration":
			var interfaceType CloudGcpPubsubIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpRedisIntegration":
			var interfaceType CloudGcpRedisIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpRouterIntegration":
			var interfaceType CloudGcpRouterIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpRunIntegration":
			var interfaceType CloudGcpRunIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpSpannerIntegration":
			var interfaceType CloudGcpSpannerIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpSqlIntegration":
			var interfaceType CloudGcpSqlIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpStorageIntegration":
			var interfaceType CloudGcpStorageIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpVmsIntegration":
			var interfaceType CloudGcpVmsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpVpcaccessIntegration":
			var interfaceType CloudGcpVpcaccessIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudHealthIntegration":
			var interfaceType CloudHealthIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudIamIntegration":
			var interfaceType CloudIamIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudIotIntegration":
			var interfaceType CloudIotIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudKinesisFirehoseIntegration":
			var interfaceType CloudKinesisFirehoseIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudKinesisIntegration":
			var interfaceType CloudKinesisIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudLambdaIntegration":
			var interfaceType CloudLambdaIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudRdsIntegration":
			var interfaceType CloudRdsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudRedshiftIntegration":
			var interfaceType CloudRedshiftIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudRoute53Integration":
			var interfaceType CloudRoute53Integration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudS3Integration":
			var interfaceType CloudS3Integration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudSesIntegration":
			var interfaceType CloudSesIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudSnsIntegration":
			var interfaceType CloudSnsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudSqsIntegration":
			var interfaceType CloudSqsIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudTrustedadvisorIntegration":
			var interfaceType CloudTrustedadvisorIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		case "CloudVpcIntegration":
			var interfaceType CloudVpcIntegration
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudIntegrationInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageCloudIntegration {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface CloudIntegration did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface CloudIntegration was not matched against all PossibleTypes: %s", typeName)
}

// CloudProvider - A cloud services provider.
type CloudProviderInterface interface {
	ImplementsCloudProvider()
}

// UnmarshalCloudProviderInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalCloudProviderInterface(b []byte) (*CloudProviderInterface, error) {
	var err error

	var rawMessageCloudProvider map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageCloudProvider)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageCloudProvider) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageCloudProvider["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "CloudAwsGovCloudProvider":
			var interfaceType CloudAwsGovCloudProvider
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudProviderInterface = &interfaceType

			return &xxx, nil
		case "CloudAwsProvider":
			var interfaceType CloudAwsProvider
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudProviderInterface = &interfaceType

			return &xxx, nil
		case "CloudBaseProvider":
			var interfaceType CloudBaseProvider
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudProviderInterface = &interfaceType

			return &xxx, nil
		case "CloudGcpProvider":
			var interfaceType CloudGcpProvider
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx CloudProviderInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageCloudProvider {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface CloudProvider did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface CloudProvider was not matched against all PossibleTypes: %s", typeName)
}
