// Code generated by tutone: DO NOT EDIT
package cloud

import (
	"context"

	"github.com/newrelic/newrelic-client-go/v2/pkg/errors"
)

// Create or modify a cloud integration.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudConfigureIntegration(
	accountID int,
	integrations CloudIntegrationsInput,
) (*CloudConfigureIntegrationPayload, error) {
	return a.CloudConfigureIntegrationWithContext(context.Background(),
		accountID,
		integrations,
	)
}

// Create or modify a cloud integration.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudConfigureIntegrationWithContext(
	ctx context.Context,
	accountID int,
	integrations CloudIntegrationsInput,
) (*CloudConfigureIntegrationPayload, error) {

	resp := CloudConfigureIntegrationQueryResponse{}
	vars := map[string]interface{}{
		"accountId":    accountID,
		"integrations": integrations,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, CloudConfigureIntegrationMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.CloudConfigureIntegrationPayload, nil
}

type CloudConfigureIntegrationQueryResponse struct {
	CloudConfigureIntegrationPayload CloudConfigureIntegrationPayload `json:"CloudConfigureIntegration"`
}

const CloudConfigureIntegrationMutation = `mutation(
	$accountId: Int!,
	$integrations: CloudIntegrationsInput!,
) { cloudConfigureIntegration(
	accountId: $accountId,
	integrations: $integrations,
) {
	errors {
		integrationSlug
		linkedAccountId
		message
		nrAccountId
		type
	}
	integrations {
		__typename
		createdAt
		id
		name
		nrAccountId
		updatedAt
		... on CloudAlbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			loadBalancerPrefixes
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudApigatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			stagePrefixes
			tagKey
			tagValue
		}
		... on CloudAutoscalingIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAppsyncIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAthenaIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsCognitoIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsConnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDirectconnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDocdbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsFsxIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsGlueIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsKinesisanalyticsIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediaconvertIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediapackagevodIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMetadataIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMqIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMsElasticacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMskIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsNeptuneIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsQldbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsRoute53resolverIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsStatesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTagsGlobalIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTransitgatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafv2Integration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsXrayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAzureApimanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppgatewayIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppserviceIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureContainersIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCosmosdbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCostmanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKeys
		}
		... on CloudAzureDatafactoryIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureEventhubIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureExpressrouteIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFirewallsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFrontdoorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureKeyvaultIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLoadbalancerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLogicappsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMachinelearningIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMariadbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMonitorIntegration {
			__typename
			enabled
			excludeTags
			includeTags
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
			resourceTypes
		}
		... on CloudAzureMysqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMysqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePowerbidedicatedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureRediscacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureServicebusIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlmanagedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureStorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualmachineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualnetworksIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVpngatewaysIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudBaseIntegration {
			__typename
		}
		... on CloudBillingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudCloudfrontIntegration {
			__typename
			fetchLambdasAtEdge
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudCloudtrailIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudDynamodbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEbsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEc2Integration {
			__typename
			awsRegions
			duplicateEc2Tags
			fetchIpAddresses
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEcsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEfsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticacheIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticbeanstalkIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticsearchIntegration {
			__typename
			awsRegions
			fetchNodes
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudEmrIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudGcpAiplatformIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAlloydbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAppengineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigqueryIntegration {
			__typename
			fetchTableMetrics
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigtableIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpComposerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataflowIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataprocIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDatastoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasedatabaseIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasehostingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasestorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirestoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpInterconnectIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpKubernetesIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpLoadbalancingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpMemcacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpPubsubIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRedisIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRouterIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRunIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSpannerIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpStorageIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVpcaccessIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudHealthIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudIamIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudIotIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisFirehoseIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisIntegration {
			__typename
			awsRegions
			fetchShards
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudLambdaIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRdsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRedshiftIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRoute53Integration {
			__typename
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudS3Integration {
			__typename
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudSesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSnsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSqsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			queuePrefixes
			tagKey
			tagValue
		}
		... on CloudTrustedadvisorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudVpcIntegration {
			__typename
			awsRegions
			fetchNatGateway
			fetchVpn
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
	}
} }`

// Disable a cloud integration. Stops collecting data for the specified integration.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudDisableIntegration(
	accountID int,
	integrations CloudDisableIntegrationsInput,
) (*CloudDisableIntegrationPayload, error) {
	return a.CloudDisableIntegrationWithContext(context.Background(),
		accountID,
		integrations,
	)
}

// Disable a cloud integration. Stops collecting data for the specified integration.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudDisableIntegrationWithContext(
	ctx context.Context,
	accountID int,
	integrations CloudDisableIntegrationsInput,
) (*CloudDisableIntegrationPayload, error) {

	resp := CloudDisableIntegrationQueryResponse{}
	vars := map[string]interface{}{
		"accountId":    accountID,
		"integrations": integrations,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, CloudDisableIntegrationMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.CloudDisableIntegrationPayload, nil
}

type CloudDisableIntegrationQueryResponse struct {
	CloudDisableIntegrationPayload CloudDisableIntegrationPayload `json:"CloudDisableIntegration"`
}

// Note: Do not make "$integrations" an optional field (as fetched from Tutone) to avoid a breaking change
const CloudDisableIntegrationMutation = `mutation(
	$accountId: Int!,
	$integrations: CloudDisableIntegrationsInput!,
) { cloudDisableIntegration(
	accountId: $accountId,
	integrations: $integrations,
) {
	disabledIntegrations {
		__typename
		createdAt
		id
		name
		nrAccountId
		updatedAt
		... on CloudAlbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			loadBalancerPrefixes
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudApigatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			stagePrefixes
			tagKey
			tagValue
		}
		... on CloudAutoscalingIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAppsyncIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAthenaIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsCognitoIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsConnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDirectconnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDocdbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsFsxIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsGlueIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsKinesisanalyticsIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediaconvertIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediapackagevodIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMetadataIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMqIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMsElasticacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMskIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsNeptuneIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsQldbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsRoute53resolverIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsStatesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTagsGlobalIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTransitgatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafv2Integration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsXrayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAzureApimanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppgatewayIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppserviceIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureContainersIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCosmosdbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCostmanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKeys
		}
		... on CloudAzureDatafactoryIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureEventhubIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureExpressrouteIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFirewallsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFrontdoorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureKeyvaultIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLoadbalancerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLogicappsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMachinelearningIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMariadbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMonitorIntegration {
			__typename
			enabled
			excludeTags
			includeTags
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
			resourceTypes
		}
		... on CloudAzureMysqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMysqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePowerbidedicatedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureRediscacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureServicebusIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlmanagedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureStorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualmachineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualnetworksIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVpngatewaysIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudBaseIntegration {
			__typename
		}
		... on CloudBillingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudCloudfrontIntegration {
			__typename
			fetchLambdasAtEdge
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudCloudtrailIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudDynamodbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEbsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEc2Integration {
			__typename
			awsRegions
			duplicateEc2Tags
			fetchIpAddresses
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEcsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEfsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticacheIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticbeanstalkIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticsearchIntegration {
			__typename
			awsRegions
			fetchNodes
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudEmrIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudGcpAiplatformIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAlloydbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAppengineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigqueryIntegration {
			__typename
			fetchTableMetrics
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigtableIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpComposerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataflowIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataprocIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDatastoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasedatabaseIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasehostingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasestorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirestoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpInterconnectIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpKubernetesIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpLoadbalancingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpMemcacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpPubsubIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRedisIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRouterIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRunIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSpannerIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpStorageIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVpcaccessIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudHealthIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudIamIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudIotIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisFirehoseIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisIntegration {
			__typename
			awsRegions
			fetchShards
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudLambdaIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRdsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRedshiftIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRoute53Integration {
			__typename
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudS3Integration {
			__typename
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudSesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSnsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSqsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			queuePrefixes
			tagKey
			tagValue
		}
		... on CloudTrustedadvisorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudVpcIntegration {
			__typename
			awsRegions
			fetchNatGateway
			fetchVpn
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
	}
	errors {
		integrationSlug
		linkedAccountId
		message
		nrAccountId
		type
	}
} }`

// Link a cloud provider account to a New Relic Account.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudLinkAccount(
	accountID int,
	accounts CloudLinkCloudAccountsInput,
) (*CloudLinkAccountPayload, error) {
	return a.CloudLinkAccountWithContext(context.Background(),
		accountID,
		accounts,
	)
}

// Link a cloud provider account to a New Relic Account.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudLinkAccountWithContext(
	ctx context.Context,
	accountID int,
	accounts CloudLinkCloudAccountsInput,
) (*CloudLinkAccountPayload, error) {

	resp := CloudLinkAccountQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"accounts":  accounts,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, CloudLinkAccountMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.CloudLinkAccountPayload, nil
}

type CloudLinkAccountQueryResponse struct {
	CloudLinkAccountPayload CloudLinkAccountPayload `json:"CloudLinkAccount"`
}

const CloudLinkAccountMutation = `mutation(
	$accountId: Int!,
	$accounts: CloudLinkCloudAccountsInput!,
) { cloudLinkAccount(
	accountId: $accountId,
	accounts: $accounts,
) {
	errors {
		linkedAccountId
		message
		nrAccountId
		providerSlug
		type
	}
	linkedAccounts {
		authLabel
		createdAt
		disabled
		externalId
		id
		metricCollectionMode
		name
		nrAccountId
		updatedAt
	}
} }`

// Rename one or more linked cloud provider accounts.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudRenameAccount(
	accountID int,
	accounts []CloudRenameAccountsInput,
) (*CloudRenameAccountPayload, error) {
	return a.CloudRenameAccountWithContext(context.Background(),
		accountID,
		accounts,
	)
}

// Rename one or more linked cloud provider accounts.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudRenameAccountWithContext(
	ctx context.Context,
	accountID int,
	accounts []CloudRenameAccountsInput,
) (*CloudRenameAccountPayload, error) {

	resp := CloudRenameAccountQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"accounts":  accounts,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, CloudRenameAccountMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.CloudRenameAccountPayload, nil
}

type CloudRenameAccountQueryResponse struct {
	CloudRenameAccountPayload CloudRenameAccountPayload `json:"CloudRenameAccount"`
}

const CloudRenameAccountMutation = `mutation(
	$accountId: Int!,
	$accounts: [CloudRenameAccountsInput!]!,
) { cloudRenameAccount(
	accountId: $accountId,
	accounts: $accounts,
) {
	errors {
		linkedAccountId
		message
		nrAccountId
		providerSlug
		type
	}
	linkedAccounts {
		authLabel
		createdAt
		disabled
		externalId
		id
		metricCollectionMode
		name
		nrAccountId
		updatedAt
	}
} }`

// Unlink one or more cloud provider accounts.
// Stops collecting data for all the associated integrations.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudUnlinkAccount(
	accountID int,
	accounts []CloudUnlinkAccountsInput,
) (*CloudUnlinkAccountPayload, error) {
	return a.CloudUnlinkAccountWithContext(context.Background(),
		accountID,
		accounts,
	)
}

// Unlink one or more cloud provider accounts.
// Stops collecting data for all the associated integrations.
//
// For details and mutation examples visit
// [our docs](https://docs.newrelic.com/docs/apis/graphql-api/tutorials/manage-your-aws-azure-google-cloud-integrations-graphql-api).
func (a *Cloud) CloudUnlinkAccountWithContext(
	ctx context.Context,
	accountID int,
	accounts []CloudUnlinkAccountsInput,
) (*CloudUnlinkAccountPayload, error) {

	resp := CloudUnlinkAccountQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"accounts":  accounts,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, CloudUnlinkAccountMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.CloudUnlinkAccountPayload, nil
}

type CloudUnlinkAccountQueryResponse struct {
	CloudUnlinkAccountPayload CloudUnlinkAccountPayload `json:"CloudUnlinkAccount"`
}

const CloudUnlinkAccountMutation = `mutation(
	$accountId: Int!,
	$accounts: [CloudUnlinkAccountsInput!]!,
) { cloudUnlinkAccount(
	accountId: $accountId,
	accounts: $accounts,
) {
	errors {
		linkedAccountId
		message
		nrAccountId
		providerSlug
		type
	}
	unlinkedAccounts {
		authLabel
		createdAt
		disabled
		externalId
		id
		metricCollectionMode
		name
		nrAccountId
		updatedAt
	}
} }`

// Update one or more Cloud Provider accounts to a NewRelic account. Updates each Linked account with the passed parameters.
func (a *Cloud) CloudUpdateAccount(
	accountID int,
	accounts CloudUpdateCloudAccountsInput,
) (*CloudUpdateAccountPayload, error) {
	return a.CloudUpdateAccountWithContext(context.Background(),
		accountID,
		accounts,
	)
}

// Update one or more Cloud Provider accounts to a NewRelic account. Updates each Linked account with the passed parameters.
func (a *Cloud) CloudUpdateAccountWithContext(
	ctx context.Context,
	accountID int,
	accounts CloudUpdateCloudAccountsInput,
) (*CloudUpdateAccountPayload, error) {

	resp := CloudUpdateAccountQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"accounts":  accounts,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, CloudUpdateAccountMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.CloudUpdateAccountPayload, nil
}

type CloudUpdateAccountQueryResponse struct {
	CloudUpdateAccountPayload CloudUpdateAccountPayload `json:"CloudUpdateAccount"`
}

const CloudUpdateAccountMutation = `mutation(
	$accountId: Int!,
	$accounts: CloudUpdateCloudAccountsInput!,
) { cloudUpdateAccount(
	accountId: $accountId,
	accounts: $accounts,
) {
	linkedAccounts {
		authLabel
		createdAt
		disabled
		externalId
		id
		metricCollectionMode
		name
		nrAccountId
		updatedAt
	}
} }`

// Get one linked provider account.
func (a *Cloud) GetLinkedAccount(
	accountID int,
	iD int,
) (*CloudLinkedAccount, error) {
	return a.GetLinkedAccountWithContext(context.Background(),
		accountID,
		iD,
	)
}

// Get one linked provider account.
func (a *Cloud) GetLinkedAccountWithContext(
	ctx context.Context,
	accountID int,
	iD int,
) (*CloudLinkedAccount, error) {

	resp := linkedAccountResponse{}
	vars := map[string]interface{}{
		"accountID": accountID,
		"id":        iD,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, getLinkedAccountQuery, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.Actor.Account.Cloud.LinkedAccount, nil
}

// Note: Do not make "$id" an optional field (as fetched from Tutone) to avoid a breaking change
const getLinkedAccountQuery = `query(
	$accountID: Int!,
	$id: Int!,
) { actor { account(id: $accountID) { cloud { linkedAccount(
	id: $id,
) {
	authLabel
	createdAt
	disabled
	externalId
	id
	integrations {
		__typename
		createdAt
		id
		linkedAccount {
			authLabel
			createdAt
			disabled
			externalId
			id
			metricCollectionMode
			name
			nrAccountId
			updatedAt
		}
		name
		nrAccountId
		service {
			createdAt
			icon
			id
			isEnabled
			name
			slug
			updatedAt
		}
		updatedAt
		... on CloudAlbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			loadBalancerPrefixes
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudApigatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			stagePrefixes
			tagKey
			tagValue
		}
		... on CloudAutoscalingIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAppsyncIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAthenaIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsCognitoIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsConnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDirectconnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDocdbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsFsxIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsGlueIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsKinesisanalyticsIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediaconvertIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediapackagevodIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMetadataIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMqIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMsElasticacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMskIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsNeptuneIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsQldbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsRoute53resolverIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsStatesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTagsGlobalIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTransitgatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafv2Integration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsXrayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAzureApimanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppgatewayIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppserviceIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureContainersIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCosmosdbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCostmanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKeys
		}
		... on CloudAzureDatafactoryIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureEventhubIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureExpressrouteIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFirewallsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFrontdoorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureKeyvaultIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLoadbalancerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLogicappsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMachinelearningIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMariadbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMonitorIntegration {
			__typename
			enabled
			excludeTags
			includeTags
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
			resourceTypes
		}
		... on CloudAzureMysqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMysqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePowerbidedicatedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureRediscacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureServicebusIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlmanagedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureStorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualmachineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualnetworksIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVpngatewaysIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudBaseIntegration {
			__typename
		}
		... on CloudBillingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudCloudfrontIntegration {
			__typename
			fetchLambdasAtEdge
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudCloudtrailIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudDynamodbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEbsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEc2Integration {
			__typename
			awsRegions
			duplicateEc2Tags
			fetchIpAddresses
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEcsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEfsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticacheIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticbeanstalkIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticsearchIntegration {
			__typename
			awsRegions
			fetchNodes
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudEmrIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudGcpAiplatformIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAlloydbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAppengineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigqueryIntegration {
			__typename
			fetchTableMetrics
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigtableIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpComposerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataflowIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataprocIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDatastoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasedatabaseIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasehostingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasestorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirestoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpInterconnectIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpKubernetesIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpLoadbalancingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpMemcacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpPubsubIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRedisIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRouterIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRunIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSpannerIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpStorageIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVpcaccessIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudHealthIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudIamIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudIotIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisFirehoseIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisIntegration {
			__typename
			awsRegions
			fetchShards
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudLambdaIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRdsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRedshiftIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRoute53Integration {
			__typename
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudS3Integration {
			__typename
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudSesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSnsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSqsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			queuePrefixes
			tagKey
			tagValue
		}
		... on CloudTrustedadvisorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudVpcIntegration {
			__typename
			awsRegions
			fetchNatGateway
			fetchVpn
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
	}
	metricCollectionMode
	name
	nrAccountId
	provider {
		__typename
		createdAt
		icon
		id
		name
		services {
			createdAt
			icon
			id
			isEnabled
			name
			slug
			updatedAt
		}
		slug
		templateParams {
			autocomplete
			immutable
			label
			name
			placeholder
			type
		}
		updatedAt
		... on CloudAwsGovCloudProvider {
			__typename
			awsAccountId
		}
		... on CloudAwsProvider {
			__typename
			roleAccountId
			roleExternalId
		}
		... on CloudBaseProvider {
			__typename
		}
		... on CloudGcpProvider {
			__typename
			serviceAccountId
		}
	}
	updatedAt
} } } } }`

// Get all linked cloud provider accounts scoped to the Actor.
func (a *Cloud) GetLinkedAccounts(
	provider string,
) (*[]CloudLinkedAccount, error) {
	return a.GetLinkedAccountsWithContext(context.Background(),
		provider,
	)
}

// Get all linked cloud provider accounts scoped to the Actor.
func (a *Cloud) GetLinkedAccountsWithContext(
	ctx context.Context,
	provider string,
) (*[]CloudLinkedAccount, error) {

	resp := linkedAccountsResponse{}
	vars := map[string]interface{}{
		"provider": provider,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, getLinkedAccountsQuery, vars, &resp); err != nil {
		return nil, err
	}

	if len(resp.Actor.Cloud.LinkedAccounts) == 0 {
		return nil, errors.NewNotFound("")
	}

	return &resp.Actor.Cloud.LinkedAccounts, nil
}

const getLinkedAccountsQuery = `query(
	$provider: String,
) { actor { cloud { linkedAccounts(
	provider: $provider,
) {
	authLabel
	createdAt
	disabled
	externalId
	id
	integrations {
		__typename
		createdAt
		id
		linkedAccount {
			authLabel
			createdAt
			disabled
			externalId
			id
			metricCollectionMode
			name
			nrAccountId
			updatedAt
		}
		name
		nrAccountId
		service {
			createdAt
			icon
			id
			isEnabled
			name
			slug
			updatedAt
		}
		updatedAt
		... on CloudAlbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			loadBalancerPrefixes
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudApigatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			stagePrefixes
			tagKey
			tagValue
		}
		... on CloudAutoscalingIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAppsyncIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsAthenaIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsCognitoIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsConnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDirectconnectIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsDocdbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsFsxIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsGlueIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsKinesisanalyticsIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediaconvertIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMediapackagevodIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMetadataIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMqIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMsElasticacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsMskIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsNeptuneIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsQldbIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsRoute53resolverIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsStatesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTagsGlobalIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsTransitgatewayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsWafv2Integration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAwsXrayIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudAzureApimanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppgatewayIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureAppserviceIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureContainersIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCosmosdbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureCostmanagementIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKeys
		}
		... on CloudAzureDatafactoryIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureEventhubIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureExpressrouteIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFirewallsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFrontdoorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureKeyvaultIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLoadbalancerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureLogicappsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMachinelearningIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMariadbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMonitorIntegration {
			__typename
			enabled
			excludeTags
			includeTags
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
			resourceTypes
		}
		... on CloudAzureMysqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureMysqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePostgresqlflexibleIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzurePowerbidedicatedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureRediscacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureServicebusIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureSqlmanagedIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureStorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualmachineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVirtualnetworksIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudAzureVpngatewaysIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			resourceGroups
		}
		... on CloudBaseIntegration {
			__typename
		}
		... on CloudBillingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudCloudfrontIntegration {
			__typename
			fetchLambdasAtEdge
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudCloudtrailIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudDynamodbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEbsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEc2Integration {
			__typename
			awsRegions
			duplicateEc2Tags
			fetchIpAddresses
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEcsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudEfsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticacheIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticbeanstalkIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElasticsearchIntegration {
			__typename
			awsRegions
			fetchNodes
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudElbIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudEmrIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudGcpAiplatformIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAlloydbIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpAppengineIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigqueryIntegration {
			__typename
			fetchTableMetrics
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpBigtableIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpComposerIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataflowIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDataprocIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpDatastoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasedatabaseIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasehostingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirebasestorageIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFirestoreIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpFunctionsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpInterconnectIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpKubernetesIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpLoadbalancingIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpMemcacheIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpPubsubIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRedisIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRouterIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpRunIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSpannerIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpSqlIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpStorageIntegration {
			__typename
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVmsIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudGcpVpcaccessIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudHealthIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudIamIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudIotIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisFirehoseIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudKinesisIntegration {
			__typename
			awsRegions
			fetchShards
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudLambdaIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRdsIntegration {
			__typename
			awsRegions
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRedshiftIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudRoute53Integration {
			__typename
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudS3Integration {
			__typename
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
		... on CloudSesIntegration {
			__typename
			awsRegions
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSnsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudSqsIntegration {
			__typename
			awsRegions
			fetchExtendedInventory
			fetchTags
			inventoryPollingInterval
			metricsPollingInterval
			queuePrefixes
			tagKey
			tagValue
		}
		... on CloudTrustedadvisorIntegration {
			__typename
			inventoryPollingInterval
			metricsPollingInterval
		}
		... on CloudVpcIntegration {
			__typename
			awsRegions
			fetchNatGateway
			fetchVpn
			inventoryPollingInterval
			metricsPollingInterval
			tagKey
			tagValue
		}
	}
	metricCollectionMode
	name
	nrAccountId
	provider {
		__typename
		createdAt
		icon
		id
		name
		services {
			createdAt
			icon
			id
			isEnabled
			name
			slug
			updatedAt
		}
		slug
		templateParams {
			autocomplete
			immutable
			label
			name
			placeholder
			type
		}
		updatedAt
		... on CloudAwsGovCloudProvider {
			__typename
			awsAccountId
		}
		... on CloudAwsProvider {
			__typename
			roleAccountId
			roleExternalId
		}
		... on CloudBaseProvider {
			__typename
		}
		... on CloudGcpProvider {
			__typename
			serviceAccountId
		}
	}
	updatedAt
} } } }`
