// Code generated by tutone: DO NOT EDIT
package changetracking

import (
	"context"

	"github.com/newrelic/newrelic-client-go/v2/internal/utils"
)

// Creates a new deployment record in NRDB and its associated deployment marker.
func (a *Changetracking) ChangeTrackingCreateDeployment(
	dataHandlingRules ChangeTrackingDataHandlingRules,
	deployment ChangeTrackingDeploymentInput,
) (*ChangeTrackingDeployment, error) {
	// DO NOT DELETE the following function call
	// This is NOT covered by Tutone, but is needed to reformat milliseconds in timestamps
	// in order to align with the expected format of the timestamp by the API
	inputTimestamp := deployment.Timestamp
	timestamp := utils.GetSafeTimestampWithMilliseconds(inputTimestamp)
	deployment.Timestamp = timestamp
	// DO NOT DELETE the above function call

	return a.ChangeTrackingCreateDeploymentWithContext(context.Background(),
		dataHandlingRules,
		deployment,
	)
}

// Creates a new deployment record in NRDB and its associated deployment marker.
func (a *Changetracking) ChangeTrackingCreateDeploymentWithContext(
	ctx context.Context,
	dataHandlingRules ChangeTrackingDataHandlingRules,
	deployment ChangeTrackingDeploymentInput,
) (*ChangeTrackingDeployment, error) {

	resp := ChangeTrackingCreateDeploymentQueryResponse{}
	vars := map[string]interface{}{
		"dataHandlingRules": dataHandlingRules,
		"deployment":        deployment,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, ChangeTrackingCreateDeploymentMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.ChangeTrackingDeployment, nil
}

type ChangeTrackingCreateDeploymentQueryResponse struct {
	ChangeTrackingDeployment ChangeTrackingDeployment `json:"ChangeTrackingCreateDeployment"`
}

const ChangeTrackingCreateDeploymentMutation = `mutation(
	$dataHandlingRules: ChangeTrackingDataHandlingRules,
	$deployment: ChangeTrackingDeploymentInput!,
) { changeTrackingCreateDeployment(
	dataHandlingRules: $dataHandlingRules,
	deployment: $deployment,
) {
	changelog
	commit
	deepLink
	deploymentId
	deploymentType
	description
	entityGuid
	groupId
	timestamp
	user
	version
} }`
