// Code generated by tutone: DO NOT EDIT
package authorizationmanagement

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `organization` field is the entry point into data that is scoped to the user's organization.
	Organization Organization `json:"organization,omitempty"`
}

// AuthorizationManagementAccountAccessGrant - The Account and Role a Group should have access to
type AuthorizationManagementAccountAccessGrant struct {
	// The Account ID the Role will grant access to
	AccountID int `json:"accountId"`
	// The Role ID that will define the access
	RoleId string `json:"roleId"`
}

// AuthorizationManagementGrantAccess - The input object representing the access to grant for the group
type AuthorizationManagementGrantAccess struct {
	// The Role and the Account the Target Group should have access to
	AccountAccessGrants []AuthorizationManagementAccountAccessGrant `json:"accountAccessGrants,omitempty"`
	// The Role and the Group the Target Group should have access to
	GroupAccessGrants []AuthorizationManagementGroupAccessGrant `json:"groupAccessGrants,omitempty"`
	// The Group ID that will have access granted
	GroupId string `json:"groupId"`
	// The Role and the Organization the Target Group should have access to
	OrganizationAccessGrants []AuthorizationManagementOrganizationAccessGrant `json:"organizationAccessGrants,omitempty"`
}

// AuthorizationManagementGrantAccessPayload - Autogenerated return type of GrantAccess
type AuthorizationManagementGrantAccessPayload struct {
	// the roles that were granted to this group
	Roles []AuthorizationManagementGrantedRole `json:"roles"`
}

// AuthorizationManagementGrantedRole - A Granted Role represents the access given to a group.
type AuthorizationManagementGrantedRole struct {
	// the account that this role grants access to
	AccountID int `json:"accountId,omitempty"`
	// the name of the object
	DisplayName string `json:"displayName,omitempty"`
	// the group that this role grants access to
	GroupId string `json:"groupId,omitempty"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// the name of the object
	Name string `json:"name"`
	// the organization this role grants access to
	OrganizationId string `json:"organizationId,omitempty"`
	// the role that defines this access
	RoleId int `json:"roleId"`
	// the type of the role
	Type string `json:"type"`
}

// AuthorizationManagementGrantedRoleSearch - container for roles enabling cursor based pagination
type AuthorizationManagementGrantedRoleSearch struct {
	// an opaque cursor to supply with subsequent   requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the roles granted to this group
	Roles []AuthorizationManagementGrantedRole `json:"roles"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// AuthorizationManagementGroupAccessGrant - The Group and Role another Group should have access to
type AuthorizationManagementGroupAccessGrant struct {
	// The Group ID the Role will grant access to
	GroupId string `json:"groupId"`
	// The Role ID that will define the access
	RoleId string `json:"roleId"`
}

// AuthorizationManagementOrganizationAccessGrant - The Organization Role a Group should have access to
type AuthorizationManagementOrganizationAccessGrant struct {
	// The Role ID that will define the Organization access
	RoleId string `json:"roleId"`
}

type AuthorizationManagementOrganizationStitchedFields struct {
	// list of roles
	Roles AuthorizationManagementRoleSearch `json:"roles,omitempty"`
}

// AuthorizationManagementRevokeAccess - The input object representing the access to revoke for the group
type AuthorizationManagementRevokeAccess struct {
	// The Role and the Account the Target Group should no longer have access to
	AccountAccessGrants []AuthorizationManagementAccountAccessGrant `json:"accountAccessGrants,omitempty"`
	// The Role and the Group the Target Group should no longer have access to
	GroupAccessGrants []AuthorizationManagementGroupAccessGrant `json:"groupAccessGrants,omitempty"`
	// The Group ID that will have access revoked
	GroupId string `json:"groupId"`
	// The Role and the Organization the Target Group should no longer have access to
	OrganizationAccessGrants []AuthorizationManagementOrganizationAccessGrant `json:"organizationAccessGrants,omitempty"`
}

// AuthorizationManagementRevokeAccessPayload - Autogenerated return type of RevokeAccess
type AuthorizationManagementRevokeAccessPayload struct {
	// the roles that were revoked from this group
	Roles []AuthorizationManagementGrantedRole `json:"roles"`
}

// AuthorizationManagementRole - a role grants access on an account or organization to groups of users
type AuthorizationManagementRole struct {
	// the name of the object
	DisplayName string `json:"displayName,omitempty"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// the name of the object
	Name string `json:"name"`
	// the scope of the role
	Scope string `json:"scope"`
	// the type of the role
	Type string `json:"type"`
}

// AuthorizationManagementRoleSearch - container for roles enabling cursor based pagination
type AuthorizationManagementRoleSearch struct {
	// an opaque cursor to supply with subsequent   requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// control the access granted to groups
	Roles []AuthorizationManagementRole `json:"roles"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// MultiTenantAuthorizationRole - Describes a role within the system
type MultiTenantAuthorizationRole struct {
	// a value that uniquely identifies this object
	ID int `json:"id"`
	// the name of the object
	Name string `json:"name"`
	// The scope the role applies to
	Scope string `json:"scope"`
	// The type of role
	Type string `json:"type"`
}

// MultiTenantAuthorizationRoleCollection - An iterable collection of roles
type MultiTenantAuthorizationRoleCollection struct {
	// collection of roles
	Items []MultiTenantAuthorizationRole `json:"items"`
	// an opaque cursor to supply with subsequent   requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// Organization - The `Organization` object provides basic data about an organization.
type Organization struct {
	// This field provides access to AuthorizationManagement data.
	AuthorizationManagement AuthorizationManagementOrganizationStitchedFields `json:"authorizationManagement,omitempty"`
	// The customer id for the organization.
	CustomerId string `json:"customerId,omitempty"`
	// The name of the organization.
	Name string `json:"name,omitempty"`
	// The telemetry id for the organization
	TelemetryId string `json:"telemetryId,omitempty"`
}

type rolesResponse struct {
	Actor Actor `json:"actor"`
}
