// Code generated by tutone: DO NOT EDIT
package alerts

import "github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"

// AlertsDayOfWeek - The day of the week used to configure a WEEKLY scheduled MutingRule
type AlertsDayOfWeek string

var AlertsDayOfWeekTypes = struct {
	// Friday
	FRIDAY AlertsDayOfWeek
	// Monday
	MONDAY AlertsDayOfWeek
	// Saturday
	SATURDAY AlertsDayOfWeek
	// Sunday
	SUNDAY AlertsDayOfWeek
	// Thursday
	THURSDAY AlertsDayOfWeek
	// Tuesday
	TUESDAY AlertsDayOfWeek
	// Wednesday
	WEDNESDAY AlertsDayOfWeek
}{
	// Friday
	FRIDAY: "FRIDAY",
	// Monday
	MONDAY: "MONDAY",
	// Saturday
	SATURDAY: "SATURDAY",
	// Sunday
	SUNDAY: "SUNDAY",
	// Thursday
	THURSDAY: "THURSDAY",
	// Tuesday
	TUESDAY: "TUESDAY",
	// Wednesday
	WEDNESDAY: "WEDNESDAY",
}

// AlertsIncidentPreference - Determines how incidents are created for critical violations of the conditions contained in the policy.
type AlertsIncidentPreference string

var AlertsIncidentPreferenceTypes = struct {
	// A condition will create a condition-level incident when it violates its critical threshold.
	// Other violating conditions will create their own incidents.
	PER_CONDITION AlertsIncidentPreference
	// Each target of each condition will create an entity-level incident upon critical violation.
	// Other violating targets will create their own incidents (even on the same condition).
	PER_CONDITION_AND_TARGET AlertsIncidentPreference
	// A condition will create a policy-level incident when it violates its critical threshold.
	// Other violating conditions will be grouped into this incident.
	PER_POLICY AlertsIncidentPreference
}{
	// A condition will create a condition-level incident when it violates its critical threshold.
	// Other violating conditions will create their own incidents.
	PER_CONDITION: "PER_CONDITION",
	// Each target of each condition will create an entity-level incident upon critical violation.
	// Other violating targets will create their own incidents (even on the same condition).
	PER_CONDITION_AND_TARGET: "PER_CONDITION_AND_TARGET",
	// A condition will create a policy-level incident when it violates its critical threshold.
	// Other violating conditions will be grouped into this incident.
	PER_POLICY: "PER_POLICY",
}

// AlertsMutingRuleConditionGroupOperator - An operator used to combine MutingRuleConditions within a MutingRuleConditionGroup.
type AlertsMutingRuleConditionGroupOperator string

var AlertsMutingRuleConditionGroupOperatorTypes = struct {
	// Match conditions by AND
	AND AlertsMutingRuleConditionGroupOperator
	// Match conditions by OR
	OR AlertsMutingRuleConditionGroupOperator
}{
	// Match conditions by AND
	AND: "AND",
	// Match conditions by OR
	OR: "OR",
}

// AlertsMutingRuleConditionOperator - The list of operators to be used in a MutingRuleCondition. Each operator is limited to one value in the `values` list unless otherwise specified.
type AlertsMutingRuleConditionOperator string

var AlertsMutingRuleConditionOperatorTypes = struct {
	// Where attribute is any.
	ANY AlertsMutingRuleConditionOperator
	// Where attribute contains value.
	CONTAINS AlertsMutingRuleConditionOperator
	// Where attribute ends with value.
	ENDS_WITH AlertsMutingRuleConditionOperator
	// Where attribute equals value.
	EQUALS AlertsMutingRuleConditionOperator
	// Where attribute in values. (Limit 500)
	IN AlertsMutingRuleConditionOperator
	// Where attribute is blank.
	IS_BLANK AlertsMutingRuleConditionOperator
	// Where attribute is not blank.
	IS_NOT_BLANK AlertsMutingRuleConditionOperator
	// Where attribute does not contain value.
	NOT_CONTAINS AlertsMutingRuleConditionOperator
	// Where attribute does not end with value.
	NOT_ENDS_WITH AlertsMutingRuleConditionOperator
	// Where attribute does not equal value.
	NOT_EQUALS AlertsMutingRuleConditionOperator
	// Where attribute not in values. (Limit 500)
	NOT_IN AlertsMutingRuleConditionOperator
	// Where attribute does not start with value.
	NOT_STARTS_WITH AlertsMutingRuleConditionOperator
	// Where attribute starts with value.
	STARTS_WITH AlertsMutingRuleConditionOperator
}{
	// Where attribute is any.
	ANY: "ANY",
	// Where attribute contains value.
	CONTAINS: "CONTAINS",
	// Where attribute ends with value.
	ENDS_WITH: "ENDS_WITH",
	// Where attribute equals value.
	EQUALS: "EQUALS",
	// Where attribute in values. (Limit 500)
	IN: "IN",
	// Where attribute is blank.
	IS_BLANK: "IS_BLANK",
	// Where attribute is not blank.
	IS_NOT_BLANK: "IS_NOT_BLANK",
	// Where attribute does not contain value.
	NOT_CONTAINS: "NOT_CONTAINS",
	// Where attribute does not end with value.
	NOT_ENDS_WITH: "NOT_ENDS_WITH",
	// Where attribute does not equal value.
	NOT_EQUALS: "NOT_EQUALS",
	// Where attribute not in values. (Limit 500)
	NOT_IN: "NOT_IN",
	// Where attribute does not start with value.
	NOT_STARTS_WITH: "NOT_STARTS_WITH",
	// Where attribute starts with value.
	STARTS_WITH: "STARTS_WITH",
}

// AlertsMutingRuleScheduleRepeat - Details about if or how frequently a MutingRule's schedule repeats.
type AlertsMutingRuleScheduleRepeat string

var AlertsMutingRuleScheduleRepeatTypes = struct {
	// Schedule repeats once per calendar day
	DAILY AlertsMutingRuleScheduleRepeat
	// Schedule repeats once per calendar month
	MONTHLY AlertsMutingRuleScheduleRepeat
	// Schedule repeats once per specified day per calendar week
	WEEKLY AlertsMutingRuleScheduleRepeat
}{
	// Schedule repeats once per calendar day
	DAILY: "DAILY",
	// Schedule repeats once per calendar month
	MONTHLY: "MONTHLY",
	// Schedule repeats once per specified day per calendar week
	WEEKLY: "WEEKLY",
}

// AlertsNRQLConditionTermsOperator - Operator used to compare against the threshold for NrqlConditions.
type AlertsNRQLConditionTermsOperator string

var AlertsNRQLConditionTermsOperatorTypes = struct {
	// For comparing values above a threshold.
	ABOVE AlertsNRQLConditionTermsOperator
	// For comparing values above or equal to a threshold.
	ABOVE_OR_EQUALS AlertsNRQLConditionTermsOperator
	// For comparing values below a threshold.
	BELOW AlertsNRQLConditionTermsOperator
	// For comparing values below or equal to a threshold.
	BELOW_OR_EQUALS AlertsNRQLConditionTermsOperator
	// For comparing values equal to a threshold.
	EQUALS AlertsNRQLConditionTermsOperator
	// For comparing values that do not equal a threshold.
	NOT_EQUALS AlertsNRQLConditionTermsOperator
}{
	// For comparing values above a threshold.
	ABOVE: "ABOVE",
	// For comparing values above or equal to a threshold.
	ABOVE_OR_EQUALS: "ABOVE_OR_EQUALS",
	// For comparing values below a threshold.
	BELOW: "BELOW",
	// For comparing values below or equal to a threshold.
	BELOW_OR_EQUALS: "BELOW_OR_EQUALS",
	// For comparing values equal to a threshold.
	EQUALS: "EQUALS",
	// For comparing values that do not equal a threshold.
	NOT_EQUALS: "NOT_EQUALS",
}

// AlertsMutingRuleConditionGroupInput - A group of MutingRuleConditions combined by an operator.
type AlertsMutingRuleConditionGroupInput struct {
	// The individual MutingRuleConditions within the group.
	Conditions []AlertsMutingRuleConditionInput `json:"conditions,omitempty"`
	// The operator used to combine all the MutingRuleConditions within the group.
	Operator AlertsMutingRuleConditionGroupOperator `json:"operator"`
}

// AlertsMutingRuleConditionInput - A condition which describes how to target a New Relic Alerts Violation.
type AlertsMutingRuleConditionInput struct {
	// The attribute on a violation. Expects one of:
	//
	// * **accountId** - The account id
	// * **conditionId** - The alert condition id
	// * **policyId** - The alert policy id
	// * **policyName** - The alert policy name
	// * **conditionName** - The alert condition name
	// * **conditionType** - The alert condition type, such as `metric`
	// * **conditionRunbookUrl** - The alert condition's runbook url
	// * **product** - The target product (e.g., `SYNTHETICS`)
	// * **targetId** - The ID of the alerts target
	// * **targetName** - The name of the alerts target
	// * **nrqlEventType** - The NRQL event type
	// * **tag** - Arbitrary tags associated with some entity (e.g., FACET from a NRQL query)
	// * **nrqlQuery** - The NRQL query string
	Attribute string `json:"attribute"`
	// The operator used to compare the attribute's value with the supplied value(s).
	Operator AlertsMutingRuleConditionOperator `json:"operator"`
	// The value(s) to compare against the attribute's value.
	Values []string `json:"values"`
}

// AlertsMutingRuleInput - Input for creating MutingRules for New Relic Alerts Violations.
type AlertsMutingRuleInput struct {
	// The condition that defines which violations to target.
	Condition AlertsMutingRuleConditionGroupInput `json:"condition,omitempty"`
	// The description of the MutingRule.
	Description string `json:"description,omitempty"`
	// Whether the MutingRule is enabled
	Enabled bool `json:"enabled"`
	// The name of the MutingRule.
	Name string `json:"name"`
	// The time window when the MutingRule should actively mute violations.
	Schedule AlertsMutingRuleScheduleInput `json:"schedule,omitempty"`
}

// AlertsMutingRuleScheduleInput - The time window when the MutingRule should actively mute violations.
type AlertsMutingRuleScheduleInput struct {
	// The datetime stamp when the MutingRule schedule should stop repeating.
	// This is in local ISO 8601 format without an offset.
	//
	// Example: `'2020-07-10T15:00:00'`
	//
	// Note: Either `endRepeat` or `repeatCount` should be used to end a MutingRule schedule.
	// Both fields should not be provided together.
	EndRepeat nrtime.NaiveDateTime `json:"endRepeat,omitempty"`
	// The datetime stamp representing when the MutingRule should end.
	// This is in local ISO 8601 format without an offset.
	//
	// Example: `'2020-07-10T15:00:00'`
	EndTime nrtime.NaiveDateTime `json:"endTime,omitempty"`
	// The frequency the MutingRule schedule repeats.
	// If the MutingRule repeats `WEEKLY`, be sure to set `weeklyRepeatDays`.
	// If the MutingRule does not repeat, use `null`.
	//
	// Example: `DAILY`
	Repeat AlertsMutingRuleScheduleRepeat `json:"repeat,omitempty"`
	// The number of times the MutingRule schedule should repeat.
	//
	// Note: Either `repeatCount` or `endRepeat` should be used to end a MutingRule schedule.
	// Both fields should not be provided together.
	RepeatCount int `json:"repeatCount,omitempty"`
	// The datetime stamp representing when the MutingRule should start.
	// This is in local ISO 8601 format without an offset.
	//
	// Example: `'2020-07-08T14:30:00'`
	StartTime nrtime.NaiveDateTime `json:"startTime,omitempty"`
	// The time zone that applies to the MutingRule schedule.
	//
	// Example: `'America/Los_Angeles'`
	//
	// See https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
	TimeZone string `json:"timeZone"`
	// The day(s) of the week that a MutingRule should repeat when the repeat field is set to `WEEKLY`.
	//
	// Example: `[MONDAY, WEDNESDAY]`
	WeeklyRepeatDays []AlertsDayOfWeek `json:"weeklyRepeatDays"`
}

// AlertsPoliciesSearchCriteriaInput - Search criteria for returning specific policies.
type AlertsPoliciesSearchCriteriaInput struct {
	// The list of policy ids to return.
	IDs []string `json:"ids"`
}

// AlertsPoliciesSearchResultSet - Collection of policies with pagination information.
type AlertsPoliciesSearchResultSet struct {
	// Cursor pointing to the end of the current page of policy records. Null if final page.
	NextCursor string `json:"nextCursor,omitempty"`
	// Set of policies returned for the supplied cursor and criteria.
	Policies []AlertsPolicy `json:"policies"`
	// Total number of policy records for the given search criteria.
	TotalCount int `json:"totalCount"`
}

// AlertsPolicy - Container for conditions with associated notifications channels.
type AlertsPolicy struct {
	// Account ID of the policy.
	AccountID int `json:"accountId"`
	// Primary key for policies.
	ID string `json:"id"`
	// Determines how incidents are created for critical violations of the conditions contained in the policy.
	IncidentPreference AlertsIncidentPreference `json:"incidentPreference"`
	// Description of the policy.
	Name string `json:"name"`
}

// AlertsPolicyInput - Container for conditions with associated notifications channels.
type AlertsPolicyInput struct {
	// Determines how incidents are created for critical violations of the conditions contained in the policy.
	IncidentPreference AlertsIncidentPreference `json:"incidentPreference"`
	// Description of the policy.
	Name string `json:"name"`
}

// AlertsPolicyUpdateInput - Policy fields to be updated.
type AlertsPolicyUpdateInput struct {
	// Determines how incidents are created for critical violations of the conditions contained in the policy.
	IncidentPreference AlertsIncidentPreference `json:"incidentPreference,omitempty"`
	// Description of the policy.
	Name string `json:"name,omitempty"`
}
