// Code generated by tutone: DO NOT EDIT
package agentapplications

import (
	"github.com/newrelic/newrelic-client-go/v2/pkg/common"
)

// AgentApplicationBrowserLoader - Determines which browser loader will be configured. There are three browser loader types. They are Pro+SPA, Pro, and Lite.
// See [documentation](https://docs.newrelic.com/docs/browser/browser-monitoring/installation/install-browser-monitoring-agent/#agent-types) for further information.
type AgentApplicationBrowserLoader string

var AgentApplicationBrowserLoaderTypes = struct {
	// Use PRO instead.
	FULL AgentApplicationBrowserLoader
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE AgentApplicationBrowserLoader
	// Don't use an agent.
	NONE AgentApplicationBrowserLoader
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO AgentApplicationBrowserLoader
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA AgentApplicationBrowserLoader
}{
	// Use PRO instead.
	FULL: "FULL",
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE: "LITE",
	// Don't use an agent.
	NONE: "NONE",
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO: "PRO",
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA: "SPA",
}

// AgentApplicationSettingsBrowserLoader - Determines which browser loader will be configured. Some allowed return values are specified for backwards-compatibility and do not represent currently allowed values for new applications.
// See [documentation](https://docs.newrelic.com/docs/browser/browser-monitoring/installation/install-browser-monitoring-agent/#agent-types) for further information.
type AgentApplicationSettingsBrowserLoader string

var AgentApplicationSettingsBrowserLoaderTypes = struct {
	// Use PRO instead
	FULL AgentApplicationSettingsBrowserLoader
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE AgentApplicationSettingsBrowserLoader
	// Don't use an agent.
	NONE AgentApplicationSettingsBrowserLoader
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO AgentApplicationSettingsBrowserLoader
	// This value is no longer in use.
	RUM AgentApplicationSettingsBrowserLoader
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA AgentApplicationSettingsBrowserLoader
	// This value is specified for backwards-compatibility.
	XHR AgentApplicationSettingsBrowserLoader
}{
	// Use PRO instead
	FULL: "FULL",
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE: "LITE",
	// Don't use an agent.
	NONE: "NONE",
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO: "PRO",
	// This value is no longer in use.
	RUM: "RUM",
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA: "SPA",
	// This value is specified for backwards-compatability.
	XHR: "XHR",
}

// AgentApplicationSettingsBrowserLoaderInput - We have three types of browser agents: Lite, Pro, and Pro+SPA.
type AgentApplicationSettingsBrowserLoaderInput string

var AgentApplicationSettingsBrowserLoaderInputTypes = struct {
	// Use PRO instead.
	FULL AgentApplicationSettingsBrowserLoaderInput
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE AgentApplicationSettingsBrowserLoaderInput
	// Don't use an agent.
	NONE AgentApplicationSettingsBrowserLoaderInput
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO AgentApplicationSettingsBrowserLoaderInput
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA AgentApplicationSettingsBrowserLoaderInput
}{
	// Use PRO instead.
	FULL: "FULL",
	// Lite: Gives you information about some basic page load timing and browser user information. Lacks the Browser Pro features and SPA features.
	LITE: "LITE",
	// Don't use an agent.
	NONE: "NONE",
	// Pro: Gives you access to the Browser Pro features. Lacks the functionality designed for single page app monitoring.
	PRO: "PRO",
	// Pro+SPA: This is the default installed agent when you enable browser monitoring. Gives you access to all of the Browser Pro features and to Single Page App (SPA) monitoring. Provides detailed page timing data and the most up-to-date New Relic features, including distributed tracing, for all types of applications.
	SPA: "SPA",
}

// AgentApplicationSettingsNetworkFilterMode - Configuration setting to apply either the show or hide strategy for network filtering.
type AgentApplicationSettingsNetworkFilterMode string

var AgentApplicationSettingsNetworkFilterModeTypes = struct {
	// Disables both show and hide confurations.
	DISABLED AgentApplicationSettingsNetworkFilterMode
	// Use the hide list configuration.
	HIDE AgentApplicationSettingsNetworkFilterMode
	// Use the show list configuration.
	SHOW AgentApplicationSettingsNetworkFilterMode
}{
	// Disables both show and hide confurations.
	DISABLED: "DISABLED",
	// Use the hide list configuration.
	HIDE: "HIDE",
	// Use the show list configuration.
	SHOW: "SHOW",
}

// AgentApplicationSettingsRecordSqlEnum - Obfuscation level for SQL queries reported in transaction trace nodes.
//
// When turned on, the New Relic agent will attempt to remove values from SQL qeries.
//
// For example:
//
// ```
// SELECT * FROM Table WHERE ssn='123-45-6789'
// ```
//
// might become:
//
// ```
// SELECT * FROM Table WHERE ssn=?
// ```
//
// This can behave differently for differnet applications and frameworks. Please test for your specific case.
// Note: RAW collection is not campatible with High Security mode and cannot be set if your agent is running in that mode.
type AgentApplicationSettingsRecordSqlEnum string

var AgentApplicationSettingsRecordSqlEnumTypes = struct {
	// This is the default value. This setting strips string literals and numeric sequences from your queries and replaces them with the ? character. For example: the query select * from table where ssn='123-45-6789' would become select * from table where ssn=?.
	OBFUSCATED AgentApplicationSettingsRecordSqlEnum
	// Query collection is turned off entirely.
	OFF AgentApplicationSettingsRecordSqlEnum
	// If you are confident that full query data collection will not impact your data security or your users' privacy, you can change the setting to RAW, which will record all query values. NOTE: 'RAW' is not permitted when 'High security mode' is enabled.
	RAW AgentApplicationSettingsRecordSqlEnum
}{
	// This is the default value. This setting strips string literals and numeric sequences from your queries and replaces them with the ? character. For example: the query select * from table where ssn='123-45-6789' would become select * from table where ssn=?.
	OBFUSCATED: "OBFUSCATED",
	// Query collection is turned off entirely.
	OFF: "OFF",
	// If you are confident that full query data collection will not impact your data security or your users' privacy, you can change the setting to RAW, which will record all query values. NOTE: 'RAW' is not permitted when 'High security mode' is enabled.
	RAW: "RAW",
}

// AgentApplicationSettingsThresholdTypeEnum - Determines whether a threshold is statically configured or dynamically configured.
type AgentApplicationSettingsThresholdTypeEnum string

var AgentApplicationSettingsThresholdTypeEnumTypes = struct {
	// Configures the threshold to be 4 times the value of APDEX_T.
	APDEX_F AgentApplicationSettingsThresholdTypeEnum
	// Threshold will be statically configured via the corresponding "value" field.
	VALUE AgentApplicationSettingsThresholdTypeEnum
}{
	// Configures the threshold to be 4 times the value of APDEX_T.
	APDEX_F: "APDEX_F",
	// Threshold will be statically configured via the corresponding "value" field.
	VALUE: "VALUE",
}

// AgentApplicationSettingsTracer - The type of tracing being done.
type AgentApplicationSettingsTracer string

var AgentApplicationSettingsTracerTypes = struct {
	// Cross-application tracing feature enabled.
	CROSS_APPLICATION_TRACER AgentApplicationSettingsTracer
	// Distributed tracing feature enabled.
	DISTRIBUTED_TRACING AgentApplicationSettingsTracer
	// Both cross-application and distributed tracing disabled.
	NONE AgentApplicationSettingsTracer
}{
	// Cross-application tracing feature enabled.
	CROSS_APPLICATION_TRACER: "CROSS_APPLICATION_TRACER",
	// Distributed tracing feature enabled.
	DISTRIBUTED_TRACING: "DISTRIBUTED_TRACING",
	// Both cross-application and distributed tracing disabled.
	NONE: "NONE",
}

// AgentApplicationSettingsUpdateErrorClass - Categories of errors that could occur while attempting updates.
type AgentApplicationSettingsUpdateErrorClass string

var AgentApplicationSettingsUpdateErrorClassTypes = struct {
	// You are not authorized to update this field.
	ACCESS_DENIED AgentApplicationSettingsUpdateErrorClass
	// The given value for the field is not valid or out of range.
	INVALID_INPUT AgentApplicationSettingsUpdateErrorClass
	// No record could be found using the given input value.
	NOT_FOUND AgentApplicationSettingsUpdateErrorClass
}{
	// You are not authorized to update this field.
	ACCESS_DENIED: "ACCESS_DENIED",
	// The given value for the field is not valid or out of range.
	INVALID_INPUT: "INVALID_INPUT",
	// No record could be found using the given input value.
	NOT_FOUND: "NOT_FOUND",
}

// AgentApplicationApmBrowserSettings - The settings of a browser application.
type AgentApplicationApmBrowserSettings struct {
	// Configure cookies. The default is enabled: true.
	CookiesEnabled bool `json:"cookiesEnabled"`
	// Configure distributed tracing in browser apps. The default is enabled: true.
	DistributedTracingEnabled bool `json:"distributedTracingEnabled"`
	// Determines which browser loader will be configured. The default is "SPA".
	LoaderType AgentApplicationBrowserLoader `json:"loaderType"`
}

// AgentApplicationBrowserSettings - The settings of a browser application. Includes loader script.
type AgentApplicationBrowserSettings struct {
	// Configure cookies. The default is enabled: true.
	CookiesEnabled bool `json:"cookiesEnabled"`
	// Configure distributed tracing in browser apps. The default is enabled: true.
	DistributedTracingEnabled bool `json:"distributedTracingEnabled"`
	// The snippet of JavaScript used to copy/paste into your JavaScript app if you aren't using an auto-instrumenting agent on the backend. Note that the resulting snippet will be a JSON string that will need to be parsed before using in your browser application.
	LoaderScript string `json:"loaderScript,omitempty"`
	// Determines which browser loader will be configured. The default is "SPA".
	LoaderType AgentApplicationBrowserLoader `json:"loaderType"`
}

// AgentApplicationBrowserSettingsInput - Configure additional browser settings here.
type AgentApplicationBrowserSettingsInput struct {
	// Configure cookies. The default is enabled: true.
	CookiesEnabled *bool `json:"cookiesEnabled,omitempty"`
	// Configure distributed tracing in browser apps. The default is enabled: true.
	DistributedTracingEnabled bool `json:"distributedTracingEnabled,omitempty"`
	// Determines which browser loader is configured. The default is "SPA".
	LoaderType AgentApplicationBrowserLoader `json:"loaderType,omitempty"`
}

// AgentApplicationCreateBrowserResult - The result of creating a browser application.
type AgentApplicationCreateBrowserResult struct {
	// The GUID for the affected Entity.
	GUID common.EntityGUID `json:"guid"`
	// The name of the application.
	Name string `json:"name"`
	// Fields related to browser settings.
	Settings AgentApplicationBrowserSettings `json:"settings,omitempty"`
}

// AgentApplicationDeleteResult - The result of deleting an application.
type AgentApplicationDeleteResult struct {
	// Did the delete succeed?
	Success bool `json:"success"`
}

// AgentApplicationEnableBrowserResult - The result of enabling browser monitoring for an APM-monitored application.
type AgentApplicationEnableBrowserResult struct {
	// The application's name
	Name string `json:"name"`
	// Fields related to browser settings.
	Settings AgentApplicationApmBrowserSettings `json:"settings,omitempty"`
}

// AgentApplicationSettingsApmBase - Settings that are applicable to APM applications and their agents.
type AgentApplicationSettingsApmBase struct {
	// The name for the application
	Alias string `json:"alias,omitempty"`
	// Access general settings for the application.
	ApmConfig AgentApplicationSettingsApmConfig `json:"apmConfig"`
	// Access error collector settings for the application. The error collector captures information about uncaught exceptions and sends them to New Relic for viewing.
	ErrorCollector AgentApplicationSettingsErrorCollector `json:"errorCollector,omitempty"`
	// Access enabled state for the Java Flight Recorder. This is available only for the Java language agent version 8.0.0 or later.
	Jfr AgentApplicationSettingsJfr `json:"jfr,omitempty"`
	// The name originally given to the application for reporting.
	OriginalName string `json:"originalName,omitempty"`
	// In APM, when transaction traces are collected, there may be additional Slow query data available.
	SlowSql AgentApplicationSettingsSlowSql `json:"slowSql,omitempty"`
	// Measures wall clock time, CPU time, and method call counts in your application's threads as they run.
	ThreadProfiler AgentApplicationSettingsThreadProfiler `json:"threadProfiler,omitempty"`
	// Type of tracer used. APM's cross application tracing links transactions between APM apps in your service-oriented architecture (SOA).  Distributed tracing is an improvement on the cross application tracing feature, and is recommended for large, distributed systems.
	TracerType AgentApplicationSettingsTracer `json:"tracerType,omitempty"`
	// Access transaction tracer settings for the application.
	TransactionTracer AgentApplicationSettingsTransactionTracer `json:"transactionTracer,omitempty"`
}

// AgentApplicationSettingsApmConfig - General settings related to APM applications.
type AgentApplicationSettingsApmConfig struct {
	// The desired target for the APDEX measurement of this APM application.
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// Sets if agents for this APM application should get some of their configuration from the server.
	UseServerSideConfig bool `json:"useServerSideConfig,omitempty"`
}

// AgentApplicationSettingsApmConfigInput - Provides fields to set general APM application settings.
type AgentApplicationSettingsApmConfigInput struct {
	// The desired target for the APDEX measurement of this application.
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// Sets if installed agents should override local settings with ones set here.
	UseServerSideConfig bool `json:"useServerSideConfig,omitempty"`
}

// AgentApplicationSettingsBrowserAjax - Browser Ajax.
type AgentApplicationSettingsBrowserAjax struct {
	// List of domains excluded from Ajax traces by the browser agent.
	DenyList []string `json:"denyList"`
}

// AgentApplicationSettingsBrowserAjaxInput - Configuration settings related to how a browser agent handles Ajax requests.
type AgentApplicationSettingsBrowserAjaxInput struct {
	// A list of host destinations that will not record AjaxRequest events when requested.
	DenyList []string `json:"denyList"`
}

// AgentApplicationSettingsBrowserBase - Settings that are applicable to browser applications.
type AgentApplicationSettingsBrowserBase struct {
	// Access general settings for the application.
	BrowserConfig AgentApplicationSettingsBrowserConfig `json:"browserConfig"`
	// browser monitoring provides real user monitoring (RUM) that measures the speed and performance of end users as they navigate the application using different web browsers, devices, operating systems, and networks.
	BrowserMonitoring AgentApplicationSettingsBrowserMonitoring `json:"browserMonitoring"`
}

// AgentApplicationSettingsBrowserConfig - General settings related to APM applications.
type AgentApplicationSettingsBrowserConfig struct {
	// The desired target for the APDEX measurement of this browser application.
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
}

// AgentApplicationSettingsBrowserConfigInput - Provides fields to set general browser application settings.
type AgentApplicationSettingsBrowserConfigInput struct {
	// The desired target for the APDEX measurement of this application.
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
}

// AgentApplicationSettingsBrowserDistributedTracing - Distributed tracing type. See [documentation](https://docs.newrelic.com/docs/browser/new-relic-browser/browser-pro-features/browser-data-distributed-tracing/) for further information.
type AgentApplicationSettingsBrowserDistributedTracing struct {
	// List of allowed origins for use with distributed tracing.
	AllowedOrigins []string `json:"allowedOrigins"`
	// Whether or not CORS is enabled in distributed tracing.
	CorsEnabled bool `json:"corsEnabled,omitempty"`
	// Whether or not CORS uses the `newrelic` header in distributed tracing.
	CorsUseNewrelicHeader bool `json:"corsUseNewrelicHeader,omitempty"`
	// Whether or not CORS uses tracecontext headers in distributed tracing.
	CorsUseTracecontextHeaders bool `json:"corsUseTracecontextHeaders,omitempty"`
	// Whether or not distributed tracing is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// Whether or not to exclude the `newrelic` header in distributed tracing.
	ExcludeNewrelicHeader bool `json:"excludeNewrelicHeader,omitempty"`
}

// AgentApplicationSettingsBrowserDistributedTracingInput - Configure distributed traces from within browser apps.
type AgentApplicationSettingsBrowserDistributedTracingInput struct {
	// Supplies allowed origins for distributed tracing in browser.
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
	// Enables CORS for distributed tracing in browser.
	CorsEnabled bool `json:"corsEnabled,omitempty"`
	// Enables the use of the `newrelic` header for CORS requests with distributed tracing. [See Docs](https://docs.newrelic.com/docs/browser/new-relic-browser/browser-pro-features/browser-data-distributed-tracing/#cors) for more information.
	CorsUseNewrelicHeader bool `json:"corsUseNewrelicHeader,omitempty"`
	// Enables CORS to use tracecontext headers for distributed tracing in browser.
	CorsUseTracecontextHeaders bool `json:"corsUseTracecontextHeaders,omitempty"`
	// Enables distributed tracing in browser.
	Enabled bool `json:"enabled"`
	// Enables the `newrelic` header to be excluded in distributed tracing in browser.
	ExcludeNewrelicHeader bool `json:"excludeNewrelicHeader,omitempty"`
}

// AgentApplicationSettingsBrowserMonitoring - Browser monitoring.
type AgentApplicationSettingsBrowserMonitoring struct {
	// Enables ajax traces in the browser app.
	Ajax AgentApplicationSettingsBrowserAjax `json:"ajax,omitempty"`
	// Configure distributed tracing in browser apps.
	DistributedTracing AgentApplicationSettingsBrowserDistributedTracing `json:"distributedTracing"`
	// The type of browser agent that will be loaded.
	Loader AgentApplicationSettingsBrowserLoader `json:"loader"`
	// Browser monitoring's page load timing feature can track sessions by using cookies that contain a simple session identifier.
	Privacy AgentApplicationSettingsBrowserPrivacy `json:"privacy"`
}

// AgentApplicationSettingsBrowserMonitoringInput - Set browser monitoring application settings.
type AgentApplicationSettingsBrowserMonitoringInput struct {
	// Browser monitoring's page load Ajax requests.
	Ajax *AgentApplicationSettingsBrowserAjaxInput `json:"ajax,omitempty"`
	// If you use browser to monitor end-user browser activity, you can now see end-user-originating browser-side traces in distributed tracing.
	DistributedTracing *AgentApplicationSettingsBrowserDistributedTracingInput `json:"distributedTracing,omitempty"`
	// Determines which browser loader will be configured.
	Loader *AgentApplicationSettingsBrowserLoaderInput `json:"loader,omitempty"`
	// Browser monitoring's page load timing feature can track sessions by using cookies that contain a simple session identifier.
	Privacy *AgentApplicationSettingsBrowserPrivacyInput `json:"privacy,omitempty"`
}

// AgentApplicationSettingsBrowserPrivacy - Browser privacy. See [documentation](https://docs.newrelic.com/docs/browser/browser-monitoring/page-load-timing-resources/cookie-collection-session-tracking/) for further information.
type AgentApplicationSettingsBrowserPrivacy struct {
	// Whether or not cookies are enabled.
	CookiesEnabled bool `json:"cookiesEnabled"`
}

// AgentApplicationSettingsBrowserPrivacyInput - Browser monitoring's page load timing feature can track sessions by using cookies that contain a simple session identifier.
type AgentApplicationSettingsBrowserPrivacyInput struct {
	// If enabled, enables cookies.
	CookiesEnabled *bool `json:"cookiesEnabled,omitempty"`
}

// AgentApplicationSettingsBrowserProperties - General Properties related to browser applications.
type AgentApplicationSettingsBrowserProperties struct {
	// The snippet of JavaScript used to copy/paste into your JavaScript app if you aren’t using an auto-instrumentating agent on the backend.
	JsLoaderScript string `json:"jsLoaderScript,omitempty"`
}

// AgentApplicationSettingsErrorCollector - The error collector captures information about uncaught exceptions and sends them to New Relic for viewing. For more information about what these settings do and which ones are applicable for your application, please see https://docs.newrelic.com for more information about agent configuration for your language agent.
type AgentApplicationSettingsErrorCollector struct {
	// Enables error collector.
	Enabled bool `json:"enabled,omitempty"`
	// Prevents specified exception classes from affecting error rate or Apdex score while still reporting the errors to APM.
	ExpectedErrorClasses []string `json:"expectedErrorClasses"`
	// An array of individual HTTP status codes to be marked as expected and thus prevented from affecting error rate or Apdex score.
	ExpectedErrorCodes []AgentApplicationSettingsErrorCollectorHttpStatus `json:"expectedErrorCodes"`
	// Specified exception class names will be ignored and will not affect error rate or Apdex score, or be reported to APM.
	IgnoredErrorClasses []string `json:"ignoredErrorClasses"`
	// An array of individual HTTP status codes that should not be treated as errors.
	IgnoredErrorCodes []AgentApplicationSettingsErrorCollectorHttpStatus `json:"ignoredErrorCodes"`
}

// AgentApplicationSettingsErrorCollectorInput - The error collector captures information about uncaught exceptions and sends them to New Relic for viewing. For more information about what these settings do and which ones are applicable for your application, please see https://docs.newrelic.com for more information about agent configuration for your language agent.
type AgentApplicationSettingsErrorCollectorInput struct {
	// Enables error collector.
	Enabled bool `json:"enabled,omitempty"`
	// Prevents specified exception classes from affecting error rate or Apdex score while still reporting the errors to APM.
	ExpectedErrorClasses []string `json:"expectedErrorClasses"`
	// An array of individual HTTP status codes to be marked as expected and thus prevented from affecting error rate or Apdex score.
	ExpectedErrorCodes []AgentApplicationSettingsErrorCollectorHttpStatus `json:"expectedErrorCodes"`
	// Specified exception class names will be ignored and will not affect error rate or Apdex score, or be reported to APM.
	IgnoredErrorClasses []string `json:"ignoredErrorClasses"`
	// An array of individual HTTP status codes that should not be treated as errors.
	IgnoredErrorCodes []AgentApplicationSettingsErrorCollectorHttpStatus `json:"ignoredErrorCodes"`
}

// AgentApplicationSettingsIgnoredStatusCodeRule - A configuration setting used ignore status codes associated with different hosts.
type AgentApplicationSettingsIgnoredStatusCodeRule struct {
	// An array of hosts to apply the status code rule to.
	Hosts []string `json:"hosts"`
	// An array of status codes to be be ignored on these hosts.
	StatusCodes []string `json:"statusCodes"`
}

// AgentApplicationSettingsIgnoredStatusCodeRuleInput - Input data that maps ignore status codes associated with different hosts.
type AgentApplicationSettingsIgnoredStatusCodeRuleInput struct {
	// An array of hosts to apply the status code rule to.
	Hosts []string `json:"hosts"`
	// An array of status codes to be be ignored on these hosts.
	StatusCodes []string `json:"statusCodes"`
}

// AgentApplicationSettingsJfr - Access to the enabled state of the Java Flight Recorder. This feature only available on the Java language agent version 8.0.0 or later.
type AgentApplicationSettingsJfr struct {
	// If true, the java agent collects Java Flight Recorder data. (Java Agent version 8.0.0 required.)
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsJfrInput - In the Java agent (v8.0.0 or later), the Java Flight Recorder can be turned on to collect additional information about the application. This setting cannot be updated for non-java agents.
type AgentApplicationSettingsJfrInput struct {
	// Whether or not JFR is enabled.
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsMobileBase - Settings that are applicable to mobile applications.
type AgentApplicationSettingsMobileBase struct {
	// Network settings associated with the mobile application.
	NetworkSettings AgentApplicationSettingsMobileNetworkSettings `json:"networkSettings,omitempty"`
	// Enables viewing in-depth reports for mobile application crashes.
	UseCrashReports bool `json:"useCrashReports,omitempty"`
}

// AgentApplicationSettingsMobileNetworkSettings - An object containing your network settings.
type AgentApplicationSettingsMobileNetworkSettings struct {
	// A list of configuration settings that map host to alias names for grouping and identification purposes.
	Aliases []AgentApplicationSettingsNetworkAlias `json:"aliases"`
	// Configuration setting to apply either the show or hide strategy for network filtering.
	FilterMode AgentApplicationSettingsNetworkFilterMode `json:"filterMode,omitempty"`
	// A list of hostnames that would be applied to our filter settings when the filterMode is 'HIDE.'
	HideList []string `json:"hideList"`
	// A list of rules to ignore status codes associated with different hosts.
	IgnoredStatusCodeRules []AgentApplicationSettingsIgnoredStatusCodeRule `json:"ignoredStatusCodeRules"`
	// A list of hostnames that would be applied to our filter settings when the filterMode is 'SHOW.'
	ShowList []string `json:"showList"`
}

// AgentApplicationSettingsMobileSettingsInput - Configure mobile settings here.
type AgentApplicationSettingsMobileSettingsInput struct {
	// Input arguments for network settings.
	NetworkSettings AgentApplicationSettingsNetworkSettingsInput `json:"networkSettings,omitempty"`
	// Sets if application should use crash report or not for mobile settings.
	UseCrashReports bool `json:"useCrashReports,omitempty"`
}

// AgentApplicationSettingsNetworkAlias - A configuration setting that maps hosts to alias names for grouping and identification purposes.
type AgentApplicationSettingsNetworkAlias struct {
	// An alternative name that can be used to reference the hostnames.
	Alias string `json:"alias,omitempty"`
	// A list of hostnames to associate with an alias.
	Hosts []string `json:"hosts"`
}

// AgentApplicationSettingsNetworkAliasesInput - Input data that maps hosts to alias names for grouping and identification purposes.
type AgentApplicationSettingsNetworkAliasesInput struct {
	// An alternative name that can be used to reference the hostnames.
	Alias string `json:"alias"`
	// A list of hostnames to associate with an alias.
	Hosts []string `json:"hosts"`
}

// AgentApplicationSettingsNetworkSettingsInput - Configure mobile network settings here.
type AgentApplicationSettingsNetworkSettingsInput struct {
	// Input data that maps hosts to alias names for grouping and identification purposes.
	Aliases []AgentApplicationSettingsNetworkAliasesInput `json:"aliases,omitempty"`
	// Configuration setting to apply either the show or hide strategy for network filtering.
	FilterMode AgentApplicationSettingsNetworkFilterMode `json:"filterMode,omitempty"`
	// A list of hostnames that would be applied to our filter settings when the filterMode is 'HIDE.'
	HideList []string `json:"hideList"`
	// Input data that maps ignore status codes associated with different hosts.
	IgnoredStatusCodeRules []AgentApplicationSettingsIgnoredStatusCodeRuleInput `json:"ignoredStatusCodeRules,omitempty"`
	// A list of hostnames that would be applied to our filter settings when the filterMode is 'SHOW.'
	ShowList []string `json:"showList"`
}

// AgentApplicationSettingsSlowSql - In APM, when transaction traces are collected, there may be additional Slow query data available.
type AgentApplicationSettingsSlowSql struct {
	// If true, the agent collects slow SQL queries.
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsSlowSqlInput - In APM, when transaction traces are collected, there may be additional Slow query data available.
type AgentApplicationSettingsSlowSqlInput struct {
	// Whether or not slow_sql is enabled.
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsThreadProfiler - Measures wall clock time, CPU time, and method call counts in your application's threads as they run.
type AgentApplicationSettingsThreadProfiler struct {
	// Whether or not the Thread Profiler is enabled for your application.
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsThreadProfilerInput - Settings for the thread profiler.
type AgentApplicationSettingsThreadProfilerInput struct {
	// Is thread profiling enabled for this application?
	Enabled bool `json:"enabled,omitempty"`
}

// AgentApplicationSettingsTracerTypeInput - Input object for setting the type of tracing performed.
type AgentApplicationSettingsTracerTypeInput struct {
	// The type of tracing being done.
	Value AgentApplicationSettingsTracer `json:"value,omitempty"`
}

// AgentApplicationSettingsTransactionTracer - Transaction tracer settings related to APM applications. For more information about what these settings do and which ones are applicable for your application, please see https://docs.newrelic.com for more information about agent configuration for your language agent.
type AgentApplicationSettingsTransactionTracer struct {
	// Enable or disable the capture of memcache keys from transaction traces.
	CaptureMemcacheKeys bool `json:"captureMemcacheKeys,omitempty"`
	// If true, this enables the transaction tracer feature, enabling collection of transaction traces.
	Enabled bool `json:"enabled,omitempty"`
	// If true, enables the collection of explain plans in transaction traces. This setting will also apply to explain plans in slow SQL traces if slow_sql.explain_enabled is not set separately.
	ExplainEnabled bool `json:"explainEnabled,omitempty"`
	// Relevant only when explain_enabled is true. Can be set to automatic configuration (APDEX_F) or manual (see explainThresholdValue).
	ExplainThresholdType AgentApplicationSettingsThresholdTypeEnum `json:"explainThresholdType,omitempty"`
	// Threshold (in seconds) above which the agent will collect explain plans. Relevant only when explainEnabled is true and explainThresholdType is set to VALUE.
	ExplainThresholdValue Seconds `json:"explainThresholdValue,omitempty"`
	// Set to true to enable logging of queries to the agent log file instead of uploading to New Relic. Queries are logged using the record_sql mode.
	LogSql bool `json:"logSql,omitempty"`
	// Obfuscation level for SQL queries reported in transaction trace nodes.
	RecordSql AgentApplicationSettingsRecordSqlEnum `json:"recordSql,omitempty"`
	// Specify a threshold in seconds. The agent includes stack traces in transaction trace nodes when the stack trace duration exceeds this threshold.
	StackTraceThreshold Seconds `json:"stackTraceThreshold,omitempty"`
	// Relevant only when TransactionTracer is enabled. Can be set to automatic configuration (APDEX_F) or manual (see TransactionThresholdValue).
	TransactionThresholdType AgentApplicationSettingsThresholdTypeEnum `json:"transactionThresholdType,omitempty"`
	// Threshold (in seconds) that transactions with a duration longer than this threshold are eligible for transaction traces.  Relevant only when transaction tracer is enabled and transaction_threshold_type is set to VALUE.
	TransactionThresholdValue Seconds `json:"transactionThresholdValue,omitempty"`
}

// AgentApplicationSettingsTransactionTracerInput - Fields related to transaction traces and data collection for traces.
type AgentApplicationSettingsTransactionTracerInput struct {
	// Enable or disable the capture of memcache keys from transaction traces.
	CaptureMemcacheKeys bool `json:"captureMemcacheKeys,omitempty"`
	// If true, this enables the transaction tracer feature, enabling collection of transaction traces.
	Enabled bool `json:"enabled,omitempty"`
	// If true, enables the collection of explain plans in transaction traces. This setting will also apply to explain plans in slow SQL traces if slow_sql.explain_enabled is not set separately.
	ExplainEnabled bool `json:"explainEnabled,omitempty"`
	// Relevant only when explain_enabled is true. Can be set to automatic configuration (APDEX_F) or manual (see explainThresholdValue).
	ExplainThresholdType AgentApplicationSettingsThresholdTypeEnum `json:"explainThresholdType,omitempty"`
	// Threshold (in seconds) above which the agent will collect explain plans. Relevant only when explain_enabled is true and explainThresholdType is set to VALUE.
	ExplainThresholdValue Seconds `json:"explainThresholdValue,omitempty"`
	// Set to true to enable logging of queries to the agent log file instead of uploading to New Relic. Queries are logged using the record_sql mode.
	LogSql bool `json:"logSql,omitempty"`
	// Obfuscation level for SQL queries reported in transaction trace nodes.
	RecordSql AgentApplicationSettingsRecordSqlEnum `json:"recordSql,omitempty"`
	// Specify a threshold in seconds. The agent includes stack traces in transaction trace nodes when the stack trace duration exceeds this threshold.
	StackTraceThreshold Seconds `json:"stackTraceThreshold,omitempty"`
	// Relevant only when transaction tracer is enabled. Can be set to automatic configuration (APDEX_F) or manual (see TransactionThresholdValue).
	TransactionThresholdType AgentApplicationSettingsThresholdTypeEnum `json:"transactionThresholdType,omitempty"`
	// Threshold (in seconds) that transactions with a duration longer than this threshold are eligible for transaction traces.  Relevant only when transaction tracer is enabled and transaction_threshold_type is set to VALUE.
	TransactionThresholdValue Seconds `json:"transactionThresholdValue,omitempty"`
}

// AgentApplicationSettingsUpdateError - Information about any errors encountered while updating values.
type AgentApplicationSettingsUpdateError struct {
	// A 'human readable' description of the error.
	Description string `json:"description,omitempty"`
	// The category of the error.
	ErrorClass AgentApplicationSettingsUpdateErrorClass `json:"errorClass,omitempty"`
	// The field that was being updated when the error was encountered.
	Field string `json:"field,omitempty"`
}

// AgentApplicationSettingsUpdateInput - The new settings to use - leave blank any settings you do not wish to modify.
//
// While all settings can be specified here, some may not affect your installed agents, depending on the language agent and the current version installed. Note: not all settings of your agent are available to be set server-side.
//
// Please see docs.newrelic.com for more information about the capabilities of individual agents.
//
// [Go agent configuration](https://docs.newrelic.com/docs/agents/go-agent/configuration/go-agent-configuration/)
//
// [Java agent configuration](https://docs.newrelic.com/docs/agents/java-agent/configuration/java-agent-configuration-config-file/)
//
// [.Net agent configuration](https://docs.newrelic.com/docs/agents/net-agent/configuration/net-agent-configuration/)
//
// [nodejs agent configuration](https://docs.newrelic.com/docs/agents/nodejs-agent/installation-configuration/nodejs-agent-configuration/)
//
// [PHP agent configuration](https://docs.newrelic.com/docs/agents/php-agent/configuration/php-agent-configuration/)
//
// [Python agent configuration](https://docs.newrelic.com/docs/agents/python-agent/configuration/python-agent-configuration/)
//
// [Ruby agent configuration](https://docs.newrelic.com/docs/agents/ruby-agent/configuration/ruby-agent-configuration/)
type AgentApplicationSettingsUpdateInput struct {
	// The new name for the application.
	Alias string `json:"alias,omitempty"`
	// Provides fields to set general APM application settings.
	ApmConfig *AgentApplicationSettingsApmConfigInput `json:"apmConfig,omitempty"`
	// Provides fields to set general browser application settings.
	BrowserConfig *AgentApplicationSettingsBrowserConfigInput `json:"browserConfig,omitempty"`
	// Provides fields to set browser monitoring application settings.
	BrowserMonitoring *AgentApplicationSettingsBrowserMonitoringInput `json:"browserMonitoring,omitempty"`
	// Captures information about uncaught exceptions and sends them to New Relic for viewing.
	ErrorCollector *AgentApplicationSettingsErrorCollectorInput `json:"errorCollector,omitempty"`
	// In the Java Agent (v8.0.0 or later), it can collect additional data with the Java Flight Recorder enabled.
	Jfr *AgentApplicationSettingsJfrInput `json:"jfr,omitempty"`
	// Input object for mobile settings.
	MobileSettings *AgentApplicationSettingsMobileSettingsInput `json:"mobileSettings,omitempty"`
	// DEPRECATED: Use `alias` to set a new name for the application.
	Name string `json:"name,omitempty"`
	// In APM, when transaction traces are collected, there may be additional Slow query data available.
	SlowSql *AgentApplicationSettingsSlowSqlInput `json:"slowSql,omitempty"`
	// Settings for the thread profiler.
	ThreadProfiler *AgentApplicationSettingsThreadProfilerInput `json:"threadProfiler,omitempty"`
	// Input object for setting the type of tracing performed.
	TracerType *AgentApplicationSettingsTracerTypeInput `json:"tracerType,omitempty"`
	// Transaction tracer settings related to APM applications.
	TransactionTracer *AgentApplicationSettingsTransactionTracerInput `json:"transactionTracer,omitempty"`
}

// AgentApplicationSettingsUpdateResult - The result of updating application settings.
type AgentApplicationSettingsUpdateResult struct {
	// The name for the application.
	Alias string `json:"alias,omitempty"`
	// Access general settings for the application.
	ApmSettings AgentApplicationSettingsApmBase `json:"apmSettings,omitempty"`
	// Access general properties for the application.
	BrowserProperties AgentApplicationSettingsBrowserProperties `json:"browserProperties,omitempty"`
	// Access general settings for the browser application.
	BrowserSettings AgentApplicationSettingsBrowserBase `json:"browserSettings,omitempty"`
	// Information about any errors encountered while updating values.
	Errors []AgentApplicationSettingsUpdateError `json:"errors,omitempty"`
	// The GUID for the affected Entity.
	GUID common.EntityGUID `json:"guid"`
	// Access mobile settings for the application.
	MobileSettings AgentApplicationSettingsMobileBase `json:"mobileSettings,omitempty"`
	// The name for the application.
	Name string `json:"name,omitempty"`
}

// AgentApplicationSettingsErrorCollectorHttpStatus - A list of HTTP status codes, such as "404" or "500."
type AgentApplicationSettingsErrorCollectorHttpStatus string

// Float - The `Float` scalar type represents signed double-precision fractional
// values as specified by
// [IEEE 754](https://en.wikipedia.org/wiki/IEEE_754).
type Float string

// Seconds - The `Seconds` scalar represents a duration in seconds
type Seconds string
