// Code generated by tutone: DO NOT EDIT
package accountmanagement

// AccountManagementCreateInput - Attributes for creating an account.
type AccountManagementCreateInput struct {
	// The name of the account.
	Name string `json:"name"`
	// The id of the managed organization where the account will be created.
	OrganizationId int `json:"organizationId,omitempty"`
	// The data center region for the account
	RegionCode string `json:"regionCode,omitempty"`
}

// AccountManagementCreateResponse - The return object for a create-account mutation.
type AccountManagementCreateResponse struct {
	// Information about the newly created account.
	ManagedAccount AccountManagementManagedAccount `json:"managedAccount,omitempty"`
}

// AccountManagementManagedAccount - Account data view for administration tasks.
type AccountManagementManagedAccount struct {
	// The account ID.
	ID int `json:"id"`
	// True if account is canceled
	IsCanceled bool `json:"isCanceled"`
	// The name of the account.
	Name string `json:"name"`
	// The data center region for the account (US or EU).
	RegionCode string `json:"regionCode"`
}

// AccountManagementOrganizationStitchedFields - The field type for stitching into the NerdGraph schema.
type AccountManagementOrganizationStitchedFields struct {
	// Admin-level info about the accounts in an organization.
	ManagedAccounts []AccountManagementManagedAccount `json:"managedAccounts"`
}

// AccountManagementUpdateInput - The attributes for updating an account.
type AccountManagementUpdateInput struct {
	// The ID for the account being updated.
	ID int `json:"id"`
	// The new account name.
	Name string `json:"name"`
}

// AccountManagementUpdateResponse - The return object for an update-account mutation.
type AccountManagementUpdateResponse struct {
	// Information about an updated account
	ManagedAccount AccountManagementManagedAccount `json:"managedAccount,omitempty"`
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `organization` field is the entry point into data that is scoped to the user's organization.
	Organization Organization `json:"organization,omitempty"`
}

// Organization - The `Organization` object provides basic data about an organization.
type Organization struct {
	// This field provides access to AccountManagement data.
	AccountManagement AccountManagementOrganizationStitchedFields `json:"accountManagement,omitempty"`
	// The customer id for the organization.
	CustomerId string `json:"customerId,omitempty"`
	// The ID of the organization.
	ID int `json:"id,omitempty"`
	// The name of the organization.
	Name string `json:"name,omitempty"`
	// The telemetry id for the organization
	TelemetryId string `json:"telemetryId,omitempty"`
}

type managedAccountsResponse struct {
	Actor Actor `json:"actor"`
}

// ID - The `ID` scalar type represents a unique identifier, often used to
// refetch an object or as key for a cache. The ID type appears in a JSON
// response as a String; however, it is not intended to be human-readable.
// When expected as an input type, any string (such as `"4"`) or integer
// (such as `4`) input value will be accepted as an ID.
type ID string
