// Code **NOT** generated by tutone
package accountmanagement

import (
	"context"

	"github.com/newrelic/newrelic-client-go/v2/pkg/errors"
)

// --------------------------------------------------------------------
// NOTE: (for the maintainers and users of newrelic-client-go)
// --------------------------------------------------------------------
// The function `GetManagedAccountsWithAdditionalArguments`, function `GetManagedAccountsWithAdditionalArgumentsWithContext` and the query `getManagedAccountsWithAdditionalArgumentsQuery` in this file
// are "modified" versions of the function `GetManagedAccounts`, the function `GetManagedAccountsWithContext` and the query `getManagedAccountsQuery` respectively,
// originally defined in accountmanagement_api.go.
//
// These manual modifications had to be written owing to the introduction of a new input (and output) field to the `getManagedAccountsQuery`, "isCanceled", which
// is causing conflicts with the Tutone generated code; see the PR linked to this change for more details on the exact limitations.
//
// Owing to this, in order to facilitate using these functions with the isCanceled attribute, modified versions of the functions and mutations have been added to
// this file. This would also allow us to ensure the older counterparts of these functions defined in accountmanagement_api.go inflict no breaking changes onto upstream
// services, such as the New Relic Terraform Provider. While we shall aim to bring this under Tutone's scope, please use the functions in this file to use the "isCanceled"
// attribute recently added to this query.
//
// TL;DR The functions in this file are NOT Tutone generated; we would eventually need to move functionalities in these duplicated functions into the original ones
// in accountmanagement_api.go .

// Admin-level info about the accounts in an organization.
func (a *Accountmanagement) GetManagedAccountsWithAdditionalArguments(
	isCanceled *bool,
) (*[]AccountManagementManagedAccount, error) {
	return a.GetManagedAccountsWithAdditionalArgumentsWithContext(context.Background(),
		isCanceled,
	)
}

// Admin-level info about the accounts in an organization.
func (a *Accountmanagement) GetManagedAccountsWithAdditionalArgumentsWithContext(
	ctx context.Context,
	isCanceled *bool,
) (*[]AccountManagementManagedAccount, error) {

	resp := managedAccountsResponse{}
	vars := map[string]interface{}{
		"isCanceled": &isCanceled,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, getManagedAccountsWithAdditionalArgumentsQuery, vars, &resp); err != nil {
		return nil, err
	}

	if len(resp.Actor.Organization.AccountManagement.ManagedAccounts) == 0 {
		return nil, errors.NewNotFound("")
	}

	return &resp.Actor.Organization.AccountManagement.ManagedAccounts, nil
}

const getManagedAccountsWithAdditionalArgumentsQuery = `query ($isCanceled: Boolean) {
  actor {
    organization {
      accountManagement {
        managedAccounts(isCanceled: $isCanceled) {
          id
          isCanceled
          name
          regionCode
        }
      }
    }
  }
}
`
