// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesis

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesis/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the consumers registered to receive data from a stream using enhanced
// fan-out, and provides information about each consumer.
//
// This operation has a limit of 5 transactions per second per stream.
func (c *Client) ListStreamConsumers(ctx context.Context, params *ListStreamConsumersInput, optFns ...func(*Options)) (*ListStreamConsumersOutput, error) {
	if params == nil {
		params = &ListStreamConsumersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListStreamConsumers", params, optFns, c.addOperationListStreamConsumersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListStreamConsumersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListStreamConsumersInput struct {

	// The ARN of the Kinesis data stream for which you want to list the registered
	// consumers. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces].
	//
	// [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams
	//
	// This member is required.
	StreamARN *string

	// The maximum number of consumers that you want a single call of
	// ListStreamConsumers to return. The default value is 100. If you specify a value
	// greater than 100, at most 100 results are returned.
	MaxResults *int32

	// When the number of consumers that are registered with the data stream is
	// greater than the default value for the MaxResults parameter, or if you
	// explicitly specify a value for MaxResults that is less than the number of
	// consumers that are registered with the data stream, the response includes a
	// pagination token named NextToken . You can specify this NextToken value in a
	// subsequent call to ListStreamConsumers to list the next set of registered
	// consumers.
	//
	// Don't specify StreamName or StreamCreationTimestamp if you specify NextToken
	// because the latter unambiguously identifies the stream.
	//
	// You can optionally specify a value for the MaxResults parameter when you
	// specify NextToken . If you specify a MaxResults value that is less than the
	// number of consumers that the operation returns if you don't specify MaxResults ,
	// the response will contain a new NextToken value. You can use the new NextToken
	// value in a subsequent call to the ListStreamConsumers operation to list the
	// next set of consumers.
	//
	// Tokens expire after 300 seconds. When you obtain a value for NextToken in the
	// response to a call to ListStreamConsumers , you have 300 seconds to use that
	// value. If you specify an expired token in a call to ListStreamConsumers , you
	// get ExpiredNextTokenException .
	NextToken *string

	// Specify this input parameter to distinguish data streams that have the same
	// name. For example, if you create a data stream and then delete it, and you later
	// create another data stream with the same name, you can use this input parameter
	// to specify which of the two streams you want to list the consumers for.
	//
	// You can't specify this parameter if you specify the NextToken parameter.
	StreamCreationTimestamp *time.Time

	noSmithyDocumentSerde
}

func (in *ListStreamConsumersInput) bindEndpointParams(p *EndpointParameters) {

	p.StreamARN = in.StreamARN
	p.OperationType = ptr.String("control")
}

type ListStreamConsumersOutput struct {

	// An array of JSON objects. Each object represents one registered consumer.
	Consumers []types.Consumer

	// When the number of consumers that are registered with the data stream is
	// greater than the default value for the MaxResults parameter, or if you
	// explicitly specify a value for MaxResults that is less than the number of
	// registered consumers, the response includes a pagination token named NextToken .
	// You can specify this NextToken value in a subsequent call to ListStreamConsumers
	// to list the next set of registered consumers. For more information about the use
	// of this pagination token when calling the ListStreamConsumers operation, see ListStreamConsumersInput$NextToken.
	//
	// Tokens expire after 300 seconds. When you obtain a value for NextToken in the
	// response to a call to ListStreamConsumers , you have 300 seconds to use that
	// value. If you specify an expired token in a call to ListStreamConsumers , you
	// get ExpiredNextTokenException .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListStreamConsumersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListStreamConsumers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListStreamConsumers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListStreamConsumers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListStreamConsumersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListStreamConsumers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListStreamConsumersPaginatorOptions is the paginator options for
// ListStreamConsumers
type ListStreamConsumersPaginatorOptions struct {
	// The maximum number of consumers that you want a single call of
	// ListStreamConsumers to return. The default value is 100. If you specify a value
	// greater than 100, at most 100 results are returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListStreamConsumersPaginator is a paginator for ListStreamConsumers
type ListStreamConsumersPaginator struct {
	options   ListStreamConsumersPaginatorOptions
	client    ListStreamConsumersAPIClient
	params    *ListStreamConsumersInput
	nextToken *string
	firstPage bool
}

// NewListStreamConsumersPaginator returns a new ListStreamConsumersPaginator
func NewListStreamConsumersPaginator(client ListStreamConsumersAPIClient, params *ListStreamConsumersInput, optFns ...func(*ListStreamConsumersPaginatorOptions)) *ListStreamConsumersPaginator {
	if params == nil {
		params = &ListStreamConsumersInput{}
	}

	options := ListStreamConsumersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListStreamConsumersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListStreamConsumersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListStreamConsumers page.
func (p *ListStreamConsumersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListStreamConsumersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListStreamConsumers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListStreamConsumersAPIClient is a client that implements the
// ListStreamConsumers operation.
type ListStreamConsumersAPIClient interface {
	ListStreamConsumers(context.Context, *ListStreamConsumersInput, ...func(*Options)) (*ListStreamConsumersOutput, error)
}

var _ ListStreamConsumersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListStreamConsumers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListStreamConsumers",
	}
}
