# Development

This repository contains code that is autogenerated via the
[openapi-generator](https://github.com/OpenAPITools/openapi-generator/tree/master/modules/openapi-generator/src/main/resources/go-experimental) project.

As such, this repository should only contain development for adding or fixing tests, for improving development tooling and documentation

## Testing

### Prerequisite

Export the following environment variables:
* `DD_TEST_CLIENT_API_KEY`: The Datadog API key to run integration tests against
* `DD_TEST_CLIENT_APP_KEY`: The Datadog Application key to run integration tests against

**IMPORTANT**: Do not use production keys.

Tests can be run againts different site (EU, staging, local):
* `DD_TEST_SITE`: The base URL for test site (e.g. `datadoghq.eu`)

**NOTE**: All recorded URLs will be replaced by `datadoghq.com`. Please make sure that you do NOT leak any
any sensitive information.

### Commands

This project contains both Integration and Unit tests.
__Never__ run the test suite against an organization with production data.

Tests can be executed via [`go test`](https://golang.org/pkg/testing/#hdr-Subtests_and_Sub_benchmarks).
You can optionally add `-run <testName>` to run individual tests.

Tests for a single file or method can be executed via:

```
 cd ./tests
 go test -v -run <NAME_OF_FAILING_TEST> ./api/v1/datadog
```

By default integration tests use recorded API responses stored in cassettes. To record new API responses run the tests with `RECORD=true`. To run integration tests against API without recording cassettes, run the tests with `RECORD=none`.

**IMPORTANT**:
When creating a PR that adds or updates a test, __never__ commit
generated code, only commit test files being updated and any updated cassettes.

Run test with `DEBUG=true` to display api server calls being made during test execution. This can be useful during debug time.

### Writing Tests

When creating new entities/objects through the API as part of tests, make sure to assign result of `tests.UniqueEntityName()` to at least one field of this object (e.g. title or name). This ensures uniqueness as well as trackability - in other words, if a CI run fails to clean up resources, we're able to track the entity to the CI run, as the unique name will contain CI run ID.

### CI Setup

This project utilizes Azure Pipelines and GitHub Actions to perform CI test steps.

This repository contains a few types of tests:

| Test Type                        | Description                                                                                                                                                                                                                                                                                                                                          |
|----------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Integration Tests                | This runs real API calls to the Datadog API and runs assertions based on the responses. These tests requires a valid Datadog API and Application key.                                                                                                                                                                                                |
| Integration Tests with Cassettes | This is the same set of tests from the Integration tests, however, these don't connect to the real Datadog api. Instead these tests playback a set of pre recorded real responses and run the assertions there. These types of tests don't require any secrets and allow for rapid iteration and quickly testing against a large OS/version matrix.  |
| Unit Tests                       | These tests utilize a set of fixture data to run assertions and don't connect to the Datadog API. These tests also don't require any secrets.                                                                                                                                                                                                        |

We utilize a couple CI Providers to accomplish testing this project:

| Test Type                        | CI Provider                                                                                                 | Reason                                                                                                                                                   |
|----------------------------------|-------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------|
| Integration Tests                | [Azure Pipelines](https://github.com/DataDog/datadog-api-client-go/blob/master/.azure-pipelines/all.yml)    | We require Datadog credentials to access the real Datadog API environment, for this reason we use Azure Pipelines to control the triggering mechanism.   |
| Integration Tests with Cassettes | [Github Actions](https://github.com/DataDog/datadog-api-client-go/blob/master/.github/workflows/test.yml)   | Adding an extended matrix to quickly test multiple OS and language versions is quick in Github Actions.                                                  |
| Unit Tests                       | Azure Pipelines and GitHub Actions                                                                          | Unit tests run fast with fixture data and are part of the regular test suite. This is run on each test command invocation in both providers.             |


You can skip GitHub action test execution by adding the `ci/skip` label to your PR.

See the CI Provider links above for the full matrix this project tests against. Minimum Golang version supported is `1.13`.


Tests running in GitHub Actions are those that __require no__ secrets, to allow for PRs created from forks to run as expected. These are the unit tests and Integration tests with cassettes. These tests are run on each commit from a PR.

Tests running in Azure Pipelines are those that __do require__ secrets to connect to the Datadog API. These tests run only when a maintainer provides a GitHub comment on the PR after performing a review.

