# Roadmap

KEDA uses [GitHub issues](https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues) to track open work items with [GitHub Projects (beta)](https://docs.github.com/en/issues/trying-out-the-new-projects-experience/about-projects) to plan for upcoming releases.

This document provides insights to the community on how we use it and what to expect.

You can find our roadmap [here](https://github.com/orgs/kedacore/projects/2).

## Upcoming Release Cycles

As part of our [release governance](https://github.com/kedacore/governance/blob/main/RELEASES.md), we are planning to release a new KEDA version every 3 months and ship on Thursdays.

Here is an overview of our current release estimations:

| Version | Estimated Release Date                               |
|:--------|:-----------------------------------------------------|
| v2.17   | Jan 30th, 2025                                       |
| v2.18   | Apr 30th, 2025                                       |
| v2.19   | July 30th, 2025                                      |

Here is an overview of our previous releases:

| Version | Release Date      | Links                                                                  |
|:--------|:------------------|:-----------------------------------------------------------------------|
| v2.16   | Nov 7th, 2024     | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.16.0) |
| v2.15   | Aug 1st, 2024     | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.15.0) |
| v2.14   | April 25th, 2024  | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.14.0) |
| v2.13   | Jan 19th, 2024    | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.13.0) |
| v2.12   | Sept 28th, 2023   | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.12.0) |
| v2.11   | June 22nd, 2023   | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.11.0) |
| v2.10   | March 9th, 2023   | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.10.0) |
| v2.9    | Dec 9th, 2022     | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.9.0)  |
| v2.8    | August 10th, 2022 | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.8.0)  |
| v2.7    | May 5th, 2022     | [Release Notes](https://github.com/kedacore/keda/releases/tag/v2.7.0)  |

## Using our roadmap

Here is some guidance on how to use our roadmap.

### Upcoming Release

As we work towards our next release, we are planning and tracking work as part of the next release cycle.

You can find an overview of the items in our upcoming release:

- As list with the respective categories ([link](https://github.com/orgs/kedacore/projects/2/views/12))
- As a board with the current status ([link](https://github.com/orgs/kedacore/projects/2/views/16))

### Triaging

All newly created issues are automatically added to the roadmap and waiting to be triaged by a maintainer.

You can find an overview of all issues pending to be triaged [here](https://github.com/orgs/kedacore/projects/2/views/10).
