#!/bin/bash
set -e

# Function to start the demo
start_demo() {
  # Step 1: Check if .env file exists
  if [ -f ".env" ]; then
    echo ".env file already exists. Skipping creation."
  else
    # Step 2: Create `.env` file and set OpenAI key
    if [ -z "$OPENAI_API_KEY" ]; then
      echo "Error: OPENAI_API_KEY environment variable is not set for the demo."
      exit 1
    fi

    echo "Creating .env file..."
    echo "OPENAI_API_KEY=$OPENAI_API_KEY" > .env
    echo ".env file created with OPENAI_API_KEY."
  fi

  # Step 3: Start Arch
  echo "Starting Arch with arch_config.yaml..."
  archgw up arch_config.yaml

  # Step 4: Start Network Agent
  echo "Starting Network Agent using Docker Compose..."
  docker compose up -d  # Run in detached mode
}

# Function to stop the demo
stop_demo() {
  # Step 1: Stop Docker Compose services
  echo "Stopping Network Agent using Docker Compose..."
  docker compose down

  # Step 2: Stop Arch
  echo "Stopping Arch..."
  archgw down
}

# Main script logic
if [ "$1" == "down" ]; then
  stop_demo
else
  # Default action is to bring the demo up
  start_demo
fi
