#  Contribution
We would love feedback on our [Roadmap](https://github.com/orgs/katanemo/projects/1) and we welcome contributions to **Arch**!
Whether you're fixing bugs, adding new features, improving documentation, or creating tutorials, your help is much appreciated.

## How to Contribute

### 1. Fork the Repository

Fork the repository to create your own version of **Arch**:

- Navigate to the [Arch GitHub repository](https://github.com/katanemo/arch).
- Click the "Fork" button in the upper right corner.
- This will create a copy of the repository under your GitHub account.

### 2. Clone Your Fork

Once you've forked the repository, clone it to your local machine:

```bash
$ git clone https://github.com/katanemo/arch.git
$ cd arch
```

### 3. Create a branch
Use a descriptive name for your branch (e.g., fix-bug-123, add-feature-x).
```bash
$ git checkout -b <your-branch-name>
```

### 4. Make Your changes

Make your changes in the relevant files. If you're adding new features or fixing bugs, please include tests where applicable.

### 5. Test your changes
```bash
cd arch
cargo test
```

### 6. Push changes, and create a Pull request

Go back to the original Arch repository, and you should see a "Compare & pull request" button. Click that to submit a Pull Request (PR). In your PR description, clearly explain the changes you made and why they are necessary.

We will review your pull request and provide feedback. Once approved, your contribution will be merged into the main repository!

Contribution Guidelines

    Ensure that all existing tests pass.
    Write clear commit messages.
    Add tests for any new functionality.
    Follow the existing coding style.
    Update documentation as needed.

To get in touch with us, please join our [discord server](https://discord.gg/rbjqVbpa). We will be monitoring that actively and offering support there.
