const structure = {
    categories: [
        { name: "Restaurant", values: [0, 1], isOpen: true },
        { name: "Café", values: [2], isOpen: true },
        { name: "Sweetshop", values: [3, 64], isOpen: true },
        { name: "Movie-Theatre", values: [4], isOpen: true },
        { name: "Pharmacy", values: [5], isOpen: true },
        { name: "Zoo", values: [6], isOpen: true },
        { name: "Forest", values: [7, 8], isOpen: true },
        { name: "Waterside", values: [9], isOpen: true },
        { name: "Post-Office", values: [10], isOpen: true },
        { name: "Art-Gallery", values: [11], isOpen: true },
        { name: "Airport", values: [12], isOpen: true },
        { name: "Station", values: [13, 14], isOpen: true },
        { name: "Beach", values: [15], isOpen: true },
        { name: "Burger-Place", values: [16], isOpen: true },
        { name: "Corner-Store", values: [17, 18], isOpen: true },
        { name: "Supermarket", values: [19, 20], isOpen: true },
        { name: "Bakery", values: [21], isOpen: true },
        { name: "Hair-Salon", values: [22], isOpen: true },
        { name: "Clothes-Store", values: [23], isOpen: true },
        { name: "Park", values: [24, 25], isOpen: true },
        { name: "Library/Bookstore", values: [26], isOpen: true },
        { name: "Roadside", values: [37, 38, 39, 40, 58], isOpen: true },
        { name: "Sushi-Restaurant", values: [41], isOpen: true },
        { name: "Mountain", values: [42], isOpen: true },
        { name: "Stadium", values: [52], isOpen: true },
        { name: "Rainy-Day", values: [43, 44, 45], isOpen: true },
        { name: "Snowy-Day", values: [88], isOpen: true },
        { name: "Theme-Park", values: [46, 47], isOpen: true },
        { name: "Bus-Stop", values: [48], isOpen: true },
        { name: "Italian-Restaurant", values: [57], isOpen: true },
        { name: "Ramen-Shop", values: [60], isOpen: true },
        { name: "Bridge", values: [63], isOpen: true },
        { name: "Hotel", values: [69], isOpen: true },
        { name: "Makeup-Store", values: [71], isOpen: true },
        { name: "Shrine-/-Temple", values: [73, 74, 75, 76, 77], isOpen: true },
        { name: "Appliance-Store", values: [80, 81, 82, 83, 84, 85, 86, 87], isOpen: true },
        { name: "Curry-Restaurant", values: [93], isOpen: true },
        { name: "Special", values: [27, 28, 55, 29, 65, 30, 31, 32, 33, 34, 35, 37, 90, 91, 49, 72, 50, 51, 53, 54, 89, 56, 92, 61, 59, 62, 66, 67, 68, 70, 78, 79], isOpen: true }
    ],
    "decorations": [
        {
            name: "Chef Hat",
            catInd: 0,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Chef Hat (Shiny)",
            catInd: 0,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Coffee Cup",
            catInd: 1,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Macaron",
            catInd: 2,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Popcorn Snack",
            catInd: 3,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Toothbrush",
            catInd: 4,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Dandelion",
            catInd: 5,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Stag Beetle",
            catInd: 6,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Acorn",
            catInd: 6,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Fishing Lure",
            catInd: 7,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Stamp",
            catInd: 8,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Picture Frame",
            catInd: 9,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Toy Airplane",
            catInd: 10,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Paper Train",
            catInd: 11,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Ticket",
            catInd: 11,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Shell",
            catInd: 12,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Burger",
            catInd: 13,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Bottle Cap",
            catInd: 14,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Snack",
            catInd: 14,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Mushroom",
            catInd: 15,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Banana",
            catInd: 15,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Baguette",
            catInd: 16,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Scissors",
            catInd: 17,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Hair Tie",
            catInd: 18,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Clover",
            catInd: 19,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "4-Leaf Clover",
            catInd: 19,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Tiny Book",
            catInd: 20,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Mario Hat",
            catInd: 37,
            colors: {
                "red": "nil", "yellow": "nil", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Lunar New Year Ornament (Red)",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Chess Piece (White)",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Fingerboard",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Flower Card 2023 A",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "off", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Flower Card 2023 B",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "off", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Flower Card 2023 C",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "off", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Flower Card 2023 D",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "off", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Flower Card 2023 E",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "off", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Flower Card 2023 F",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "off", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Sticker (Green)",
            catInd: 21,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Sticker (Blue)",
            catInd: 21,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Sticker (Orange)",
            catInd: 21,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Sticker (Winter)",
            catInd: 21,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Sushi",
            catInd: 22,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Mountain Pin Badge",
            catInd: 23,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Leaf Hat A",
            catInd: 25,
            colors: {
                "red": "nil", "yellow": "nil", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Leaf Hat B",
            catInd: 25,
            colors: {
                "red": "nil", "yellow": "nil", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Leaf Hat C",
            catInd: 25,
            colors: {
                "red": "nil", "yellow": "nil", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Theme Park Ticket A",
            catInd: 27,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Theme Park Ticket B",
            catInd: 27,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Paper Bus",
            catInd: 28,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Jack-O'-Lantern",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "1st Anniversary Snack",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Koppaite Space Suit",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Ball Keychain",
            catInd: 24,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Mitten",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "2023 Glasses",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Lunar New Year Ornament (Gold)",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Valentine Sticker",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Pizza",
            catInd: 29,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Coin",
            catInd: 21,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Easter Egg",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Ramen Keychain",
            catInd: 30,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Present Sticker (Gold)",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Sneaker Keychain",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Bridge Badge",
            catInd: 31,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Donut",
            catInd: 2,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Chess Piece (Black)",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Pikmin 4 Spaceship",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Mahjong Tile A",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Mahjong Tile B",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Hotel Amenities",
            catInd: 32,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Ice Cream",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Makeup",
            catInd: 33,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Halloween Treat",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Fortune A (大吉)",
            catInd: 34,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Fortune B (中吉)",
            catInd: 34,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Fortune C (小吉)",
            catInd: 34,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Fortune D (吉)",
            catInd: 34,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Fortune E (末吉)",
            catInd: 34,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Puzzle: 2021 Fall Memories",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Puzzle: 2022 Summer Memories",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Battery A",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Battery B",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Battery C",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Battery D",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Battery E",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Battery F",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Fairy Lights A",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Fairy Lights B",
            catInd: 35,
            colors: {
                "red": "nil", "yellow": "off", "blue": "nil",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Snow",
            catInd: 26,
            colors: {
                "red": "nil", "yellow": "nil", "blue": "off",
                "white": "off", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "2024 Glasses",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Flower Card 2024 A",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Flower Card 2024 B",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        },
        {
            name: "Reverse Valentine's Day Sticker",
            catInd: 37,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "nil", "purple": "nil", "grey": "nil", "pink": "nil"
            }
        },
        {
            name: "Curry Bowl",
            catInd: 36,
            colors: {
                "red": "off", "yellow": "off", "blue": "off",
                "white": "off", "purple": "off", "grey": "off", "pink": "off"
            }
        }
    ]
};

const newSeeds = {
  decorationCount: 0,
  categories: {},
  categoryOrder: [],
};

for (let category of structure.categories) {
  const categoryKey = category.name.charAt(0).toLowerCase() + category.name.replace(/[^a-zA-Z0-9]+/g, '').slice(1);
  newSeeds.categories[categoryKey] = {
    key: categoryKey,
    name: category.name,
    isOpen: true,
    decorations: {},
    decorationOrder: [],
  };
  newSeeds.categoryOrder.push(categoryKey);

  for (let decorIndex of category.values) {
    let decor = structure.decorations[decorIndex];
    let decorKey = decor.name.charAt(0).toLowerCase() + decor.name.replace(/[^a-zA-Z0-9]+/g, '').slice(1);

    newSeeds.decorationCount++;
    newSeeds.categories[categoryKey].decorationOrder.push(decorKey);
    newSeeds.categories[categoryKey].decorations[decorKey] = {
      catKey: categoryKey,
      key: decorKey,
      name: decor.name,
      colors: decor.colors
    };
  }
};

const fs = require('node:fs');

fs.writeFile('./src/scripts/newCats.json', JSON.stringify(newSeeds, null, 4),  err => {
  if (err) {
    console.error(err);
  } else {
    // file written successfully
  }
});