/*=======================
 * 洢ϰ8.16
 ========================*/

#include "MemoryManager.h"

// ʼһƬõĴ洢
void InitSpace(Space* space) {
    void* base;    // ڴʼַ
    Record* record; // һ¼
    
    // ʼMAXSIZEֽڵڴ棬
    base = calloc(MAXSIZE, BYTE);
    space->base = base;
    
    // ʼڴʹü¼
    InitList(&(space->recordList));
    
    record = (Record*) malloc(sizeof(Record));
    
    record->addr = 0;
    record->size = MAXSIZE;
    record->tag = 0;
    record->pre = -1;
    record->next = -1;
    record->oldAddr = -1;
    
    // һڴʹü¼()
    ListInsert(&(space->recordList), 1, record);
    
    // һõĿп
    space->cur = 1;
    
    // ʼַ
    InitList(&(space->ptrList));
}

// СΪnڴ棬ָڴַ
int* AllocMemory(Space* space, int n) {
    int found;  // ǷҵõĿп
    int i, cur, len;
    Record* record;
    Record* newRecord;
    int* ptr;
    
    // µǰĿп¼λ
    i = cur = space->cur;
    found = 0;
    
    // ȡǰڴ¼ĳ
    len = ListLength(space->recordList);
    
    // ҿõĿڴ
    while(1) {
        // ȡǰڴʹϢ
        GetElem(space->recordList, i, (ElemType*) &record);
        
        // ռÿ飬ѾĿп
        if(record->tag == 1 || record->size < n) {
            // ǰһ¼עѭ
            i = (i + 1) % len == 0 ? len : (i + 1) % len;
            if(i == cur) {
                break;  // ֻص˱㣬˵ûҵʵĿп
            }
            continue;
        }
        
        // ҵʵĿп
        found = 1;
        break;
    }
    
    // ûҵʵĿп
    if(found == 0) {
        return NULL;
    }
    
    // ݲΧڣ
    if(record->size - e <= n) {
        record->tag = 1;                    // תΪռ״̬
        
        // Ҫֿп
    } else {
        // ½һм¼
        newRecord = (Record*) malloc(sizeof(Record));
        newRecord->addr = record->addr + n;
        newRecord->size = record->size - n;
        newRecord->tag = 0;
        newRecord->pre = -1;
        newRecord->next = -1;
        newRecord->oldAddr = -1;
        
        // µĿм¼
        ListInsert(&(space->recordList), len + 1, newRecord);
        len += 1;    // һ
        
        // ǰĿм¼תΪʹü¼
        record->size = n;
        record->tag = 1;
    }
    
    // һַ
    ptr = (int*) malloc(sizeof(int));
    ListInsert(&(space->ptrList), ListLength(space->ptrList)+1, ptr);
    *ptr = record->addr;
    
    // αcurָһм¼
    while(1) {
        // ȡǰڴʹϢ
        GetElem(space->recordList, i, (ElemType*) &record);
        
        // ռÿ
        if(record->tag == 1) {
            // ǰһ¼עѭ
            i = (i + 1) % len == 0 ? len : (i + 1) % len;
            if(i == cur) {
                break;  // ֻص˱㣬˵ûҵʵĿп
            }
            continue;
        }
        
        // 洢һÿпλ(ûҵ洢)
        space->cur = i;
        
        break;
    }
    
    return ptr;  // ؿڴַ
}

// ͷַpڴ
void FreeMemory(Space* space, int* p) {
    int i, len;
    Record* record;
    
    // ȡǰڴ¼ĳ
    len = ListLength(space->recordList);
    
    // ڴ¼Ҵͷڴڵļ¼
    for(i = 1; i <= len; i++) {
        // ȡǰڴʹϢ
        GetElem(space->recordList, i, (ElemType*) &record);
        
        // ƥļ¼
        if(*p != record->addr) {
            continue;
        }
        
        // ü¼ǿУֱӷ
        if(record->tag == 0) {
            return;
        }
        
        // ʹü¼Ϊ
        record->tag = 0;
        
        // αָոջյڴ
        space->cur = i;
        
        // õַӦڴ洦Ĩ(Ǹѡ)
        memset(getPtr(*space, p), 0, record->size*BYTE);
        
        // Ҹַڵַеλ
        for(i = 0; i < space->ptrList.length; i++) {
            if(space->ptrList.elem[i] == p) {
                break;
            }
        }
        
        // ɾַݸǰݣ
        memmove(&(space->ptrList.elem[i]), &(space->ptrList.elem[i + 1]), (space->ptrList.length - i - 1) * sizeof(void*));
        
        space->ptrList.length -= 1;
        
        return;
    }
    
}

// ַaddrתΪײʵַ
void* getPtr(Space space, const int* addr) {
    if(addr == NULL) {
        return NULL;
    } else {
        if(*addr < 0 || *addr > MAXSIZE) {
            return NULL;
        }
        
		// VSҪָָͣ趨Ϊһֽ
        return (char*)(space.base) + (*addr * BYTE);
    }
}

// ӡڴ沼֣ʾʽΪ׵ַ С ־ | ǰ  | 
void PrintMemoryLayout(Space space) {
    Record* record;
    int i, len;
    char* data;
    
    len = ListLength(space.recordList);
    
    for(i = 0; i < len; i++) {
        record = space.recordList.elem[i];
        
        printf("%2d ", record->addr);
        printf("%2d ", record->size);
        printf("%1d ", record->tag);
        
        // ǰͺϢ
        printf(" | ");
        
        if(record->tag == 0) {
            printf("       \n");
            continue;
        }
        
        if(record->pre == -1) {
            printf("   ");
        } else {
            printf("%2d ", record->pre);
        }
        
        if(record->next == -1) {
            printf("   ");
        } else {
            printf("%2d ", record->next);
        }
    
        // ڴеݣֻһֽд洢ݣֻڲ
        printf("  ");
        
        data = (char*)calloc(1, sizeof(char));
        memmove(data, getPtr(space, &(record->addr)), 1);
        printf("%d", *data);
        
        printf("\n");
    }
    
    printf("\n");
}
