/*====================
 * ·㷨
 *
 * 㷨: 7.157.16
 =====================*/

#include "ShortestPaths.h"

/*
 * 洢Զ֮Ĺϵ
 *
 * ͼ˵洢0ʾ㲻ֱͨ洢1ʾֱͨ
 * ˵洢Ƕ֮ȨֵȨֵΪINFINITEʾ㲻ֱͨ
 */
static int adjs[MAX_VERTEX_NUM][MAX_VERTEX_NUM];


/*
 * ӦִеϽ˹㷨֮ǰã֮Ĺϵ
 */
void GetAdjs(ALGraph G) {
    int i, j;
    ArcNode* p;
    
    for(i = 0; i < G.vexnum; i++) {
        // ʼϵ
        for(j = 0; j < G.vexnum; j++) {
            // ֻߴ˷֧
            if(G.kind == DN || G.kind == UDN) {
                adjs[i][j] = INFINITE;
            }
            
            // ͼֻߴ˷֧
            if(G.kind == DG || G.kind == UDG) {
                adjs[i][j] = 0;
            }
        }
        
        // ֱӵĶ
        for(p = G.vertices[i].firstarc; p != NULL; p = p->nextarc) {
            // ֻߴ˷֧
            if(G.kind == DN || G.kind == UDN) {
                adjs[i][p->adjvex] = p->info->weight;
            }
            
            // ͼֻߴ˷֧
            if(G.kind == DG || G.kind == UDG) {
                adjs[i][p->adjvex] = 1;
            }
        }
    }
}

/*
 *  㷨7.15 
 *
 * Ͻ˹(Dijkstra)㷨Դ·
 *
 * @param G  ͼ
 * @param v0 Դ·㡣
 * @param P  洢v0·Ϣ
 *           P[j][k]==TRUEv0->j·ᾭk򣬴
 *           ע
 *           1.ֻӳ˶Ĵԣδӳ·ϵĴ
 *           2.֮ж·ֻѡȡһ
 * @param D  洢v0·ۣͼУôǲͣУôȨֵ͡
 */
void ShortestPath_DIJ(ALGraph G, int v0, PathMatrix_DIJ P, ShortPathTable_DIJ D) {
    int v, w, i, j, min;
    Status final[MAX_VERTEX_NUM];   // ǵǰǷѾʹǷѼ·
    
    /*
     * ԤѷʹĶ㼯ΪSδʹĶ㼯ΪV-S
     * ʼʱ㼯SΪգ㼯V-SΪжļV
     */
    for(v = 0; v < G.vexnum; v++) {
        // ʼʱжδʹ
        final[v] = FALSE;
        
        // ʼv0->v·
        D[v] = adjs[v0][v];
        
        // Ԥv0->vҪw·
        for(w = 0; w < G.vexnum; w++) {
            P[v][w] = FALSE;
        }
        
        // ֻߴ˷֧(ֻ̲˴)
        if(G.kind == DN || G.kind == UDN) {
            // v0->vֱͨ
            if(D[v] < INFINITE) {
                P[v][v0] = TRUE;    // ָʾv0->vؽv0(˵һ)
                P[v][v] = TRUE;     // ָʾv0->vؽv(˵)
            }
        }
        
        // ͼֻߴ˷֧
        if(G.kind == DG || G.kind == UDG) {
            // v0vֱͨ
            if(D[v] != 0) {
                P[v][v0] = TRUE;    // ָʾv0->vؽv0(˵һ)
                P[v][v] = TRUE;     // ָʾv0->vؽv(˵)
            }
        }
    }
    
    // ʼv0붥㼯S
    D[v0] = 0;
    final[v0] = TRUE;
    
    /*
     * ʼѭG1.vexnum-1㡣
     * ÿv0ĳ·򽫸öӶ㼯V-SŲ㼯S
     */
    for(i = 1; i < G.vexnum; i++) {
        /*
         * ÿνѡȡ֮ǰӦvΪһֵ֮
         * (̲޴˲裬ҪϣкܶЧѭ)
         */
        v = -1;
        
        // ¼붥v0̾
        min = INFINITE;
        
        // 㼯V-S(δ·Ķ)ѡv0Ķ
        for(w = 0; w < G.vexnum; w++) {
            // wV-S(δ·)
            if(!final[w]) {
                // ͼ˵Ϊ0ζ㲻ͨ
                if((G.kind == DG || G.kind == UDG) && D[w] == 0) {
                    continue;
                }
                
                // v0wľD[w]СڵǰԤС룬Ҫ¶;Ϣ
                if(D[w] < min) {
                    v = w;      // δʵĶоv0Ķ㣬߿Ϊ¶㼯V-Sо붥㼯SĶ
                    min = D[w]; // ¸ľ
                }
            }
        }
        
        // ҵ˸Ķ
        if(v != -1) {
            // 㼯V-Sеǰv0vS
            final[v] = TRUE;
        } else {
            // ûҵĶ㣬˵v0V-Sеʣඥûӣʱֱӽ
            return;
        }
        
        // Ķv壬¶v0V-S㶥·
        for(w = 0; w < G.vexnum; w++) {
            // ֻߴ˷֧(ֻ̲˴)
            if(G.kind == DN || G.kind == UDN) {
                /*
                 * Ϊ˱Ҫȷadjs[v][w]ΪINFINITE
                 * ˴ʵûҪжmin!=INFINITEΪûҵĶʱǰˡ
                 * (̲ĵαδҪ)
                 */
                if(min != INFINITE && adjs[v][w] != INFINITE) {
                    // ¶㼯S㼯V-S
                    if(!final[w] && (min + adjs[v][w] < D[w])) {
                        // ¾룺ڶv0->wvø̵ľ룬ʴ˴Ҫ¸þ
                        D[w] = min + adjs[v][w];
                        
                        /* ·P[w] = P[v] + [w] */
                        
                        // Ƚv0->w·Ϊv0->j·
                        for(j = 0; j < G.vexnum; j++) {
                            P[w][j] = P[v][j];
                        }
                        
                        // ٽwӵv0->w·
                        P[w][w] = TRUE;
                    }
                }
            }
            
            // ͼֻߴ˷֧
            if(G.kind == DG || G.kind == UDG) {
                // ¶㼯S㼯V-S
                if(!final[w] && adjs[v][w] != 0 && D[w] == 0) {
                    // ¾룺ڶv0->wvø̵ľ룬ʴ˴Ҫ¸þ
                    D[w] = D[v] + 1;    // ͼڶ㲽Ϊ1
                    
                    /* ·P[w] = P[v] + [w] */
                    
                    // Ƚv0->w·Ϊv0->j·
                    for(j = 0; j < G.vexnum; j++) {
                        P[w][j] = P[v][j];
                    }
                    
                    // ٽwӵv0->w·
                    P[w][w] = TRUE;
                }
            }
        }
    }
}

/*
 * ӡʹõϽ˹(Dijkstra)㷨ȡĵԴ·
 */
void PrintPath_DIJ(ALGraph G, int v0, PathMatrix_DIJ P, ShortPathTable_DIJ D) {
    int j;
    
    // ·
    for(j = 0; j < G.vexnum; j++) {
        if(P[j][v0] == FALSE) {
            printf("%c  %c ֮ûͨ·\n", GetVex(G, v0), GetVex(G, j));
            continue;
        }
        
        printf("%c  %c ֮̾Ϊ%2d·Ϊ", GetVex(G, v0), GetVex(G, j), D[j]);
        
        /*
         * v0->j֮򶥵гһ·ӡ
         * P[i]ָʾv0->j·ϾĶ
         */
        PrintPath(G, v0, j, P[j]);
    }
}

/*
 * ӡab··ĶϢλP
 */
static void PrintPath(ALGraph G, int a, int b, Boolean P[MAX_VERTEX_NUM]) {
    int i;
    int vexs[MAX_VERTEX_NUM + 1];
    int path[MAX_VERTEX_NUM + 1];
    
    vexs[0] = 0;
    
    // ȡv0->i;ϵж㣬
    for(i = 0; i < G.vexnum; i++) {
        if(P[i] == TRUE) {
            vexs[0]++;
            vexs[vexs[0]] = i;
        }
    }
    
    // ֻ¿ٴ
    if(vexs[0] == 2) {
        path[0] = 2;
        path[1] = a;
        path[2] = b;
        goto print;
    }
    
    // ֻ¿ٴ
    if(vexs[0] == 3) {
        path[0] = 3;
        path[1] = a;
        for(i = 1; i <= vexs[0]; i++) {
            if(vexs[i] != a && vexs[i] != b) {
                path[2] = vexs[i];
                break;
            }
        }
        path[3] = b;
        goto print;
    }
    
    path[0] = 1;
    path[1] = a;
    
    for(i = 1; i <= vexs[0]; i++) {
        if(vexs[i] == a) {
            vexs[i] = -1;
            break;
        }
    }
    
    Find(G, a, b, vexs, path);

print:
    // ӡкõ·
    for(i = 1; i <= path[0]; i++) {
        printf("%c ", GetVex(G, path[i]));
    }
    
    printf("\n");
}

/*
 * ùԤҵһpreb···жλvexsУҳ·洢path
 */
static Status Find(ALGraph G, int pre, int b, int vexs[MAX_VERTEX_NUM + 1], int path[MAX_VERTEX_NUM + 1]) {
    int i;
    int tmp;
    Status s;
    
    for(i = 1; i <= vexs[0]; i++) {
        // Ѽ뵽·
        if(vexs[i] == -1) {
            continue;
        }
        
        // ͨ
        if(((G.kind == DN || G.kind == UDN) && adjs[pre][vexs[i]] == INFINITE)
        || ((G.kind == DG || G.kind == UDG) && adjs[pre][vexs[i]] == 0)) {
            continue;
        }
        
        path[0]++;
        path[path[0]] = vexs[i];
        
        // յ
        if(vexs[i] == b) {
            // ҵ·
            if(path[0] == vexs[0]) {
                return OK;
            } else {
                path[0]--;
                continue;
            }
        }
        
        tmp = vexs[i];
        vexs[i] = -1;
        
        s = Find(G, tmp, b, vexs, path);
        
        if(s == OK) {
            return OK;
        } else {
            // ָö㣬Ա
            vexs[i] = tmp;
            path[0]--;
        }
    }
    
    return ERROR;
}
