#include <stdio.h>
#include <limits.h>
#include "SqList.h"
#include "ALGraph.h"

/*
 * ȡ洢޻ͼеıʽ沨ʽ
 *
 * עʽṹο̲Ĳͼ7.23
 */
void Algo_7_40(ALGraph G, SqList* RPN);

/*
 * Ӷvȡͼд洢ıʽ沨ʽ
 * ȡ沨ʽ洢RPNС
 */
static void AntiPolandFormula_7_40(ALGraph G, int v, SqList* RPN);

/*
 * 沨ʽֵ
 */
int Evaluation_7_40(SqList RPN);


int main(int argc, char* argv[]) {
    ALGraph G;
    SqList RPN;     // 洢沨ʽ
    
    printf(" ӡ... \n");
    {
        char* path[4];
        
        path[0] = "TestData_DG.txt";
        path[1] = "";
        path[2] = "";
        path[3] = "";
        
        CreateGraph(&G, path);
        PrintGraph(G);
        printf("\n");
    }
    
    printf(" ȡд洢ıʽ沨ʽ... \n");
    {
        Algo_7_40(G, &RPN);
        printf("\n");
    }
    
    printf(" 沨ʽֵ... \n");
    {
        printf("沨ʽֵΪ%d\n", Evaluation_7_40(RPN));
        printf("\n");
    }
    
    return 0;
}


/*
 * ȡ洢޻ͼеıʽ沨ʽ
 *
 * עʽṹο̲Ĳͼ7.23
 */
void Algo_7_40(ALGraph G, SqList* RPN) {
    int i, root;
    int indegree[MAX_VERTEX_NUM];   // жϢ
    ArcNode* p;
    ElemType e;
    
    // ʼжΪ0
    for(i = 0; i < G.vexnum; i++) {
        indegree[i] = 0;
    }
    
    // ж
    for(i = 0; i < G.vexnum; i++) {
        // ָö׸ڽӵ
        p = G.vertices[i].firstarc;
        
        // öڽӵ㣬ͳƸ
        while(p != NULL) {
            indegree[p->adjvex]++;
            p = p->nextarc;
        }
    }
    
    // ҵ
    for(i = 0; i < G.vexnum; i++) {
        if(indegree[i] == 0) {
            root = i;
            break;
        }
    }
    
    // ʼΪ0Ա
    InitList(RPN);
    
    // ޻ͼĸͨβݹȡд洢ıʽ沨ʽ
    AntiPolandFormula_7_40(G, root, RPN);
    
    // 沨ʽ
    for(i = 1; i <= ListLength(*RPN); i++) {
        GetElem(*RPN, i, &e);
        
        if(e.type == Operand) {
            printf("%d ", e.op);    // 
        } else {
            printf("%c ", e.op);    // 
        }
    }
    printf("\n");
}

/*
 * Ӷvȡͼд洢ıʽ沨ʽ
 * ȡ沨ʽ洢RPNС
 */
void AntiPolandFormula_7_40(ALGraph G, int v, SqList* RPN) {
    ArcNode* r;
    Vertex vex;
    
    // ȱڽӵ
    for(r = G.vertices[v].firstarc; r != NULL; r = r->nextarc) {
        AntiPolandFormula_7_40(G, r->adjvex, RPN);
    }
    
    // ȡ/
    vex = G.vertices[v].context;
    
    // ûڽӵɱʱ洢ö
    ListInsert(RPN, ListLength(*RPN) + 1, vex);
}

/*
 * 沨ʽֵ󣬷INT_MIN
 */
int Evaluation_7_40(SqList RPN) {
    int stack[MAX_VERTEX_NUM];  // ģһջ洢ʽļ
    int top = 0; // ջα
    int a, b;
    ElemType e;
    int i;
    Boolean hasError = FALSE;   // г˴
    
    for(i = 1; i <= ListLength(RPN) && !hasError; i++) {
        GetElem(RPN, i, &e);
        
        // 
        if(e.type == Operand) {
            stack[top++] = e.op;
            
            // 
        } else {
            if(top > 0) {
                b = stack[--top];
            } else {
                return INT_MIN;
            }
            
            if(top > 0) {
                a = stack[--top];
            } else {
                return INT_MIN;
            }
            
            switch(e.op) {
                case '+':
                    stack[top++] = a + b;
                    break;
                case '-':
                    stack[top++] = a - b;
                    break;
                case '*':
                    stack[top++] = a * b;
                    break;
                case '/':
                    stack[top++] = a / b;
                    break;
                default:
                    printf("޷ʶĲ%c\n", e.op);
                    hasError = TRUE;
                    break;
            }
        }
    }
    
    // ջֻӦʣһֵ
    if(hasError || top != 1) {
        return INT_MIN;
    }
    
    return stack[0];
}
