/*=================================
 * 7.33һṹ
 ==================================*/

#include "Graph.h"

// ¼ݵԴļfpΪnullʱ˵Ҫӿ̨¼
static FILE* fp = NULL;


/*
 * 
 *
 * pathΪNULLΪ""ʱӿ̨ȡͼĳʼϢ
 * 򣬴ԤļжȡͼĳʼϢ
 */
Status CreateGraph(Graph* G, char* path) {
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    // Ҫļȡ
    if(!readFromConsole) {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
    }
    
    Create(G);
    
    if(fp != NULL) {
        fclose(fp);
        fp = NULL;
    }
    
    return OK;
}

/*
 * ĺ㷨
 */
static void Create(Graph* G) {
    int u, v, k;
    VertexType v1, v2;
    int weight;
    
    // ӿ̨ȡ
    if(fp == NULL) {
        printf("Ķ");
        scanf("%d", &((*G).vexnum));
        printf("ı");
        scanf("%d", &((*G).arcnum));
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", (*G).vexnum);
        for(k = 0; k < (*G).vexnum; k++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).vexs[k]));
        }
        
        // ļȡ
    } else {
        ReadData(fp, "%d", &((*G).vexnum)); // ¼붥
        ReadData(fp, "%d", &((*G).arcnum)); // ¼
        
        // ¼붥㼯
        for(k = 0; k < (*G).vexnum; k++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).vexs[k]));
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && (*G).arcnum != 0) {
        printf("Ϊ¼ %d ߵϢȨֵ֮ÿո\n", (*G).arcnum);
    }
    
    // ߼ṹ0ŵԪ洢ߵ
    (*G).EdgeSet = (EdgeSetType*) malloc(((*G).arcnum + 1) * sizeof(EdgeSetType));
    if((*G).EdgeSet == NULL) {
        exit(ERROR);
    }
    
    // EdgeSet0ŵԪ洢бߵ
    (*G).EdgeSet[0].weight = (*G).arcnum;
    
    // ¼ߵϢ
    for(k = 0; k < (*G).arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d Ȩֵ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%d", &weight);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c%d", &v1, &v2, &weight);
        }
        
        u = LocateVex(*G, v1);  // ȡv1ڶ㼯еλ
        v = LocateVex(*G, v2);  // ȡv2ڶ㼯еλ
        
        (*G).EdgeSet[k + 1].u = u;
        (*G).EdgeSet[k + 1].v = v;
        (*G).EdgeSet[k + 1].weight = weight;
    }
}

/*
 * 
 *
 * ضuеλ
 */
int LocateVex(Graph G, VertexType u) {
    int i;
    
    for(i = 0; i < G.vexnum; i++) {
        if(G.vexs[i] == u) {
            return i;
        }
    }
    
    return -1;
}

/*
 * ӱ߼EdgeSetлȡСߵĶuvTRUE
 * ߼Ϊգ򷵻FASLE
 */
Boolean GetMinEdge(EdgeSetType* EdgeSet, int* u, int* v) {
    int i, j, k;
    int min = INT_MAX;  // ¼Ȩֵֵ
    
    // ߼Ϊ
    if(EdgeSet[0].weight == 0) {
        return FALSE;
    }
    
    // ȨֵСı
    for(k = 1; k <= EdgeSet[0].weight; k++) {
        if(EdgeSet[k].weight < min) {
            min = EdgeSet[k].weight;
            i = EdgeSet[k].u;
            j = EdgeSet[k].v;
        }
    }
    
    // ¼Ϣ
    *u = i;
    *v = j;
    
    return TRUE;
}

/*
 * ӱ߼ɾڶuvСߡ
 * ɾɹTRUE򣬷FALSE
 */
Boolean DelMinEdge(EdgeSetType* EdgeSet, int u, int v) {
    int k;
    Boolean found = FALSE;  // Ƿҵ˱<u, v>
    
    // ߼Ϊ
    if(EdgeSet[0].weight == 0) {
        return FALSE;
    }
    
    // ȲҸڱ߼еλ
    for(k = 1; k <= EdgeSet[0].weight; k++) {
        if((EdgeSet[k].u == u && EdgeSet[k].v == v) || (EdgeSet[k].u == v && EdgeSet[k].v == u)) {
            found = TRUE;
            break;
        }
    }
    
    if(found == FALSE) {
        return FALSE;
    }
    
    // õɾʽֱһߵϢǴɾߵϢ
    EdgeSet[k] = EdgeSet[EdgeSet[0].weight];
    EdgeSet[0].weight--;
    
    return TRUE;
}

/*
 * ӡṹ
 */
void PrintGraph(Graph G) {
    int i, j, k, w;
    int adjs[MAX_VERTEX_NUM][MAX_VERTEX_NUM];
    
    if(G.vexnum == 0) {
        printf("ͼӡ\n");
        return;
    }
    
    // ʼߵϢ
    for(i = 0; i < G.vexnum; i++) {
        for(j = 0; j < G.vexnum; j++) {
            adjs[i][j] = INFINITE;
        }
    }
    
    // ߼
    for(k = 1; k <= G.EdgeSet[0].weight; k++) {
        i = G.EdgeSet[k].u;
        j = G.EdgeSet[k].v;
        w = G.EdgeSet[k].weight;
        
        adjs[i][j] = adjs[j][i] = w;
    }
    
    printf("ǰ %2d 㣬 %2d ...\n", G.vexnum, G.arcnum);
    
    printf("  ");
    for(i = 0; i < G.vexnum; i++) {
        printf("  %c", G.vexs[i]);
    }
    printf("\n");
    
    for(i = 0; i < G.vexnum; i++) {
        printf("%c ", G.vexs[i]);
        
        for(j = 0; j < G.vexnum; j++) {
            if(adjs[i][j] == INFINITE) {
                printf("  -");
            } else {
                printf("%3d", adjs[i][j]);
            }
        }
        
        printf("\n");
    }
}
