/*==================
 * ͼǿͨ
 ===================*/

#include "StronglyConnectedComponents.h"


/* ȫֱ */
static int count;      // ԷʹĽ

// Kosaraju㷨
static Boolean visited[MAX_VERTEX_NUM];    // ʱ־飬¼ʹĶ
static int finished[MAX_VERTEX_NUM];       // 洢ȱзʵԪ

// Tarjan㷨
static int dfs[MAX_VERTEX_NUM];    // ȱʱηʵԪ()
static int low[MAX_VERTEX_NUM];    // low[v]  ==> ԪvԻݵ
static int stack[MAX_VERTEX_NUM];  // 洢Ľ


/*
 * (1) Tarjan㷨ȡǿͨ
 *
 * ˼ȱ+ݣ뱾µ8ؽڵ㷨֮
 */
void Tarjan(OLGraph G) {
    int i;
    
    count = -1;  // ʼ
    
    // ʼΪδ
    for(i = 0; i < G.vexnum; i++) {
        dfs[i] = -1;
        low[i] = -1;
    }
    
    printf("ӡǰͼеĸǿͨ\n");
    
    for(i = 0; i < G.vexnum; i++) {
        if(dfs[i] == -1) {
            DFS_Tarjan(G, i);
        }
    }
}

/*
 * ȱvɴԪأҳеǿͨ
 */
static void DFS_Tarjan(OLGraph G, int v) {
    int min;
    int w;
    int i;
    
    ++count;
    
    // ¼ʴ
    dfs[v] = min = count;
    
    // ¼Ľ
    stack[count] = v;
    
    // ȱvʼͼ
    for(w = FirstAdjVex(G, G.xlist[v].data); w >= 0; w = NextAdjVex(G, G.xlist[v].data, G.xlist[w].data)) {
        // wδ
        if(dfs[w] == -1) {
            DFS_Tarjan(G, w);  // δʵĶDFS
            
            if(low[w] < min) {
                min = low[w];
            }
            
            // ѷʹĽ
        } else {
            // wѱʹwvϵ
            if(dfs[w] < min) {
                min = dfs[w];
            }
        }
    }
    
    // ""㻹ûȷȣֻ¼""ϵķʴ
    if(low[stack[min]]==-1) {
        low[v] = min;
    } else {
        // ȡ""ϵĿɻ
        low[v] = low[stack[min]];
    }
    
    // ȡǰǿͨӼ
    if(low[v] == dfs[v]) {
        for(i = count; i >= 0; i--) {
            if(low[stack[i]] == dfs[v]) {
                printf("%c ", GetVex(G, stack[i]));
                count--;
            } else {
                break;
            }
        }
        printf("\n");
    }
}


/*
 * (2) Kosaraju㷨ȡǿͨǽ̲ᵽ㷨
 *
 * ˼ǣ
 * 1.ĳȱͼõһУ
 * 2.ͼ
 * 3.óķУеÿȱ
 */
void Kosaraju(OLGraph G) {
    int i, v;
    
    count = 0;  // ʼ
    
    // 1.ĳȱͼõһ
    DFSTraverse(G, StoreElem);
    
    // 2.ͼ
    InverseGraph(&G);
    
    // ʱ־ʼ
    for(i = 0; i < G.vexnum; i++) {
        visited[i] = FALSE;
    }
    
    printf("ӡǰͼеĸǿͨ\n");
    
    // 3.óķУеÿȱ
    for(i = 0; i < count; i++) {
        v = LocateVex(G, finished[i]);
        
        if(visited[v] == TRUE) {
            continue;
        }
        
        DFS_Inverse(G, v);
        printf("\n");
    }
}

/*
 * ͼʮ洢ṹлķ
 *
 * ˼ǣ
 * 1.һκλĿͼ
 * 2.αÿÿ뻡
 * 3.ժ뻡뵽ͼбɳ
 */
static void InverseGraph(OLGraph* G) {
    OLGraph newG = *G;
    int i;
    ArcBox* r;
    ArcBox* pre, * p;
    int tmp;
    
    for(i = 0; i < newG.vexnum; i++) {
        newG.xlist[i].firstin = NULL;
        newG.xlist[i].firstout = NULL;
    }
    
    for(i = 0; i < (*G).vexnum; i++) {
        while((*G).xlist[i].firstin != NULL) {
            // ժָ򶥵i뻡
            r = (*G).xlist[i].firstin;
            (*G).xlist[i].firstin = r->hlink;
            
            // ûķ
            tmp = r->headvex;
            r->headvex = r->tailvex;
            r->tailvex = tmp;
            
            r->hlink = NULL;
            r->tlink = NULL;
            
            // 뵽ͼ
            pre = newG.xlist[r->headvex].firstin;
            if(pre == NULL) {
                newG.xlist[r->headvex].firstin = r;
            } else {
                if(r->tailvex < pre->tailvex) {
                    r->hlink = newG.xlist[r->headvex].firstin;
                    newG.xlist[r->headvex].firstin = r;
                } else if(r->tailvex > pre->tailvex) {
                    p = pre->hlink;
                    
                    while(p != NULL && r->tailvex > p->tailvex) {
                        pre = p;
                        p = p->hlink;
                    }
                    
                    if(p == NULL || r->tailvex < p->tailvex) {
                        r->hlink = p;
                        pre->hlink = r;
                    }
                } else {
                    // ʱ
                }
            }
            
            // 뵽ͼĺ
            pre = newG.xlist[r->tailvex].firstout;
            if(pre == NULL) {
                newG.xlist[r->tailvex].firstout = r;
            } else {
                if(r->headvex < pre->headvex) {
                    r->tlink = newG.xlist[r->tailvex].firstout;
                    newG.xlist[r->tailvex].firstout = r;
                } else if(r->headvex > pre->headvex) {
                    p = pre->tlink;
                    
                    while(p != NULL && r->headvex > p->headvex) {
                        pre = p;
                        p = p->tlink;
                    }
                    
                    if(p == NULL || r->headvex < p->headvex) {
                        r->tlink = p;
                        pre->tlink = r;
                    }
                } else {
                    // ʱ
                }
            }
        }
    }
    
    *G = newG;
}

/*
 * 洢ȱзʵԪ
 */
static Status StoreElem(VertexType c) {
    finished[count++] = c;
    return OK;
}

/*
 * ȱѾúͼ
 */
static void DFS_Inverse(OLGraph G, int v) {
    int w;
    
    // ѷʹֱӷ
    if(visited[v] == TRUE) {
        return;
    }
    
    // ӵvݹȱͼG
    visited[v] = TRUE;
    
    // ӡʵĶ
    printf("%c ", GetVex(G, v));
    
    for(w = FirstAdjVex(G, G.xlist[v].data);
        w >= 0;
        w = NextAdjVex(G, G.xlist[v].data, G.xlist[w].data)) {
        DFS_Inverse(G, w);  // δʵĶDFS
    }
}
