/*====================
 * ͼʮ洢ʾ
 *
 * 㷨: 7.3
 ====================*/

#include "OLGraph.h"

// ¼ݵԴļfpΪnullʱ˵Ҫӿ̨¼
static FILE* fp = NULL;

/*
 * IncInfoָʾͼıǷڸϢ
 * ֵΪ0ʾ޸Ϣ򣬱ʾڸϢ
 */
Boolean IncInfo = FALSE;

// ʱ־飬¼ʹĶ
static Boolean visited[MAX_VERTEX_NUM];

// 
static Status (* VisitFunc)(VertexType e);


/*
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(OLGraph* G, char* path[]) {
    int readFromConsole;    // Ƿӿ̨ȡ
    int kind;
    Status flag;
    
    printf("ͼ(0-ͼ  1-  2-ͼ  3-)");
    scanf("%d", &kind);
    
    // ͲϹ
    if(kind < 0 || kind > 3) {
        return ERROR;
    }
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = (path == NULL) || strcmp(path[kind], "") == 0;
    
    // Ҫļȡ
    if(readFromConsole) {
        (*G).kind = kind;   // ¼ͼ/
    } else {
        // ļ׼ȡ
        fp = fopen(path[kind], "r");
        if(fp == NULL) {
            return ERROR;
        }
        
        // ¼ͼ
        ReadData(fp, "%d", &((*G).kind));
    }
    
    // ͼ/ͼ/һ
    switch((*G).kind) {
        case DG:
            flag = CreateDG(G);
            break;
        case DN:
            flag = CreateDN(G);
            break;
        case UDG:
            flag = CreateUDG(G);
            break;
        case UDN:
            flag = CreateUDN(G);
            break;
        default:
            flag = ERROR;
            break;
    }
    
    if(fp != NULL) {
        fclose(fp);
        fp = NULL;
    }
    
    return flag;
}

/*
 *  㷨7.3 
 *
 * ͼ
 *
 * ע
 * ̲ʹͷ巨뻡Ψһŵǲ뷽㣬
 * 漰ɾʱЧʽϵͣ
 * ң"ͷ巨"˳ı/ģ
 * չͼ/еı/Ҳġ
 *
 * Ϊ˿˷ȱ㣬""뷨֤Ļ""ġ
 * ͬʱʹ""㷨ýΪӡ
 */
static Status CreateDG(OLGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).arcnum = 0;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &vexnum);
        printf("ͼĻ");
        scanf("%d", &arcnum);
        printf("ͼĻǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            scanf("%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum);    // ¼붥
        ReadData(fp, "%d", &arcnum);    // ¼뻡
        ReadData(fp, "%d", &IncInfo);   // жϻǷϢ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊͼ¼ %d Ϣ֮ÿո\n", arcnum);
    }
    
    // ¼뻡Ϣ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼뻡Ϣ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &info);
        }
        
        // 뻡<v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * 
 */
static Status CreateDN(OLGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).arcnum = 0;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &vexnum);
        printf("Ļ");
        scanf("%d", &arcnum);
        printf("ĻϱϢΪ˴ȨֵҪ洢Ϣ...\n");
        IncInfo = 1;
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum); // ¼붥
        ReadData(fp, "%d", &arcnum); // ¼뻡
        ReadData(fp, "%d", &IncInfo);// жϻǷϢ(˴Ӧ)
        IncInfo = 1;    // ǿƽȨֵ¼뵽Ϣ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊ¼ %d (Ȩֵ)Ϣ㼰Ȩֵ֮ÿո\n", arcnum);
    }
    
    // ¼뻡Ϣ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d Ȩֵ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼뻡Ϣ
        if(IncInfo) {
            // ¼븽Ϣ(˴Ҫ¼Ȩֵ)
            Input(*G, &info);
        }
        
        // 뻡<v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ͼ
 */
static Status CreateUDG(OLGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).arcnum = 0;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &vexnum);
        printf("ͼı");
        scanf("%d", &arcnum);
        printf("ͼıǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum); // ¼붥
        ReadData(fp, "%d", &arcnum); // ¼
        ReadData(fp, "%d", &IncInfo);// жϱǷϢ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊͼ¼ %d ߵϢ֮ÿո\n", arcnum);
    }
    
    // ¼ߵϢ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ߣ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼ߵϢ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &info);
        }
        
        // <v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * 
 */
static Status CreateUDN(OLGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).arcnum = 0;
    
    if(fp == NULL) {
        printf("Ķ");
        scanf("%d", &vexnum);
        printf("ı");
        scanf("%d", &arcnum);
        printf("ıϱϢΪ˴ȨֵҪ洢Ϣ...\n");
        IncInfo = 1;
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum); // ¼붥
        ReadData(fp, "%d", &arcnum); // ¼
        ReadData(fp, "%d", &IncInfo);// жϱǷϢ
        IncInfo = 1;    // ǿƽȨֵ¼뵽Ϣ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊ¼ %d (Ȩֵ)Ϣ㼰Ȩֵ֮ÿո\n", arcnum);
    }
    
    // ¼ߵϢ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ߼Ȩֵ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼ߵϢ
        if(IncInfo) {
            // ¼븽Ϣ(˴Ҫ¼Ȩֵ)
            Input(*G, &info);
        }
        
        // <v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ¼뻡ظϢ
 */
static void Input(OLGraph G, InfoType** info) {
    int weight;
    
    // ""Ҫ¼ȨֵϢ
    if(G.kind == DN || G.kind == UDN) {
        *info = (InfoType*) malloc(sizeof(InfoType));
        
        if(fp == NULL) {
            scanf("%d", &weight);
        } else {
            ReadData(fp, "%d", &weight);
        }
        
        (*info)->weight = weight;
    }
}

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(OLGraph G, VertexType u) {
    int i;
    
    for(i = 0; i < G.vexnum; i++) {
        if(G.xlist[i].data == u) {
            return i;
        }
    }
    
    return -1;
}

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex(OLGraph* G, VertexType v) {
    int k;
    
    // 
    if((*G).vexnum == MAX_VERTEX_NUM) {
        return ERROR;
    }
    
    // ҪжϸöǷ
    k = LocateVex(*G, v);
    if(k >= 0) {
        return ERROR;    // ָĶʱظ
    }
    
    G->xlist[(*G).vexnum].data = v;
    G->xlist[(*G).vexnum].firstin = NULL;
    G->xlist[(*G).vexnum].firstout = NULL;
    
    (*G).vexnum++;
    
    return OK;
}

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex(OLGraph* G, VertexType v) {
    int k, i;
    ArcBox* pre, * r;
    ArcBox* pre2, * r2;
    
    // ҪжϸöǷ
    k = LocateVex(*G, v);
    if(k == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    // ҵԽvͷŸн
    r = G->xlist[k].firstout;
    while(r != NULL) {
        pre = r;
        r = r->tlink;
        
        // ϲpreλ
        pre2 = NULL;
        r2 = G->xlist[pre->headvex].firstin;   // ˣr2һΪNULL
        while(r2 != NULL && r2->tailvex != k) {
            pre2 = r2;
            r2 = r2->hlink;
        }
        
        // ˣr2һָ˴ɾĻ
        if(pre2 == NULL) {
            G->xlist[pre->headvex].firstin = r2->hlink;
        } else {
            pre2->hlink = r2->hlink;
        }
        
        free(pre);
        
        (*G).arcnum--;
    }
    
    G->xlist[k].firstout = NULL;
    
    // ɾЩָ򶥵vĻң±곬kĶ㣬±ֵҪݼ
    for(i = 0; i < G->vexnum; i++) {
        pre = NULL;
        r = G->xlist[i].firstout;
        while(r != NULL && r->headvex < k) {
            if(r->tailvex > k) {
                r->tailvex -= 1;
            }
            pre = r;
            r = r->tlink;
        }
        
        // ж±Сk
        if(r == NULL) {
            continue;
        }
        
        if(r->headvex == k) {
            // ӿͷɾv
            if(pre == NULL) {
                G->xlist[i].firstout = r->tlink;
                
                // мĳλɾv
            } else {
                pre->tlink = r->tlink;
            }
            
            // ϲrλ
            pre2 = NULL;
            r2 = G->xlist[k].firstin;   // ˣr2һΪNULL
            while(r2 != NULL && r2->tailvex != r->tailvex) {
                pre2 = r2;
                r2 = r2->hlink;
            }
            
            // ˣr2һָ˴ɾĻ
            if(pre2 == NULL) {
                G->xlist[k].firstin = r2->hlink;
            } else {
                pre2->hlink = r2->hlink;
            }
            
            free(r);
            
            // ͼ/ȻҪݼ/
            if((*G).kind == DG || (*G).kind == DN) {
                (*G).arcnum--;
            }
        }
        
        // ٴȷrλ
        if(pre == NULL) {
            r = G->xlist[i].firstout;
        } else {
            r = pre->tlink;
        }
        
        // ±곬kĶ㣬Ҫݼ±
        while(r != NULL) {
            if(r->tailvex > k) {
                r->tailvex -= 1;
            }
            
            if(r->headvex > k) {
                r->headvex -= 1;
            }
            
            r = r->tlink;
        }
    }
    
    // 㼯ǰ
    for(i = k + 1; i < (*G).vexnum; i++) {
        G->xlist[i - 1] = G->xlist[i];
    }
    
    // ݼ
    (*G).vexnum--;
    
    return OK;
}

/*
 * һ/(ڲʹ)
 */
static ArcBox* newArcBoxPtr(int tailvex, int headvex, ArcBox* hlink, ArcBox* tlink, InfoType* info) {
    ArcBox* p = (ArcBox*) malloc(sizeof(ArcBox));
    if(!p) {
        exit(OVERFLOW);
    }
    
    p->tailvex = tailvex;
    p->headvex = headvex;
    
    p->hlink = hlink;
    p->tlink = tlink;
    
    p->info = info;
    
    return p;
}

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 * ͼ/˵ڿɱг/ĸϢ
 *
 * ע˴յĲMGraphЩһĸϢа˸/Ȩֵ
 */
Status InsertArc(OLGraph* G, VertexType v, VertexType w, ...) {
    int tail, head, k, count;
    ArcBox* p;
    ArcBox* pre;
    ArcBox* r;
    Boolean overlay = FALSE;   // ǷΪ
    InfoType* info = NULL;     // /ĸϢ
    va_list ap;
    
    tail = LocateVex(*G, v); // ȡvڶ㼯еλ
    if(tail == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    head = LocateVex(*G, w); // ȡwڶ㼯еλ
    if(head == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    // ܾ
    if(tail == head) {
        return ERROR;
    }
    
    // /ϴڸϢ
    if(IncInfo) {
        va_start(ap, w);                // wѯ׸ɱ
        info = va_arg(ap, InfoType*);   // ȡϢ
        va_end(ap);
    }
    
    /* ҪҺʵĲλ */
    
    for(count = 0; count < 2; count++) {
        
        // ںϲҺʵĲλ
        pre = NULL;
        // ָtailΪβ/
        r = G->xlist[tail].firstout;
        while(r != NULL && r->headvex < head) {
            pre = r;
            r = r->tlink;
        }
        
        // ͬλõĽ
        if(r != NULL && r->headvex == head) {
            r->info = info; // øý
            overlay = TRUE; // ˸
        } else {
            p = newArcBoxPtr(tail, head, NULL, r, info);
            
            if(pre == NULL) {
                G->xlist[tail].firstout = p;
            } else {
                pre->tlink = p;
            }
        }
        
        // ûзǣ˵½㣬ʱҪϵλ
        if(overlay == FALSE) {
            // ϲҺʵĲλ
            pre = NULL;
            // ָheadΪͷ/
            r = G->xlist[head].firstin;
            while(r != NULL && r->tailvex < tail) {
                pre = r;
                r = r->hlink;
            }
            
            // ͬλõĽ
            if(r != NULL && r->tailvex == tail) {
                // ִеΪ˸ǣǰ
            } else {
                /* ˣpѾ */
                
                if(pre == NULL) {
                    p->hlink = G->xlist[head].firstin;
                    G->xlist[head].firstin = p;
                } else {
                    p->hlink = pre->hlink;
                    pre->hlink = p;
                }
            }
        }
        
        // ǰͼ/ģҪǶԳ
        if((G->kind == UDG || G->kind == UDN) && tail != head) {
            // ߵij
            k = tail;
            tail = head;
            head = k;
        } else {
            break;  // ģԽ
        }
    }
    
    // ڷǸǵ£ſǸ±/
    if(!overlay) {
        (*G).arcnum++;  // 򣬱/ֻһ
    }
    
    return OK;
}

/*
 * ɾ/<v, w>
 */
Status DeleteArc(OLGraph* G, VertexType v, VertexType w) {
    int tail, head, k, count;
    ArcBox* pre, * r;
    ArcBox* pre2, * r2;
    
    tail = LocateVex(*G, v);
    if(tail == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    head = LocateVex(*G, w);
    if(head == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    for(count = 0; count < 2; count++) {
        pre = NULL;
        // ںҵɾı/
        r = G->xlist[tail].firstout;
        while(r != NULL && r->headvex < head) {
            pre = r;
            r = r->tlink;
        }
        
        // ҵ˴ɾı/
        if(r != NULL && r->headvex == head) {
            if(pre == NULL) {
                G->xlist[tail].firstout = r->tlink;
            } else {
                pre->tlink = r->tlink;
            }
            
            // ϲrλ
            pre2 = NULL;
            r2 = G->xlist[head].firstin;   // ˣr2һΪNULL
            while(r2 != NULL && r2->tailvex != r->tailvex) {
                pre2 = r2;
                r2 = r2->hlink;
            }
            
            // ˣr2һָ˴ɾĻ
            if(pre2 == NULL) {
                G->xlist[head].firstin = r2->hlink;
            } else {
                pre2->hlink = r2->hlink;
            }
            
            free(r);
        } else {
            return ERROR; // ûҵ
        }
        
        // ǰͼ/ģҪǶԳ
        if((G->kind == UDG || G->kind == UDN) && tail != head) {
            // ߵtailhead
            k = tail;
            tail = head;
            head = k;
        } else {
            break;  // ģԽ
        }
    }
    
    (*G).arcnum--;  // 򣬱/ֻһ
    
    return OK;
}

/*
 * ͼλʽǰṹ
 */
void PrintGraph(OLGraph G) {
    int i, head;
    ArcBox* p;
    
    if(G.vexnum == 0) {
        printf("ͼӡ\n");
        return;
    }
    
    printf("ǰͼ/ %2d 㣬 %2d /...\n", G.vexnum, G.arcnum);
    
    for(i = 0; i < G.vexnum; i++) {
        printf("%c ===> ", G.xlist[i].data);
        
        head = 0;
        p = G.xlist[i].firstout;
        
        while(p != NULL) {
            if(head < p->headvex) {
                if(IncInfo == 0) {
                    printf("      ");
                    
                    // 丽ϢлȡȨֵ
                } else {
                    printf("          ");
                }
            } else {
                if(IncInfo == 0) {
                    printf("<%c, %c>", G.xlist[p->tailvex].data, G.xlist[p->headvex].data);
                    
                    // 丽ϢлȡȨֵ
                } else {
                    printf("<%c, %c, %2d>", G.xlist[p->tailvex].data, G.xlist[p->headvex].data, p->info->weight);
                }
                
                p = p->tlink;
            }
            
            head++;
            
            if(p != NULL) {
                printf("  ");
            }
        }
        
        printf("\n");
    }
}
