/*=============================
 * ĺ(˫)Ĵ洢ʾ
 =============================*/

#ifndef CTREE_H
#define CTREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include "Status.h"     //**01 **//
#include "LinkQueue.h"  //**03 ջͶ**//

/*  */
#define MAX_TREE_SIZE 1024

/* ĺ */
#define MAX_CHILD_COUNT 8

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/* ӽ㶨 */
typedef struct CTNode {
    int child;              // úе
    struct CTNode* next;    // ָһ
} CTNode;

/* ָӽָ */
typedef CTNode* ChildPtr;

/* (˫)Ľ㶨 */
typedef struct {
    int parent;             // ˫λ
    TElemType data;         // ǰ
    ChildPtr firstchild;    // ͷָ
} CTBox;

/*
 * (˫)Ͷ
 *
 *ע
 * 1.нnodes""洢ûп϶
 * 2.rܳnodesλ
 * 3.⣬ΰ˳ŸУһ̲ͼʾܻ
 * 4.nodesѭʹõģһ̲δᵽ
 * 5.nodesռ㹻ģΪ̬洢
 */
typedef struct {
    CTBox nodes[MAX_TREE_SIZE]; // 洢н
    int r;  // λ()
    int n;  // Ľ
} CTree;


/*
 * ĳϢ
 *
 * ע˫ױ洢ṹҪټǰĵһе
 * */
typedef struct{
    int row;            // ǰ
    int col;            // ǰ
    int childIndex;     // ǰǵڼ
    int lastChild;      // ǰһе
} Pos;


/*
 * ʼ
 *
 * 
 */
Status InitTree(CTree* T);

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(CTree T);

/*
 * 
 *
 * ȣ
 */
int TreeDepth(CTree T);


/* ڲʹõĺ */

// ȡTĽϢЩϢPos͵Ķ
static void getPos(CTree T, Pos pt[]);


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(CTree T);

// ͼλǰṹڲʵ
static void Print(CTree T, Pos pt[], int i);

// ͼλнṹڲʹ
static void PrintFramework(CTree T);

#endif
