/*=============================
 * ĺ(˫)Ĵ洢ʾ
 =============================*/

#include "CTree.h"

/*
 * ʼ
 *
 * 
 */
Status InitTree(CTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    T->n = 0;
    
    // 
    memset(T->nodes, 0, sizeof(T->nodes));
    
    return OK;
}

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(CTree* T, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("ԪϢڿս㣬ʹ^...\n");
        Create(T, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        Create(T, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(CTree T) {
    return T.n == 0 ? TRUE : FALSE;
}

/*
 * 
 *
 * ȣ
 */
int TreeDepth(CTree T) {
    int k, level;
    
    // 
    if(TreeEmpty(T)) {
        return 0;
    }
    
    /*
     * kʼΪһλ
     * Ľ㰴洢洢Ľضλ
     */
    k = (T.r + T.n - 1) % MAX_TREE_SIZE;
    level = 0;
    
    do {
        level++;
        k = T.nodes[k].parent;
    } while(k != -1);
    
    return level;
}


/* ڲʹõĺ */

// ڲ
static void Create(CTree* T, FILE* fp) {
    int r;          // ĸλã
    int n;          // ¼Ԫ
    int cur;        // α
    TElemType ch;
    LinkQueue Q;
    QElemType e;    // Ԫָʾλ
    char s[MAX_CHILD_COUNT + 1];
    int i;
    ChildPtr p, pc;
    
    InitQueue(&Q);
    
    n = 0;
    
    // ȡλ
    if(fp == NULL) {
        printf("λ(0~%d)", MAX_TREE_SIZE - 1);
        scanf("%d", &r);
        cur = r;
        
        printf("ֵ");
        scanf("%s", s);
        ch = s[0];
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        T->nodes[cur].firstchild = NULL;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            DeQueue(&Q, &e);    // λó
            
            printf(" %c ĺӽ㣬ںʱһ^", T->nodes[e].data);
            scanf("%s", s);
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                T->nodes[cur].firstchild = NULL;
                
                // ĳ
                p = T->nodes[e].firstchild;
                
                // װǰ
                pc = (ChildPtr) malloc(sizeof(CTNode));
                pc->child = cur;
                pc->next = NULL;
                
                // ǰӵĺ
                if(p == NULL) {
                    T->nodes[e].firstchild = pc;
                } else {
                    // ҵβ
                    while(p->next != NULL) {
                        p = p->next;
                    }
                    
                    p->next = pc;
                }
                
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    } else {
        // ¼λ
        ReadData(fp, "%d", &r);
        cur = r;
        
        // ¼ֵ
        ReadData(fp, "%s", s);
        ch = s[0];
        printf("¼ֵ%c\n", ch);
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        T->nodes[cur].firstchild = NULL;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            ReadData(fp, "%s", s);
            ch = s[0];
            printf("¼ %c ĺӣ", ch);
            
            // ¼뺢ӽ
            ReadData(fp, "%s", s);
            printf("%s\n", s);
            
            DeQueue(&Q, &e);    // λó
            
            // 
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                T->nodes[cur].firstchild = NULL;
                
                // װǰ
                pc = (ChildPtr) malloc(sizeof(CTNode));
                pc->child = cur;
                pc->next = NULL;
                
                // ĳ
                p = T->nodes[e].firstchild;
                
                // ǰӵĺ
                if(p == NULL) {
                    T->nodes[e].firstchild = pc;
                } else {
                    // ҵβ
                    while(p->next != NULL) {
                        p = p->next;
                    }
                    
                    p->next = pc;
                }
                
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    }
    
    T->r = r;
    T->n = n;
}

// ȡTĽϢЩϢPos͵Ķ
static void getPos(CTree T, Pos pt[]) {
    LinkQueue Q;
    QElemType e;
    ChildPtr cp;
    
    int level, n, count;
    
    memset(pt, 0, MAX_TREE_SIZE * sizeof(Pos));
    
    // 
    if(TreeEmpty(T)) {
        return;
    }
    
    InitQueue(&Q);
    
    // λ
    EnQueue(&Q, T.r);
    pt[T.r].row = 1;
    pt[T.r].col = 1;
    pt[T.r].childIndex = 1;
    
    // ڵĲ
    level = 0;
    
    while(!QueueEmpty(Q)) {
        DeQueue(&Q, &e);
        
        // ˸ı
        if(pt[e].row != level) {
            count = 0;
            level = pt[e].row;
        }
        
        n = 0;  // eĺӼ0
        
        // ÿʱһϢΪЧΪÿ㶼кӽ
        pt[e].lastChild = -1;
        
        // ָýĺ
        cp = T.nodes[e].firstchild;
        
        // ͷŸý㴦ĺռڴ
        while(cp != NULL) {
            // ǰλ
            EnQueue(&Q, cp->child);
            
            // ¼
            pt[cp->child].row = pt[e].row + 1;
            
            // ¼
            pt[cp->child].col = ++count;
            
            // ¼ǰǵڼ
            pt[cp->child].childIndex = ++n;
            
            // ΪһӵϢ
            pt[e].lastChild = cp->child;
            
            cp = cp->next;
        }
    }
}


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(CTree T) {
    Pos pt[MAX_TREE_SIZE];
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return;
    }
    
    // TнλϢ
    getPos(T, pt);
    
    Print(T, pt, T.r);
    
    printf("\n");
    
    printf("洢ṹ\n");
    PrintFramework(T);
}

// ͼλǰṹڲʵ
static void Print(CTree T, Pos pt[], int i) {
    int firstChild = -1;    // ʼΪЧ
    int rightBrother;
    int k;
    
    // ʵǰ
    printf("%c ", T.nodes[i].data);
    
    // ˫ױ洢ṹӸ
    if(T.nodes[i].firstchild!=NULL) {
        firstChild = T.nodes[i].firstchild->child;
    }
    
    // ӣҪȷӵݣ
    if(firstChild != -1) {
        Print(T, pt, firstChild);
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(rightBrother != (T.r + T.n) % MAX_TREE_SIZE && T.nodes[i].parent == T.nodes[rightBrother].parent) {
        // ʵǰֵǰǰ㲻һӣһλ
        if(pt[T.nodes[i].parent].lastChild != i) {
            printf("\n");
            
            for(k = 0; k < pt[rightBrother].row - 1; k++) {
                printf(". ");
            }
        }
        
        Print(T, pt, rightBrother);
    }
}

// ͼλнṹڲʹ
static void PrintFramework(CTree T) {
    int k;
    ChildPtr cp;
    
    if(T.n == 0) {
        return;
    }
    
    printf("+---------+-----------\n");
    printf("|  i e  p | child list\n");
    printf("+---------+-----------\n");
    
    for(k = T.r; k != (T.r + T.n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        
        printf("| %2d %c %2d", k, T.nodes[k].data, T.nodes[k].parent);
        
        cp = T.nodes[k].firstchild;
        if(cp != NULL) {
            printf(" ->");
        } else {
            printf(" | ");
        }
        
        while(cp != NULL) {
            printf(" %2d", cp->child);
            cp = cp->next;
        }
        
        printf("\n");
    }
    
    printf("+---------+-----------\n");
}
