#include <stdio.h>
#include <stdlib.h>     // ṩmallocreallocfreeexitԭ
#include "Status.h"     //**01 **//
#include "BiTree.h"     //**06 Ͷ**//

#define MAX_TREE_DEPTH 20    // 
#define MAX_TREE_SIZE  1024  // Ԫֵ

/*
 * еkֵorder
 */
Status Algo_6_41(BiTree T, int k, int* order, TElemType* e);

/*
 * ҶӽĿ
 */
int Algo_6_42(BiTree T);

/*
 * 
 */
void Algo_6_43(BiTree T);

/*
 * 'x'
 */
int Algo_6_44(BiTree T, TElemType x);

/*
 * ɾTеx
 */
Status Algo_6_45(BiTree* T, TElemType x);

/*
 * ƶķǵݹ㷨
 */
void Algo_6_46(BiTree T, BiTree* Tx);

/*
 * 
 */
void Algo_6_47(BiTree T);

/*
 * Ĺͬ
 */
BiTree Algo_6_48(BiTree T, TElemType a, TElemType b);

/*
 * ж϶ǷΪȫ
 */
Status Algo_6_49(BiTree T);

/*
 * ѰҸ㵽p·path洢·ϸָ(pָ)
 */
static int FindPath(BiTree T, TElemType e, BiTree path[]);

// ָeָ
static BiTree EPtr(BiTree T, TElemType e);


int main(int argc, char* argv[]) {
    BiTree T;
    
    printf(" T ...\n");
    InitBiTree(&T);
    CreateBiTree(&T, "TestData.txt");
    PrintTree(T);
    printf("\n");
    
    printf(" 6.41 ֤...\n");
    {
        int k = 9;
        int order = 0;  // 
        TElemType e;
        
        if(Algo_6_41(T, k, &order, &e)) {
            printf("е %d ԪΪ %c \n", k, e);
        } else {
            printf("˴Ԫزڣ\n");
        }
        
        printf("\n");
    }
    
    printf(" 6.42 ֤...\n");
    {
        printf("ҶӽΪ%d\n", Algo_6_42(T));
        printf("\n");
    }
    
    printf(" 6.43 ֤...\n");
    {
        printf("Ϊ\n");
        Algo_6_43(T);
        PrintTree(T);
        printf("\n");
    }
    
    printf(" 6.44 ֤...\n");
    {
        char x = 'E';
        
        printf(" %c Ϊ %d\n", x, Algo_6_44(T, x));
        printf("\n");
    }
    
    printf(" 6.45 ֤...\n");
    {
        char x = 'D';
        
        printf("ɾ %c 󣬶Ϊ\n", x);
        if(Algo_6_45(&T, x)) {
            PrintTree(T);
        }
        printf("\n");
    }
    
    printf(" 6.46 ֤...\n");
    {
        BiTree Tx;
        
        printf(" T  Tx 󣬶TxΪ\n");
        Algo_6_46(T, &Tx);
        PrintTree(Tx);
        printf("\n");
    }
    
    printf(" 6.47 ֤...\n");
    {
        printf("Ϊ");
        Algo_6_47(T);
        printf("\n");
    }
    
    printf(" 6.48 ֤...\n");
    {
        BiTree Tmp = NULL;
        TElemType a = 'I';
        TElemType b = 'H';
        
        if((Tmp = Algo_6_48(T, a, b)) != NULL) {
            printf("'%c'  '%c' ͬΪ'%c'\n", a, b, Tmp->data);
        }
        printf("\n");
    }
    
    printf(" 6.49 ֤...\n");
    {
        if(Algo_6_49(T)) {
            printf("˶ȫ\n");
        } else {
            printf("˶ȫ!\n");
        }
    }
    
    return 0;
}


/*
 * еkֵorder
 */
Status Algo_6_41(BiTree T, int k, int* order, TElemType* e) {
    
    if(T == NULL) {
        *e = '\0';
        return ERROR;
    }
    
    (*order)++;
    
    if(*order == k) {
        *e = T->data;
        return OK;
    } else {
        if(Algo_6_41(T->lchild, k, order, e)) {
            return OK;
        }
        
        if(Algo_6_41(T->rchild, k, order, e)) {
            return OK;
        }
    }
    
    return ERROR;
}

/*
 * ҶӽĿ
 */
int Algo_6_42(BiTree T) {
    int count = 0;
    
    if(T != NULL) {
        if(T->lchild == NULL && T->rchild == NULL) {
            count++;
        } else {
            count += Algo_6_42(T->lchild);  // Ҷӽ
            count += Algo_6_42(T->rchild);  // Ҷӽ
        }
    }
    
    return count;
}

/*
 * 
 */
void Algo_6_43(BiTree T) {
    BiTree p;
    
    if(T != NULL) {
        p = T->lchild;
        T->lchild = T->rchild;
        T->rchild = p;
        
        // ݹ齻
        Algo_6_43(T->lchild);
        Algo_6_43(T->rchild);
    }
}

/*
 * T'x'
 */
int Algo_6_44(BiTree T, TElemType x) {
    BiTree p;
    
    p = EPtr(T, x);         // һݹxλãָʽ
    
    return BiTreeDepth(p);  // ڶݹx
}

/*
 * ɾTеx
 */
Status Algo_6_45(BiTree* T, TElemType x) {
    
    if(*T == NULL) {
        return ERROR;
    }
    
    // ҵ˸ý㣬ݹ
    if((*T)->data == x) {
        ClearBiTree(T);
        return OK;
        // ݹѰҸý
    } else {
        if(Algo_6_45(&((*T)->lchild), x)) {
            return OK;
        }
        
        if(Algo_6_45(&((*T)->rchild), x)) {
            return OK;
        }
        
        return ERROR;
    }
}

/*
 * ƶķǵݹ㷨
 */
void Algo_6_46(BiTree T, BiTree* Tx) {
    int front, rear;
    BiTree queue[MAX_TREE_SIZE] = {NULL};   // ָ飬ģУʼԪΪNULL
    BiTree tree[MAX_TREE_SIZE];     // ½Ķ
    BiTree p;
    int parent;
    
    if(T == NULL) {
        *Tx = NULL;
        return;
    }
    
    front = rear = 0;
    
    queue[rear] = T;
    
    while(front <= rear) {
        p = queue[front];
        
        if(p == NULL) {
            front++;
            continue;
        }
        
        // ½
        tree[front] = (BiTree) malloc(sizeof(BiTNode));
        tree[front]->data = p->data;
        tree[front]->lchild = tree[front]->rchild = NULL;
        
        // Ϊýҽڸ
        if(front > 0) {
            parent = (front - 1) / 2;
            
            // ǰΪ
            if(2 * parent + 1 == front) {
                tree[parent]->lchild = tree[front];
            } else {
                tree[parent]->rchild = tree[front];
            }
        }
        
        if(p->lchild != NULL) {
            rear = 2 * front + 1;
            queue[rear] = p->lchild;
        }
        
        if(p->rchild != NULL) {
            rear = 2 * front + 2;
            queue[rear] = p->rchild;
        }
        
        front++;
    }
    
    *Tx = tree[0];
}

/*
 * 
 */
void Algo_6_47(BiTree T) {
    int front, rear;
    BiTree queue[MAX_TREE_SIZE];  // ָ飬ģ
    BiTree p;
    
    if(T == NULL) {
        return;
    }
    
    front = rear = 0;
    
    queue[rear++] = T;
    
    while(front != rear) {
        p = queue[front++];
        
        printf("%c ", p->data);
        
        if(p->lchild != NULL) {
            queue[rear++] = p->lchild;
        }
        
        if(p->rchild != NULL) {
            queue[rear++] = p->rchild;
        }
    }
    
    printf("\n");
}

/*
 * Ĺͬ
 */
BiTree Algo_6_48(BiTree T, TElemType a, TElemType b) {
    BiTree pa[MAX_TREE_DEPTH] = {NULL};
    BiTree pb[MAX_TREE_DEPTH] = {NULL};
    int lenA, lenB;
    int i, j;
    
    // ·ѰҺ
    if((lenA = FindPath(T, a, pa)) != 0 && (lenB = FindPath(T, b, pb)) != 0) {
        for(i = lenA - 1; pa[i] != NULL; i--) {
            for(j = lenB - 1; pb[j] != NULL; j--) {
                if(pa[i]->data == pb[j]->data) {
                    return pa[i];
                }
            }
        }
    }
    
    return NULL;
}

/*
 * ж϶ǷΪȫ
 *
 * ȫصǲʱһ
 */
Status Algo_6_49(BiTree T) {
    int front, rear;
    BiTree queue[MAX_TREE_SIZE];     // ָ飬ģ
    int order[MAX_TREE_SIZE];
    BiTree p;
    int count;
    
    if(T == NULL) {
        return OK;
    }
    
    front = rear = 0;
    count = 1;
    
    queue[rear] = T;
    order[rear] = 1;
    rear++;
    
    // ͬʱΪ
    while(front < rear) {
        if(order[front] != count) {
            return ERROR;
        }
        
        p = queue[front];   // ȡͷԪ
        
        if(p->lchild != NULL) {
            queue[rear] = p->lchild;
            order[rear] = 2 * order[front];
            rear++;
        }
        
        if(p->rchild != NULL) {
            queue[rear] = p->rchild;
            order[rear] = 2 * order[front] + 1;
            rear++;
        }
        
        front++;
        count++;    // ÿһһ
    }
    
    return OK;
}

// ָeָ
static BiTree EPtr(BiTree T, TElemType e) {
    BiTree pl, pr;
    
    if(T == NULL) {
        return NULL;
    }
    
    // ҵĿ㣬ֱӷָ
    if(T->data == e) {
        return T;
    }
    
    // вe
    pl = EPtr(T->lchild, e);
    if(pl != NULL) {
        return pl;
    }
    
    // вe
    pr = EPtr(T->rchild, e);
    if(pr != NULL) {
        return pr;
    }
    
    return NULL;
}

// ѰҸ㵽p·path洢·ϸָ(pָ)
static int FindPath(BiTree T, TElemType e, BiTree path[]) {
    int i = -1;
    int mark[MAX_TREE_DEPTH] = {0}; // ʱջ
    BiTree p;
    
    p = T;
    
    while(TRUE) {
        // ûĽ㣬ȳ
        while(p != NULL && p->data != e) {
            i++;
            
            // µǰָ
            path[i] = p;
            
            // ѷʹý
            mark[i] = 1;
            p = p->lchild;
        }
        
        // Ľ
        if(p != NULL) {
            return i + 1;
        }
        
        // ص
        p = path[i];
        
        // ڣ߸ѱʹصĸ
        while(p->rchild == NULL || mark[i] == 2) {
            path[i] = NULL;     // ÿոλ
            
            i--;
            if(i == -1) {
                return 0;
            }
            
            // ˵
            p = path[i];
        }
        
        // ѷʹý
        mark[i] = 2;
        p = p->rchild;
    }
}
