/*===========================
 * չ洢ʾ
 ============================*/

#include "GList-E.h"            //**05 ͹**//

/*
 * ʼ
 *
 * ʼյĹΪ0Ϊ1
 *
 *ע
 * Ҫÿһſ
 */
Status InitGList(GList* L) {
    if(L == NULL) {
        return ERROR;
    }
    
    *L = (GList) malloc(sizeof(GLNode));
    if(!*L) {
        exit(OVERFLOW);
    }
    
    (*L)->tag = List;
    (*L)->Node.hp = NULL;
    (*L)->tp = NULL;
    
    return OK;
}

/*
 * 
 *
 * ַSL
 */
Status CreateGList(GList* L, SString S) {
    SString emp, hsub, sub, tmp;
    
    if(L == NULL) {
        return ERROR;
    }
    
    // ַSеĿհףɴӡַո
    ClearBlank(S);
    
    if(StrEmpty(S)) {
        return ERROR;
    }
    
    // Ϊ˲ƻS
    StrCopy(sub, S);
    
    /*
     * ִеʱ
     * ٴִеʱѾȥ
     */
    sever(hsub, sub);
    
    *L = (GList) malloc(sizeof(GLNode));
    if(*L == NULL) {
        exit(OVERFLOW);
    }
    
    StrAssign(emp, "()");
    
    if(!StrCompare(hsub, emp)) {
        (*L)->tag = List;
        (*L)->Node.hp = NULL;
    } else {
        if(StrLength(hsub) == 1) {
            (*L)->tag = Atom;
            (*L)->Node.atom = hsub[1];
        } else {
            (*L)->tag = List;
            
            SubString(tmp, hsub, 2, StrLength(hsub) - 2);
            
            CreateGList(&((*L)->Node.hp), tmp);
        }
    }
    
    // ڶβ˳ݹ
    if(StrEmpty(sub)) {
        (*L)->tp = NULL;
    } else {
        // ݹβ
        CreateGList(&((*L)->tp), sub);
    }
    
    return OK;
}

/*
 * 
 *
 * ͷŹռڴ档
 */
Status DestroyGList(GList* L) {
    GList head, tail;
    
    if(L == NULL || *L == NULL) {
        return ERROR;
    }
    
    // ӱ
    if((*L)->tag == List) {
        head = (*L)->Node.hp;  // ͷ
        tail = (*L)->tp;       // β
        
        free(*L);
        *L = NULL;
        
        // ݹ鴦ͷ
        if(head != NULL) {
            DestroyGList(&head);
        }
        
        // ݹ鴦β
        if(tail != NULL) {
            DestroyGList(&tail);
        }
        
        // ԭӽ
    } else {
        tail = (*L)->tp;    // β
        
        free(*L);
        *L = NULL;
        
        if(tail != NULL) {
            DestroyGList(&tail);
        }
    }
    
    return OK;
}

/*
 * 
 *
 * ɹLƵõT
 */
Status CopyGList(GList* T, GList L) {
    
    if(L == NULL) {
        return ERROR;
    }
    
    *T = (GList) malloc(sizeof(GLNode));
    if(*T == NULL) {
        exit(OVERFLOW);
    }
    
    // ԭ
    if(L->tag == Atom) {
        (*T)->tag = Atom;
        (*T)->Node.atom = L->Node.atom;
        
        // ӱ
    } else {
        (*T)->tag = List;
        
        // Ʊͷ
        if(L->Node.hp != NULL) {
            CopyGList(&((*T)->Node.hp), L->Node.hp);
        } else {
            (*T)->Node.hp = NULL;
        }
    }
    
    // Ʊβ
    if(L->tp != NULL) {
        CopyGList(&((*T)->tp), L->tp);
    } else {
        (*T)->tp = NULL;
    }
    
    return OK;
}

/*
 * 
 *
 * عĳȡ
 */
int GListLength(GList L) {
    int count = 0;
    GList p;
    
    // 
    if(L == NULL) {
        return -1;
    }
    
    p = L->Node.hp;
    
    while(p != NULL) {
        ++count;
        p = p->tp;
    }
    
    return count;
}

/*
 * 
 *
 * ع
 */
int GListDepth(GList L) {
    int max, deep;
    GList p;
    
    max = 0;
    
    // 
    if(L == NULL) {
        return -1;
    }
    
    // ձΪ1
    if(L->tag == List && !L->Node.hp) {
        return 1;
    }
    
    // ԭΪ0
    if(L->tag == Atom) {
        return 0;
    }
    
    // ݹӱ
    for(p = L->Node.hp; p != NULL; p = p->tp) {
        // pΪͷָӱ
        deep = GListDepth(p);
        if(deep > max) {
            max = deep;
        }
    }
    
    return max + 1;
}

/*
 * п
 *
 * жϹǷΪա
 */
Status GListEmpty(GList L) {
    // 
    if(L == NULL) {
        return ERROR;
    }
    
    if(L->tag == List && L->Node.hp == NULL && L->tp == NULL) {
        return TRUE;
    } else {
        return ERROR;
    }
}

/*
 * ͷ
 */
GList GetHead(GList L) {
    GList p, q;
    
    // ڻΪձ޷ȡͷ
    if(L == NULL || L->Node.hp == NULL) {
        return NULL;
    }
    
    q = L->Node.hp->tp;         // ʱLıβϢ
    L->Node.hp->tp = NULL;      // ȥLıβ
    
    CopyGList(&p, L->Node.hp);  // ƱͷϢαβ
    
    L->Node.hp->tp = q;         // ָLıβϢ
    
    return p;
}

/*
 * β
 */
GList GetTail(GList L) {
    GList p, q;
    
    // ڻΪձ޷ȡβ
    if(L == NULL || L->Node.hp == NULL) {
        return NULL;
    }
    
    q = L->Node.hp;         // ʱLıͷϢ
    L->Node.hp = q->tp;     // ժLıͷ
    
    CopyGList(&p, L);       // ƱβϢαͷ
    
    q->tp = L->Node.hp;     // ָLıͷϢ
    L->Node.hp = q;
    
    return p;
}

/*
 * 
 *
 * ԪeΪLĵһԪء
 */
Status InsertFirst(GList* L, GList e) {
    
    // 
    if(L == NULL || *L == NULL) {
        return ERROR;
    }
    
    if(e == NULL) {
        return ERROR;
    }
    
    e->tp = (*L)->Node.hp;
    (*L)->Node.hp = e;
    
    return OK;
}

/*
 * ɾ
 *
 * LĵһԪɾeء
 */
Status DeleteFirst(GList* L, GList* e) {
    GList p;
    
    // ڻΪձ޷ɾͷ
    if(*L == NULL || (*L)->Node.hp == NULL) {
        return ERROR;
    }
    
    p = (*L)->Node.hp;
    (*L)->Node.hp = p->tp;
    p->tp = NULL;
    
    *e = p;
    
    return OK;
}

/*
 * 
 *
 * visitʹL
 */
void Traverse(GList L, void(Visit)(AtomType)) {
    if(L == NULL) {
        return;
    }
    
    if(L->tag == List) {
        Traverse(L->Node.hp, Visit);
    } else {
        Visit(L->Node.atom);
    }
    
    Traverse(L->tp, Visit);
}

/*
 * ͼλ
 *
 * L
 */
void PrintGList(GList L) {
    Print(L);
    printf("\n");
}

/*
 * ͼλڲʵ֡
 */
static void Print(GList L) {
    if(L == NULL) {
        return;
    }
    
    // 
    if(L->tag == List) {
        printf("(");
        
        if(L->Node.hp) {
            Print(L->Node.hp);
        }
        
        if(L->tp) {
            printf("),");
            Print(L->tp);
        } else {
            printf(")");
        }
        
        // ԭӽ
    } else {
        printf("%c", L->Node.atom);
        if(L->tp) {
            printf(",");
            Print(L->tp);
        }
    }
}

/*
 * ǿմstrָ֣hsubΪһ','֮ǰӴstrΪһ','֮Ӵ
 *
 *ע
 * 1.ַstrȷ޿հ׷ţ
 *   strſȥҲδȥ
 * 2.ɺstrҲᷢ仯
 */
static void sever(SString hstr, SString str) {
    int i, k, n;
    SString ch;
    
    n = StrLength(str);
    
    i = 0;  // ַʱα
    k = 0;  // δ
    
    do {
        ++i;
        
        // ȡstrһַ
        SubString(ch, str, i, 1);
        
        if(ch[1] == '(') {
            ++k;
        }
        if(ch[1] == ')') {
            --k;
        }
    } while(i < n && (ch[1] != ',' || k != 0));
    
    if(i < n) {
        SubString(hstr, str, 1, i - 1);
        SubString(str, str, i + 1, n - i);
    } else {
        StrCopy(hstr, str);
        ClearString(str);
    }
}
