/*========
 * ά
 =========*/

#include "Array.h"  //**05 ͹**//

/*
 * ʼ
 *
 * ʼάΪdim飬ɱָʾάȵĴС
 */
Status InitArray(Array* A, int dim, ...) {
    int elemtotal;  // ͳԪظ
    va_list ap;     // apſɱϢָʾάȵĴС
    int i;
    
    if(A == NULL) {
        return ERROR;
    }
    
    if(dim < 1 || dim > MAX_ARRAY_DIM) {    // ά
        return ERROR;
    }
    
    (*A).dim = dim;     // ʼά
    
    // ʼάϢ
    (*A).bounds = (int*) malloc(dim * sizeof(int));
    if((*A).bounds == NULL) {
        exit(OVERFLOW);
    }
    
    // άȳȺϷboundsAԪelemtotal
    elemtotal = 1;
    
    // ʹapָһɱdim൱ʼʶ
    va_start(ap, dim);
    
    for(i = 0; i < dim; i++) {
        // ¼ǰάȵĿ
        (*A).bounds[i] = va_arg(ap, int);
        if((*A).bounds[i] <= 0) {
            return ERROR;
        }
        
        elemtotal *= A->bounds[i];
    }
    
    // ÿap
    va_end(ap);
    
    // ʼռ䣬ԴԪ
    (*A).base = (ElemType*) malloc(elemtotal * sizeof(ElemType));
    if((*A).base == NULL) {
        exit(OVERFLOW);
    }
    
    // ʼӳϢ
    (*A).constants = (int*) malloc(dim * sizeof(int));
    if((*A).constants == NULL) {
        exit(OVERFLOW);
    }
    
    // һάȣÿҪԽһԪ
    (*A).constants[dim - 1] = 1;
    for(i = dim - 2; i >= 0; i--) {
        (*A).constants[i] = (*A).bounds[i + 1] * (*A).constants[i + 1];
    }
    
    /*
     * 
     * ά[2,3,4]˵boundsֵΪ<2,3,4>constantsֵΪ<12,4,1>
     * boundsһάа2Ԫأڶάа3Ԫأάа4Ԫ
     * constantsһάÿҪ12ԪأڶάÿҪԽ4ԪأάÿҪԽ1Ԫ
     */
    
    return OK;
}

/*
 * (ṹ)
 *
 * ռõĿռ䡣
 */
Status DestroyArray(Array* A) {
    if(A == NULL || (*A).base == NULL || (*A).bounds == NULL || (*A).constants == NULL) {
        return ERROR;
    }
    
    free((*A).base);
    (*A).base = NULL;
    
    free((*A).bounds);
    (*A).bounds = NULL;
    
    free((*A).constants);
    (*A).constants = NULL;
    
    (*A).dim = 0;
    
    return OK;
}

/*
 * ȡֵ
 *
 * ȡָ±괦ԪֵɱΪdim±ֵָʾȡԪ±ꡣ
 */
Status Value(Array A, ElemType* e, ...) {
    va_list ap;
    Status result;
    int off;
    
    va_start(ap, e);
    
    // ԪصĿԪҪԽԪ
    result = Locate(A, ap, &off);
    
    va_end(ap);
    
    if(result == OVERFLOW) {
        return result;
    }
    
    *e = *(A.base + off);
    
    return OK;
}

/*
 * ֵ
 *
 * Ϊָ±괦ԪظֵɱΪdim±ֵָʾֵԪ±ꡣ
 */
Status Assign(Array* A, ElemType e, ...) {
    va_list ap;
    Status result;
    int off;
    
    va_start(ap, e);
    
    // ԪصĿԪҪԽԪ
    result = Locate(*A, ap, &off);
    
    va_end(ap);
    
    if(result == OVERFLOW) {
        return result;
    }
    
    *(A->base + off) = e;
    
    return OK;
}

/*
 * apָʾֵAеλã
 * ԪصĿԪҪԽԪ
 */
static Status Locate(Array A, va_list ap, int* off) {
    int i, ind;
    
    *off = 0;
    
    for(i = 0; i < A.dim; i++) {
        ind = va_arg(ap, int);
        
        // ֤±겻Խ
        if(ind < 0 || ind >= A.bounds[i]) {
            return OVERFLOW;
        }
        
        // ĳάȵĵλԪظ*Ҫĵλ
        *off += A.constants[i] * ind;
    }
    
    return OK;
}
