#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Status.h"             //**01 **//

/*
 * ԪͶ
 *
 *ע
 * ȻַԪȻintԭǣ
 * 1.Ҫͷ洢intֱchar
 * 2.charintݣԽȻintҲ洢char
 */
typedef int ElemType;

/* ַ */
typedef struct SNode {
    ElemType chdata;        // ݽ
    struct SNode* succ;  // ָ̽
    struct SNode* next;  // nextУָǰ㣬ģʽУָý㴦ʧʱӦȽϵһ
} SNode;

// ַ
typedef SNode* String;


// ʼ
Status StrAssign_4_28(String* S, char* chars);

// 󴮳
int StrLength_4_28(String S);

// ַ
void StrPrint_4_28(String S);

/*
 * ģʽnextֵĽ㷨
 *
 * ൱KMP㷨µget_nextval
 */
Status Algo_4_28(String T);

/*
 * KMP㷨
 *
 * ൱KMP㷨µIndex_KMP
 */
int Algo_4_29(String S, String T, int pos);


int main(int argc, char* argv[]) {
    char* s = "abaaabaababaabcaabaabcacabaabcaabaabcac";
    char* t = "abaabcac";
    String S, T;
    int pos, i;
    
    StrAssign_4_28(&S, s);  //
    StrAssign_4_28(&T, t);  //ģʽ
    
    printf("S = ");
    StrPrint_4_28(S);
    printf("ģʽT = ");
    StrPrint_4_28(T);
    
    printf(" 4.28 ֤...\n");
    Algo_4_28(T);
    printf("next...\n");
    
    printf(" 4.29 ֤...\n");
    pos = 18;
    i = Algo_4_29(S, T, pos);
    printf("ģʽ T  S ĵ %d ַһƥɹλΪ %d\n", pos, i);
    
    return 0;
}


// ʼ
Status StrAssign_4_28(String* S, char* chars) {
    int i, len;
    String p;
    
    if(S == NULL || chars == NULL) {
        return ERROR;
    }
    
    len = (int) strlen(chars);
    
    // ͷ
    *S = (String) malloc(sizeof(SNode));
    (*S)->chdata = len; // ¼ĳ
    (*S)->next = NULL;  // ͷǰ
    
    p = *S;
    
    for(i = 0; i < len; i++) {
        p->succ = (String) malloc(sizeof(SNode));
        p->succ->chdata = chars[i];
        p->succ->next = p;          // nextĬָǰһ
        p = p->succ;
    }
    
    // һĺΪNULL
    p->succ = NULL;
    
    return OK;
}

// 󴮳
int StrLength_4_28(String S) {
    return S == NULL ? 0 : S->chdata;
}

// ַ
void StrPrint_4_28(String S) {
    String p;
    
    if(S == NULL) {
        printf("\n");
        return;
    }
    
    for(p = S->succ; p != NULL; p = p->succ) {
        printf("%c", p->chdata);
    }
    
    printf("\n");
}

/*
 * ģʽnextֵĽ㷨
 *
 * ൱KMP㷨µget_nextval
 */
Status Algo_4_28(String T) {
    SNode* i, * j;
    
    if(StrLength_4_28(T) == 0) {
        return ERROR;
    }
    
    i = T->succ;    // ൱֮ǰi=1
    j = T;          // ൱֮ǰj=0
    
    // ģʽһַʧʱģʽҪͷȽϣҪǰһλñȽ
    i->next = T;
    
    // ģʽϵַ
    while(i->succ != NULL) {
        if(j == T || i->chdata == j->chdata) {
            i = i->succ;
            j = j->succ;
            
            if(i->chdata != j->chdata) {
                i->next = j;
            } else {
                i->next = j->next;
            }
        } else {
            j = j->next;
        }
    }
    
    return OK;
}

/*
 * KMP㷨
 *
 * ൱KMP㷨µIndex_KMP
 */
int Algo_4_29(String S, String T, int pos) {
    int count;        // ¼iλ
    SNode* i, * j;    // iSjT
    
    if(pos < 1 || StrLength_4_28(S) == 0 || StrLength_4_28(T) == 0) {
        return 0;
    }
    
    for(count = 1, i = S->succ; count < pos; count++, i = i->succ) {
        // iָpos
    }
    
    j = T->succ;
    
    // Ƚַ
    while(i != NULL && j != NULL) {
        /*
         * Σ
         * 1.ģʽĵһַʧ
         * 2.ģʽַ
         */
        if(j == T || i->chdata == j->chdata) {
            i = i->succ;
            j = j->succ;
            
            count++;        // ¼iλ
        } else {
            // ʧʱصǰһʵλ
            j = j->next;
        }
    }
    
    // ƥɹƥλ
    if(j == NULL) {
        return count-StrLength_4_28(T);
    } else {
        // ƥʧ
        return 0;
    }
}
