#include <stdio.h>
#include <stdlib.h>     // ṩmallocreallocfreeexitԭ
#include "Status.h"     //**01 **//
#include "SqList.h"     //**02 Ա**//

/* 궨 */
#define MAXQSIZE 5      // гȣͬʱҲǺ쳲еά
#define MAX 100000

/* Ԫ */
typedef int QElemType;

/* ˳ѭ */
typedef struct {
    QElemType* base;    // ָд洢ռ
    int rear;           // βα
    int length;         // Ԫظ
} SqQueue;

// гʼ
Status InitQueue_3_30(SqQueue* Q);

// 
Status EnQueue_3_30(SqQueue* Q, QElemType e);

// 
Status DeQueue_3_30(SqQueue* Q, QElemType* e);

/*
 * k쳲ضǰn+1
 */
Status Algo_3_32(int k, SqList* fib);


// Ԫ
void Output(SqQueue Q) {
    int head;
    
    if(Q.length == 0) {
        printf("\n");
        return;
    }
    
    // ͷα
    head = (Q.rear - Q.length + MAXQSIZE) % MAXQSIZE;
    
    do {
        printf("%d ", Q.base[head]);
        head = (head + 1) % MAXQSIZE;
    } while(head != Q.rear);
    
    printf("\n");
}


int main(int argc, char* argv[]) {
    int i;
    
    printf("  3.30 ֤...\n");
    {
        SqQueue Q;
        QElemType e;
        printf(" ʼ...\n");
        InitQueue_3_30(&Q);\

        printf("  5 Ӳ...\n");
        for(i = 1; i <= 5; i++) {
            EnQueue_3_30(&Q, i);
            printf(" Ԫ \"%d\" Ӻ󣬶еԪΪ", i);
            Output(Q);
        }
        
        printf("  5 Ӳ...\n");
        for(i = 1; i <= 5; i++) {
            DeQueue_3_30(&Q, &e);
            printf(" Ԫ \"%d\" Ӻ󣬶еԪΪ", e);
            Output(Q);
        }
    }
    
    printf("  3.32 ֤...\n");
    {
        SqList fib;
        
        Algo_3_32(MAXQSIZE, &fib);
        printf(" %d 쳲еǰ %d Ϊ\n", MAXQSIZE, fib.length);
        for(i = 0; i < fib.length; i++) {
            printf("%d ", fib.elem[i]);
        }
        printf("\n");
    }
    
    return 0;
}


// гʼ
Status InitQueue_3_30(SqQueue* Q) {
    if(Q == NULL) {
        return ERROR;
    }
    
    (*Q).base = (QElemType*) malloc(MAXQSIZE * sizeof(QElemType));
    if((*Q).base == NULL) {
        exit(OVERFLOW);
    }
    
    (*Q).rear = 0;
    (*Q).length = 0;
    
    return OK;
}

// 
Status EnQueue_3_30(SqQueue* Q, QElemType e) {
    
    if(Q == NULL) {
        return ERROR;
    }
    
    // ע
    if((*Q).length == MAXQSIZE) {
        return ERROR;
    }
    
    (*Q).base[(*Q).rear] = e;
    (*Q).rear = ((*Q).rear + 1) % MAXQSIZE;
    
    (*Q).length++;
    
    return OK;
}

// 
Status DeQueue_3_30(SqQueue* Q, QElemType* e) {
    int head;
    
    if(Q == NULL) {
        return ERROR;
    }
    
    // п
    if((*Q).length == 0) {
        return ERROR;
    }
    
    // ͷα
    head = ((*Q).rear - (*Q).length + MAXQSIZE) % MAXQSIZE;
    
    *e = (*Q).base[head];
    
    (*Q).length--;
    
    return OK;
}

/*
 * k쳲ضǰn+1
 *
 *ע
 * ˸оЩǣǿ
 * ΪȻҪǰn+1ֻk˵Ǹǰn+1ضҪ浽ĵط
 * ǣȻǰn+1ûҪõѭеĺkˣ...
 * Ϊġڡn+1ֵôѭӦüֵ
 */
Status Algo_3_32(int k, SqList* fib) {
    int flag;
    int i, j, sum;
    SqQueue Q;
    ElemType e;
    
    if(k < 2 || MAX < 0) {
        return ERROR;
    }
    
    InitQueue_3_30(&Q);
    InitList(fib);
    
    // ǰk-1Ϊ0
    for(i = 1; i <= k - 1; i++) {
        EnQueue_3_30(&Q, 0);
        ListInsert(fib, i, 0);
    }
    
    // kΪ1
    EnQueue_3_30(&Q, 1);
    ListInsert(fib, i, 1);
    
    while((flag = GetElem(*fib, i, &e))==OK && e<=MAX){
        /*
         * ѭԪصĺ
         * ʵһԸΪ˳кkĺͣһûѭɶ
         */
        for(j = 0, sum = 0; j < Q.length; j++) {
            sum += Q.base[j];
        }
        
        // ˴eֻʱ
        DeQueue_3_30(&Q, &e);
        
        // ¼Ԫ
        EnQueue_3_30(&Q, sum);
        
        // ˳˳лһ
        ListInsert(fib, ++i, sum);
    }
    
    return flag;
}
