/*==================
 * С
 *
 * 㷨: 7.9
 ==================*/

#include "MinimumSpanningTree.h"


/*
 * ķ㷨õĸ飬
 * ¼ӶӼUӼV-UĴСı
 */
static struct {
    VertexType adjvex;      // ӼUеĶ
    VRType lowcost;         // ӼV-UǰıߵȨֵ
} closedge[MAX_VERTEX_NUM]; // 


/*
 *  㷨7.9 
 *
 * ķ㷨
 *
 * ӵuGСTTĸߡ
 * 㷨ĺʱǶԶıеı޹أΪڱ߱Ƚϳܵ
 *
 * עԤͼȨֵ0
 */
void MinSpanTree_PRIM(MGraph G, VertexType u) {
    int i, j, k;
    
    // ضuеλ
    k = LocateVex(G, u);
    
    // ʼu˶ӼU
    for(j = 0; j < G.vexnum; j++) {
        if(j != k) {
            closedge[j].adjvex = u;
            closedge[j].lowcost = G.arcs[k][j].adj;
        }
    }
    
    // ֵΪ0ζŶkѽ붥ӼU
    closedge[k].lowcost = 0;
    
    // ѡG.vexnum-1
    for(i = 1; i < G.vexnum; i++) {
        // ӶӼV-UѡһѡԱ뵽С
        k = minimum(G);
        
        // ӡͱߵϢ
        printf("%c --%d-- %c\n", closedge[k].adjvex, closedge[k].lowcost, G.vexs[k]);
        
        // k뵽ӼU
        closedge[k].lowcost = 0;
        
        // ¶붥ӼUҪ¶ӼU붥ӼV-UıߵϢ
        for(j = 0; j < G.vexnum; j++) {
            if(G.arcs[k][j].adj < closedge[j].lowcost) {
                closedge[j].adjvex = G.vexs[k];
                closedge[j].lowcost = G.arcs[k][j].adj;
            }
        }
    }
}

/*
 * ӶӼV-UѡһѡԱ뵽С
 *
 * ѡ񶥵ӼUӼV-UȨֵСıߣ
 * ظñڶӼV-UͷĶ˵㣬
 * ö˵뵽ӼUУΪС½㡣
 *
 * עβ̲иģͬ
 */
static int minimum(MGraph G) {
    int i, k = -1;
    int min = INT_MAX;
    
    // ȨֵΪ0ıѡӵСȨֵı
    for(i = 0; i < G.vexnum; i++) {
        if(closedge[i].lowcost != 0 && closedge[i].lowcost < min) {
            min = closedge[i].lowcost;
            k = i;
        }
    }
    
    return k;
}

/*
 * ³˹㷨
 *
 * ӵuGСTTĸ
 * 㷨ĺʱǶԱߵıеĶ޹أΪڱ߱Ƚϡ
 *
 * ԸĽ֮бʱԲõ9½ܵĶ
 */
void MinSpanTree_KRUSKAL(MGraph G) {
    int i, j, k;
    int s1, s2;
    
    // ߼
    struct Edge {
        int v1;         // 1±
        int v2;         // 2±
        VRType adj;     // Ȩֵ
    } * edges, tmp;
    
    // ¼Ѿ뵽СĶ㼯ʹüϵĿǿжϺѡǷɻ·
    MFSet S;
    Relation relation;
    
    // ߼Ǳߵ
    edges = (struct Edge*)malloc(G.arcnum* sizeof(struct Edge));
    
    // Ա߼
    k = 0;
    
    // ȡеı
    for(i = 0; i < G.vexnum; i++) {
        // ģֻһı߾Ϳ
        for(j = 0; j <= i; j++) {
            // ֻЧı߽ͳ
            if(G.arcs[i][j].adj != INFINITE) {
                edges[k].v1 = i;
                edges[k].v2 = j;
                edges[k].adj = G.arcs[i][j].adj;
                k++;
            }
        }
    }
    
    // ȨֵСԱֻ߽ǼʹЧʽϵ͵ð
    for(i = 0; i < G.arcnum - 1; i++) {
        for(j = 0; j < G.arcnum - i - 1; j++) {
            // ÿֱȨֵŲ
            if(edges[j].adj > edges[j + 1].adj) {
                tmp = edges[j];
                edges[j] = edges[j + 1];
                edges[j + 1] = tmp;
            }
        }
    }
    
    // ʼ㼯
    initial_mfset(&S, G.vexnum);
    
    // ӱ߼ѡȨֵСҲɻ·ı߼뵽С
    for(i = 0; i < G.arcnum; i++) {
        s1 = find_mfset(S, edges[i].v1);
        s2 = find_mfset(S, edges[i].v2);

        // ˵λͬһϣ
        if(s1 == s2) {
            continue;
        }
        
        // Ԫϵ
        relation.n = 1;
        relation.pairs[0].i = edges[i].v1;
        relation.pairs[0].j = edges[i].v2;
        
        build_mfset(&S, relation);
        
        // ӡͱߵϢ
        printf("%c --%d-- %c\n", GetVex(G, edges[i].v1), edges[i].adj, GetVex(G, edges[i].v2));
    }
}
