/*==================
 * ͼ
 *
 * 㷨: 7.77.8
 ===================*/

#include "SpanningTree.h"


// ʱ־飬¼ʹĶ
static Boolean visited[MAX_VERTEX_NUM];


/*
 *  㷨7.7 
 *
 * ͼ(ɭ)
 */
void DFSForest(MGraph G, CSTree* T) {
    int v;
    CSTree p, q;
    
    InitTree(T);
    
    for(v = 0; v < G.vexnum; v++) {
        visited[v] = FALSE;
    }
    
    for(v = 0; v < G.vexnum; v++) {
        // ѷʹĶ
        if(visited[v]) {
            continue;
        }
        
        p = (CSTree) malloc(sizeof(CSNode));    // 
        if(!p) {
            exit(OVERFLOW);
        }
        p->data = GetVex(G, v);
        p->firstchild = p->nextsibling = NULL;
    
        if(!(*T)) {                            // ǵһĸ
            *T = p;
        } else {                               // ĸǰһֵܣ
            q->nextsibling = p;
        }
    
        q = p;                                 // qָʾǰĸ
        
        DFSTree(G, v, &p);                     // pΪ
    }
}

/*
 *  㷨7.8 
 *
 * ͨȱ㣬vʼ
 */
void DFSTree(MGraph G, int v, CSTree* T) {
    Status first;
    int w;
    CSTree p, q;
    
    visited[v] = TRUE;
    first = TRUE;
    
    // forѭҳvк
    for(w = FirstAdjVex(G, G.vexs[v]); w>=0; w = NextAdjVex(G, G.vexs[v], G.vexs[w])) {
        // ѷʹĶ
        if(visited[w]) {
            continue;
        }
    
        // 캢ӽ
        p = (CSTree) malloc(sizeof(CSNode));
        if(!p) {
            exit(OVERFLOW);
        }
        p->data = GetVex(G, w);
        p->firstchild = p->nextsibling = NULL;
        
        // ǵһ
        if(first) {
            (*T)->firstchild = p;
            first = FALSE;
            
            // ǵһӣΪֵܽ
        } else {
            q->nextsibling = p;
        }
        
        q = p;
        
        DFSTree(G, w, &q);
    }
}
