/*=================================
 * ͼ(ڽӾ)洢ʾ
 *
 * 㷨: 7.17.27.47.57.6
 ==================================*/

#ifndef MGRAPH_H
#define MGRAPH_H

#include <stdio.h>
#include <limits.h>     // ṩINT_MAX
#include <string.h>     // ṩmemsetstrcmp ԭ
#include <stdarg.h>     // ṩva_listva_startva_argva_end
#include "Status.h"     //**01 **//
#include "LinkQueue.h"  //**03 ջͶ**//

/*
 * ע
 *
 * ͨȨͼΪͼȨͼΪ
 * ͼ/еĶϵΪߡͼ/еĶϵΪֻͷ뻡β
 * ʵʱУδػϸ
 */

/* 궨 */
#define INFINITE INT_MAX    // ֵʾе㲻ֱ
#define MAX_VERTEX_NUM 26   // 󶥵


// ͼ
typedef enum {
    DG,     // 0-ͼ
    DN,     // 1-(Ȩֵ)
    UDG,    // 2-ͼ
    UDN     // 3-(Ȩֵ)
} GraphKind;

// 
typedef char VertexType;

/*
 * ϵ
 *
 * ȨͼУֵͨΪ01ʾǷֱͨ
 * ȨͼУֵͨΪȨֵ
 */
typedef int VRType;

// ߵظϢ
typedef struct {
    // еĻӦ
    void* v; // һıռλṹΪյĻVC++лᱨ
} InfoType;

// ߵͣÿϿиϢinfo
typedef struct ArcCell {
    VRType adj;  // ϵȨͼȨͼеĺ岻ͬ
    InfoType* info; // ߵĸϢͨ
} ArcCell;

/* ͼ/(ڽӾ)洢ʾͶ */
typedef struct {
    VertexType vexs[MAX_VERTEX_NUM];               // 
    ArcCell arcs[MAX_VERTEX_NUM][MAX_VERTEX_NUM];  // ڽӾ
    int vexnum, arcnum;                            // ͼ/Ķͻ
    GraphKind kind;                                // ͼͱ־
} MGraph;


// /ǷڸϢ
extern Boolean IncInfo;


/*
 *  㷨7.1 
 *
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(MGraph* G, char* path[]);

/*
 * ͼ
 */
static Status CreateDG(MGraph* G);

/*
 * 
 */
static Status CreateDN(MGraph* G);

/*
 * ͼ
 */
static Status CreateUDG(MGraph* G);

/*
 *  㷨7.2 
 *
 * 
 */
static Status CreateUDN(MGraph* G);

/*
 * ¼ߵظϢ
 */
static void Input(MGraph G, InfoType** info);

/*
 * 
 *
 * ڽӾ洢ͼͷڴ棬ֻرɡ
 */
Status DestroyGraph(MGraph* G);

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(MGraph G, VertexType u);

/*
 * ȡֵ
 *
 * vĶֵ
 */
VertexType GetVex(MGraph G, int v);

/*
 * ֵ
 *
 * vֵΪvalue
 */
Status PutVex(MGraph* G, VertexType v, VertexType value);

/*
 * ׸ڽӵ
 *
 * ضv׸ڽӵ
 */
int FirstAdjVex(MGraph G, VertexType v);

/*
 * һڽӵ
 *
 * ضv(w)һڽӵ
 */
int NextAdjVex(MGraph G, VertexType v, VertexType w);

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex(MGraph* G, VertexType v);

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex(MGraph* G, VertexType v);

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 *
 * ͼ˵ڿɱг/ĸϢ
 * ˵ڿɱг/ȨֵԼϢ
 */
Status InsertArc(MGraph* G, VertexType v, VertexType w, ...);

/*
 * ɾ/<v, w>
 *
 * ɾֻǸ±/ͨϵ
 */
Status DeleteArc(MGraph* G, VertexType v, VertexType w);

/*
 *  㷨7.4 
 *
 * ȱ(˴ݹʵ)
 */
void DFSTraverse(MGraph G, Status(Visit)(VertexType));

/*
 *  㷨7.5 
 *
 * ȱĺ
 */
static void DFS(MGraph G, int v);

/*
 *  㷨7.6 
 *
 * ȱ(˴ʵ)
 */
void BFSTraverse(MGraph G, Status(Visit)(VertexType));

/*
 * ͼλʽǰṹ
 *
 * עͼ/Уʹ"-"ʾ㲻ֱͨ
 */
void PrintGraph(MGraph G);

#endif
