/*==============================
 * 
 *
 * 㷨: 6.86.96.106.11
 ===============================*/

#ifndef MFSET_H
#define MFSET_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include <math.h>       //
#include "Status.h"     //**01 **//

/* ָʾӼ */
#define MAX_TREE_SIZE 1024

/* Ԫϵ */
#define MAX_PAIR_SIZE 100

/*
 * (˫)Ľ㶨
 *
 *ע
 * 1.ս̲ĵͼʾ˫ڼϵӦУģѱ򻯣˫׽㲻ٱ
 * 2.ʾһӼΪӼһԪشڡ
 * 3.ȷĳӼSĸӼʱҪ׷ݵӼĸ
 * 4.ʵʹУÿӼܶԪأʱԽÿԪӼϵ
 *   ÿԪ뼯Sи
 */
typedef struct PTNode {
    int parent;         // ˫λָʾýӼ
} PTNode;

/*
 * (˫)Ͷ
 *
 *ע
 * 1.нnodes""洢ûп϶
 * 2.ӼʱrΪ1rΪ0
 * 3.⣬ΰ˳Ÿ
 * 5.nodesռ㹻ģΪ̬洢
 */
typedef struct {
    PTNode nodes[MAX_TREE_SIZE];    // 洢н
    int r;  // λ()ָʾһӼ
    int n;  // Ľָʾ
} PTree;

/* Ͷ */
typedef PTree MFSet;

/* Ԫϵ */
typedef struct {
    int i;
    int j;
} Pair;

/* ڵĵȼ۹ϵ */
typedef struct {
    Pair pairs[MAX_PAIR_SIZE];  // 㹻Ŀռ洢Ԫϵ
    int n;                      // ֪ĵȼ۹ϵ
} Relation;


/*
 * ʼһɶӼÿӼֻԱɵļS
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status initial_mfset(MFSet* S, char* path);

/*
 * ʼϵĶԪȼ۹ϵ
 */
Status initial_relation(Relation* R, char* path);

/*
 *  㷨6.9 
 *
 * ཻӼSiӼSjĲ
 */
Status merge_mfset(MFSet* S, int i, int j);

/*
 *  㷨6.8 
 *
 * ڼSвԪiǰӼ
 */
int find_mfset(MFSet S, int i);

/*
 *  㷨6.10 
 *
 * ཻӼSiӼSjĲ
 *
 * 㷨ǡ㷨6.9ĸĽĽ֮ڣ
 * 1.ӼľֵΪӼԪص
 * 2.ֽģСļϺϲģļ
 */
Status mix_mfset(MFSet* S, int i, int j);

/*
 *  㷨6.11 
 *
 * ڼSвԪiǰӼ
 *
 * 㷨ǡ㷨6.8ĸĽĽ֮ڣ
 * ɺ󣬻ĸ߶Ƚ̯ƽԪֱӹصӼϡ
 *
 *ע
 * òԼɸĶ
 */
int fix_mfset(MFSet* S, int i);

/*
 * ݵȼ۹ϵR/SеԪ(Ӽ)
 *
 *ע
 * ÷bix_relationĿһ£
 * ÷õǡ㷨6.8͡㷨6.9
 * δŻİ汾
 */
Status build_mfset(MFSet* S, Relation R);

/*
 * ݵȼ۹ϵR/SеԪ(Ӽ)
 *
 *ע
 * ÷build_relationĿһ£
 * ÷õǡ㷨6.10͡㷨6.11
 * Żİ汾
 */
Status bix_mfset(MFSet* S, Relation R);


/* ڲʹõĺ */

// ϵڲ
static void mfset(MFSet* S, FILE* fp);

// ϵĶԪϵڲ
static void relation(Relation* R, FILE* fp);


/* ͼλ */

// ͼλʽǰ
void PrintSet(MFSet S);

// ͼλнṹڲʹ
static void PrintFramework(MFSet S);

#endif
