/*===================================
 * Ķ-ֵܣṹ洢ʾ
 ====================================*/

#include "CSTree.h"
#include "LinkQueue.h"  //**03 ջͶ**//

/*
 * ʼ
 *
 * 
 */
Status InitTree(CSTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    *T = NULL;
    
    return OK;
}

/*
 * 
 *
 * ͷռڴ档
 *
 *ע
 * ÿղһµ
 */
Status DestroyTree(CSTree* T) {
    // ٣ʹÿվͿ
    return ERROR;
}

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearTree(CSTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    // *TΪʱеݹ
    if(*T) {
        if((*T)->firstchild != NULL) {
            ClearTree(&((*T)->firstchild));
        }
        
        if((*T)->nextsibling != NULL) {
            ClearTree(&((*T)->nextsibling));
        }
        
        free(*T);
        *T = NULL;
    }
    
    return OK;
}

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(CSTree* T, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("Уûкӽûֵܽڵ㣬ʹ^棺");
        Create(T, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        Create(T, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(CSTree T) {
    return T == NULL ? TRUE : FALSE;
}

/*
 * 
 *
 * ȣ
 */
int TreeDepth(CSTree T) {
    int max = 0;
    
    Depth(T, 0, &max);
    
    return max;
}

/*
 * ȡֵ
 *
 * ֵָ
 */
TElemType Value(CSTree T, TElemType e) {
    CSTree p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ûҵԪe
    if(p == NULL) {
        return '\0';
    } else {
        return p->data;
    }
}

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(CSTree T, TElemType e, TElemType value) {
    CSTree p;
    
    // 
    if(TreeEmpty(T)) {
        return ERROR;
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ûҵԪe
    if(p == NULL) {
        return ERROR;
    } else {
        // иֵ
        p->data = value;
        return OK;
    }
}

/*
 * 
 *
 * ĸ㡣
 */
TElemType Root(CSTree T) {
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    return T->data;
}

/*
 * ˫
 *
 * нe˫׽㡣
 */
TElemType Parent(CSTree T, TElemType e) {
    CSTree p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe˫׽ָ
    p = PPtr(T, e);
    
    // ûҵԪe˫
    if(p == NULL) {
        return '\0';
    } else {
        return p->data;
    }
}

/*
 * 
 *
 * Tнeĺ
 */
int ChildCount(CSTree T, TElemType e) {
    CSTree p;
    int count;
    
    // 
    if(TreeEmpty(T)) {
        return 0;
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ûҵԪe
    if(p == NULL) {
        return 0;
    }
    
    count = 0;
    
    for(p = p->firstchild; p != NULL; p = p->nextsibling) {
        count++;
    }
    
    return count;
}

/*
 * 
 *
 * нeĵiӡ
 */
TElemType Child(CSTree T, TElemType e, int i) {
    CSTree p;
    
    // 
    if(TreeEmpty(T)) {
        return 0;
    }
    
    // iķΧԽ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return '\0';
    }
    
    // ȡeĵiӵָ
    p = CPtr(T, e, i);
    
    if(p != NULL) {
        return p->data;
    } else {
        return '\0';
    }
}

/*
 * ֵ
 *
 * нeֵܽ㡣
 */
TElemType LeftSibling(CSTree T, TElemType e) {
    CSTree p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe˫׽ָ
    p = PPtr(T, e);
    
    // ûҵԪe˫
    if(p == NULL) {
        return '\0';
    }
    
    // eڶֵ
    for(p = p->firstchild; p != NULL; p = p->nextsibling) {
        if(p->nextsibling != NULL && p->nextsibling->data == e) {
            return p->data;
        }
    }
    
    return '\0';
}

/*
 * ֵ
 *
 * нeֵܽ㡣
 */
TElemType RightSibling(CSTree T, TElemType e) {
    CSTree p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ûҵԪe˫
    if(p == NULL) {
        return '\0';
    }
    
    if(p->nextsibling != NULL) {
        return p->nextsibling->data;
    } else {
        return '\0';
    }
}

/*
 * 
 *
 * cΪTpĵiӡ
 */
Status InsertChild(CSTree* T, TElemType p, int i, CSTree c) {
    CSTree r;
    
    // Ϊ
    if(TreeEmpty(*T) || TreeEmpty(c)) {
        return ERROR;
    }
    
    // iķΧС
    if(i < 1) {
        return ERROR;
    }
    
    // Ϊһ
    if(i == 1) {
        r = (*T)->firstchild;
        (*T)->firstchild = c;
        c->nextsibling = r;
    } else {
        // ȡpĵi-1ӵָ
        r = CPtr(*T, p, i - 1);
        if(r == NULL) {
            return ERROR;
        }
        
        c->nextsibling = r->nextsibling;
        r->nextsibling = c;
    }
    
    return OK;
}

/*
 * ɾ
 *
 * ɾTpĵiӡ
 */
Status DeleteChild(CSTree* T, TElemType p, int i) {
    CSTree r, q;
    
    // ɾΪ
    if(TreeEmpty(*T)) {
        return ERROR;
    }
    
    // iķΧԽ磨жϣ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return ERROR;
    }
    
    // ɾһӣ
    if(i == 1) {
        // pָ
        r = EPtr(*T, p);
        if(r == NULL) {
            return ERROR;
        }
        
        q = r->firstchild;
        r->firstchild = q->nextsibling;
        q->nextsibling = NULL;
    } else {
        // ȡpĵi-1ӵָ
        r = CPtr(*T, p, i - 1);
        if(r == NULL) {
            return ERROR;
        }
        
        // i
        q = r->nextsibling;
        r->nextsibling = q->nextsibling;
        q->nextsibling = NULL;
    }
    
    ClearTree(&q);
    
    return OK;
}

/*
 * 
 */
Status PreOrderTraverse(CSTree T, Status(Visit)(TElemType)) {
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    PreTraverse(T, Visit);
    
    printf("\n");
    
    return OK;
}

/*
 * 
 */
Status PostOrderTraverse(CSTree T, Status(Visit)(TElemType)) {
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    PostTraverse(T, Visit);
    
    printf("\n");
    
    return OK;
}

/*
 * 
 */
Status LevelOrderTraverse(CSTree T, Status(Visit)(TElemType)) {
    LinkQueue Q;
    QElemType p, pc;
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    InitQueue(&Q);
    EnQueue(&Q, T);
    
    while(!QueueEmpty(Q)) {
        DeQueue(&Q, &p);    // ĽΪ
    
        if(!Visit(p->data)) {
            return ERROR;
        }
        
        // ýĺ
        for(pc = p->firstchild; pc != NULL; pc = pc->nextsibling) {
            EnQueue(&Q, pc);
        }
    }
    
    printf("\n");
    
    return OK;
}


/* ڲʹõĺ */

// ڲ
static void Create(CSTree* T, FILE* fp) {
    char ch;
    
    // ȡǰֵ
    if(fp == NULL) {
        scanf("%c", &ch);
    } else {
        ReadData(fp, "%c", &ch);
    }
    
    if(ch == '^') {
        *T = NULL;
    } else {
        // ɸ
        *T = (CSTree) malloc(sizeof(CSNode));
        if(!(*T)) {
            exit(OVERFLOW);
        }
        (*T)->data = ch;
        Create(&((*T)->firstchild), fp);    // 
        Create(&((*T)->nextsibling), fp);   // ֵ
    }
}

// ȵڲʵ
static void Depth(CSTree T, int d, int* max) {
    if(T == NULL) {
        return;
    }
    
    d++;    // ָʾǰڵĲ
    
    if(d > *max) {
        *max = d;
    }
    
    Depth(T->firstchild, d, max);       // ±
    Depth(T->nextsibling, --d, max);    // ұ
}

// eָ룬ڣNULL
static CSTree EPtr(CSTree T, TElemType e) {
    CSTree pc, ps;
    
    if(T == NULL) {
        return NULL;
    }
    
    // ҵĿ㣬ֱӷָ
    if(T->data == e) {
        return T;
    }
    
    // ²e
    pc = EPtr(T->firstchild, e);
    if(pc != NULL) {
        return pc;
    }
    
    // Ҳe
    ps = EPtr(T->nextsibling, e);
    if(ps != NULL) {
        return ps;
    }
    
    return NULL;
}

// e˫׽ָ룬ڣNULL
static CSTree PPtr(CSTree T, TElemType e) {
    LinkQueue Q;
    QElemType p, pc;
    
    // û˫
    if(T == NULL || T->data == e) {
        return NULL;
    }
    
    InitQueue(&Q);
    EnQueue(&Q, T);
    
    while(!QueueEmpty(Q)) {
        DeQueue(&Q, &p);    // ĽΪ
        
        // ýĺ
        for(pc = p->firstchild; pc != NULL; pc = pc->nextsibling) {
            if(pc->data == e) {
                return p;
            }
            
            EnQueue(&Q, pc);
        }
    }
    
    return NULL;
}

// eĵiӵָ룬ڣNULL
static CSTree CPtr(CSTree T, TElemType e, int i) {
    CSTree p;
    int count;
    
    // 
    if(TreeEmpty(T)) {
        return NULL;
    }
    
    // iķΧԽ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return NULL;
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ûҵԪe
    if(p == NULL) {
        return NULL;
    }
    
    p = p->firstchild;
    count = 1;
    
    while(p != NULL && count < i) {
        p = p->nextsibling;
        count++;
    }
    
    if(p != NULL) {
        return p;
    } else {
        return NULL;
    }
}

// ڲʵ
static Status PreTraverse(CSTree T, Status(Visit)(TElemType)) {
    CSTree firstChild;
    CSTree rightBrother;
    
    // ʵǰ
    if(!Visit(T->data)) {
        return ERROR;
    }
    
    firstChild = T->firstchild;
    
    // ӣҪȷӵݣ
    if(firstChild != NULL && !PreTraverse(T->firstchild, Visit)) {
        return ERROR;
    }
    
    rightBrother = T->nextsibling;
    
    // ֵܣҪȷֵܵݣ
    if(rightBrother != NULL && !PreTraverse(rightBrother, Visit)) {
        return ERROR;
    }
    
    return OK;
}

// ڲʵ
static Status PostTraverse(CSTree T, Status(Visit)(TElemType)) {
    CSTree firstChild;
    CSTree rightBrother;
    
    firstChild = T->firstchild;
    
    // ӣҪȷӵݣ
    if(firstChild != NULL && !PostTraverse(T->firstchild, Visit)) {
        return ERROR;
    }
    
    // ʵǰ
    if(!Visit(T->data)) {
        return ERROR;
    }
    
    rightBrother = T->nextsibling;
    
    // ֵܣҪȷֵܵݣ
    if(rightBrother != NULL && !PostTraverse(rightBrother, Visit)) {
        return ERROR;
    }
    
    return OK;
}


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(CSTree T) {
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return;
    }
    
    Print(T, 0);
    
    printf("\n");
}

// ͼλǰṹڲʵ
static void Print(CSTree T, int row) {
    int k;
    
    if(T == NULL) {
        return;
    }
    
    // ʵǰ
    printf("%c ", T->data);
    
    Print(T->firstchild, row + 1);
    
    if(T->nextsibling != NULL) {
        printf("\n");
        
        for(k = 0; k < row; k++) {
            printf(". ");
        }
        
        Print(T->nextsibling, row);
    }
}
