/*=============================
 * ĺ(˫)Ĵ洢ʾ
 =============================*/

#ifndef CTREE_H
#define CTREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include "Status.h"     //**01 **//
#include "LinkQueue.h"  //**03 ջͶ**//

/*  */
#define MAX_TREE_SIZE 1024

/* ĺ */
#define MAX_CHILD_COUNT 8

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/* ӽ㶨 */
typedef struct CTNode {
    int child;              // úе
    struct CTNode* next;    // ָһ
} CTNode;

/* ָӽָ */
typedef CTNode* ChildPtr;

/* (˫)Ľ㶨 */
typedef struct {
    int parent;             // ˫λ
    TElemType data;         // ǰ
    ChildPtr firstchild;    // ͷָ
} CTBox;

/*
 * (˫)Ͷ
 *
 *ע
 * 1.нnodes""洢ûп϶
 * 2.rܳnodesλ
 * 3.⣬ΰ˳ŸУһ̲ͼʾܻ
 * 4.nodesѭʹõģһ̲δᵽ
 * 5.nodesռ㹻ģΪ̬洢
 */
typedef struct {
    CTBox nodes[MAX_TREE_SIZE]; // 洢н
    int r;  // λ()
    int n;  // Ľ
} CTree;


/*
 * ĳϢ
 *
 * ע˫ױ洢ṹҪټǰĵһе
 * */
typedef struct{
    int row;            // ǰ
    int col;            // ǰ
    int childIndex;     // ǰǵڼ
    int lastChild;      // ǰһе
} Pos;


/*
 * ʼ
 *
 * 
 */
Status InitTree(CTree* T);

/*
 * 
 *
 * ͷռڴ档
 *
 *ע
 * ÿղһµ
 */
Status DestroyTree(CTree* T);

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearTree(CTree* T);

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(CTree* T, char* path);

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(CTree T);

/*
 * 
 *
 * ȣ
 */
int TreeDepth(CTree T);

/*
 * ȡֵ
 *
 * ֵָ
 */
TElemType Value(CTree T, TElemType e);

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(CTree* T, TElemType e, TElemType value);

/*
 * 
 *
 * ĸ㡣
 */
TElemType Root(CTree T);

/*
 * ˫
 *
 * нe˫׽㡣
 */
TElemType Parent(CTree T, TElemType e);

/*
 * 
 *
 * Tнeĺ
 */
int ChildCount(CTree T, TElemType e);

/*
 * 
 *
 * нeĵiӡ
 */
TElemType Child(CTree T, TElemType e, int i);

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָ߽ڸýֵܡ
 */
TElemType LeftSibling(CTree T, TElemType e);

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָұ߽ڸýֵܡ
 */
TElemType RightSibling(CTree T, TElemType e);

/*
 * 
 *
 * cΪTpĵiӡ
 */
Status InsertChild(CTree* T, TElemType p, int i, CTree c);

/*
 * ɾ
 *
 * ɾTpĵiӡ
 */
Status DeleteChild(CTree* T, TElemType p, int i);

/*
 * 
 */
Status PreOrderTraverse(CTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status PostOrderTraverse(CTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status LevelOrderTraverse(CTree T, Status(Visit)(TElemType));


/* ڲʹõĺ */

// ڲ
static void Create(CTree* T, FILE* fp);

// eڣ-1
static int EIndex(CTree T, TElemType e);

// eĵiڣ-1
static int CIndex(CTree T, TElemType e, int i);

// ȡTĽϢЩϢPos͵Ķ
static void getPos(CTree T, Pos pt[]);

// ڲʵ
static Status PreTraverse(CTree T, int i, Status(Visit)(TElemType));

// ڲʵ
static Status PostTraverse(CTree T, int i, Status(Visit)(TElemType));

// posϢڲʹ
static void printPos(CTree T, Pos pt[]);


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(CTree T);

// ͼλǰṹڲʵ
static void Print(CTree T, Pos pt[], int i);

// ͼλнṹڲʹ
static void PrintFramework(CTree T);

#endif
