/*==================
 * ˫ױ洢ʾ
 ===================*/

#include "PTree.h"

/*
 * ʼ
 *
 * 
 */
Status InitTree(PTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    T->n = 0;
    
    // 
    memset(T->nodes, 0, sizeof(T->nodes));
    
    return OK;
}

/*
 * 
 *
 * ͷռڴ档
 *
 *ע
 * ˫ױṹ޷
 */
Status DestroyTree(PTree* T) {
    // ޷
    return ERROR;
}

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearTree(PTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    // Ԫ㼴
    T->n = 0;
    
    // 
    memset(T->nodes, 0, sizeof(T->nodes));
    
    return OK;
}

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateTree(PTree* T, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("ԪϢڿս㣬ʹ^...\n");
        Create(T, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        Create(T, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 * п
 *
 * жǷΪ
 */
Status TreeEmpty(PTree T) {
    return T.n == 0 ? TRUE : FALSE;
}

/*
 * 
 *
 * ȣ
 */
int TreeDepth(PTree T) {
    int k, level;
    
    // 
    if(TreeEmpty(T)) {
        return 0;
    }
    
    /*
     * kʼΪһλ
     * Ľ㰴洢洢Ľضλ
     */
    k = (T.r + T.n - 1) % MAX_TREE_SIZE;
    level = 0;
    
    do {
        level++;
        k = T.nodes[k].parent;
    } while(k != -1);
    
    return level;
}

/*
 * ȡֵ
 *
 * ֵָ
 */
TElemType Value(PTree T, TElemType e) {
    int p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    
    // ûҵԪe
    if(p == -1) {
        return '\0';
    } else {
        return T.nodes[p].data;
    }
}

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(PTree* T, TElemType e, TElemType value) {
    int p;
    
    // 
    if(TreeEmpty(*T)) {
        return ERROR;
    }
    
    // ȡe
    p = EIndex(*T, e);
    
    // ûҵԪe
    if(p == -1) {
        return ERROR;
    } else {
        // иֵ
        T->nodes[p].data = value;
        return OK;
    }
}

/*
 * 
 *
 * ĸ㡣
 */
TElemType Root(PTree T) {
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    return T.nodes[T.r].data;
}

/*
 * ˫
 *
 * нe˫׽㡣
 */
TElemType Parent(PTree T, TElemType e) {
    int p, parent;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    
    // ûҵԪe
    if(p == -1) {
        return '\0';
    } else {
        parent = T.nodes[p].parent;
        
        // ˫
        if(parent == -1) {
            return '\0';
        } else {
            return T.nodes[parent].data;
        }
    }
}

/*
 * 
 *
 * Tнeĺ
 */
int ChildCount(PTree T, TElemType e) {
    int p, k, count;
    
    // 
    if(TreeEmpty(T)) {
        return -1;
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return -1;
    }
    
    // ҵһ
    for(k = (p + 1) % MAX_TREE_SIZE; k != (T.r + T.n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        if(T.nodes[k].parent == p) {
            break;
        }
    }
    
    count = 0;
    
    // ͳƽeĺ
    while(k != (T.r + T.n) % MAX_TREE_SIZE && T.nodes[k].parent == p) {
        count++;
        k = (k + 1) % MAX_TREE_SIZE;
    }
    
    return count;
}

/*
 * 
 *
 * нeĵiӡ
 */
TElemType Child(PTree T, TElemType e, int i) {
    int p;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // iķΧԽ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return '\0';
    }
    
    // ȡeĵi
    p = CIndex(T, e, i);
    // eiӲ
    if(p == -1) {
        return '\0';
    }
    
    return T.nodes[p].data;
}

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָ߽ڸýֵܡ
 */
TElemType LeftSibling(PTree T, TElemType e) {
    int p, ls;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return '\0';
    }
    
    // ֵ
    ls = (p - 1 + MAX_TREE_SIZE) % MAX_TREE_SIZE;
    
    // ýЧe˫ͬ˵ֵ
    if(ls != p && T.nodes[ls].data != '\0' && T.nodes[ls].parent == T.nodes[p].parent) {
        return T.nodes[ls].data;
    }
    
    return '\0';
}

/*
 * ֵ
 *
 * нeֵܽ㡣
 *
 *ע
 * Ľܻӣ
 * ֵָұ߽ڸýֵܡ
 */
TElemType RightSibling(PTree T, TElemType e) {
    int p, rs;
    
    // 
    if(TreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return '\0';
    }
    
    // ֵ
    rs = (p + 1) % MAX_TREE_SIZE;
    
    // ýЧe˫ͬ˵ֵ
    if(rs != p && T.nodes[rs].data != '\0' && T.nodes[rs].parent == T.nodes[p].parent) {
        return T.nodes[rs].data;
    }
    
    return '\0';
}

/*
 * 
 *
 * cΪTpĵiӡ
 */
Status InsertChild(PTree* T, TElemType p, int i, PTree c) {
    Pos pt[MAX_TREE_SIZE], pc[MAX_TREE_SIZE];
    int pIndex;
    int lastChild, bound;
    int level;
    int m, n, k;
    int tCur, cCur;
    
    PTree R;
    int tParent[MAX_TREE_SIZE], cParent[MAX_TREE_SIZE];
    int x, y, z;
    
    // Ϊ
    if(TreeEmpty(*T) || TreeEmpty(c)) {
        return ERROR;
    }
    
    // iķΧС
    if(i < 1) {
        return ERROR;
    }
    
    // ȡp
    pIndex = EIndex(*T, p);
    
    // p㲻ڣ򷵻شʾ
    if(pIndex == -1) {
        return ERROR;
    }
    
    // TнλϢ
    getPos(*T, pt);
    
    // pһӵ
    lastChild = pt[pIndex].lastChild;
    
    // iķΧ
    if(lastChild != -1 && i > pt[lastChild].childIndex + 1) {
        return ERROR;
    }
    
    if(i == 1) {
        // pǵһ
        if(pt[pIndex].childIndex == 1) {
            bound = -1;
        } else {
            // pֵ
            for(k = (pIndex - 1) % MAX_TREE_SIZE; pt[k].lastChild == -1 && pt[k].childIndex != 1; k = (k - 1) % MAX_TREE_SIZE) {
                // ұ߽ĸ
            }
            
            // Ѿòһ㣬ýȻûк
            if(pt[k].lastChild == -1) {
                bound = -1;
            } else {
                bound = pt[k].lastChild;    // kһӵ
            }
        }
    } else {
        // pûк
        if(lastChild == -1) {
            return ERROR;
        } else {
            for(k = pt[pIndex].lastChild; pt[k].childIndex != i - 1; k = (k - 1) % MAX_TREE_SIZE) {
                // Ҳλõǰһӵ
            }
            bound = k;
        }
    }
    
    level = pt[pIndex].row + 1;   // ĸڵ
    
    // cнλϢ
    getPos(c, pc);
    // ²иԪص
    for(k = c.r; k != (c.r + c.n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        pc[k].row += level - 1;
    }
    
    // tCurָlevelеĵһ
    for(tCur = pIndex; tCur != (T->r + T->n) % MAX_TREE_SIZE; tCur = (tCur + 1) % MAX_TREE_SIZE) {
        if(pt[tCur].row == level) {
            break;
        }
    }
    
    // cCurָcеĸ㣬øҲӦ뵽Tеlevel
    cCur = c.r;
    
    while(tCur != (T->r + T->n) % MAX_TREE_SIZE && cCur != (c.r + c.n) % MAX_TREE_SIZE) {
        // Tҽǰ벿
        if(bound != -1) {
            tCur = (bound + 1) % MAX_TREE_SIZE;
        }
        
        if(bound == -1) {
            m = 0;
        } else {
            m = pt[bound].col;
        }
        
        n = 0;
        
        // c뵽Tм
        while(cCur != (c.r + c.n) % MAX_TREE_SIZE && pc[cCur].row == level) {
            // ı
            
            pc[cCur].col += m;
            n++;
            
            cCur++;
        }
        
        // Tĺ벿
        while(tCur != (T->r + T->n) % MAX_TREE_SIZE && pt[tCur].row == level) {
            
            pt[tCur].col += n;
            
            tCur++;
        }
        
        // һı߽
        if(bound != -1) {
            // bound
            for(k = bound; pt[k].lastChild == -1 && pt[k].childIndex != 1; k = (k - 1) % MAX_TREE_SIZE) {
                // ұ߽ĸ
            }
            
            // Ѿòһ㣬ýȻûк
            if(pt[k].lastChild == -1) {
                bound = -1;
            } else {
                bound = pt[k].lastChild;    // kһӵ
            }
        }
        
        level++;
    }
    
    // posϢ
//    printPos(*T, pt);
//    printPos(c, pc);
    
    InitTree(&R);
    
    R.r = T->r;
    n = 0;
    
    x = T->r;   // Tα
    y = c.r;    // cα
    z = R.r;    // Rα
    
    while(x != (T->r + T->n) % MAX_TREE_SIZE && y != (c.r + c.n) % MAX_TREE_SIZE) {
        if(pt[x].row < pc[y].row || (pt[x].row == pc[y].row && pt[x].col < pc[y].col)) {
            
            // ¼xλ
            tParent[x] = z;
            
            // ЧԪطŵλ
            R.nodes[z] = T->nodes[x];
            
            if(R.nodes[z].parent != -1) {
                // ¸λ
                R.nodes[z].parent = tParent[R.nodes[z].parent];
            }
    
            x = (x + 1) % MAX_TREE_SIZE;
        } else if(pt[x].row > pc[y].row || (pt[x].row == pc[y].row && pt[x].col > pc[y].col)) {
            // ¼yλ
            cParent[y] = z;
            
            // ЧԪطŵλ
            R.nodes[z] = c.nodes[y];
            
            if(R.nodes[z].parent != -1) {
                // ¸λ
                R.nodes[z].parent = cParent[R.nodes[z].parent];
            } else {
                // һ𣬼cĸĸΪp
                R.nodes[z].parent = tParent[pIndex];
            }
    
            y = (y + 1) % MAX_TREE_SIZE;
        }
        
        z = (z + 1) % MAX_TREE_SIZE;
        n++;
    }
    
    while(x != (T->r + T->n) % MAX_TREE_SIZE) {
        // ¼kλ
        tParent[x] = z;
    
        // ЧԪطŵλ
        R.nodes[z] = T->nodes[x];
        
        if(R.nodes[z].parent != -1) {
            // ¸λ
            R.nodes[z].parent = tParent[R.nodes[z].parent];
        }
        
        x = (x + 1) % MAX_TREE_SIZE;
        z = (z + 1) % MAX_TREE_SIZE;
        n++;
    }
    
    while(y != (c.r + c.n) % MAX_TREE_SIZE) {
        // ¼kλ
        cParent[y] = z;
    
        // ЧԪطŵλ
        R.nodes[z] = c.nodes[y];
        
        if(R.nodes[z].parent != -1) {
            // ¸λ
            R.nodes[z].parent = cParent[R.nodes[z].parent];
        } else {
            // һ𣬼cĸĸΪp
            R.nodes[z].parent = tParent[pIndex];
        }
        
        y = (y + 1) % MAX_TREE_SIZE;
        z = (z + 1) % MAX_TREE_SIZE;
        n++;
    }
    
    R.n = n;
    *T = R;
    
    return OK;
}

/*
 * ɾ
 *
 * ɾTpĵiӡ
 */
Status DeleteChild(PTree* T, TElemType p, int i) {
    LinkList Lt;
    int index;
    int k, m, n;
    PTree R;
    int parent[MAX_TREE_SIZE];
    
    // ɾΪ
    if(TreeEmpty(*T)) {
        return ERROR;
    }
    
    // iķΧԽ磨жϣ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return ERROR;
    }
    
    // ȡpĵi
    index = CIndex(*T, p, i);
    
    // ɾ㲻ڣ򷵻شʾ
    if(index == -1) {
        return ERROR;
    }
    
    InitList(&Lt);
    
    m = 0;
    // p뵽
    ListInsert(Lt, ++m, index);
    T->nodes[index].data = '\0';
    
    k = (index + 1) % MAX_TREE_SIZE;
    
    while(k != (T->r + T->n) % MAX_TREE_SIZE) {
        // жϵǰǷΪkڲĺ
        if(LocateElem(Lt, T->nodes[k].parent, Equal)) {
            ListInsert(Lt, ++m, k);
            
            T->nodes[k].data = '\0';
        }
        
        k = (k + 1) % MAX_TREE_SIZE;
    }
    
    DestroyList(&Lt);
    
    InitTree(&R);
    
    R.r = T->r;
    n = 0;
    
    m = R.r;    // Rα
    
    for(k = T->r; k != (T->r + T->n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        if(T->nodes[k].data != '\0') {
            // ¼kλ
            parent[k] = m;
            
            // ЧԪطŵλ
            R.nodes[m] = T->nodes[k];
    
            // ¸λ
            if(R.nodes[m].parent!=-1) {
                R.nodes[m].parent = parent[R.nodes[m].parent];
            }
            
            m = (m + 1) % MAX_TREE_SIZE;
            n++;
        }
    }
    
    R.n = n;
    *T = R;
    
    return OK;
}

/*
 * 
 */
Status PreOrderTraverse(PTree T, Status(Visit)(TElemType)) {
    Pos pt[MAX_TREE_SIZE];
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    // TнλϢ
    getPos(T, pt);
    
    PreTraverse(T, pt, T.r, Visit);
    
    printf("\n");
    
    return OK;
}

/*
 * 
 */
Status PostOrderTraverse(PTree T, Status(Visit)(TElemType)) {
    Pos pt[MAX_TREE_SIZE];
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    // TнλϢ
    getPos(T, pt);
    
    PostTraverse(T, pt, T.r, Visit);
    
    printf("\n");
    
    return OK;
}

/*
 * 
 */
Status LevelOrderTraverse(PTree T, Status(Visit)(TElemType)) {
    int i;
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return ERROR;
    }
    
    // ˳αԪ
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        if(!Visit(T.nodes[i].data)) {
            return ERROR;
        }
    }
    
    printf("\n");
    
    return OK;
}


/* ڲʹõĺ */

// ڲ
static void Create(PTree* T, FILE* fp) {
    int r;          // ĸλã
    int n;          // ¼Ԫ
    int cur;        // α
    TElemType ch;
    LinkQueue Q;
    QElemType e;    // Ԫָʾλ
    char s[MAX_CHILD_COUNT + 1];
    int i;
    
    InitQueue(&Q);
    
    n = 0;
    
    // ȡλ
    if(fp == NULL) {
        printf("λ(0~%d)", MAX_TREE_SIZE - 1);
        scanf("%d", &r);
        cur = r;
        
        printf("ֵ");
        scanf("%s", s);
        ch = s[0];
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            DeQueue(&Q, &e);    // λó
            
            printf(" %c ĺӽ㣬ںʱһ^", T->nodes[e].data);
            scanf("%s", s);
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    } else {
        // ¼λ
        ReadData(fp, "%d", &r);
        cur = r;
        
        // ¼ֵ
        ReadData(fp, "%s", s);
        ch = s[0];
        printf("¼ֵ%c\n", ch);
        
        // 
        EnQueue(&Q, cur);
        T->nodes[cur].data = ch;
        T->nodes[cur].parent = -1;
        cur = (cur + 1) % MAX_TREE_SIZE;
        n++;
        
        while(!QueueEmpty(Q)) {
            ReadData(fp, "%s", s);
            ch = s[0];
            printf("¼ %c ĺӣ", ch);
            
            // ¼뺢ӽ
            ReadData(fp, "%s", s);
            printf("%s\n", s);
            
            DeQueue(&Q, &e);    // λó
            
            // 
            for(i = 0; i < strlen(s); i++) {
                if(s[i] == '^') {
                    break;
                }
                
                EnQueue(&Q, cur); // ǰλ
                T->nodes[cur].data = s[i];
                T->nodes[cur].parent = e;
                cur = (cur + 1) % MAX_TREE_SIZE;
                n++;
            }
        }
    }
    
    T->r = r;
    T->n = n;
}

// eڣ-1
static int EIndex(PTree T, TElemType e) {
    int i = T.r;    // ָ
    int p = -1;
    
    // 
    if(TreeEmpty(T)) {
        return -1;
    }
    
    // вҽe
    while(i != (T.r + T.n) % MAX_TREE_SIZE) {
        if(T.nodes[i].data == e) {
            p = i;
            break;
        }
        
        i = (i + 1) % MAX_TREE_SIZE;
    }
    
    return p;
}

// eĵiڣ-1
static int CIndex(PTree T, TElemType e, int i) {
    int p, k, r, count;
    
    // 
    if(TreeEmpty(T)) {
        return -1;
    }
    
    // iķΧԽ
    if(i < 1 || i > MAX_CHILD_COUNT) {
        return -1;
    }
    
    // ȡe
    p = EIndex(T, e);
    // e
    if(p == -1) {
        return -1;
    }
    
    k = (p + 1) % MAX_TREE_SIZE;
    
    // ҵһӣk¼
    while(k != (T.r + T.n) % MAX_TREE_SIZE && T.nodes[k].parent < p) {
        k = (k + 1) % MAX_TREE_SIZE;
    }
    
    // ȷһӴ
    if(k != (T.r + T.n) % MAX_TREE_SIZE) {
        count = 1;
        r = k;
        
        while(count < i && T.nodes[r].parent==p) {
            r = (r + 1) % MAX_TREE_SIZE;
            count++;
        }
        
        if(count == i) {
            return r;
        }
    }
    
    return -1;
}

// ȡTĽϢЩϢPos͵Ķ
static void getPos(PTree T, Pos pt[]) {
    LinkList Lt, Lt_parent, Lt_child;
    int m, n, p, k, s;
    int level;
    
    memset(pt, 0, MAX_TREE_SIZE * sizeof(Pos));
    
    // 
    if(TreeEmpty(T)) {
        return;
    }
    
    InitList(&Lt_parent);
    InitList(&Lt_child);
    
    // parentΪ-1
    ListInsert(Lt_parent, 1, -1);
    
    level = 1;
    k = T.r;
    m = n = 0;
    s = -1; // ʼͷĸΪ-1
    
    while(k != (T.r + T.n) % MAX_TREE_SIZE) {
        // kһеʼΪ-1
        pt[k].firstChild = -1;
        
        // kһеʼΪ-1
        pt[k].lastChild = -1;
        
        // ǰkĸ
        p = T.nodes[k].parent;
        if(p != s) {
            s = p;  // ׷ٸı仯
            n = 0;  // ıʱҪ¼
        }
        
        // жϵǰǷΪlevel-1ĺ
        if(LocateElem(Lt_parent, p, Equal)) {
            ListInsert(Lt_child, ++m, k);
            
            pt[k].row = level;
            pt[k].col = m;
            pt[k].childIndex = ++n;
            
            // ȷǰ㸸
            if(p != -1) {
                // һе
                if(pt[p].firstChild==-1) {
                    pt[p].firstChild = k;
                }
                
                // һе
                pt[p].lastChild = k;
            }
            
            k = (k + 1) % MAX_TREE_SIZE;
        } else {
            Lt = Lt_parent;
            Lt_parent = Lt_child;
            Lt_child = Lt;
            ClearList(Lt_child);
            
            level++;
            m = 0;
        }
    }
    
    DestroyList(&Lt_parent);
    DestroyList(&Lt_child);
}

// ڲʵ
static Status PreTraverse(PTree T, Pos pt[], int i, Status(Visit)(TElemType)) {
    int firstChild;
    int rightBrother;
    
    // ʵǰ
    if(!Visit(T.nodes[i].data)) {
        return ERROR;
    }
    
    firstChild = pt[i].firstChild;
    
    // ӣҪȷӵݣ
    if(firstChild != -1 && !PreTraverse(T, pt, firstChild, Visit)) {
        return ERROR;
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(T.nodes[i].parent == T.nodes[rightBrother].parent && !PreTraverse(T, pt, rightBrother, Visit)) {
        return ERROR;
    }
    
    return OK;
}

// ڲʵ
static Status PostTraverse(PTree T, Pos pt[], int i, Status(Visit)(TElemType)) {
    int firstChild;
    int rightBrother;
    
    firstChild = pt[i].firstChild;
    
    // ӣҪȷӵݣ
    if(firstChild != -1 && !PostTraverse(T, pt, firstChild, Visit)) {
        return ERROR;
    }
    
    // ʵǰ
    if(!Visit(T.nodes[i].data)) {
        return ERROR;
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(T.nodes[i].parent == T.nodes[rightBrother].parent && !PostTraverse(T, pt, rightBrother, Visit)) {
        return ERROR;
    }
    
    return OK;
}

// posϢڲʹ
static void printPos(PTree T, Pos pt[]) {
    int i;
    
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        printf("%2c ", T.nodes[i].data);
    }
    printf("\n");
    
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        printf("%2d ", pt[i].row);
    }
    printf("\n");
    
    for(i = T.r; i != (T.r + T.n) % MAX_TREE_SIZE; i = (i + 1) % MAX_TREE_SIZE) {
        printf("%2d ", pt[i].col);
    }
    printf("\n");
}


/* ͼλ */

// ͼλʽǰṹ
void PrintTree(PTree T) {
    Pos pt[MAX_TREE_SIZE];
    
    // 
    if(TreeEmpty(T)) {
        printf("\n");
        return;
    }
    
    // TнλϢ
    getPos(T, pt);
    
    Print(T, pt, T.r);
    
    printf("\n");
    
    printf("洢ṹ\n");
    PrintFramework(T);
}

// ͼλǰṹڲʵ
static void Print(PTree T, Pos pt[], int i) {
    int firstChild;
    int rightBrother;
    int k;
    
    // ʵǰ
    printf("%c ", T.nodes[i].data);
    
    firstChild = pt[i].firstChild;
    
    // ӣҪȷӵݣ
    if(firstChild != -1) {
        Print(T, pt, firstChild);
    }
    
    rightBrother = (i + 1) % MAX_TREE_SIZE;
    
    // ֵܣҪȷֵܵݣ
    if(rightBrother != (T.r + T.n) % MAX_TREE_SIZE && T.nodes[i].parent == T.nodes[rightBrother].parent) {
        // ʵǰֵǰǰ㲻һӣһλ
        if(pt[T.nodes[i].parent].lastChild != i) {
            printf("\n");
            
            for(k = 0; k < pt[rightBrother].row - 1; k++) {
                printf(". ");
            }
        }
        
        Print(T, pt, rightBrother);
    }
}

// ͼλнṹڲʹ
static void PrintFramework(PTree T) {
    int k;
    
    if(T.n == 0) {
        printf("\n");
        return;
    }
    
    printf("+---------+\n");
    printf("|  i e  p |\n");
    printf("+---------+\n");
    
    for(k = T.r; k != (T.r + T.n) % MAX_TREE_SIZE; k = (k + 1) % MAX_TREE_SIZE) {
        printf("| %2d %c %2d |\n", k, T.nodes[k].data, T.nodes[k].parent);
    }
    
    printf("+---------+\n");
}
