/*=============================
 * Ķ洢ṹ
 *
 * 㷨: 6.16.26.36.4
 =============================*/

#ifndef BITREE_H
#define BITREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include <math.h>       // ṩ pow ԭ
#include "Status.h"     //**01 **//

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/* 㶨 */
typedef struct BiTNode {
    TElemType data;             // Ԫ
    struct BiTNode* lchild;     // ָ
    struct BiTNode* rchild;     // Һָ
} BiTNode;

/* ָָ */
typedef BiTNode* BiTree;


/*
 * ʼ
 *
 * ն
 */
Status InitBiTree(BiTree* T);

/*
 * 
 *
 * ͷŶռڴ档
 *
 *ע
 * Ķ洢ṹ٣ûҪ١
 * Ϊٺ״̬ÿպ״̬һµġ
 */
Status DestroyBiTree(BiTree* T);

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearBiTree(BiTree* T);

/*
 *  㷨6.4 
 *
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateBiTree(BiTree* T, char* path);

/*
 * п
 *
 * ж϶ǷΪ
 */
Status BiTreeEmpty(BiTree T);

/*
 * 
 *
 * ضȣ
 */
int BiTreeDepth(BiTree T);

/*
 * ȡֵ
 *
 * ضֵָ
 */
TElemType Value(BiTree T, TElemType e);

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(BiTree T, TElemType e, TElemType value);

/*
 * 
 *
 * ضĸ㡣
 */
TElemType Root(BiTree T);

/*
 * ˫
 *
 * ضнe˫׽㡣
 */
TElemType Parent(BiTree T, TElemType e);

/*
 * 
 *
 * ضнeӽ㡣
 */
TElemType LeftChild(BiTree T, TElemType e);

/*
 * Һ
 *
 * ضнeҺӽ㡣
 */
TElemType RightChild(BiTree T, TElemType e);

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType LeftSibling(BiTree T, TElemType e);

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType RightSibling(BiTree T, TElemType e);

/*
 * 
 *
 * ֪cΪTཻķǿնcΪգ
 * LRȡֵ(01)cΪTнp/
 * ңpԭе/޽Ϊc
 */
Status InsertChild(BiTree T, TElemType p, int LR, BiTree c);

/*
 * ɾ
 *
 * LRȡֵ(01)ɾp/
 */
Status DeleteChild(BiTree T, TElemType p, int LR);

/*
 *  㷨6.1 
 *
 * 
 */
Status PreOrderTraverse(BiTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status InOrderTraverse(BiTree T, Status(Visit)(TElemType));

/*
 *  㷨6.2 
 *
 * 
 *
 *ע
 * ǵݹ㷨
 */
Status InOrderTraverse_2(BiTree T, Status(Visit)(TElemType));

/*
 *  㷨6.3 
 *
 * 
 *
 *ע
 * ǵݹ㷨
 */
Status InOrderTraverse_3(BiTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status PostOrderTraverse(BiTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status LevelOrderTraverse(BiTree T, Status(Visit)(TElemType));


/* ڲʹõĺ */

// ڲ
static void CreateTree(BiTree* T, FILE* fp);

// ָeָ
static BiTree EPtr(BiTree T, TElemType e);

// ָe˫׽ָ
static BiTree PPtr(BiTree T, TElemType e);

// ڲʵ
static Status PreTraverse(BiTree T, Status(Visit)(TElemType));

// ڲʵ
static Status InTraverse(BiTree T, Status(Visit)(TElemType));

// ڲʵ
static Status PostTraverse(BiTree T, Status(Visit)(TElemType));


/* ͼλ */

// ͼλʽǰṹڲʹ
void PrintTree(BiTree T);

#endif
