/*=============================
 * Ķ洢ṹ
 *
 * 㷨: 6.16.26.36.4
 =============================*/

#include "BiTree.h"
#include "LinkQueue.h"  //**03 ջͶ**//
#include "SqStack.h"    //**03 ջͶ**//

/*
 * ʼ
 *
 * ն
 */
Status InitBiTree(BiTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    *T = NULL;
    
    return OK;
}

/*
 * 
 *
 * ͷŶռڴ档
 *
 *ע
 * Ķ洢ṹ٣ûҪ١
 * Ϊٺ״̬ÿպ״̬һµġ
 */
Status DestroyBiTree(BiTree* T) {
    // ٣ʹÿվͿ
    return ERROR;
}

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearBiTree(BiTree* T) {
    if(T == NULL) {
        return ERROR;
    }
    
    // *TΪʱеݹ
    if(*T) {
        if((*T)->lchild!=NULL) {
            ClearBiTree(&((*T)->lchild));
        }
        
        if((*T)->rchild!=NULL) {
            ClearBiTree(&((*T)->rchild));
        }
        
        free(*T);
        *T = NULL;
    }
    
    return OK;
}

/*
 *  㷨6.4 
 *
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateBiTree(BiTree* T, char* path) {
    FILE* fp;
    int readFromConsole;    // Ƿӿ̨ȡ
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = path == NULL || strcmp(path, "") == 0;
    
    if(readFromConsole) {
        printf("Уûӽ㣬ʹ^棺");
        CreateTree(T, NULL);
    } else {
        // ļ׼ȡ
        fp = fopen(path, "r");
        if(fp == NULL) {
            return ERROR;
        }
        CreateTree(T, fp);
        fclose(fp);
    }
    
    return OK;
}

/*
 * п
 *
 * ж϶ǷΪ
 */
Status BiTreeEmpty(BiTree T) {
    return T == NULL ? TRUE : FALSE;
}

/*
 * 
 *
 * ضȣ
 */
int BiTreeDepth(BiTree T) {
    int LD, RD;
    
    if(T == NULL) {
        return 0;                       // Ϊ0
    } else {
        LD = BiTreeDepth(T->lchild);    // 
        RD = BiTreeDepth(T->rchild);    // 
        
        return (LD >= RD ? LD : RD) + 1;
    }
}

/*
 * ȡֵ
 *
 * ضֵָ
 */
TElemType Value(BiTree T, TElemType e) {
    BiTree p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ûҵԪe
    if(p == NULL) {
        return '\0';
    } else {
        return p->data;
    }
}

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(BiTree T, TElemType e, TElemType value) {
    BiTree p;
    
    // 
    if(BiTreeEmpty(T)) {
        return ERROR;
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ûҵԪe
    if(p == NULL) {
        return ERROR;
    } else {
        // иֵ
        p->data = value;
        return OK;
    }
}

/*
 * 
 *
 * ضĸ㡣
 */
TElemType Root(BiTree T) {
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    return T->data;
}

/*
 * ˫
 *
 * ضнe˫׽㡣
 */
TElemType Parent(BiTree T, TElemType e) {
    BiTree p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe˫׽ָ
    p = PPtr(T, e);
    
    // ûҵԪe˫
    if(p == NULL) {
        return '\0';
    } else {
        return p->data;
    }
}

/*
 * 
 *
 * ضнeӽ㡣
 */
TElemType LeftChild(BiTree T, TElemType e) {
    BiTree p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ҵԪe
    if(p != NULL && p->lchild != NULL) {
        return p->lchild->data;
    }
    
    return '\0';
}

/*
 * Һ
 *
 * ضнeҺӽ㡣
 */
TElemType RightChild(BiTree T, TElemType e) {
    BiTree p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡeָ
    p = EPtr(T, e);
    
    // ҵԪe
    if(p != NULL && p->rchild != NULL) {
        return p->rchild->data;
    }
    
    return '\0';
}

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType LeftSibling(BiTree T, TElemType e) {
    BiTree p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe˫׽ָ
    p = PPtr(T, e);
    
    // ҵԪe˫
    if(p != NULL && p->lchild != NULL) {
        return p->lchild->data;
    }
    
    return '\0';
}

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType RightSibling(BiTree T, TElemType e) {
    BiTree p;
    
    // 
    if(BiTreeEmpty(T)) {
        return '\0';
    }
    
    // ȡe˫׽ָ
    p = PPtr(T, e);
    
    // ҵԪe˫
    if(p != NULL && p->rchild != NULL) {
        return p->rchild->data;
    }
    
    return '\0';
}

/*
 * 
 *
 * ֪cΪTཻķǿնcΪգ
 * LRȡֵ(01)cΪTнp/
 * ңpԭе/޽Ϊc
 */
Status InsertChild(BiTree T, TElemType p, int LR, BiTree c) {
    BiTree p_ptr;
    
    // Ϊ
    if(BiTreeEmpty(c)) {
        return ERROR;
    }
    
    // ȡpָ
    p_ptr = EPtr(T, p);
    
    // p㲻ڣ򷵻شʾ
    if(p_ptr == NULL) {
        return ERROR;
    }
    
    // cΪp
    if(LR==0) {
        // pժpΪc
        if(p_ptr->lchild!=NULL) {
            c->rchild = p_ptr->lchild;
        }
        
        p_ptr->lchild = c;
    } else {
        // pժpΪc
        if(p_ptr->rchild!=NULL) {
            c->rchild = p_ptr->rchild;
        }
    
        p_ptr->rchild = c;
    }
    
    return OK;
}

/*
 * ɾ
 *
 * LRȡֵ(01)ɾp/
 */
Status DeleteChild(BiTree T, TElemType p, int LR) {
    BiTree p_ptr;
    
    // 
    if(BiTreeEmpty(T)) {
        return ERROR;
    }
    
    // ȡpָ
    p_ptr = EPtr(T, p);
    
    // p㲻ڣ򷵻شʾ
    if(p_ptr == NULL) {
        return ERROR;
    }
    
    // Ҫɾp
    if(LR == 0) {
        ClearBiTree(&(p_ptr->lchild));
        
        // Ҫɾp
    } else {
        ClearBiTree(&(p_ptr->rchild));
    }
    
    return OK;
}

/*
 *  㷨6.1 
 *
 * 
 */
Status PreOrderTraverse(BiTree T, Status(Visit)(TElemType)) {
    Status status;
    
    status = PreTraverse(T, Visit);
    printf("\n");
    
    return status;
}

/*
 * 
 */
Status InOrderTraverse(BiTree T, Status(Visit)(TElemType)) {
    Status status;
    
    status = InTraverse(T, Visit);
    printf("\n");
    
    return status;
}

/*
 *  㷨6.2 
 *
 * 
 *
 *ע
 * ǵݹ㷨
 */
Status InOrderTraverse_2(BiTree T, Status(Visit)(TElemType)) {
    SqStack S;
    BiTree p;
    
    InitStack(&S);
    Push(&S, T);    // ָջ
    
    while(!StackEmpty(S)) {
        // ߵͷ
        while(GetTop(S, &p) && p != NULL) {
            Push(&S, p->lchild);
        }
        
        Pop(&S, &p);    // ָջ
        
        if(!StackEmpty(S)) {
            // ʽ
            Pop(&S, &p);
            if(!Visit(p->data)) {
                return ERROR;
            }
            
            // һ
            Push(&S, p->rchild);
        }
    }
    
    printf("\n");
    
    return OK;
}

/*
 *  㷨6.3 
 *
 * 
 *
 *ע
 * ǵݹ㷨
 */
Status InOrderTraverse_3(BiTree T, Status(Visit)(TElemType)) {
    SqStack S;
    BiTree p;
    
    InitStack(&S);
    
    p = T;
    
    while(p != NULL || !StackEmpty(S)) {
        if(p != NULL) {
            Push(&S, p);    // ָջ
            p = p->lchild;  // 
        } else {
            // ʽ
            Pop(&S, &p);
            if(!Visit(p->data)) {
                return ERROR;
            }
            
            p = p->rchild;
        }
    }
    
    printf("\n");
    
    return OK;
}

/*
 * 
 */
Status PostOrderTraverse(BiTree T, Status(Visit)(TElemType)) {
    Status status;
    
    status = PostTraverse(T, Visit);
    printf("\n");
    
    return status;
}

/*
 * 
 */
Status LevelOrderTraverse(BiTree T, Status(Visit)(TElemType)) {
    LinkQueue Q;
    BiTree e;
    
    // Ϊ
    if(T == NULL) {
        printf("\n");
        return OK;
    }
    
    // ʵֲ
    InitQueue(&Q);
    
    // ָ
    EnQueue(&Q, T);
    
    // һֱѭֱΪ
    while(!QueueEmpty(Q)) {
        DeQueue(&Q, &e);
        
        // Ԫ
        if(!Visit(e->data)) {
            return ERROR;
        }
        
        // 
        if(e->lchild != NULL) {
            EnQueue(&Q, e->lchild);
        }
        
        // Һ
        if(e->rchild != NULL) {
            EnQueue(&Q, e->rchild);
        }
    }
    
    printf("\n");
    
    return OK;
}


/* ڲʹõĺ */

// ڲ
static void CreateTree(BiTree* T, FILE* fp) {
    char ch;
    
    // ȡǰֵ
    if(fp == NULL) {
        scanf("%c", &ch);
    } else {
        ReadData(fp, "%c", &ch);
    }
    
    if(ch == '^') {
        *T = NULL;
    } else {
        // ɸ
        *T = (BiTree) malloc(sizeof(BiTNode));
        if(!(*T)) {
            exit(OVERFLOW);
        }
        (*T)->data = ch;
        CreateTree(&((*T)->lchild), fp); // 
        CreateTree(&((*T)->rchild), fp); // 
    }
}

// ָeָ
static BiTree EPtr(BiTree T, TElemType e) {
    BiTree pl, pr;
    
    if(T == NULL) {
        return NULL;
    }
    
    // ҵĿ㣬ֱӷָ
    if(T->data == e) {
        return T;
    }
    
    // вe
    pl = EPtr(T->lchild, e);
    if(pl != NULL) {
        return pl;
    }
    
    // вe
    pr = EPtr(T->rchild, e);
    if(pr != NULL) {
        return pr;
    }
    
    return NULL;
}

// ָe˫׽ָ
static BiTree PPtr(BiTree T, TElemType e) {
    BiTree pl, pr;
    
    if(T == NULL || T->data == e) {
        return NULL;
    }
    
    // eT
    if(T->lchild != NULL && T->lchild->data == e) {
        return T;
    }
    
    // eTҺ
    if(T->rchild != NULL && T->rchild->data == e) {
        return T;
    }
    
    // вe
    pl = PPtr(T->lchild, e);
    if(pl != NULL) {
        return pl;
    }
    
    // вe
    pr = PPtr(T->rchild, e);
    if(pr != NULL) {
        return pr;
    }
    
    return NULL;
}

// ڲʵ
static Status PreTraverse(BiTree T, Status(Visit)(TElemType)) {
    if(T) {
        if(Visit(T->data)) {
            if(PreTraverse(T->lchild, Visit)) {
                if(PreTraverse(T->rchild, Visit)) {
                    return OK;
                }
            }
        }
        
        return ERROR;
    
        // 
    } else {
        return OK;
    }
}

// ڲʵ
static Status InTraverse(BiTree T, Status(Visit)(TElemType)) {
    if(T) {
        if(InTraverse(T->lchild, Visit)) {
            if(Visit(T->data)) {
                if(InTraverse(T->rchild, Visit)) {
                    return OK;
                }
            }
        }
        
        return ERROR;
        
        // 
    } else {
        return OK;
    }
}

// ڲʵ
static Status PostTraverse(BiTree T, Status(Visit)(TElemType)) {
    if(T) {
        if(PostTraverse(T->lchild, Visit)) {
            if(PostTraverse(T->rchild, Visit)) {
                if(Visit(T->data)) {
                    return OK;
                }
            }
        }
        
        return ERROR;
        
        // 
    } else {
        return OK;
    }
}


/* ͼλ */

// ͼλʽǰṹڲʹ
void PrintTree(BiTree T) {
    int level, width;
    int i, j, k, w;
    int begin;
    int distance;
    TElemType** tmp;
    LinkQueue Q;
    BiTree e;
    
    // 
    if(BiTreeEmpty(T)) {
        printf("\n");
        return;
    }
    
    level = BiTreeDepth(T);         // ȫṹ߶
    width = (int)pow(2, level)-1;   // ȫṹ
    
    // ̬
    tmp = (TElemType**)malloc(level* sizeof(TElemType*));
    
    // ̬
    for(i = 0; i < level; i++) {
        tmp[i] = (TElemType*)malloc(width* sizeof(TElemType));
        
        // ʼڴֵΪַ
        memset(tmp[i], '\0', width);
    }
    
    // ʵֲ
    InitQueue(&Q);
    EnQueue(&Q, T);
    
    // Ԫأ䰲ŵάtmpкʵλ
    for(i = 0; i < level; i++) {
        w        = (int) pow(2, i);             // ǰĿ
        distance = width / w;                   // ǰԪؼ
        begin    = width / (int) pow(2, i + 1); // ǰ׸Ԫ֮ǰĿո
        
        for(k = 0; k < w; k++) {
            DeQueue(&Q, &e);
            
            if(e == NULL) {
                EnQueue(&Q, NULL);
                EnQueue(&Q, NULL);
            } else {
                j = begin + k * (1 + distance);
                tmp[i][j] = e->data;
                
                // 
                EnQueue(&Q, e->lchild);
                
                // Һ
                EnQueue(&Q, e->rchild);
            }
        }
    }
    
    for(i = 0; i < level; i++) {
        for(j = 0; j < width; j++) {
            if(tmp[i][j] != '\0') {
                printf("%c", tmp[i][j]);
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}
