/*==================
 * ˳洢ṹ
 ===================*/

#ifndef SQBITREE_H
#define SQBITREE_H

#include <stdio.h>
#include <stdlib.h>     // ṩ mallocfree ԭ
#include <string.h>     // ṩ memsetstrcmp ԭ
#include <math.h>       // ṩ pow ԭ
#include "Status.h"     //**01 **//

/* 궨 */
#define MAX_TREE_SIZE 1024       // 

/* ԪͶ壬ԪΪchar */
typedef char TElemType;

/*
 * Ͷ壬0ŵԪ洢㡣
 *
 *ע
 * ڶ˳ṹУԪǰȫ˳Ĳеġ
 */
typedef TElemType SqBiTree[MAX_TREE_SIZE];


/*
 * ʼ
 *
 * ն
 */
Status InitBiTree(SqBiTree T);

/*
 * 
 *
 * ͷŶռڴ档
 *
 *ע
 * ˳洢ṹ޷١
 */
Status DestroyBiTree(SqBiTree T);

/*
 * ÿ
 *
 * еݣʹΪ
 */
Status ClearBiTree(SqBiTree T);

/*
 * 
 *
 * ԤĶ
 * ԼʹáС
 *
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLΪմ
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateBiTree(SqBiTree T, char* path);

/*
 * п
 *
 * ж϶ǷΪ
 */
Status BiTreeEmpty(SqBiTree T);

/*
 * 
 *
 * ضȣ
 */
int BiTreeDepth(SqBiTree T);

/*
 * ȡֵ
 *
 * ضֵָ
 */
TElemType Value(SqBiTree T, TElemType e);

/*
 * ֵ
 *
 * ΪָĽ㸳ֵ
 */
Status Assign(SqBiTree T, TElemType e, TElemType value);

/*
 * 
 *
 * ضĸ㡣
 */
TElemType Root(SqBiTree T);

/*
 * ˫
 *
 * ضнe˫׽㡣
 */
TElemType Parent(SqBiTree T, TElemType e);

/*
 * 
 *
 * ضнeӽ㡣
 */
TElemType LeftChild(SqBiTree T, TElemType e);

/*
 * Һ
 *
 * ضнeҺӽ㡣
 */
TElemType RightChild(SqBiTree T, TElemType e);

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType LeftSibling(SqBiTree T, TElemType e);

/*
 * ֵ
 *
 * ضнeֵܽ㡣
 */
TElemType RightSibling(SqBiTree T, TElemType e);

/*
 * 
 *
 * ֪cΪTཻķǿնcΪգ
 * LRȡֵ(01)cΪTнp/
 * ңpԭе/޽Ϊc
 */
Status InsertChild(SqBiTree T, TElemType p, int LR, SqBiTree c);

/*
 * ɾ
 *
 * LRȡֵ(01)ɾp/
 */
Status DeleteChild(SqBiTree T, TElemType p, int LR);

/*
 * 
 */
Status PreOrderTraverse(SqBiTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status InOrderTraverse(SqBiTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status PostOrderTraverse(SqBiTree T, Status(Visit)(TElemType));

/*
 * 
 */
Status LevelOrderTraverse(SqBiTree T, Status(Visit)(TElemType));


/* ڲʹõĺ */

// ڲ
static void CreateTree(SqBiTree T, int i, FILE* fp);

// ȵڲ
static int TreeDepth(SqBiTree T, int i);

// ضeţiǽp
static int EIndex(SqBiTree T, TElemType e, int i);

// ժ¶TеiΪRj
static void Transfer(SqBiTree T, int i, SqBiTree R, int j);

// ɾTеi
static void Delete(SqBiTree T, int i);

// ڲʵ
static Status PreTraverse(SqBiTree T, Status(Visit)(TElemType), int i);

// ڲʵ
static Status InTraverse(SqBiTree T, Status(Visit)(TElemType), int i);

// ڲʵ
static Status PostTraverse(SqBiTree T, Status(Visit)(TElemType), int i);


/* ͼλ */

// ͼλʽǰṹڲʹ
void PrintTree(SqBiTree T);

#endif
