/*==================
 * ģŶ
 *
 * 㷨: 3.63.7
 ===================*/

#ifndef BANKQUEUING_C
#define BANKQUEUING_C

#include "BankQueuing.h"                //**03 ջͶ**//

/* ȫֱǰ涼gǣ */
int gTotalTime;     // ۼƿͻ
int gCustomerNum;   // ۼƿͻʱ

int gCloseTime;     // ʱ,ÿӪҵ8Сʱ480

EventList gEv;      // ¼洢д¼
Event     gEn;      // ǰڴ¼

LinkQueue gQ[N+1];  // 4ͻ,0ŵԪ


/*
 *  㷨3.6 
 *
 * ҵģ⣬ͳһڿͻжƽʱ
 */
void Bank_Simulation_1()
{
    char eventType;
    
    OpenForDay();                       // п
    
    // ¼Ϊ
    while(MoreEvent()) {
        EventDrived(&eventType);        // ¼
        
        switch(eventType) {
            case 'A':
                CustomerArrived();      // ͻ¼
                break;
            case 'D':
                CustomerDeparture();    // ͻ뿪¼
                break;
            default :
                Invalid();
        }
    }
    
    CloseForDay();
}

/*
 *  㷨3.7 
 *
 * ҵģ⣬ͳһڿͻжƽʱ
 * 㷨3.7Ƶ
 */
void Bank_Simulation_2() {
    OpenForDay();                       // п
    
    while(!ListEmpty(gEv)) {
        ListDelete(gEv, 1, &gEn);
        
        if(gEn.NType == Arrive) {
            CustomerArrived();          // ͻ¼
        } else {
            CustomerDeparture();        // ͻ뿪¼
        }
    }
    
    CloseForDay();                      // й
}

/*
 * пţʼл
 */
void OpenForDay() {
    int i;
    
    // ʱ,ÿӪҵ8Сʱ480
    gCloseTime = 480;
    
    // ʼۼʱͿͻΪ0
    gTotalTime = 0;
    gCustomerNum = 0;
    
    // ʼ¼Ϊձ
    InitList(&gEv);
    
    // 趨һͻ¼
    gEn.OccurTime = 0;
    gEn.NType = Arrive;
    
    // ¼
    OrderInsert(gEv, gEn, cmp);
    
    // ʼ4ն
    for(i = 1; i <= N; ++i) {
        InitQueue(&gQ[i]);
    }
    
    Show();
}

/*
 * й
 *
 * ͷԴӡͳϢ
 */
void CloseForDay() {
    printf("ܹ%dͻƽʱΪ%dӡ\n", gCustomerNum, gTotalTime / gCustomerNum);
}

/*
 * ж¼ǷΪա
 * Ƿδ¼
 */
Status MoreEvent() {
    return !ListEmpty(gEv);
}

/*
 * ¼¼Ƴ¼洢ȫֱgEnС
 * event洢¼
 */
void EventDrived(char* eventType) {
    // ¼лȡ¼
    ListDelete(gEv, 1, &gEn);
    
    // ʶ¼
    if(gEn.NType == Arrive) {
        *eventType = 'A';
    } else {
        *eventType = 'D';
    }
}

/*
 * ͻ¼gEn.NType=0
 */
void CustomerArrived() {
    Event en;               // ¼
    QElemType customer;     // ͻ¼
    
    int durtime;    // ǰͻҵҪʱ
    
    int intertime;  // һͻﵽʱ
    int t;          // һͻʱ
    
    int i;          // б
    
    // ܿͻһ
    ++gCustomerNum;
    
    // ɵǰͻҵҪʱһͻﵽʱ
    Random(&durtime, &intertime);
    
    // һͻʱ
    t = gEn.OccurTime + intertime;
    
    // δţһͻ""¼¼
    if(t < gCloseTime) {
        en.OccurTime = t;   // һͻĵʱ
        en.NType = Arrive;  // ""¼
        OrderInsert(gEv, en, cmp);  // ""¼¼
    }
    
    // ȡǰ̵Ķб
    i = Minimum();
    
    // ¼ǰͻϢ
    customer.ArrivedTime = gEn.OccurTime;   // ʱ
    customer.Duration = durtime;            // ҵʱ
    customer.Count = gCustomerNum;          // ͻ
    
    // ǰͻ̶Ŷ
    EnQueue(&gQ[i], customer);
    printf("%3dͻ̨ %d Ŷ...\n", customer.Count, i);
    Show();
    
    /*
     * ǰֻһͻŶӣҪ뿪ʱ䣬
     * һ"뿪"¼뵽¼
     */
    if(QueueLength(gQ[i]) == 1) {
        en.OccurTime = gEn.OccurTime + durtime; // ǰͻ뿪ʱ
        en.NType     = i;                       // "뿪"¼ֵͣΪ1-4ָʾӵڼ뿪
        OrderInsert(gEv, en, cmp);  // "뿪"¼¼
    }
}

/*
 * ͻ뿪¼gEn.NType>0
 */
void CustomerDeparture() {
    Event en;               // ¼
    QElemType customer;     // ͻ¼
    int i = gEn.NType;      // б
    
    // iеĶͷͻҵ񲢳
    DeQueue(&gQ[i], &customer);
    printf("%3dͻӹ̨ %d 뿪...\n", customer.Count, i);
    Show();
    
    // ۼƿͻʱ
    gTotalTime += gEn.OccurTime - customer.ArrivedTime;
    
    /*
     * ǰȻŶӵĿͻҪöжͷͻ뿪ʱ
     * ע֮㣬Ϊֻһͻ뿪ˣһͻ뿪ʱŻ
     */
    if(!QueueEmpty(gQ[i])) {
        // ȡͷͻ
        GetHead(gQ[i], &customer);
        en.OccurTime = gEn.OccurTime + customer.Duration;   // "뿪"¼ʱ
        en.NType     = i;                                   // "뿪"¼
        OrderInsert(gEv, en, cmp);  // "뿪"¼¼
    }
}

/*
 * Ч¼
 */
void Invalid() {
    printf("д");
    exit(OVERFLOW);
}

/*
 * ¼en뵽¼evУevǰʱ絽е¼
 * cmpȽ¼enΪڶʵδȥ
 */
Status OrderInsert(EventList ev, Event en, int(cmp)(Event, Event)) {
    EventList p, pre, s;
    
    if(ev == NULL) {
        return ERROR;
    }
    
    for(pre = ev; pre->next != NULL && cmp(pre->next->data, en) < 0; pre = pre->next) {
        // 
    }
    
    s = (LinkList) malloc(sizeof(LNode));
    if(s == NULL) {
        exit(OVERFLOW);
    }
    s->data = en;
    
    s->next = pre->next;
    pre->next = s;
    
    return OK;
}

/*
 * Ƚ¼
 */
int cmp(Event a, Event b) {
    if(a.OccurTime < b.OccurTime) {
        return -1;      // aȽ
    } else if(a.OccurTime > b.OccurTime) {
        return 1;       // aȽ
    } else {
        return 0;       // ͬʱ
    }
}

/*
 * 
 *
 * durtime  ǰͷҵʱ
 * intertimeһͻʱ
 */
void Random(int* durtime, int* intertime) {
    srand((unsigned) time(NULL));
    *durtime = rand() % DurationTime + 1;       // ҵʱ120
    *intertime = rand() % IntervalTime + 1;     // һ˿͵ʱΪ110
}

/*
 * س̵Ķе
 */
int Minimum() {
    int i1 = QueueLength(gQ[1]);
    int i2 = QueueLength(gQ[2]);
    int i3 = QueueLength(gQ[3]);
    int i4 = QueueLength(gQ[4]);
    
    if(i1 <= i2 && i1 <= i3 && i1 <= i4) {
        return 1;
    }
    
    if(i2 < i1 && i2 <= i3 && i2 <= i4) {
        return 2;
    }
    
    if(i3 < i1 && i3 < i2 && i3 <= i4) {
        return 3;
    }
    
    if(i4 < i1 && i4 < i2 && i4 < i3) {
        return 4;
    }
    
    return 0;
}

/*
 * ʾпͻеŶ
 */
void Show() {
    int i;
    QueuePtr p;     // ¼Ŀͻǵڼ
    
    // пͻ
    for(i = 1; i <= N; i++) {
        for(p = gQ[i].front; p; p = p->next) {
            if(p == gQ[i].front) {
                if(i == 1) {
                    printf("̨š");
                }
                if(i == 2) {
                    printf("̨ơ");
                }
                if(i == 3) {
                    printf("̨ǡ");
                }
                if(i == 4) {
                    printf("̨ȡ");
                }
            } else {
                printf("%03d", p->data.Count);
            }
            
            
            if(p == gQ[i].rear) {
                printf("\n");
            }
        }
    }
    
    printf("\n");
    
    Wait(SleepTime);
}

#endif
