/*=======================
 * չĵ
 *
 * 㷨: 2.20
 ========================*/

#include "ELinkList.h"  //**02 Ա**//


/* ڴ */

/*
 * ڴ
 *
 * Ϊһ㣬ָe
 *
 *ע
 * staticεĺǸú޵ǰļʹ
 */
Status MakeNode(Link* p, ElemType e) {
    if(p == NULL) {
        return ERROR;
    }
    
    // ռ
    *p = (Link) malloc(sizeof(LNode));
    if(*p == NULL) {
        // û˳򣬶Ƿشʾ
        return ERROR;
    }
    
    (*p)->data = e;
    (*p)->next = NULL;
    
    return OK;
}

/*
 * ڴ
 *
 * ͷָĽ㡣
 *
 *ע
 * staticεĺǸú޵ǰļʹ
 */
void FreeNode(Link* p) {
    if(p == NULL || *p == NULL) {
        return;
    }
    
    free(*p);
    
    *p = NULL;
}


/*  */

/*
 * ʼ
 *
 * ʼɹ򷵻OK򷵻ERROR
 */
Status InitList(ELinkList* L) {
    Link p;
    
    if(L == NULL) {
        return ERROR;
    }
    
    // ͷ
    p = (Link) malloc(sizeof(LNode));
    if(p == NULL) {
        exit(OVERFLOW);
    }
    p->next = NULL;
    
    // ֻͷʱλαָ
    (*L).head = (*L).tail = p;
    (*L).len = 0;
    
    return OK;
}

/*
 * (ṹ)
 *
 * ͷռڴ档
 */
Status DestroyList(ELinkList* L) {
    
    // ʱûҪ
    if(L == NULL || (*L).head == NULL) {
        return ERROR;
    }
    
    ClearList(L);
    
    free((*L).head);
    
    (*L).head = (*L).tail = NULL;
    
    return OK;
}

/*
 * ÿ()
 *
 * Ҫͷзͷ㴦Ŀռ䡣
 */
Status ClearList(ELinkList* L) {
    Link p, q;
    
    // ûЧԪʱҪ
    if(L == NULL || (*L).head == NULL || (*L).len <= 0) {
        return ERROR;
    }
    
    // ָ1Ԫ
    p = (*L).head->next;
    
    // ͷԪռڴ
    while(p != NULL) {
        q = p->next;
        free(p);
        p = q;
    }
    
    (*L).head->next = NULL;
    (*L).tail = (*L).head;
    (*L).len = 0;
    
    return OK;
}

/*
 * п
 *
 * жǷЧݡ
 *
 * ֵ
 * TRUE : Ϊ
 * FALSE: Ϊ
 */
Status ListEmpty(ELinkList L) {
    if(L.len <= 0) {
        return TRUE;
    } else {
        return FALSE;
    }
}

/*
 * 
 *
 * ЧԪص
 */
int ListLength(ELinkList L) {
    return L.len;
}

/*
 * 
 *
 * ׸eCompareϵԪá
 * Ԫأ򷵻NULL
 *
 *ע
 * 1.ԪeCompareڶβ
 * 2.ķֵĿԪصãλ
 */
Position LocateElem(ELinkList L, ElemType e, Status(Compare)(ElemType, ElemType)) {
    Position p;
    
    if(L.len <= 0) {
        return NULL;
    }
    
    // ָ1Ԫ
    p = L.head->next;
    
    while(p != NULL && !Compare(p->data, e)) {
        p = p->next;
    }
    
    return p;
}

/*
 *  㷨2.20 
 *
 * 
 *
 * iλϲeɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 * Կ㷨2.9ĸд
 */
Status ListInsert(ELinkList* L, int i, ElemType e) {
    Link h, s;
    
    if(L == NULL || (*L).head == NULL) {
        return ERROR;
    }
    
    // ȷiֵϹ[1, len+1]
    if(i < 1 || i > (*L).len + 1) {
        return ERROR;
    }
    
    // ҵi-1Ԫصã洢h
    if(LocatePos(*L, i - 1, &h) == ERROR) {
        return ERROR;
    }
    
    // ½s
    if(MakeNode(&s, e) == ERROR) {
        return ERROR;
    }
    
    // s뵽h棬Ϊhĵһ
    if(InsFirst(L, h, s) == ERROR) {
        return ERROR;
    }
    
    return OK;
}

/*
 * ɾ
 *
 * ɾiλϵԪأɾԪش洢eС
 * ɾɹ򷵻OK򷵻ERROR
 *
 *ע
 * ̲iĺԪλã1ʼ
 * Կ㷨2.10ĸд
 */
Status ListDelete(ELinkList* L, int i, ElemType* e) {
    Link h, q;
    
    if(L == NULL || (*L).head == NULL) {
        return ERROR;
    }
    
    // ȷiֵϹ[1, len]
    if(i < 1 || i > (*L).len) {
        return ERROR;
    }
    
    // ҵi-1Ԫصã洢h
    if(LocatePos(*L, i - 1, &h) == ERROR) {
        return ERROR;
    }
    
    // ɾhĵһ㣬q洢ɾ
    if(DelFirst(L, h, &q) == ERROR) {
        return ERROR;
    }
    
    // ±ɾԪصֵ
    *e = q->data;
    
    // ͷűɾĿռ
    FreeNode(&q);
    
    return OK;
}

/*
 * 
 *
 * visitL
 */
void ListTraverse(ELinkList L, void(Visit)(ElemType)) {
    Link p;
    
    if(L.len <= 0) {
        return;
    }
    
    // ָ1Ԫ
    p = L.head->next;
    
    while(p != NULL) {
        Visit(p->data);
        p = p->next;
    }
    
    printf("\n");
}


/* չ */

/*
 * ȡֵ
 *
 * ȡpԪֵ
 */
ElemType GetCurElem(Link p) {
    if(p == NULL) {
        return INT_MIN;
    }
    
    return p->data;
}

/*
 * ֵ
 *
 * ΪpԪֵ
 */
Status SetCurElem(Link p, ElemType e) {
    if(p == NULL) {
        return ERROR;
    }
    
    p->data = e;
    
    return OK;
}

/*
 * ͷ
 *
 * ȡͷá
 */
Position GetHead(ELinkList L) {
    return L.head;
}

/*
 * β
 *
 * ȡβá
 */
Position GetLast(ELinkList L) {
    return L.tail;
}

/*
 * ǰ
 *
 * ȡpǰڣ򷵻NULL
 */
Position PriorPos(ELinkList L, Link p) {
    Link pre;
    
    // ȷ(ͷ)
    if(L.head == NULL) {
        return NULL;
    }
    
    if(p == NULL) {
        return NULL;
    }
    
    // ָͷ
    pre = L.head;
    
    // һǰ
    if(pre->next == p) {
        return NULL;
    }
    
    // Pǰ
    while(pre != NULL && pre->next != p) {
        pre = pre->next;
    }
    
    return pre;
}

/*
 * 
 *
 * ȡpḷ́ڣNULL
 */
Position NextPos(ELinkList L, Link p) {
    
    // ȷ(ͷ)
    if(L.head == NULL) {
        return NULL;
    }
    
    if(p == NULL) {
        return NULL;
    }
    
    return p->next;
}

/*
 * 
 *
 * Lеi(Ϊ0)㣬ôpҷOK
 * iֵϹ棬򷵻ERROR
 * رע⣬iΪ0ʱp洢ͷ
 */
Status LocatePos(ELinkList L, int i, Link* p) {
    int j;
    Link r;
    
    // עiΪ0
    if(i < 0 || i > L.len) {
        return ERROR;
    }
    
    // ֤(ͷ)
    if(L.head == NULL) {
        return ERROR;
    }
    
    // iΪ0ʱȡͷ
    if(i == 0) {
        *p = L.head;
        return OK;
    }
    
    j = 0;         // 
    r = L.head;    // ָͷ
    
    while(r != NULL && j < i) {
        j++;
        r = r->next;
    }
    
    if(r == NULL) {
        return ERROR;
    }
    
    *p = r;
    
    return OK;
}

/*
 * 
 *
 * s뵽h棬Ϊhĵһ
 *
 *ע
 * ̲жڸ÷Щ⣬İ汾
 */
Status InsFirst(ELinkList* L, Link h, Link s) {
    if(L == NULL || (*L).head == NULL || h == NULL || s == NULL) {
        return ERROR;
    }
    
    s->next = h->next;
    h->next = s;
    
    // hΪβ㣬Ҫβ
    if(h == (*L).tail) {
        (*L).tail = h->next;
    }
    
    (*L).len++;
    
    return OK;
}

/*
 * ɾ
 *
 * ɾhĵһ㣬q洢ɾ
 *
 *ע
 * ̲жڸ÷ĶԴֲڣİ汾
 */
Status DelFirst(ELinkList* L, Link h, Link* q) {
    if(L == NULL || (*L).head == NULL || h == NULL || q == NULL) {
        return ERROR;
    }
    
    // ûнɾشϢ
    if(h->next == NULL) {
        return ERROR;
    }
    
    *q = h->next;
    
    h->next = (*q)->next;
    
    // ɾɹĽ
    (*q)->next = NULL;
    
    // hֻһ㣬βָ
    if(h->next == NULL) {
        (*L).tail = h;
    }
    
    // ͷűɾռռ
    (*L).len--;
    
    return OK;
}

/*
 * ǰ
 *
 * s뵽p֮ǰpָ½
 */
Status InsBefore(ELinkList* L, Link* p, Link s) {
    Link pre;
    
    if(L == NULL || (*L).head == NULL || p == NULL || s == NULL) {
        return ERROR;
    }
    
    // ָͷ
    pre = (*L).head;
    
    // pĹǰڵһԪأǰΪͷ
    while(pre != NULL && pre->next != (*p)) {
        pre = pre->next;
    }
    
    // ûҵǰ
    if(pre == NULL) {
        return ERROR;
    }
    
    s->next = *p;
    pre->next = s;
    *p = s;
    
    (*L).len++;                            //޸lenõ*L
    
    return OK;
}

/*
 * 
 *
 * s뵽p֮ǰpָ½
 */
Status InsAfter(ELinkList* L, Link* p, Link s) {
    Link r;
    
    if(L == NULL || (*L).head == NULL || p == NULL || s == NULL) {
        return ERROR;
    }
    
    r = (*L).head;
    
    while(r != NULL && r != (*p)) {
        r = r->next;
    }
    
    // δҵpشϢ
    if(r == NULL) {
        return ERROR;
    }
    
    // pָһ㣬Ҫβָ
    if(*p == (*L).tail) {
        (*L).tail = s;
    }
    
    s->next = (*p)->next;
    (*p)->next = s;
    *p = s;
    
    (*L).len++;
    
    return OK;
}

/*
 * β
 *
 * sָһL
 */
Status Append(ELinkList* L, Link s) {
    int count;
    
    if(L == NULL || (*L).head == NULL || s == NULL) {
        return ERROR;
    }
    
    count = 0;
    (*L).tail->next = s;
    
    // ȷµβλ
    while(s != NULL) {
        (*L).tail = s;
        s = s->next;
        count++;
    }
    
    (*L).len += count;
    
    return OK;
}

/*
 * βƳ
 *
 * βƳƳĽô洢q
 */
Status Remove(ELinkList* L, Link* q) {
    Link p;
    
    if(L == NULL || (*L).head == NULL || q == NULL) {
        return ERROR;
    }
    
    // ûԪؿɹƳ
    if((*L).len == 0) {
        *q = NULL;
        return ERROR;
    }
    
    *q = (*L).tail;
    
    // ȷµβλ
    p = (*L).head;
    while(p->next != (*L).tail) {
        p = p->next;
    }
    p->next = NULL;
    (*L).tail = p;
    
    (*L).len--;
    
    return OK;
}
