/*==============
 * ϵͳ
 *
 * 㷨: 8.2
 ===============*/

#include "BuddySystem.h"

// ¼ڴʼַڼʱҪõ
WORD* start;


/*
 * ʼһСΪ2^Mֵڴ棬ָڴָ
 * עصĳʼڴѾhead
 */
void InitSpace(FreeList avail) {
    int k;
    WORD* r;

    // M+1Ԫ
    for(k = 0; k <= M; k++) {
        avail[k].nodesize = (int) pow(2, k);
        avail[k].first = NULL;
    }

    r = (WORD*) malloc((int) pow(2, M) * sizeof(WORD));
    if(r == NULL) {
        exit(OVERFLOW);
    }

    // ͷϢ
    r->llink = r->rlink = r;
    r->tag = 0;
    r->kval = M;

    avail[M].first = r;

    start = r;
}

/*
 *  㷨8.2 
 *
 * ϵͳڴ㷨
 *
 * ӿռavailһСΪn(ԭʼֵ)Ŀռ䣬ָ뵽Ŀռָ롣ʧܣ򷵻NULL
 *
 * ע
 * 1.״Ϸһڴͽз
 * 2.nֵĿռ䣬ָûԭʼռ䡣
 *   ʵʱҪǵÿǰ1ֵheadϢʵҪ(n+1)֡
 *   n㷨8.1n෴Ҫע⡣
 */
WORD* AllocBuddy(FreeList avail, int n) {
    int k, i;
    WORD* pa, * pre, * suc, * pi;

    /*
     * һжϣĿռС1ֱӷء
     */
    if(n < 1) {
        printf("־ʧܣ\"\"ӦС1\n");
        return NULL;
    }

    // ҲСnĿп
    for(k = 0; k <= M && (avail[k].nodesize < n + 1 || !avail[k].first); k++) {
    }

    // ҲʵĿп飬ؿָ
    if(k > M) {
        printf("־ʧܣû㹻Ŀп\n");
        return NULL;
    }

    pa = avail[k].first; // ָɷӱĵһ
    pre = pa->llink;     // ֱǰͺ
    suc = pa->rlink;

    // ˴һп飬ӱΪ
    if(pa == suc) {
        avail[k].first = NULL;

        // 򣬴ͷժһõĿп飬ӱͷָָһп
    } else {
        pre->rlink = suc;
        suc->llink = pre;
        avail[k].first = suc;
    }

    /*
     * k-1ʼFreeList飬ʣĿп顣
     * ʣĿпǶʣÿռĲ֡
     *
     * õһʽ2^m-2^n = 2^n+2^(n+1)+...+2^(m-1)
     * ʼΪ2^16ʱܹ1500֣ôҪһ2^11Ŀп
     * ֮ʣΪ2^16-2^11 = 2^11+2^12+2^13+2^14+2^15
     * ЩʣԲΪ5п飬ֱ洢1514131211
     */
    for(i = 1; k - i >= 0 && avail[k - i].nodesize >= n + 1; i++) {
        pi = pa + (int) pow(2, k - i);  // ÿνpiָʣռĺһ
        pi->rlink = pi->llink = pi;     // ʼpiǰͺ
        pi->tag = 0;                    // Ϊп
        pi->kval = k - i;               // øÿ־ʵΪ2^(k-i)
        avail[k - i].first = pi;

        /*
         * ע
         * ֽpiֱӵavailУûпͬλô᲻бͬĿп顣
         * ﲻҪǵԭͬλôѾڱͬĿп飬
         * ôҪֽʣռ䣬仰˵ѭ
         * ֻҪѭ˵ĿλôѾΪˣûҵʵĿп飬Žһα괦Ѱҿп顣
         */
    }

    // ʣµǰĿռҪĿռ(ûpaǰͺ̣ΪûҪ)
    pa->tag = 1;
    pa->kval = k - (--i);

    printf("־ɹû %d ֣ϵͳ %d ֣ʵʷ %d \n", n, n + 1, (int) pow(2, pa->kval));

    return pa;
}

/*
 * ϵͳڴ㷨
 *
 * ָpڴͷ(free()ֻǶڴͷŲÿָpĲӦ÷)
 *
 * עû֤pȡֵ÷ӦȷpںϹķΧ
 */
void FreeBuddy(FreeList avail, WORD* p) {
    int k;
    WORD* r;
    WORD* buddy = Buddy(p);

    if(p == NULL) {
        return;
    }

    /*
     * ｫp򵥵ز뵽availУΣ
     * 1.ǿ
     * 2.УǻĴСpĴСһ£˵黹ûƴϺ
     * 3.pƴӳһĿп
     */
    if(buddy->tag == 1 || buddy->kval != p->kval || p->kval == M) {
        for(k = 0; k <= M && k < p->kval; k++) {
            // pӦĲ
        }

        // ҵۣͷ巨п뵽Ŀ
        if(k <= M && k == p->kval) {
            p->tag = 0;

            if(avail[k].first == NULL) {
                p->llink = p->rlink = p;
            } else {
                p->llink = avail[k].first->llink;
                p->rlink = avail[k].first;
                p->llink->rlink = p;
                p->rlink->llink = p;
            }

            avail[k].first = p;

            printf("־ճɹ[%d, (2^%d)] %d Ŀп\n", (int) (p - start), k, k);
        }

        // ǿеģʱӦкϲ
    } else {
        for(k = 0; k <= M && k < p->kval; k++) {
            // һڵĲ
        }

        // ҵۣӿпժ
        if(k <= M && k == p->kval) {
            // һλ
            if(avail[k].first == buddy) {
                buddy->rlink->llink = buddy->llink;
                buddy->llink->rlink = buddy->rlink;

                avail[k].first = buddy->rlink;

                // мλ
            } else {
                for(r = avail[k].first; r->rlink != buddy; r = r->rlink) {
                    // һ飬rָǰ
                }

                r->rlink = buddy->rlink;
                buddy->rlink->llink = r;
            }

            printf("־ϲɹ[%d, (2^%d)][%d, (2^%d)]ϲ", (int) (p - start), k, (int) (buddy - start), k);

            // ϲ֮ǰҪȷĸ鿿ǰ
            if(p < buddy) {
                p->tag = 0;
            } else {
                p = buddy;
            }

            p->kval = k + 1;  // ָһ󣬼ɺϲ

            printf("[%d, (2^%d)]\n", (int) (p - start), k + 1);

            // µĿп֮Ҫݹ飬鿴ÿпǷҲڿл
            FreeBuddy(avail, p);
        }
    }
}

/*
 * ӡڴ沼֣鿴ǰڴʹ
 * עڲʹ
 */
void PrintMemoryLayout() {
    int i, count, total;
    WORD* p;

    printf("|");

    p = start;
    count = (int) pow(2, p->kval);

    for(i = 1; i <= count; i++) {
        if(p->tag == 0) {
            printf("_");
        } else {
            printf("*");
        }

        // 뵽һ
        if(i == count && count < (int) pow(2, M)) {
            p = start + count;
            count += (int) pow(2, p->kval);
            printf("|");
        }
    }

    printf("|\n");
}

/*
 * ҿpĻ
 *
 * һп԰Ѻ󣬻ɵСп飬Сп黥Ϊ顣
 *
 * 㷨Ϊ
 * ʼַΪpСΪ2^kڴ飺
 * 1. p MOD 2^(k+1) == 0   ,pĻʼַΪp+2^k
 * 2. p MOD 2^(k+1) == 2^k ,pĻʼַΪp-2^k
 *
 * עڲʹãڻ㷨
 */
static WORD* Buddy(WORD* p) {
    long s, m, n;

    if(p == NULL) {
        return NULL;
    }

    // startпľʼַspڻϵͳеľԵַ0ʼ
    s = p - start;
    if(s < 0) {
        return NULL;
    }

    m = (long) pow(2, p->kval);
    n = (long) pow(2, p->kval + 1);

    if(s % n == 0) {
        return p + m;
    }

    if(s % n == m) {
        return p - m;
    }

    return NULL;
}

