#include <stdio.h>
#include "Status.h"
#include "SqStack.h"

/* 궨 */
#define MAXSIZE 200 // ڴܴС


/* пռͶ */
typedef struct {
    void* base;     // ÿռڴʼַ
    int size;       // пռС(ֽڼ)
    SqStack block;  // ѾʹõڴСڴϢջ
} Space;


// ʼڴռ估ڴϢջ
void InitSpace(Space* space);

// ӡڴ沼֣鿴ǰڴʹ
void PrintMemoryLayout(Space space);

// СΪnڴ飬뵽ڴʼַ
void* Algo_8_11(Space* space, int n);

// ڴ棬ѭ"ͷ"ԭ
Status Algo_8_12(Space* space);


int main(int argc, char* argv[]) {
    Space space;
    int s[5] = {50, 50, 150, 100, 50}; // ڴ
    int i;

    // ʼڴ
    InitSpace(&space);
    PrintMemoryLayout(space);
    printf("\n");

    // /ͷڴ
    for(i = 0; i < 5; i++) {
        printf(" %d ڴ...\n", s[i]);
        Algo_8_11(&space, s[i]);
        PrintMemoryLayout(space);
        printf("\n");
    }

    return 0;
}


// ʼһпռ
void InitSpace(Space* space) {
    // MAXֽڵĿռ(ܳʼɹ)
    space->base = malloc(MAXSIZE);
    space->size = MAXSIZE;

    // ʼڴϢջ
    InitStack(&(space->block));
}

// ӡڴ沼֣鿴ǰڴʹ
void PrintMemoryLayout(Space space) {
    int i;

    for(i = 1; i <= MAXSIZE; i++) {
        if(i <= space.size) {
            printf("");
        } else {
            printf("");
        }

        // Ԥÿ20һ
        if(i % 20 == 0) {
            printf("\n");
        }
    }

    if(MAXSIZE % 20 != 0) {
        printf("\n");
    }
}

// СΪnڴ飬뵽ڴʼַ
void* Algo_8_11(Space* space, int n) {

    /*
     * õڴڴ
     * Ҫͷʹõڴڳռ䡣
     */
    while(space->size < n && Algo_8_12(space) == OK) {
        // ֱڴҪ󣬻ȫռڴѾͷţŻ˳ѭ
    }

    // û㹻ڴã򷵻ؿָ
    if(space->size < n) {
        return NULL;
    }

    // ÿռС
    space->size -= n;

    // ³ɹ뵽ڴ
    Push(&(space->block), n);

    // 뵽ڴʼַ
    return space->base + space->size;
}

// ڴ棬ѭ"ͷ"ԭ
Status Algo_8_12(Space* space) {
    int e;

    // ѾûпͷڴʱERROR
    if(StackEmpty(space->block)) {
        return ERROR;
    }

    // ڴͷŵ
    Pop(&(space->block), &e);

    // ÿռ
    space->size += e;

    return OK;
}

