/*==================
 * ͼڽӱ洢ʾ
 ===================*/

#include "ALGraph.h"

// ¼ݵԴļfpΪnullʱ˵Ҫӿ̨¼
static FILE* fp = NULL;

/*
 * IncInfoָʾͼ/ı/ǷڸϢ
 * ֵΪ0ʾ޸Ϣ򣬱ʾڸϢ
 */
Boolean IncInfo = FALSE;

// ʱ־飬¼ʹĶ
static Boolean visited[MAX_VERTEX_NUM];

// 
static Status (* VisitFunc)(VertexType e);

// 붥һһӦĲ
char ops[MAX_VERTEX_NUM];


/*
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(ALGraph* G, char* path[]) {
    int readFromConsole;    // Ƿӿ̨ȡ
    int kind;
    Status flag;
    
    // ˴̶Ϊͼ
    kind = 0;
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = (path == NULL) || strcmp(path[kind], "") == 0;
    
    // Ҫļȡ
    if(readFromConsole) {
        (*G).kind = GraphKind(kind);   // ¼ͼ/
    } else {
        // ļ׼ȡ
        fp = fopen(path[kind], "r");
        if(fp == NULL) {
            return ERROR;
        }
        
        // ¼ͼ
        ReadData(fp, "%d", &((*G).kind));
    }
    
    // ͼ/ͼ/һ
    switch((*G).kind) {
        case DG:
            flag = CreateDG(G);
            break;
        default:
            flag = ERROR;
            break;
    }
    
    if(fp != NULL) {
        fclose(fp);
        fp = NULL;
    }
    
    return flag;
}

/*
 * ͼ
 */
static Status CreateDG(ALGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).arcnum = 0;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &vexnum);
        printf("ͼĻ");
        scanf("%d", &arcnum);
        printf("ͼĻǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).vertices[i].data));
            (*G).vertices[i].firstarc = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum);    // ¼붥
        ReadData(fp, "%d", &arcnum);    // ¼뻡
        ReadData(fp, "%d", &IncInfo);   // жϻǷϢ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).vertices[i].data));
            (*G).vertices[i].firstarc = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊͼ¼ %d Ϣ֮ÿո\n", arcnum);
    }
    
    // ¼뻡Ϣ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼뻡Ϣ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &info);
        }
        
        // 뻡<v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ¼붥ӦĲ
    if(fp == NULL) {
        printf("¼ %d 붥һһӦĲ/ͬ/֮ÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &(ops[i]));
        }
    } else {
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &(ops[i]));
        }
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ¼/ظϢ
 */
static void Input(ALGraph G, InfoType** info) {
    int weight;
    
    // ""Ҫ¼ȨֵϢ
    if(G.kind == DN || G.kind == UDN) {
        *info = (InfoType*) malloc(sizeof(InfoType));
        
        if(fp == NULL) {
            scanf("%d", &weight);
        } else {
            ReadData(fp, "%d", &weight);
        }
        
        (*info)->weight = weight;
    }
}

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(ALGraph G, VertexType u) {
    int i;
    
    for(i = 0; i < G.vexnum; i++) {
        if(G.vertices[i].data == u) {
            return i;
        }
    }
    
    return -1;
}

/*
 * һ/(ڲʹ)
 */
static ArcNode* newArcNodePtr(int adjvex, ArcNode* nextarc, InfoType* info) {
    ArcNode* p = (ArcNode*) malloc(sizeof(ArcNode));
    if(!p) {
        exit(OVERFLOW);
    }
    
    p->adjvex = adjvex;
    
    p->nextarc = nextarc;
    
    p->info = info;
    
    return p;
}

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 * ͼ/˵ڿɱг/ĸϢ
 *
 * ע˴յĲMGraphЩһĸϢа˸/Ȩֵ
 */
Status InsertArc(ALGraph* G, VertexType v, VertexType w, ...) {
    int tail, head, k, count;
    ArcNode* r;
    ArcNode* pre;
    Boolean overlay = FALSE;    // ǷΪ
    InfoType* info = NULL;      // /ĸϢ
    va_list ap;
    
    tail = LocateVex(*G, v); // ȡvڶ㼯еλ
    if(tail == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    head = LocateVex(*G, w); // ȡwڶ㼯еλ
    if(head == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    // ܾ
    if(tail == head) {
        return ERROR;
    }
    
    // /ϴڸϢ
    if(IncInfo) {
        va_start(ap, w);                // wѯ׸ɱ
        info = va_arg(ap, InfoType*);   // ȡϢ
        va_end(ap);
    }
    
    /* ҪҺʵĲλ */
    
    for(count = 0; count < 2; count++) {
        pre = NULL;
        // ָtailΪβ/
        r = G->vertices[tail].firstarc;
        while(r != NULL && r->adjvex < head) {
            pre = r;
            r = r->nextarc;
        }
        
        // ͬλõĽ
        if(r != NULL && r->adjvex == head) {
            r->info = info; // øý
            overlay = TRUE; // ˸
        } else {
            if(pre == NULL) {
                G->vertices[tail].firstarc = newArcNodePtr(head, r, info);
            } else {
                pre->nextarc = newArcNodePtr(head, r, info);
            }
        }
        
        // ǰͼ/ģҪǶԳ
        if((G->kind == UDG || G->kind == UDN) && tail != head) {
            // ߵij
            k = tail;
            tail = head;
            head = k;
        } else {
            break;  // ģԽ
        }
    }
    
    // ڷǸǵ£ſǸ±/
    if(!overlay) {
        (*G).arcnum++;  // 򣬱/ֻһ
    }
    
    return OK;
}

/*
 * ͼλʽǰṹ
 */
void PrintGraph(ALGraph G) {
    int i;
    ArcNode* p;
    
    if(G.vexnum == 0) {
        printf("ͼӡ\n");
        return;
    }
    
    printf("ǰͼ/ %2d 㣬 %2d /...\n", G.vexnum, G.arcnum);
    
    for(i = 0; i < G.vexnum; i++) {
        printf("%c ===> ", G.vertices[i].data);
        
        p = G.vertices[i].firstarc;
        while(p != NULL) {
            if(IncInfo == 0) {
                printf("%c ", G.vertices[p->adjvex].data);
                
                // 丽ϢлȡȨֵ
            } else {
                printf("%c[%2d] ", G.vertices[p->adjvex].data, p->info->weight);
            }
            
            p = p->nextarc;
            
            if(p != NULL) {
                printf("- ");
            }
        }
        
        printf("\n");
    }
}
