/*====================
 * ͼʮ洢ʾ
 *
 * 㷨: 7.3
 ====================*/

#ifndef OLGRAPH_H
#define OLGRAPH_H

#include <stdio.h>
#include <string.h>     // ṩmemsetstrcmp ԭ
#include <stdarg.h>     // ṩva_listva_startva_argva_end
#include <stdlib.h>     // ṩmallocreallocfreeexitԭ
#include "Status.h"     //**01 **//

/*
 * ע
 *
 * ͨȨͼΪͼȨͼΪ
 * ͼ/еĶϵΪߡͼ/еĶϵΪֻͷ뻡β
 * ʵʱУδػϸ
 *
 * ǰṹʺϴ洢ͼ
 *
 *  /Ϣʱʵǰ""ģʹòĻǰ""еġ
 */


/* 궨 */
#define MAX_VERTEX_NUM 26   // 󶥵


// ͼ
typedef enum {
    DG,     // 0-ͼ
    DN,     // 1-(Ȩֵ)
    UDG,    // 2-ͼ
    UDN     // 3-(Ȩֵ)
} GraphKind;

// 
typedef char VertexType;

// /ظϢ
typedef struct {
    /*
     * ע
     * ̲иĽṹֻȨͼûȨͼ()
     * Ϊ˰ѡҲǽȥڸϢ"Ȩ"ԡ
     */
    int weight;
} InfoType;

/* / */
typedef struct ArcBox {
    int tailvex;    // ͷλ
    int headvex;    // βλ
    struct ArcBox* hlink;  // ָһӵͬͷĻ
    struct ArcBox* tlink;  // ָһӵͬβĻ
    InfoType* info;  // ûظϢ
} ArcBox;

// ÿͷ
typedef struct VexNode {
    VertexType data;    // 
    ArcBox* firstin;    // ָöĵһ뻡
    ArcBox* firstout;   // ָöĵһ
} VexNode;

/* ͼʮ洢ʾͶ */
typedef struct {
    VexNode xlist[MAX_VERTEX_NUM];  // ͷ
    int vexnum, arcnum;             // ͻ
    GraphKind kind;                 // ͼͱ־
} OLGraph;


// /ǷڸϢ
extern Boolean IncInfo;


/*
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(OLGraph* G, char* path[]);

/*
 *  㷨7.3 
 *
 * ͼ
 *
 * ע
 * ̲ʹͷ巨뻡Ψһŵǲ뷽㣬
 * 漰ɾʱЧʽϵͣ
 * ң"ͷ巨"˳ı/ģ
 * չͼ/еı/Ҳġ
 *
 * Ϊ˿˷ȱ㣬""뷨֤Ļ""ġ
 * ͬʱʹ""㷨ýΪӡ
 */
static Status CreateDG(OLGraph* G);

/*
 * ¼뻡ظϢ
 */
static void Input(OLGraph G, InfoType** info);

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(OLGraph G, VertexType u);

/*
 * ȡֵ
 *
 * vĶֵ
 */
VertexType GetVex(OLGraph G, int v);

/*
 * ׸ڽӵ
 *
 * ضv׸ڽӵ
 */
int FirstAdjVex(OLGraph G, VertexType v);

/*
 * һڽӵ
 *
 * ضv(w)һڽӵ
 */
int NextAdjVex(OLGraph G, VertexType v, VertexType w);

/*
 * һ/(ڲʹ)
 */
static ArcBox* newArcBoxPtr(int tailvex, int headvex, ArcBox* hlink, ArcBox* tlink, InfoType* info);

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 * ͼ/˵ڿɱг/ĸϢ
 *
 * ע˴յĲMGraphЩһĸϢа˸/Ȩֵ
 */
Status InsertArc(OLGraph* G, VertexType v, VertexType w, ...);

/*
 * ȱ(˴ݹʵ)
 */
void DFSTraverse(OLGraph G, Status(Visit)(VertexType));

/*
 * ȱĺ
 */
static void DFS(OLGraph G, int v);

/*
 * ͼλʽǰṹ
 */
void PrintGraph(OLGraph G);

#endif
