/*====================
 * ͼʮ洢ʾ
 *
 * 㷨: 7.3
 ====================*/

#include "OLGraph.h"

// ¼ݵԴļfpΪnullʱ˵Ҫӿ̨¼
static FILE* fp = NULL;

/*
 * IncInfoָʾͼıǷڸϢ
 * ֵΪ0ʾ޸Ϣ򣬱ʾڸϢ
 */
Boolean IncInfo = FALSE;

// ʱ־飬¼ʹĶ
static Boolean visited[MAX_VERTEX_NUM];

// 
static Status (* VisitFunc)(VertexType e);


/*
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(OLGraph* G, char* path[]) {
    int readFromConsole;    // Ƿӿ̨ȡ
    int kind;
    Status flag;
    
    // ˴̶Ϊͼ
    kind = 0;
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = (path == NULL) || strcmp(path[kind], "") == 0;
    
    // Ҫļȡ
    if(readFromConsole) {
        (*G).kind = GraphKind(kind);   // ¼ͼ/
    } else {
        // ļ׼ȡ
        fp = fopen(path[kind], "r");
        if(fp == NULL) {
            return ERROR;
        }
        
        // ¼ͼ
        ReadData(fp, "%d", &((*G).kind));
    }
    
    // ͼ/ͼ/һ
    switch((*G).kind) {
        case DG:
            flag = CreateDG(G);
            break;
        default:
            flag = ERROR;
            break;
    }
    
    if(fp != NULL) {
        fclose(fp);
        fp = NULL;
    }
    
    return flag;
}

/*
 *  㷨7.3 
 *
 * ͼ
 *
 * ע
 * ̲ʹͷ巨뻡Ψһŵǲ뷽㣬
 * 漰ɾʱЧʽϵͣ
 * ң"ͷ巨"˳ı/ģ
 * չͼ/еı/Ҳġ
 *
 * Ϊ˿˷ȱ㣬""뷨֤Ļ""ġ
 * ͬʱʹ""㷨ýΪӡ
 */
static Status CreateDG(OLGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).arcnum = 0;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &vexnum);
        printf("ͼĻ");
        scanf("%d", &arcnum);
        printf("ͼĻǷϢ(0-1-)");
        scanf("%d", &IncInfo);
        
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            scanf("%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum);    // ¼붥
        ReadData(fp, "%d", &arcnum);    // ¼뻡
        ReadData(fp, "%d", &IncInfo);   // жϻǷϢ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).xlist[i].data));
            (*G).xlist[i].firstin = NULL;
            (*G).xlist[i].firstout = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊͼ¼ %d Ϣ֮ÿո\n", arcnum);
    }
    
    // ¼뻡Ϣ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼뻡Ϣ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &info);
        }
        
        // 뻡<v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ¼뻡ظϢ
 */
static void Input(OLGraph G, InfoType** info) {
    int weight;
    
    // ""Ҫ¼ȨֵϢ
    if(G.kind == DN || G.kind == UDN) {
        *info = (InfoType*) malloc(sizeof(InfoType));
        
        if(fp == NULL) {
            scanf("%d", &weight);
        } else {
            ReadData(fp, "%d", &weight);
        }
        
        (*info)->weight = weight;
    }
}

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(OLGraph G, VertexType u) {
    int i;
    
    for(i = 0; i < G.vexnum; i++) {
        if(G.xlist[i].data == u) {
            return i;
        }
    }
    
    return -1;
}

/*
 * ȡֵ
 *
 * vĶֵ
 */
VertexType GetVex(OLGraph G, int v) {
    if(v < 0 || v >= G.vexnum) {
        return '\0';    // ָĶ㲻
    }
    
    return G.xlist[v].data;
}

/*
 * ׸ڽӵ
 *
 * ضv׸ڽӵ
 */
int FirstAdjVex(OLGraph G, VertexType v) {
    int k;
    ArcBox* r;
    
    // ҪжϸöǷ
    k = LocateVex(G, v);
    if(k == -1) {
        return -1;    // ָĶ㲻
    }
    
    r = G.xlist[k].firstout;
    if(r == NULL) {
        return -1;
    } else {
        return r->headvex;
    }
}

/*
 * һڽӵ
 *
 * ضv(w)һڽӵ
 */
int NextAdjVex(OLGraph G, VertexType v, VertexType w) {
    int kv, kw;
    ArcBox* r;
    
    // ҪжϸöǷ
    kv = LocateVex(G, v);
    if(kv == -1) {
        return -1;    // ָĶ㲻
    }
    
    // ҪжϸöǷ
    kw = LocateVex(G, w);
    if(kw == -1) {
        return -1;    // ָĶ㲻
    }
    
    r = G.xlist[kv].firstout;
    if(r == NULL) {
        return -1;  // Ϊ
    }
    
    // вw
    while(r != NULL && r->headvex < kw) {
        r = r->tlink;
    }
    
    // ûҵw
    if(r == NULL) {
        return -1;
    }
    
    // ҵwwûбĶ㣬ôҲ޷ڽӵ
    if(r->headvex == kw && r->tlink != NULL) {
        return r->tlink->headvex;
    }
    
    return -1;
}

/*
 * һ/(ڲʹ)
 */
static ArcBox* newArcBoxPtr(int tailvex, int headvex, ArcBox* hlink, ArcBox* tlink, InfoType* info) {
    ArcBox* p = (ArcBox*) malloc(sizeof(ArcBox));
    if(!p) {
        exit(OVERFLOW);
    }
    
    p->tailvex = tailvex;
    p->headvex = headvex;
    
    p->hlink = hlink;
    p->tlink = tlink;
    
    p->info = info;
    
    return p;
}

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 * ͼ/˵ڿɱг/ĸϢ
 *
 * ע˴յĲMGraphЩһĸϢа˸/Ȩֵ
 */
Status InsertArc(OLGraph* G, VertexType v, VertexType w, ...) {
    int tail, head, k, count;
    ArcBox* p;
    ArcBox* pre;
    ArcBox* r;
    Boolean overlay = FALSE;   // ǷΪ
    InfoType* info = NULL;     // /ĸϢ
    va_list ap;
    
    tail = LocateVex(*G, v); // ȡvڶ㼯еλ
    if(tail == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    head = LocateVex(*G, w); // ȡwڶ㼯еλ
    if(head == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    // ܾ
    if(tail == head) {
        return ERROR;
    }
    
    // /ϴڸϢ
    if(IncInfo) {
        va_start(ap, w);                // wѯ׸ɱ
        info = va_arg(ap, InfoType*);   // ȡϢ
        va_end(ap);
    }
    
    /* ҪҺʵĲλ */
    
    for(count = 0; count < 2; count++) {
        
        // ںϲҺʵĲλ
        pre = NULL;
        // ָtailΪβ/
        r = G->xlist[tail].firstout;
        while(r != NULL && r->headvex < head) {
            pre = r;
            r = r->tlink;
        }
        
        // ͬλõĽ
        if(r != NULL && r->headvex == head) {
            r->info = info; // øý
            overlay = TRUE; // ˸
        } else {
            p = newArcBoxPtr(tail, head, NULL, r, info);
            
            if(pre == NULL) {
                G->xlist[tail].firstout = p;
            } else {
                pre->tlink = p;
            }
        }
        
        // ûзǣ˵½㣬ʱҪϵλ
        if(overlay == FALSE) {
            // ϲҺʵĲλ
            pre = NULL;
            // ָheadΪͷ/
            r = G->xlist[head].firstin;
            while(r != NULL && r->tailvex < tail) {
                pre = r;
                r = r->hlink;
            }
            
            // ͬλõĽ
            if(r != NULL && r->tailvex == tail) {
                // ִеΪ˸ǣǰ
            } else {
                /* ˣpѾ */
                
                if(pre == NULL) {
                    p->hlink = G->xlist[head].firstin;
                    G->xlist[head].firstin = p;
                } else {
                    p->hlink = pre->hlink;
                    pre->hlink = p;
                }
            }
        }
        
        // ǰͼ/ģҪǶԳ
        if((G->kind == UDG || G->kind == UDN) && tail != head) {
            // ߵij
            k = tail;
            tail = head;
            head = k;
        } else {
            break;  // ģԽ
        }
    }
    
    // ڷǸǵ£ſǸ±/
    if(!overlay) {
        (*G).arcnum++;  // 򣬱/ֻһ
    }
    
    return OK;
}

/*
 * ȱ(˴ݹʵ)
 */
void DFSTraverse(OLGraph G, Status(Visit)(VertexType)) {
    int v;
    
    // ʹȫֱVisitFuncʹDFSúָ
    VisitFunc = Visit;
    
    // ʱ־ʼ
    for(v = 0; v < G.vexnum; v++) {
        visited[v] = FALSE;
    }
    
    // ˴Ҫԭǲܱ֤ж㶼һ
    for(v = 0; v < G.vexnum; v++) {
        if(!visited[v]) {
            DFS(G, v);  // δʵĶDFS
        }
    }
}

/*
 * ȱĺ
 */
static void DFS(OLGraph G, int v) {
    int w;
    
    // ӵvݹȱͼG
    visited[v] = TRUE;
    
    // ʵv
    VisitFunc(G.xlist[v].data);
    
    for(w = FirstAdjVex(G, G.xlist[v].data);
        w >= 0;
        w = NextAdjVex(G, G.xlist[v].data, G.xlist[w].data)) {
        if(!visited[w]) {
            DFS(G, w);  // δʵĶDFS
        }
    }
}

/*
 * ͼλʽǰṹ
 */
void PrintGraph(OLGraph G) {
    int i, head;
    ArcBox* p;
    
    if(G.vexnum == 0) {
        printf("ͼӡ\n");
        return;
    }
    
    printf("ǰͼ/ %2d 㣬 %2d /...\n", G.vexnum, G.arcnum);
    
    for(i = 0; i < G.vexnum; i++) {
        printf("%c ===> ", G.xlist[i].data);
        
        head = 0;
        p = G.xlist[i].firstout;
        
        while(p != NULL) {
            if(head < p->headvex) {
                if(IncInfo == 0) {
                    printf("      ");
                    
                    // 丽ϢлȡȨֵ
                } else {
                    printf("          ");
                }
            } else {
                if(IncInfo == 0) {
                    printf("<%c, %c>", G.xlist[p->tailvex].data, G.xlist[p->headvex].data);
                    
                    // 丽ϢлȡȨֵ
                } else {
                    printf("<%c, %c, %2d>", G.xlist[p->tailvex].data, G.xlist[p->headvex].data, p->info->weight);
                }
                
                p = p->tlink;
            }
            
            head++;
            
            if(p != NULL) {
                printf("  ");
            }
        }
        
        printf("\n");
    }
}
