/*==================
 * ͼڽӱ洢ʾ
 ===================*/

#include "ALGraph.h"

// ¼ݵԴļfpΪnullʱ˵Ҫӿ̨¼
static FILE* fp = NULL;

/*
 * IncInfoָʾͼ/ı/ǷڸϢ
 * ֵΪ0ʾ޸Ϣ򣬱ʾڸϢ
 */
Boolean IncInfo = FALSE;

// ʱ־飬¼ʹĶ
static Boolean visited[MAX_VERTEX_NUM];

// 
static Status (* VisitFunc)(VertexType e);


/*
 * 
 *
 *ע
 *
 * ̲Ĭϴӿ̨ȡݡ
 * Ϊ˷ԣÿжֶݣ
 * ѡԤļpathжȡݡ
 *
 * Ҫӿ̨ȡݣpathΪNULLpath[kind]Ϊ""
 * ҪļжȡݣҪpathдļϢ
 */
Status CreateGraph(ALGraph* G, char* path[]) {
    int readFromConsole;    // Ƿӿ̨ȡ
    int kind;
    Status flag;
    
    // ˴̶Ϊͼ
    kind = 2;
    
    // ûļ·Ϣӿ̨ȡ
    readFromConsole = (path == NULL) || strcmp(path[kind], "") == 0;
    
    // Ҫļȡ
    if(readFromConsole) {
        (*G).kind = GraphKind(kind);   // ¼ͼ/
    } else {
        // ļ׼ȡ
        fp = fopen(path[kind], "r");
        if(fp == NULL) {
            return ERROR;
        }
        
        // ¼ͼ
        ReadData(fp, "%d", &((*G).kind));
    }
    
    // ͼ/ͼ/һ
    switch((*G).kind) {
        case UDG:
            flag = CreateUDG(G);
            break;
        default:
            flag = ERROR;
            break;
    }
    
    if(fp != NULL) {
        fclose(fp);
        fp = NULL;
    }
    
    return flag;
}

/*
 * ͼ
 */
static Status CreateUDG(ALGraph* G) {
    int i, k;
    int vexnum, arcnum;
    VertexType v1, v2;
    InfoType* info = NULL;
    
    (*G).vexnum = (*G).arcnum = 0;
    
    if(fp == NULL) {
        printf("ͼĶ");
        scanf("%d", &vexnum);
        printf("ͼı");
        scanf("%d", &arcnum);
        printf("ͼıǷϢ(0-1-)");
        scanf("%d", &IncInfo);
    
        // ¼붥㼯
        printf("¼ %d 㣬֮ͬÿո", vexnum);
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(stdin);
            scanf("%c", &((*G).vertices[i].data));
            (*G).vertices[i].firstarc = NULL;
            (*G).vexnum++;
        }
    } else {
        ReadData(fp, "%d", &vexnum); // ¼붥
        ReadData(fp, "%d", &arcnum); // ¼
        ReadData(fp, "%d", &IncInfo);// жϱǷϢ
        
        // ¼붥㼯
        for(i = 0; i < vexnum; i++) {
            // հףѰһ"ɶ"
            skipBlank(fp);
            ReadData(fp, "%c", &((*G).vertices[i].data));
            (*G).vertices[i].firstarc = NULL;
            (*G).vexnum++;
        }
    }
    
    // ڿ̨¼Ϣʱʾ
    if(fp == NULL && arcnum != 0) {
        printf("Ϊͼ¼ %d ߵϢ֮ÿո\n", arcnum);
    }
    
    // ¼ߵϢ
    for(k = 0; k < arcnum; k++) {
        if(fp == NULL) {
            printf(" %2d ߣ", k + 1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v1);
            skipBlank(stdin);   // հףѰһɶ
            scanf("%c", &v2);
        } else {
            // հףѰһɶ
            skipBlank(fp);
            ReadData(fp, "%c%c", &v1, &v2);
        }
        
        // Ҫ¼ߵϢ
        if(IncInfo) {
            // ¼븽Ϣ
            Input(*G, &info);
            
        }
        
        // <v1, v2>
        InsertArc(G, v1, v2, info);
    }
    
    // ļжȡʱʵӦжһǷ㹻Ϣ
    return OK;
}

/*
 * ¼/ظϢ
 */
static void Input(ALGraph G, InfoType** info) {
    int weight;
    
    // ""Ҫ¼ȨֵϢ
    if(G.kind == DN || G.kind == UDN) {
        *info = (InfoType*) malloc(sizeof(InfoType));
        
        if(fp == NULL) {
            scanf("%d", &weight);
        } else {
            ReadData(fp, "%d", &weight);
        }
        
        (*info)->weight = weight;
    }
}

/*
 * 
 *
 * ضuͼ/еλ
 */
int LocateVex(ALGraph G, VertexType u) {
    int i;
    
    for(i = 0; i < G.vexnum; i++) {
        if(G.vertices[i].data == u) {
            return i;
        }
    }
    
    return -1;
}

/*
 * ȡֵ
 *
 * vĶֵ
 */
VertexType GetVex(ALGraph G, int v) {
    if(v < 0 || v >= G.vexnum) {
        return '\0';    // ָĶ㲻
    }
    
    return G.vertices[v].data;
}

/*
 * ֵ
 *
 * vֵΪvalue
 */
Status PutVex(ALGraph* G, VertexType v, VertexType value) {
    int k;
    
    // ҪжϸöǷ
    k = LocateVex((*G), v);
    if(k == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    // 滻ͷ
    (*G).vertices[k].data = value;
    
    /* еԪش洢Ƕλã滻Ŀֵ */
    
    return OK;
}

/*
 * ׸ڽӵ
 *
 * ضv׸ڽӵ
 */
int FirstAdjVex(ALGraph G, VertexType v) {
    int k;
    ArcNode* r;
    
    // ҪжϸöǷ
    k = LocateVex(G, v);
    if(k == -1) {
        return -1;    // ָĶ㲻
    }
    
    r = G.vertices[k].firstarc;
    if(r == NULL) {
        return -1;
    } else {
        return r->adjvex;
    }
}

/*
 * һڽӵ
 *
 * ضv(w)һڽӵ
 */
int NextAdjVex(ALGraph G, VertexType v, VertexType w) {
    int kv, kw;
    ArcNode* r;
    
    // ҪжϸöǷ
    kv = LocateVex(G, v);
    if(kv == -1) {
        return -1;    // ָĶ㲻
    }
    
    // ҪжϸöǷ
    kw = LocateVex(G, w);
    if(kw == -1) {
        return -1;    // ָĶ㲻
    }
    
    r = G.vertices[kv].firstarc;
    if(r == NULL) {
        return -1;  // Ϊ
    }
    
    // вw
    while(r != NULL && r->adjvex < kw) {
        r = r->nextarc;
    }
    
    // ûҵw
    if(r == NULL) {
        return -1;
    }
    
    // ҵwwûбĶ㣬ôҲ޷ڽӵ
    if(r->adjvex == kw && r->nextarc != NULL) {
        return r->nextarc->adjvex;
    }
    
    return -1;
}

/*
 * 붥
 *
 * ָĶv׷ӵ㼯УδöĹϵ
 */
Status InsertVex(ALGraph* G, VertexType v) {
    int k;
    
    // 
    if((*G).vexnum == MAX_VERTEX_NUM) {
        return ERROR;
    }
    
    // ҪжϸöǷ
    k = LocateVex(*G, v);
    if(k >= 0) {
        return ERROR;    // ָĶʱظ
    }
    
    G->vertices[(*G).vexnum].data = v;
    G->vertices[(*G).vexnum].firstarc = NULL;
    
    (*G).vexnum++;
    
    return OK;
}

/*
 * ɾ
 *
 * Ӷ㼯ɾָĶvעҪصĶϵ
 */
Status DeleteVex(ALGraph* G, VertexType v) {
    int k, i;
    ArcNode* pre, * r;
    
    // ҪжϸöǷ
    k = LocateVex(*G, v);
    if(k == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    // ҵԽvͷŸн
    r = G->vertices[k].firstarc;
    while(r != NULL) {
        pre = r;
        r = r->nextarc;
        free(pre);
        
        (*G).arcnum--;
    }
    
    G->vertices[k].firstarc = NULL;
    
    // ɾЩָ򶥵vĻң±곬kĶ㣬±ֵҪݼ
    for(i = 0; i < G->vexnum; i++) {
        pre = NULL;
        r = G->vertices[i].firstarc;
        while(r != NULL && r->adjvex < k) {
            pre = r;
            r = r->nextarc;
        }
        
        // ж±Сk
        if(r == NULL) {
            continue;
        }
        
        if(r->adjvex == k) {
            // ӿͷɾv
            if(pre == NULL) {
                G->vertices[i].firstarc = r->nextarc;
                
                // мĳλɾv
            } else {
                pre->nextarc = r->nextarc;
            }
            
            free(r);
            
            // ͼ/ȻҪݼ/
            if((*G).kind == DG || (*G).kind == DN) {
                (*G).arcnum--;
            }
        }
        
        // ٴȷrλ
        if(pre == NULL) {
            r = G->vertices[i].firstarc;
        } else {
            r = pre->nextarc;
        }
        
        // ±곬kĶ㣬Ҫݼ±
        while(r != NULL && r->adjvex > k) {
            r->adjvex -= 1;
            r = r->nextarc;
        }
    }
    
    // 㼯ǰ
    for(i = k + 1; i < (*G).vexnum; i++) {
        G->vertices[i - 1] = G->vertices[i];
    }
    
    // ݼ
    (*G).vexnum--;
    
    return OK;
}

/*
 * һ/(ڲʹ)
 */
static ArcNode* newArcNodePtr(int adjvex, ArcNode* nextarc, InfoType* info) {
    ArcNode* p = (ArcNode*) malloc(sizeof(ArcNode));
    if(!p) {
        exit(OVERFLOW);
    }
    
    p->adjvex = adjvex;
    
    p->nextarc = nextarc;
    
    p->info = info;
    
    return p;
}

/*
 * /<v, w>
 *
 * ǰͼ/ģһҪϵֻһ
 * ͼ/˵ڿɱг/ĸϢ
 *
 * ע˴յĲMGraphЩһĸϢа˸/Ȩֵ
 */
Status InsertArc(ALGraph* G, VertexType v, VertexType w, ...) {
    int tail, head, k, count;
    ArcNode* r;
    ArcNode* pre;
    Boolean overlay = FALSE;    // ǷΪ
    InfoType* info = NULL;      // /ĸϢ
    va_list ap;
    
    tail = LocateVex(*G, v); // ȡvڶ㼯еλ
    if(tail == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    head = LocateVex(*G, w); // ȡwڶ㼯еλ
    if(head == -1) {
        return ERROR;  // ָĶ㲻
    }
    
    // ܾ
    if(tail == head) {
        return ERROR;
    }
    
    // /ϴڸϢ
    if(IncInfo) {
        va_start(ap, w);                // wѯ׸ɱ
        info = va_arg(ap, InfoType*);   // ȡϢ
        va_end(ap);
    }
    
    /* ҪҺʵĲλ */
    
    for(count = 0; count < 2; count++) {
        pre = NULL;
        // ָtailΪβ/
        r = G->vertices[tail].firstarc;
        while(r != NULL && r->adjvex < head) {
            pre = r;
            r = r->nextarc;
        }
        
        // ͬλõĽ
        if(r != NULL && r->adjvex == head) {
            r->info = info; // øý
            overlay = TRUE; // ˸
        } else {
            if(pre == NULL) {
                G->vertices[tail].firstarc = newArcNodePtr(head, r, info);
            } else {
                pre->nextarc = newArcNodePtr(head, r, info);
            }
        }
        
        // ǰͼ/ģҪǶԳ
        if((G->kind == UDG || G->kind == UDN) && tail != head) {
            // ߵij
            k = tail;
            tail = head;
            head = k;
        } else {
            break;  // ģԽ
        }
    }
    
    // ڷǸǵ£ſǸ±/
    if(!overlay) {
        (*G).arcnum++;  // 򣬱/ֻһ
    }
    
    return OK;
}

/*
 * ɾ/<v, w>
 */
Status DeleteArc(ALGraph* G, VertexType v, VertexType w) {
    int tail, head, k, count;
    ArcNode* r;
    ArcNode* pre;
    
    tail = LocateVex(*G, v);
    if(tail == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    head = LocateVex(*G, w);
    if(head == -1) {
        return ERROR;    // ָĶ㲻
    }
    
    for(count = 0; count < 2; count++) {
        pre = NULL;
        // ڵǰҵɾı/
        r = G->vertices[tail].firstarc;
        while(r != NULL && r->adjvex < head) {
            pre = r;
            r = r->nextarc;
        }
        
        // ҵ˴ɾı/
        if(r != NULL && r->adjvex == head) {
            if(pre == NULL) {
                G->vertices[tail].firstarc = r->nextarc;
            } else {
                pre->nextarc = r->nextarc;
            }
            
            free(r);
        } else {
            return ERROR; // ûҵ
        }
        
        // ǰͼ/ģҪǶԳ
        if((G->kind == UDG || G->kind == UDN) && tail != head) {
            // ߵtailhead
            k = tail;
            tail = head;
            head = k;
        } else {
            break;  // ģԽ
        }
    }
    
    (*G).arcnum--;  // 򣬱/ֻһ
    
    return OK;
}

/*
 * ͼλʽǰṹ
 */
void PrintGraph(ALGraph G) {
    int i;
    ArcNode* p;
    
    if(G.vexnum == 0) {
        printf("ͼӡ\n");
        return;
    }
    
    printf("ǰͼ/ %2d 㣬 %2d /...\n", G.vexnum, G.arcnum);
    
    for(i = 0; i < G.vexnum; i++) {
        printf("%c ===> ", G.vertices[i].data);
        
        p = G.vertices[i].firstarc;
        while(p != NULL) {
            if(IncInfo == 0) {
                printf("%c ", G.vertices[p->adjvex].data);
                
                // 丽ϢлȡȨֵ
            } else {
                printf("%c[%2d] ", G.vertices[p->adjvex].data, p->info->weight);
            }
            
            p = p->nextarc;
            
            if(p != NULL) {
                printf("- ");
            }
        }
        
        printf("\n");
    }
}
